/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.authz.jaccx.condition;

import com.ibm.sec.authz.jaccx.EvaluationContext;
import com.ibm.sec.authz.jaccx.condition.Condition;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class LogicalCondition
implements Condition,
Serializable {
    private static final long serialVersionUID = -3406652896110933575L;
    private final Set conditions;
    private final int logic;
    private boolean readOnly = false;
    public static final int AND = 0;
    public static final int OR = 1;
    public static final int NOT = 2;

    public LogicalCondition(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("an invalid logic identifier.");
        }
        this.logic = n;
        this.conditions = new HashSet();
    }

    public LogicalCondition(int n, Set set) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("an invalid logic identifier.");
        }
        this.logic = n;
        this.conditions = set;
        if (this.logic == 2 && this.conditions.size() != 1) {
            throw new IllegalArgumentException("Found multiple conditions for NOT.");
        }
        this.setReadOnly();
    }

    public boolean evaluate(EvaluationContext evaluationContext) {
        if (this.conditions.size() == 0) {
            return true;
        }
        Iterator iterator = this.conditions.iterator();
        switch (this.logic) {
            case 0: {
                while (iterator.hasNext()) {
                    if (((Condition)iterator.next()).evaluate(evaluationContext)) continue;
                    return false;
                }
                return true;
            }
            case 1: {
                while (iterator.hasNext()) {
                    if (!((Condition)iterator.next()).evaluate(evaluationContext)) continue;
                    return true;
                }
                return false;
            }
            case 2: {
                if (!iterator.hasNext()) break;
                return !((Condition)iterator.next()).evaluate(evaluationContext);
            }
        }
        return false;
    }

    public int getLogic() {
        return this.logic;
    }

    public Set getConditions() {
        return Collections.unmodifiableSet(this.conditions);
    }

    public void addCondition(Condition condition) {
        if (this.readOnly) {
            throw new UnsupportedOperationException("addCondition was invoked after ReadOnly was set.");
        }
        if (this.logic == 2 && this.conditions.size() > 1) {
            throw new UnsupportedOperationException("addCondition was invoked to add multiple conditions for NOT.");
        }
        this.conditions.add(condition);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly() {
        this.readOnly = true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getClass().getName();
        stringBuffer.append(string);
        Iterator iterator = this.conditions.iterator();
        switch (this.logic) {
            case 0: {
                stringBuffer.append(": AND");
                break;
            }
            case 1: {
                stringBuffer.append(": OR");
                break;
            }
            case 2: {
                stringBuffer.append(": NOT");
                break;
            }
            default: {
                return null;
            }
        }
        while (iterator.hasNext()) {
            stringBuffer.append("\n");
            stringBuffer.append(iterator.next().toString());
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof LogicalCondition) {
            LogicalCondition logicalCondition = (LogicalCondition)object;
            if (this.logic == logicalCondition.logic) {
                return this.conditions.containsAll(logicalCondition.conditions) && logicalCondition.conditions.containsAll(this.conditions);
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return ((Object)this.conditions).hashCode();
    }

    public Set getReferencedAttributeNames() {
        HashSet hashSet = new HashSet();
        Iterator iterator = this.conditions.iterator();
        while (iterator.hasNext()) {
            Condition condition = (Condition)iterator.next();
            hashSet.addAll(condition.getReferencedAttributeNames());
        }
        return hashSet;
    }
}

