/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.authz.jaccx.condition;

import com.ibm.sec.authz.jaccx.EvaluationContext;
import com.ibm.sec.authz.jaccx.condition.AttributeName;
import com.ibm.sec.authz.jaccx.condition.Condition;
import com.ibm.sec.authz.jaccx.resource.Resource;
import com.ibm.sec.authz.jaccx.resource.ResourceContext;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContextException;

public class OwnerCondition
implements Condition {
    private static final long serialVersionUID = 5776959943142837102L;
    private static final String SUBJECT_KEY = "javax.security.auth.Subject.container";
    public static final OwnerCondition OWNER_CONDITION = new OwnerCondition();
    private static final Set referencedAttributeNameSet = new HashSet(1);

    private OwnerCondition() {
    }

    public boolean evaluate(EvaluationContext evaluationContext) {
        try {
            Set set = evaluationContext.getKeys();
            if (set.contains(Resource.JACC_RESOURCE_KEY) && set.contains(ResourceContext.JACC_RESOURCE_CONTEXT_KEY)) {
                Resource resource = (Resource)evaluationContext.getContext(Resource.JACC_RESOURCE_KEY);
                ResourceContext resourceContext = (ResourceContext)evaluationContext.getContext(ResourceContext.JACC_RESOURCE_CONTEXT_KEY);
                Subject subject = (Subject)evaluationContext.getContext(SUBJECT_KEY);
                return (Boolean)resourceContext.getAttribute(resource, "is-owner", subject);
            }
            return false;
        }
        catch (PolicyContextException policyContextException) {
            return false;
        }
    }

    public String toString() {
        return this.getClass().getName();
    }

    public boolean equals(Object object) {
        return object instanceof OwnerCondition;
    }

    public int hashCode() {
        return 0;
    }

    public Set getReferencedAttributeNames() {
        return referencedAttributeNameSet;
    }

    static {
        referencedAttributeNameSet.add(new AttributeName(3, "is-owner"));
    }
}

