/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.authz.jaccx.condition;

import com.ibm.sec.authz.jaccx.EvaluationContext;
import com.ibm.sec.authz.jaccx.condition.AttributeName;
import com.ibm.sec.authz.jaccx.condition.Condition;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexCondition
implements Condition,
Serializable {
    private static final long serialVersionUID = 3734107291721267479L;
    private final AttributeName attributeName;
    private final Pattern pattern;

    public RegexCondition(AttributeName attributeName, String string) {
        this.attributeName = attributeName;
        this.pattern = Pattern.compile(string);
    }

    public boolean evaluate(EvaluationContext evaluationContext) {
        Object object = this.attributeName.getAttribute(evaluationContext);
        if (object instanceof String) {
            Matcher matcher = this.pattern.matcher((String)object);
            return matcher.matches();
        }
        return false;
    }

    public AttributeName getAttributeName() {
        return this.attributeName;
    }

    public String getRegex() {
        return this.pattern.pattern();
    }

    public String toString() {
        String string = this.getClass().getName();
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(": ");
        stringBuffer.append(this.attributeName);
        stringBuffer.append(" matches? ");
        stringBuffer.append(this.pattern.pattern());
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof RegexCondition) {
            RegexCondition regexCondition = (RegexCondition)object;
            return this.attributeName.equals(regexCondition.attributeName) && this.pattern.pattern().equals(regexCondition.pattern.pattern());
        }
        return false;
    }

    public int hashCode() {
        return this.attributeName.hashCode() + this.pattern.pattern().hashCode();
    }

    public Set getReferencedAttributeNames() {
        HashSet<AttributeName> hashSet = new HashSet<AttributeName>();
        hashSet.add(this.attributeName);
        return hashSet;
    }
}

