/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.authz.jaccx.resource;

import com.ibm.sec.authz.jaccx.resource.Resource;
import com.ibm.sec.authz.jaccx.resource.ResourceContext;
import com.ibm.sec.authz.jaccx.resource.ResourceScope;
import com.ibm.sec.authz.jaccx.resource.ResourceScopeCollection;
import com.ibm.sec.authz.jaccx.resource.TreeBasedResource;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;

public class TreeBasedResourceScope
implements ResourceScope,
Serializable {
    private static final long serialVersionUID = -6603504588126972018L;
    private final int propagation;
    private final TreeBasedResource rootResource;
    public static final int SELF = 0;
    public static final int CHILDREN = 1;
    public static final int SELF_AND_CHILDREN = 2;
    public static final int DESCENDANTS = 3;
    public static final int SELF_AND_DESCENDANTS = 4;
    public static final String SELF_STRING = "SELF";
    public static final String CHILDREN_STRING = "CHILDREN";
    public static final String SELF_AND_CHILDREN_STRING = "SELF_AND_CHILDREN";
    public static final String DESCENDANTS_STRING = "DESCENDANTS";
    public static final String SELF_AND_DESCENDANTS_STRING = "SELF_AND_DESCENDANTS";
    private static final String[] PROPAGATION_SPEC = new String[5];

    public int getPropagationRule() {
        return this.propagation;
    }

    public String getPropagationRuleStr() {
        return PROPAGATION_SPEC[this.propagation];
    }

    public TreeBasedResourceScope(TreeBasedResource treeBasedResource, int n) {
        this.rootResource = treeBasedResource;
        if (n < 0 || n > 4) {
            throw new IllegalArgumentException("an invalid propagation rule indentifier.");
        }
        this.propagation = n;
    }

    public TreeBasedResourceScope(TreeBasedResource treeBasedResource, String string) {
        this.rootResource = treeBasedResource;
        if (string.equals(SELF_STRING)) {
            this.propagation = 0;
        } else if (string.equals(CHILDREN_STRING)) {
            this.propagation = 1;
        } else if (string.equals(SELF_AND_CHILDREN_STRING)) {
            this.propagation = 2;
        } else if (string.equals(DESCENDANTS_STRING)) {
            this.propagation = 3;
        } else if (string.equals(SELF_AND_DESCENDANTS_STRING)) {
            this.propagation = 4;
        } else {
            throw new IllegalArgumentException("an invalid propagation rule indentifier.");
        }
    }

    public int getSpecificationLevel() {
        return -1 * this.rootResource.getDepth();
    }

    public int hashCode() {
        return this.rootResource.hashCode() + this.propagation;
    }

    public boolean equals(Object object) {
        if (object instanceof TreeBasedResourceScope) {
            TreeBasedResourceScope treeBasedResourceScope = (TreeBasedResourceScope)object;
            if (this.propagation == treeBasedResourceScope.propagation) {
                return this.rootResource.equals(treeBasedResourceScope.rootResource);
            }
            return false;
        }
        return false;
    }

    public TreeBasedResource getRootResource() {
        return this.rootResource;
    }

    public boolean isWithinResourceScope(Resource resource, ResourceContext resourceContext) {
        if (resource == null) {
            throw new IllegalArgumentException("the resource argument must not be null.");
        }
        if (!(resource instanceof TreeBasedResource)) {
            throw new IllegalArgumentException("the resource argument must be an instance of " + this.rootResource.getClass());
        }
        TreeBasedResource treeBasedResource = (TreeBasedResource)resource;
        switch (this.propagation) {
            case 0: {
                if (this.rootResource.equals(treeBasedResource)) break;
                return false;
            }
            case 1: {
                if (treeBasedResource.getDepth() != this.rootResource.getDepth() + 1) {
                    return false;
                }
                return this.rootResource.isParent(treeBasedResource);
            }
            case 2: {
                if (treeBasedResource.getDepth() != this.rootResource.getDepth() && treeBasedResource.getDepth() != this.rootResource.getDepth() + 1) {
                    return false;
                }
                return this.rootResource.isParent(treeBasedResource);
            }
            case 3: {
                if (treeBasedResource.getDepth() <= this.rootResource.getDepth()) {
                    return false;
                }
                return this.rootResource.isParent(treeBasedResource);
            }
            case 4: {
                if (treeBasedResource.getDepth() < this.rootResource.getDepth()) {
                    return false;
                }
                return this.rootResource.isParent(treeBasedResource);
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append(": ");
        stringBuffer.append(this.rootResource);
        stringBuffer.append(": ");
        stringBuffer.append(PROPAGATION_SPEC[this.propagation]);
        return stringBuffer.toString();
    }

    public ResourceScopeCollection newResourceScopeCollection() {
        return null;
    }

    public Iterator getResources(Resource resource, ResourceContext resourceContext) {
        if (resource == null) {
            throw new IllegalArgumentException("the resource argument must not be null.");
        }
        if (!(resource instanceof TreeBasedResource)) {
            throw new IllegalArgumentException("the resource argument must be an instance of " + this.rootResource.getClass());
        }
        TreeBasedResource treeBasedResource = (TreeBasedResource)resource;
        HashSet<TreeBasedResource> hashSet = new HashSet<TreeBasedResource>();
        switch (this.propagation) {
            case 0: {
                if (!this.rootResource.equals(treeBasedResource)) break;
                hashSet.add(this.rootResource);
                break;
            }
            case 1: 
            case 3: {
                if (this.rootResource.equals(treeBasedResource) || treeBasedResource.isParent(this.rootResource)) {
                    Iterator iterator = (Iterator)resourceContext.getAttribute(this.rootResource, "children", null);
                    while (iterator.hasNext()) {
                        hashSet.add((TreeBasedResource)iterator.next());
                    }
                    break;
                }
                if (!this.isWithinResourceScope(treeBasedResource, resourceContext)) break;
                hashSet.add(treeBasedResource);
                break;
            }
            case 2: 
            case 4: {
                if (treeBasedResource.isParent(this.rootResource)) {
                    hashSet.add(this.rootResource);
                    break;
                }
                if (!this.isWithinResourceScope(treeBasedResource, resourceContext)) break;
                hashSet.add(treeBasedResource);
                break;
            }
        }
        return hashSet.iterator();
    }

    static {
        TreeBasedResourceScope.PROPAGATION_SPEC[0] = SELF_STRING;
        TreeBasedResourceScope.PROPAGATION_SPEC[1] = CHILDREN_STRING;
        TreeBasedResourceScope.PROPAGATION_SPEC[2] = SELF_AND_CHILDREN_STRING;
        TreeBasedResourceScope.PROPAGATION_SPEC[3] = DESCENDANTS_STRING;
        TreeBasedResourceScope.PROPAGATION_SPEC[4] = SELF_AND_DESCENDANTS_STRING;
    }
}

