/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.authz.jaccx.role;

import com.ibm.sec.authz.jaccx.EvaluationContext;
import com.ibm.sec.authz.jaccx.condition.Condition;
import com.ibm.sec.authz.jaccx.resource.Resource;
import com.ibm.sec.authz.jaccx.resource.ResourceContext;
import com.ibm.sec.authz.jaccx.resource.ResourceScope;
import com.ibm.sec.authz.jaccx.role.RoleCondition;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.security.jacc.PolicyContextException;

abstract class AbstractScopedRoleCondition
implements RoleCondition,
Serializable {
    private static final long serialVersionUID = -3379001160193888750L;
    private final String role;
    private final ResourceScope scope;
    private final Condition condition;

    AbstractScopedRoleCondition(String string, ResourceScope resourceScope, Condition condition) {
        if (string == null) {
            throw new IllegalArgumentException("the role name is null.");
        }
        if (resourceScope == null) {
            throw new IllegalArgumentException("the resource scope is null.");
        }
        this.role = string;
        this.scope = resourceScope;
        this.condition = condition;
    }

    AbstractScopedRoleCondition(String string, ResourceScope resourceScope) {
        if (string == null) {
            throw new IllegalArgumentException("the role name is null.");
        }
        if (resourceScope == null) {
            throw new IllegalArgumentException("the resource scope is null.");
        }
        this.role = string;
        this.scope = resourceScope;
        this.condition = null;
    }

    public String getRole() {
        return this.role;
    }

    public ResourceScope getResourceScope() {
        return this.scope;
    }

    public final int getSpecificationLevel() {
        return this.scope.getSpecificationLevel();
    }

    public Condition getCondition() {
        return this.condition;
    }

    public boolean equals(Object object) {
        if (object instanceof AbstractScopedRoleCondition) {
            AbstractScopedRoleCondition abstractScopedRoleCondition = (AbstractScopedRoleCondition)object;
            if (!this.role.equals(abstractScopedRoleCondition.role)) {
                return false;
            }
            if (!((Object)this.scope).equals(abstractScopedRoleCondition.scope)) {
                return false;
            }
            if (this.condition != null && abstractScopedRoleCondition.condition == null) {
                return false;
            }
            if (this.condition == null && abstractScopedRoleCondition.condition != null) {
                return false;
            }
            return this.condition == null || abstractScopedRoleCondition.condition == null || ((Object)this.condition).equals(abstractScopedRoleCondition.condition);
        }
        return false;
    }

    boolean implies(String string, EvaluationContext evaluationContext) {
        Set set = evaluationContext.getKeys();
        try {
            ResourceContext resourceContext;
            if (!this.role.equals(string)) {
                return false;
            }
            Resource resource = (Resource)evaluationContext.getContext(Resource.JACC_RESOURCE_KEY);
            boolean bl = this.scope.isWithinResourceScope(resource, resourceContext = set.contains(ResourceContext.JACC_RESOURCE_CONTEXT_KEY) ? (ResourceContext)evaluationContext.getContext(ResourceContext.JACC_RESOURCE_CONTEXT_KEY) : null);
            if (!bl) {
                return false;
            }
            if (this.condition == null) {
                return true;
            }
            return this.condition.evaluate(evaluationContext);
        }
        catch (PolicyContextException policyContextException) {
            return false;
        }
    }

    public int hashCode() {
        int n = this.role.hashCode();
        n += ((Object)this.scope).hashCode();
        if (this.condition != null) {
            n += ((Object)this.condition).hashCode();
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("(");
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(" ");
        stringBuffer.append(this.role);
        stringBuffer.append(" ");
        stringBuffer.append(this.scope);
        stringBuffer.append(")");
        if (this.condition != null) {
            stringBuffer.append("\n");
            stringBuffer.append("Condition: \n");
            stringBuffer.append(this.condition);
        }
        return stringBuffer.toString();
    }

    public Set getReferencedAttributeNames() {
        if (this.condition != null) {
            return this.condition.getReferencedAttributeNames();
        }
        return new HashSet();
    }
}

