/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.authz.jaccx.role;

import com.ibm.sec.authz.jaccx.EvaluationContext;
import com.ibm.sec.authz.jaccx.resource.Resource;
import com.ibm.sec.authz.jaccx.resource.ResourceContext;
import com.ibm.sec.authz.jaccx.resource.ResourceScope;
import com.ibm.sec.authz.jaccx.resource.TreeBasedResource;
import com.ibm.sec.authz.jaccx.resource.TreeBasedResourceScope;
import com.ibm.sec.authz.jaccx.role.RoleBlockCondition;
import com.ibm.sec.authz.jaccx.role.RoleBlockConditionCollection;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.security.jacc.PolicyContextException;

public class TreeBasedPropagationBlockCondition
implements RoleBlockCondition,
Serializable {
    private static final long serialVersionUID = 1252524099136752594L;
    private final String role;
    private final TreeBasedResource resource;
    private final int link;
    private final ResourceScope scope;
    public static final int LINKS_TO_CHILDREN = 1;
    public static final int LINK_FROM_PARENT = 2;
    public static final String LINKS_TO_CHILDREN_STRING = "LINKS_TO_CHILDREN";
    public static final String LINK_FROM_PARENT_STRING = "LINK_FROM_PARENT";

    public TreeBasedPropagationBlockCondition(String string, TreeBasedResource treeBasedResource, int n) {
        if (string == null) {
            throw new IllegalArgumentException("the role name is null.");
        }
        if (treeBasedResource == null) {
            throw new IllegalArgumentException("the resource is null.");
        }
        this.role = string;
        this.resource = treeBasedResource;
        this.link = n;
        if (n == 1) {
            this.scope = new TreeBasedResourceScope(treeBasedResource, 3);
        } else if (n == 2) {
            this.scope = new TreeBasedResourceScope(treeBasedResource, 4);
        } else {
            throw new IllegalArgumentException("the link argument is illegal.");
        }
    }

    public int getLink() {
        return this.link;
    }

    public TreeBasedResource getResource() {
        return this.resource;
    }

    public String getRole() {
        return this.role;
    }

    public int getSpecificationLevel() {
        return this.scope.getSpecificationLevel();
    }

    public int hashCode() {
        return this.role.hashCode() + this.resource.hashCode() + this.link;
    }

    public boolean equals(Object object) {
        if (object instanceof TreeBasedPropagationBlockCondition) {
            TreeBasedPropagationBlockCondition treeBasedPropagationBlockCondition = (TreeBasedPropagationBlockCondition)object;
            if (this.link != treeBasedPropagationBlockCondition.link) {
                return false;
            }
            if (!this.role.equals(treeBasedPropagationBlockCondition.role)) {
                return false;
            }
            return this.resource.equals(treeBasedPropagationBlockCondition.resource);
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("(");
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(" ");
        stringBuffer.append(this.role);
        stringBuffer.append(" ");
        stringBuffer.append(this.resource);
        stringBuffer.append(" ");
        if (this.link == 1) {
            stringBuffer.append(LINKS_TO_CHILDREN_STRING);
        } else if (this.link == 2) {
            stringBuffer.append(LINK_FROM_PARENT_STRING);
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public boolean blocks(String string, EvaluationContext evaluationContext) {
        Set set = evaluationContext.getKeys();
        try {
            if (this.role != null && !this.role.equals(string)) {
                return false;
            }
            if (this.resource == null) {
                return true;
            }
            Resource resource = (Resource)evaluationContext.getContext(Resource.JACC_RESOURCE_KEY);
            ResourceContext resourceContext = set.contains(ResourceContext.JACC_RESOURCE_CONTEXT_KEY) ? (ResourceContext)evaluationContext.getContext(ResourceContext.JACC_RESOURCE_CONTEXT_KEY) : null;
            return this.scope.isWithinResourceScope(resource, resourceContext);
        }
        catch (PolicyContextException policyContextException) {
            return false;
        }
    }

    public RoleBlockConditionCollection newRoleBlockConditionCollection() {
        return null;
    }

    public Set getReferencedAttributeNames() {
        return new HashSet();
    }
}

