/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.authz.provider;

import com.ibm.sec.authz.jaccx.AdministrativePolicyConfiguration;
import com.ibm.sec.authz.jaccx.xml.XMLSerializable;
import com.ibm.sec.authz.jaccx.xml.XMLSerializationException;
import com.ibm.sec.iauthz.log.SecLogger;
import com.ibm.sec.iauthz.mcc.DataProcessingException;
import com.ibm.sec.iauthz.mcc.DataProcessingFactory;
import com.ibm.sec.iauthz.mcc.ICfgDataProcessing;
import com.ibm.sec.iauthz.mcc.dna.InheritedRole;
import com.ibm.sec.iauthz.mcc.dna.PolicyConfigObject;
import com.ibm.sec.iauthz.util.CWRGSMessageHelper;
import com.ibm.sec.iauthz.util.CollectionFactory;
import com.ibm.sec.iauthz.util.CommonAuthzUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyContextException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

class CommonAuthzPolicyConfiguration
implements AdministrativePolicyConfiguration,
XMLSerializable {
    private ICfgDataProcessing _cfgDP;
    private short _state;
    private String _contextID;
    private SecurityManager _secMgr;
    private static final SecLogger _logger = SecLogger.getLogger(class$com$ibm$sec$authz$provider$CommonAuthzPolicyConfiguration == null ? (class$com$ibm$sec$authz$provider$CommonAuthzPolicyConfiguration = CommonAuthzPolicyConfiguration.class$("com.ibm.sec.authz.provider.CommonAuthzPolicyConfiguration")) : class$com$ibm$sec$authz$provider$CommonAuthzPolicyConfiguration);
    private static boolean UPDATE_STATE = true;
    private static boolean KEEP_STATE = false;
    static /* synthetic */ Class class$com$ibm$sec$authz$provider$CommonAuthzPolicyConfiguration;

    public CommonAuthzPolicyConfiguration(String string) throws PolicyContextException {
        String string2 = "CommonAuthzPolicyConfiguration(String)";
        _logger.entry(string2, string);
        if (string == null) {
            String string3 = CWRGSMessageHelper.getMessage("CONSTRUCT_POLICY_CONTEXTID_NULL");
            _logger.error(string2, string3);
            throw new PolicyContextException(string3);
        }
        try {
            DataProcessingFactory dataProcessingFactory = DataProcessingFactory.getFactory();
            this._cfgDP = dataProcessingFactory.getCfgInstance(string, string, DataProcessingFactory.IS_POLICY);
            this._contextID = string;
            this._cfgDP.setState((short)0, UPDATE_STATE);
            this._state = this._cfgDP.getState();
        }
        catch (DataProcessingException dataProcessingException) {
            String string4 = CWRGSMessageHelper.getMessage("CONSTRUCT_POLICY_ERROR", new Object[]{string, dataProcessingException.toString()});
            _logger.error(string2, string4, dataProcessingException);
            throw new PolicyContextException(string4, (Throwable)dataProcessingException);
        }
        _logger.exit(string2);
    }

    public PermissionCollection getExcludedPolicy() throws PolicyContextException {
        String string = "getExcludedPolicy()";
        _logger.entry(string);
        PermissionCollection permissionCollection = this.getPolicyInternal(string, "_EXCLUDED_");
        _logger.exit(string);
        return permissionCollection;
    }

    public PermissionCollection getUncheckedPolicy() throws PolicyContextException {
        String string = "getExcludedPolicy()";
        _logger.entry(string);
        PermissionCollection permissionCollection = this.getPolicyInternal(string, "_UNCHECKED_");
        _logger.exit(string);
        return permissionCollection;
    }

    public PermissionCollection getRolePolicy(String string) throws PolicyContextException {
        String string2 = "getRolePolicy( String )";
        _logger.entry(string2, string);
        PermissionCollection permissionCollection = this.getPolicyInternal(string2, string);
        _logger.exit(string2, permissionCollection);
        return permissionCollection;
    }

    private PermissionCollection getPolicyInternal(String string, String string2) throws PolicyContextException {
        String string3 = "getPolicyInternal( String, String)";
        _logger.entry(string3, string2);
        Permissions permissions = new Permissions();
        CommonAuthzUtilities.checkSecurityPermission(string, _logger, this._secMgr);
        CommonAuthzUtilities.checkForInvalidState(string, _logger, this._state, (short)2);
        PolicyConfigObject policyConfigObject = new PolicyConfigObject(string2);
        try {
            Iterator iterator = this._cfgDP.retrievePolicy(policyConfigObject);
            while (iterator.hasNext()) {
                PolicyConfigObject policyConfigObject2 = (PolicyConfigObject)iterator.next();
                Permission permission = policyConfigObject2.getPermission();
                ((PermissionCollection)permissions).add(permission);
            }
        }
        catch (DataProcessingException dataProcessingException) {
            String string4 = CWRGSMessageHelper.getMessage("GET_POLICY_RETRIEVE_ERROR", new Object[]{this._contextID, string2, dataProcessingException.toString()});
            _logger.error(string3, string4, dataProcessingException);
            throw new PolicyContextException(string4, (Throwable)dataProcessingException);
        }
        _logger.exit(string3);
        return permissions;
    }

    public Iterator getRoles() throws PolicyContextException {
        String string = "getRoles()";
        _logger.entry(string);
        Set set = CollectionFactory.newSet();
        CommonAuthzUtilities.checkSecurityPermission(string, _logger, this._secMgr);
        CommonAuthzUtilities.checkForInvalidState(string, _logger, this._state, (short)2);
        PolicyConfigObject policyConfigObject = new PolicyConfigObject();
        try {
            Iterator iterator = this._cfgDP.retrievePolicy(policyConfigObject);
            while (iterator.hasNext()) {
                PolicyConfigObject policyConfigObject2 = (PolicyConfigObject)iterator.next();
                String string2 = policyConfigObject2.getRoleName();
                set.add(string2);
            }
        }
        catch (DataProcessingException dataProcessingException) {
            String string3 = CWRGSMessageHelper.getMessage("GET_ROLES_POLICY_ERROR", new Object[]{this._contextID, dataProcessingException.toString()});
            _logger.error(string, string3, dataProcessingException);
            throw new PolicyContextException(string3, (Throwable)dataProcessingException);
        }
        _logger.exit(string);
        return set.iterator();
    }

    public Iterator getRoles(String string) throws PolicyContextException {
        String string2 = "getRoles(String)";
        _logger.entry(string2, string);
        Set set = CollectionFactory.newSet();
        CommonAuthzUtilities.checkSecurityPermission(string2, _logger, this._secMgr);
        CommonAuthzUtilities.checkForInvalidState(string2, _logger, this._state, (short)2);
        try {
            Iterator iterator = this._cfgDP.getInheritedRoles(string);
            while (iterator.hasNext()) {
                InheritedRole inheritedRole = (InheritedRole)iterator.next();
                String string3 = inheritedRole.getRoleName();
                set.add(string3);
            }
        }
        catch (DataProcessingException dataProcessingException) {
            String string4 = CWRGSMessageHelper.getMessage("GET_INHERITED_ROLES_POLICY_ERROR", new Object[]{this._contextID, string, dataProcessingException.toString()});
            _logger.error(string2, string4, dataProcessingException);
            throw new PolicyContextException(string4, (Throwable)dataProcessingException);
        }
        _logger.exit(string2);
        return set.iterator();
    }

    public Iterator getLinkedPolicyConfigurations() throws PolicyContextException {
        String string = "getLinkedPolicyConfigurations()";
        _logger.entry(string);
        Iterator iterator = null;
        CommonAuthzUtilities.checkSecurityPermission(string, _logger, this._secMgr);
        CommonAuthzUtilities.checkForInvalidState(string, _logger, this._state, (short)2);
        try {
            iterator = this._cfgDP.getLinkedPolicy();
        }
        catch (DataProcessingException dataProcessingException) {
            String string2 = CWRGSMessageHelper.getMessage("GET_LINKED_POLICY_ERROR", new Object[]{this._contextID, dataProcessingException.toString()});
            _logger.error(string, string2, dataProcessingException);
            throw new PolicyContextException(string2, (Throwable)dataProcessingException);
        }
        _logger.exit(string);
        return iterator;
    }

    public String getContextID() throws PolicyContextException {
        String string = "getContextID()";
        _logger.entry(string);
        CommonAuthzUtilities.checkSecurityPermission(string, _logger, this._secMgr);
        _logger.exit(string, this._contextID);
        return this._contextID;
    }

    public synchronized void commit() throws PolicyContextException {
        String string = "commit()";
        _logger.entry(string);
        CommonAuthzUtilities.checkSecurityPermission(string, _logger, this._secMgr);
        CommonAuthzUtilities.checkForInvalidState(string, _logger, this._state, (short)2);
        if (this._state == 0) {
            _logger.debug(string, CWRGSMessageHelper.getMessage("COMMIT_POLICY", new Object[]{this._contextID}));
            try {
                this._cfgDP.setState((short)1, UPDATE_STATE);
                this._state = this._cfgDP.getState();
            }
            catch (DataProcessingException dataProcessingException) {
                String string2 = CWRGSMessageHelper.getMessage("COMMIT_POLICY_ERROR", new Object[]{this._contextID, dataProcessingException.toString()});
                _logger.error(string, string2, dataProcessingException);
                throw new PolicyContextException(string2, (Throwable)dataProcessingException);
            }
        } else {
            _logger.debug(string, CWRGSMessageHelper.getMessage("COMMIT_ON_INSERVICE", new Object[]{this._contextID}));
        }
        _logger.exit(string);
    }

    public void linkConfiguration(PolicyConfiguration policyConfiguration) throws PolicyContextException {
        String string = "linkConfiguration(PolicyConfiguration)";
        _logger.entry(string);
        if (policyConfiguration == null) {
            String string2 = CWRGSMessageHelper.getMessage("LINK_POLICY_TARGET_NULL");
            _logger.error(string, string2);
            throw new PolicyContextException(string2);
        }
        CommonAuthzUtilities.checkSecurityPermission(string, _logger, this._secMgr);
        CommonAuthzUtilities.checkForValidState(string, _logger, this._state, (short)0);
        try {
            _logger.debug(string, "Attempting to link contextID " + policyConfiguration.getContextID() + " to contextID " + this._contextID);
            this._cfgDP.addLinkedPolicy(policyConfiguration.getContextID());
        }
        catch (DataProcessingException dataProcessingException) {
            String string3 = CWRGSMessageHelper.getMessage("LINK_POLICY_ERROR", new Object[]{policyConfiguration.getContextID(), this._contextID, dataProcessingException.toString()});
            _logger.error(string, string3, dataProcessingException);
            throw new PolicyContextException(string3, (Throwable)dataProcessingException);
        }
        _logger.exit(string);
    }

    public synchronized void delete() throws PolicyContextException {
        String string = "delete()";
        _logger.entry(string);
        CommonAuthzUtilities.checkSecurityPermission(string, _logger, this._secMgr);
        try {
            this._cfgDP.setState((short)2, UPDATE_STATE);
            this._state = this._cfgDP.getState();
        }
        catch (DataProcessingException dataProcessingException) {
            String string2 = CWRGSMessageHelper.getMessage("DELETE_SET_STATE_ERROR", new Object[]{this._contextID, dataProcessingException.toString()});
            _logger.error(string, string2, dataProcessingException);
            throw new PolicyContextException(string2, (Throwable)dataProcessingException);
        }
        _logger.exit(string);
    }

    public void deleteCurrentPolicy() throws PolicyContextException {
        String string = "deleteCurrentPolicy()";
        _logger.entry(string);
        CommonAuthzUtilities.checkSecurityPermission(string, _logger, this._secMgr);
        if (this._state != 2) {
            try {
                this._cfgDP.setState((short)2, KEEP_STATE);
            }
            catch (DataProcessingException dataProcessingException) {
                String string2 = CWRGSMessageHelper.getMessage("DELETE_CURRENT_POLICY_ERROR", new Object[]{this._contextID, dataProcessingException.toString()});
                _logger.error(string, string2, dataProcessingException);
                throw new PolicyContextException(string2, (Throwable)dataProcessingException);
            }
        } else {
            _logger.debug(string, CWRGSMessageHelper.getMessage("POLICY_ALREADY_DELETED"));
        }
        _logger.exit(string);
    }

    public void removeFromExcludedPolicy(Permission permission) throws PolicyContextException {
        String string = "removeFromExcludedPolicy(Permission)";
        _logger.entry(string, permission);
        if (permission == null) {
            String string2 = CWRGSMessageHelper.getMessage("REMOVE_EXCLUDED_PERM_NULL");
            _logger.error(string, string2);
            throw new PolicyContextException(string2);
        }
        CommonAuthzUtilities.checkSecurityPermission(string, _logger, this._secMgr);
        this.removePolicy("_EXCLUDED_", permission);
        _logger.exit(string);
    }

    public void removeFromUncheckedPolicy(Permission permission) throws PolicyContextException {
        String string = "removeFromUncheckedPolicy(Permission)";
        _logger.entry(string, permission);
        if (permission == null) {
            String string2 = CWRGSMessageHelper.getMessage("REMOVE_UNCHECKED_PERM_NULL");
            _logger.error(string, string2);
            throw new PolicyContextException(string2);
        }
        CommonAuthzUtilities.checkSecurityPermission(string, _logger, this._secMgr);
        this.removePolicy("_UNCHECKED_", permission);
        _logger.exit(string);
    }

    public void removeExcludedPolicy() throws PolicyContextException {
        String string = "removeExcludedPolicy()";
        _logger.entry(string);
        CommonAuthzUtilities.checkSecurityPermission(string, _logger, this._secMgr);
        this.removePolicy("_EXCLUDED_", null);
        _logger.exit(string);
    }

    public void removeUncheckedPolicy() throws PolicyContextException {
        String string = "removeUncheckedPolicy()";
        _logger.entry(string);
        CommonAuthzUtilities.checkSecurityPermission(string, _logger, this._secMgr);
        this.removePolicy("_UNCHECKED_", null);
        _logger.exit(string);
    }

    public void removeFromRole(String string, Permission permission) throws PolicyContextException {
        String string2 = "removeFromRolePolicy(String, Permission)";
        _logger.entry(string2, new Object[]{string, permission});
        if (permission == null || string == null) {
            String string3 = CWRGSMessageHelper.getMessage("REMOVE_ROLE_PERM_ERROR", new Object[]{permission, string});
            _logger.error(string2, string3);
            throw new PolicyContextException(string3);
        }
        CommonAuthzUtilities.checkSecurityPermission(string2, _logger, this._secMgr);
        this.removePolicy(string, permission);
        _logger.exit(string2);
    }

    public void removeRole(String string) throws PolicyContextException {
        String string2 = "removeRole(String)";
        _logger.entry(string2, string);
        if (string == null) {
            String string3 = CWRGSMessageHelper.getMessage("REMOVE_ROLE_POLICY_NULL");
            _logger.error(string2, string3);
            throw new PolicyContextException(string3);
        }
        CommonAuthzUtilities.checkSecurityPermission(string2, _logger, this._secMgr);
        this.removePolicy(string, null);
        _logger.exit(string2);
    }

    private void removePolicy(String string, Permission permission) throws PolicyContextException {
        String string2 = "removePolicy( String, Permission )";
        _logger.entry(string2, new Object[]{string, permission});
        CommonAuthzUtilities.checkForValidState(string2, _logger, this._state, (short)0);
        PolicyConfigObject policyConfigObject = null;
        policyConfigObject = permission != null ? new PolicyConfigObject(string, permission) : new PolicyConfigObject(string);
        try {
            this._cfgDP.removePolicy(policyConfigObject);
        }
        catch (DataProcessingException dataProcessingException) {
            String string3 = CWRGSMessageHelper.getMessage("REMOVE_ROLE_POLICY_ERROR", new Object[]{this._contextID, string, permission, dataProcessingException.toString()});
            _logger.error(string2, string3, dataProcessingException);
            throw new PolicyContextException(string3, (Throwable)dataProcessingException);
        }
        _logger.exit(string2);
    }

    public boolean inService() throws PolicyContextException {
        String string = "inService()";
        _logger.entry(string);
        boolean bl = false;
        CommonAuthzUtilities.checkSecurityPermission(string, _logger, this._secMgr);
        if (this._state == 1) {
            bl = true;
        }
        _logger.exit(string, new Boolean(bl));
        return bl;
    }

    public void addToExcludedPolicy(Permission permission) throws PolicyContextException {
        String string = "addToExcludedPolicy(Permission)";
        _logger.entry(string, permission);
        if (permission == null) {
            String string2 = CWRGSMessageHelper.getMessage("ADD_EXCLUDED_PERM_NULL");
            _logger.error(string, string2);
            throw new PolicyContextException(string2);
        }
        CommonAuthzUtilities.checkSecurityPermission(string, _logger, this._secMgr);
        this.deployPermission("_EXCLUDED_", permission);
        _logger.exit(string);
    }

    public void addToUncheckedPolicy(Permission permission) throws PolicyContextException {
        String string = "addToUncheckedPolicy(Permission)";
        _logger.entry(string, permission);
        if (permission == null) {
            String string2 = CWRGSMessageHelper.getMessage("ADD_UNCHECKED_PERM_NULL");
            _logger.error(string, string2);
            throw new PolicyContextException(string2);
        }
        CommonAuthzUtilities.checkSecurityPermission(string, _logger, this._secMgr);
        this.deployPermission("_UNCHECKED_", permission);
        _logger.exit(string);
    }

    public void addToExcludedPolicy(PermissionCollection permissionCollection) throws PolicyContextException {
        String string = "addToExcludedPolicy(PermissionCollection)";
        _logger.entry(string);
        if (permissionCollection == null) {
            String string2 = CWRGSMessageHelper.getMessage("ADD_EXCLUDED_PERMS_NULL");
            _logger.error(string, string2);
            throw new PolicyContextException(string2);
        }
        CommonAuthzUtilities.checkSecurityPermission(string, _logger, this._secMgr);
        Enumeration<Permission> enumeration = permissionCollection.elements();
        while (enumeration.hasMoreElements()) {
            Permission permission = enumeration.nextElement();
            this.deployPermission("_EXCLUDED_", permission);
        }
        _logger.exit(string);
    }

    public void addToUncheckedPolicy(PermissionCollection permissionCollection) throws PolicyContextException {
        String string = "addToUncheckedPolicy(PermissionCollection)";
        _logger.entry(string);
        if (permissionCollection == null) {
            String string2 = CWRGSMessageHelper.getMessage("ADD_UNCHECKED_PERMS_NULL");
            _logger.error(string, string2);
            throw new PolicyContextException(string2);
        }
        CommonAuthzUtilities.checkSecurityPermission(string, _logger, this._secMgr);
        Enumeration<Permission> enumeration = permissionCollection.elements();
        while (enumeration.hasMoreElements()) {
            Permission permission = enumeration.nextElement();
            this.deployPermission("_UNCHECKED_", permission);
        }
        _logger.exit(string);
    }

    public void addToRole(String string, Permission permission) throws PolicyContextException {
        String string2 = "addToRole(String, Permission)";
        _logger.entry(string2, new Object[]{string, permission});
        if (permission == null || string == null) {
            String string3 = CWRGSMessageHelper.getMessage("ADD_PERMISSION_TO_ROLE", new Object[]{permission, string});
            _logger.error(string2, string3);
            throw new PolicyContextException(string3);
        }
        CommonAuthzUtilities.checkSecurityPermission(string2, _logger, this._secMgr);
        this.deployPermission(string, permission);
        _logger.exit(string2);
    }

    public void addToRole(String string, PermissionCollection permissionCollection) throws PolicyContextException {
        String string2 = "addToRole(String, PermissionCollection)";
        _logger.entry(string2, string);
        if (permissionCollection == null || string == null) {
            String string3 = CWRGSMessageHelper.getMessage("ADD_PERMISSIONS_TO_ROLE", new Object[]{permissionCollection, string});
            _logger.error(string2, string3);
            throw new PolicyContextException(string3);
        }
        CommonAuthzUtilities.checkSecurityPermission(string2, _logger, this._secMgr);
        Enumeration<Permission> enumeration = permissionCollection.elements();
        while (enumeration.hasMoreElements()) {
            Permission permission = enumeration.nextElement();
            this.deployPermission(string, permission);
        }
        _logger.exit(string2);
    }

    private void deployPermission(String string, Permission permission) throws PolicyContextException {
        String string2 = "deployPermission( String, Permission )";
        _logger.entry(string2, new Object[]{string, permission});
        CommonAuthzUtilities.checkForValidState(string2, _logger, this._state, (short)0);
        PolicyConfigObject policyConfigObject = new PolicyConfigObject(string, permission);
        try {
            this._cfgDP.deployPolicy(policyConfigObject);
        }
        catch (DataProcessingException dataProcessingException) {
            String string3 = CWRGSMessageHelper.getMessage("DEPLOY_POLICY_ERROR", new Object[]{this._contextID, string, dataProcessingException.toString()});
            _logger.error(string2, string3, dataProcessingException);
            throw new PolicyContextException(string3, (Throwable)dataProcessingException);
        }
        _logger.exit(string2);
    }

    public void addRoleInheritance(String string, String string2) throws PolicyContextException {
        String string3 = "addRoleInheritance(String, String)";
        _logger.entry(string3, new Object[]{string, string2});
        if (string == null || string2 == null) {
            String string4 = CWRGSMessageHelper.getMessage("ADD_ROLE_INHERITANCE_NULL", new Object[]{string, string2});
            _logger.error(string3, string4);
            throw new PolicyContextException(string4);
        }
        CommonAuthzUtilities.checkSecurityPermission(string3, _logger, this._secMgr);
        CommonAuthzUtilities.checkForValidState(string3, _logger, this._state, (short)0);
        try {
            this._cfgDP.addInheritedRole(string, string2);
        }
        catch (DataProcessingException dataProcessingException) {
            String string5 = CWRGSMessageHelper.getMessage("ADD_ROLE_INHERITANCE_ERROR", new Object[]{this._contextID, string, string2, dataProcessingException.toString()});
            _logger.error(string3, string5, dataProcessingException);
            throw new PolicyContextException(string5, (Throwable)dataProcessingException);
        }
        _logger.exit(string3);
    }

    public void writeXML(OutputStream outputStream) throws XMLSerializationException, IOException, ParserConfigurationException {
        String string = "writeXML(OutputStream)";
        _logger.entry(string);
        if (outputStream == null) {
            String string2 = CWRGSMessageHelper.getMessage("WRITE_XML_NULL");
            _logger.error(string, string2);
            throw new XMLSerializationException(string2);
        }
        CommonAuthzUtilities.checkSecurityPermission(string, _logger, this._secMgr);
        CommonAuthzUtilities.checkForInvalidState(string, _logger, this._state, (short)2);
        try {
            this._cfgDP.retrieveXACML(outputStream);
        }
        catch (DataProcessingException dataProcessingException) {
            String string3 = CWRGSMessageHelper.getMessage("WRITE_XML_ERROR", new Object[]{this._contextID, dataProcessingException.toString()});
            _logger.error(string, string3, dataProcessingException);
            throw new XMLSerializationException(string3, dataProcessingException);
        }
        _logger.exit(string);
    }

    public void readXML(InputStream inputStream) throws XMLSerializationException, IOException, SAXException, ParserConfigurationException {
        String string = "readXML(InputStream)";
        _logger.entry(string);
        if (inputStream == null) {
            String string2 = CWRGSMessageHelper.getMessage("READ_XML_NULL");
            _logger.error(string, string2);
            throw new XMLSerializationException(string2);
        }
        CommonAuthzUtilities.checkSecurityPermission(string, _logger, this._secMgr);
        CommonAuthzUtilities.checkForValidState(string, _logger, this._state, (short)0);
        try {
            this._cfgDP.deployXACML(inputStream);
        }
        catch (DataProcessingException dataProcessingException) {
            String string3 = CWRGSMessageHelper.getMessage("READ_XML_ERROR", new Object[]{this._contextID, dataProcessingException.toString()});
            _logger.error(string, string3, dataProcessingException);
            throw new XMLSerializationException(string3, dataProcessingException);
        }
        _logger.exit(string);
    }

    public void setStateOpen() throws PolicyContextException {
        String string = "setStateOpen()";
        _logger.entry(string);
        try {
            this._cfgDP.setState((short)0, UPDATE_STATE);
            this._state = this._cfgDP.getState();
        }
        catch (DataProcessingException dataProcessingException) {
            String string2 = CWRGSMessageHelper.getMessage("SET_STATE_OPEN_ERROR", new Object[]{this._contextID, dataProcessingException.toString()});
            _logger.error(string, string2, dataProcessingException);
            throw new PolicyContextException(string2, (Throwable)dataProcessingException);
        }
        _logger.exit(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

