/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.authz.provider;

import com.ibm.sec.authz.jaccx.EntitlementPolicy;
import com.ibm.sec.authz.jaccx.EvaluationContext;
import com.ibm.sec.authz.jaccx.PolicyContextWrapper;
import com.ibm.sec.authz.jaccx.role.RoleCondition;
import com.ibm.sec.authz.jaccx.role.RoleMapping;
import com.ibm.sec.authz.jaccx.role.RoleMappingContext;
import com.ibm.sec.authz.jaccx.role.RoleMappingContextFactory;
import com.ibm.sec.authz.jaccx.role.RoleMappingRefreshFailureException;
import com.ibm.sec.authz.provider.CommonAuthzSystemPolicy;
import com.ibm.sec.iauthz.log.SecLogger;
import com.ibm.sec.iauthz.mcc.DataProcessingException;
import com.ibm.sec.iauthz.mcc.DataProcessingFactory;
import com.ibm.sec.iauthz.mcc.IRtRoleDataProcessing;
import com.ibm.sec.iauthz.mcc.dna.DeltaDataObject;
import com.ibm.sec.iauthz.runtime.FileBasedOptimizedRoleMappingConfiguration;
import com.ibm.sec.iauthz.runtime.MemoryBasedOptimizedRoleMappingConfiguration;
import com.ibm.sec.iauthz.runtime.OptimizedRoleMappingConfiguration;
import com.ibm.sec.iauthz.runtime.RWLock;
import com.ibm.sec.iauthz.runtime.RuntimeConfiguration;
import com.ibm.sec.iauthz.runtime.RuntimeUtils;
import com.ibm.sec.iauthz.util.CWRGSMessageHelper;
import com.ibm.sec.iauthz.util.CollectionFactory;
import java.io.File;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;

public class CommonAuthzRoleMapping
extends RoleMapping {
    private static final SecLogger logger = SecLogger.getLogger(class$com$ibm$sec$authz$provider$CommonAuthzRoleMapping == null ? (class$com$ibm$sec$authz$provider$CommonAuthzRoleMapping = CommonAuthzRoleMapping.class$("com.ibm.sec.authz.provider.CommonAuthzRoleMapping")) : class$com$ibm$sec$authz$provider$CommonAuthzRoleMapping);
    private final Map roleMap;
    private final RuntimeConfiguration runtimeConfig;
    private final boolean lockEnabled = true;
    private final RWLock lock = new RWLock();
    private static final Object dummyLock = new Object();
    private static int num_of_instances;
    private static final int MAX_RETURN = 256;
    static /* synthetic */ Class class$com$ibm$sec$authz$provider$CommonAuthzRoleMapping;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommonAuthzRoleMapping() {
        if (logger.isEntryLevel()) {
            logger.entry("<init>");
        }
        Object object = dummyLock;
        synchronized (object) {
            if (++num_of_instances > 1 && logger.isWarningLevel()) {
                String string = CWRGSMessageHelper.getMessage("PE_PROVIDER_MUST_BE_SINGLETON", new Object[]{this.getClass().getName()});
                logger.warning("<init>", string);
            }
        }
        this.runtimeConfig = new RuntimeConfiguration("role");
        this.roleMap = CollectionFactory.newMap();
        this.refresh();
        if (logger.isEntryLevel()) {
            logger.exit("<init>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean inService(String string) {
        if (logger.isEntryLevel()) {
            logger.entry("inService(String)", string);
        }
        this.lock.beginRead();
        try {
            boolean bl = this.roleMap.keySet().contains(string);
            if (logger.isExitLevel()) {
                logger.exit("inService(String)", Boolean.toString(bl));
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            this.lock.endRead();
        }
    }

    public boolean checkRoleMembership(String string) {
        if (logger.isEntryLevel()) {
            logger.entry("checkRoleMembership(String)", string);
        }
        RoleMappingContext roleMappingContext = CommonAuthzRoleMapping.getRoleMappingContext(PolicyContext.getContextID());
        boolean bl = this._checkRoleMembership(roleMappingContext, PolicyContextWrapper.POLICY_CONTEXT, string);
        if (logger.isExitLevel()) {
            logger.exit("checkRoleMembership(String)", bl);
        }
        return bl;
    }

    public boolean checkRoleMembership(RoleMappingContext roleMappingContext, EvaluationContext evaluationContext, String string) {
        if (logger.isEntryLevel()) {
            logger.entry("checkRoleMembership(RoleMappingContext, EvaluationContext, String)", new Object[]{roleMappingContext, evaluationContext, string});
        }
        boolean bl = this._checkRoleMembership(roleMappingContext, evaluationContext, string);
        if (logger.isExitLevel()) {
            logger.exit("checkRoleMembership(RoleMappingContext, EvaluationContext, String)", bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _checkRoleMembership(RoleMappingContext roleMappingContext, EvaluationContext evaluationContext, String string) {
        boolean bl;
        if (logger.isEntryLevel()) {
            logger.entry("_checkRoleMembership(RoleMappingContext, EvaluationContext, String)", new Object[]{roleMappingContext, evaluationContext, string});
        }
        RuntimeUtils.dumpEvaluationContext(roleMappingContext, evaluationContext);
        if (roleMappingContext == null) {
            if (logger.isWarningLevel()) {
                String string2 = CWRGSMessageHelper.getMessage("PE_ROLE_MAPPING_CONTEXT_IS_NULL_AT_RUNTIME");
                logger.warning("_checkRoleMembership(RoleMappingContext, EvaluationContext, String)", string2);
            }
            if (logger.isExitLevel()) {
                logger.exit("_checkRoleMembership(RoleMappingContext, EvaluationContext, String)", Boolean.FALSE);
            }
            return false;
        }
        this.lock.beginRead();
        try {
            OptimizedRoleMappingConfiguration optimizedRoleMappingConfiguration = (OptimizedRoleMappingConfiguration)this.roleMap.get(roleMappingContext.getContextID());
            if (optimizedRoleMappingConfiguration == null) {
                if (logger.isWarningLevel()) {
                    String string3 = CWRGSMessageHelper.getMessage("PE_ROLE_MAPPING_CONTEXT_NOT_IN_SERVICE", new Object[]{roleMappingContext.getContextID()});
                    logger.warning("_checkRoleMembership(RoleMappingContext, EvaluationContext, String)", string3);
                }
                if (logger.isExitLevel()) {
                    logger.exit("_checkRoleMembership(RoleMappingContext, EvaluationContext, String)", Boolean.FALSE);
                }
                boolean bl2 = false;
                return bl2;
            }
            bl = optimizedRoleMappingConfiguration.checkRoleMembership(string, evaluationContext);
        }
        finally {
            this.lock.endRead();
        }
        if (logger.isExitLevel()) {
            logger.exit("_checkRoleMembership(RoleMappingContext, EvaluationContext, String)", bl);
        }
        return bl;
    }

    public Iterator getRoles(RoleMappingContext roleMappingContext, EvaluationContext evaluationContext) {
        if (logger.isEntryLevel()) {
            logger.entry("getRoles(RoleMappingContext, EvaluationContext)", new Object[]{roleMappingContext, evaluationContext});
        }
        Iterator iterator = this._getRoles(roleMappingContext, evaluationContext);
        if (logger.isExitLevel()) {
            logger.exit("getRoles(RoleMappingContext, EvaluationContext)", iterator);
        }
        return iterator;
    }

    public Iterator getRoles() {
        if (logger.isEntryLevel()) {
            logger.entry("getRoles");
        }
        RoleMappingContext roleMappingContext = CommonAuthzRoleMapping.getRoleMappingContext(PolicyContext.getContextID());
        Iterator iterator = this._getRoles(roleMappingContext, PolicyContextWrapper.POLICY_CONTEXT);
        if (logger.isExitLevel()) {
            logger.exit("getRoles", iterator);
        }
        return iterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator _getRoles(RoleMappingContext roleMappingContext, EvaluationContext evaluationContext) {
        Iterator iterator;
        if (logger.isEntryLevel()) {
            logger.entry("_getRoles(RoleMappingContext, EvaluationContext)", new Object[]{roleMappingContext, evaluationContext});
        }
        RuntimeUtils.dumpEvaluationContext(roleMappingContext, evaluationContext);
        if (roleMappingContext == null) {
            if (logger.isWarningLevel()) {
                String string = CWRGSMessageHelper.getMessage("PE_ROLE_MAPPING_CONTEXT_IS_NULL_AT_RUNTIME");
                logger.warning("_getRoles(RoleMappingContext, EvaluationContext)", string);
            }
            if (logger.isExitLevel()) {
                logger.exit("_getRoles(RoleMappingContext, EvaluationContext)");
            }
            return CollectionFactory.newSet().iterator();
        }
        this.lock.beginRead();
        try {
            OptimizedRoleMappingConfiguration optimizedRoleMappingConfiguration = (OptimizedRoleMappingConfiguration)this.roleMap.get(roleMappingContext.getContextID());
            if (optimizedRoleMappingConfiguration == null) {
                Object object;
                if (logger.isWarningLevel()) {
                    object = CWRGSMessageHelper.getMessage("PE_ROLE_MAPPING_CONTEXT_NOT_IN_SERVICE", new Object[]{roleMappingContext.getContextID()});
                    logger.warning("_getRoles(RoleMappingContext, EvaluationContext)", (String)object);
                }
                if (logger.isExitLevel()) {
                    logger.exit("_getRoles(RoleMappingContext, EvaluationContext)");
                }
                object = CollectionFactory.newSet().iterator();
                return object;
            }
            iterator = optimizedRoleMappingConfiguration.getRoles(evaluationContext);
        }
        finally {
            this.lock.endRead();
        }
        if (logger.isExitLevel()) {
            logger.exit("_getRoles(RoleMappingContext, EvaluationContext)", iterator);
        }
        return iterator;
    }

    public PermissionCollection getPermissions() {
        if (logger.isEntryLevel()) {
            logger.entry("getPermissions");
        }
        Iterator iterator = this.getRoles();
        Policy policy = CommonAuthzSystemPolicy.getPolicy();
        Permissions permissions = new Permissions();
        if (policy instanceof EntitlementPolicy) {
            Enumeration<Permission> enumeration = ((EntitlementPolicy)((Object)policy)).getPermissions(null).elements();
            while (enumeration.hasMoreElements()) {
                ((PermissionCollection)permissions).add(enumeration.nextElement());
            }
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                enumeration = ((EntitlementPolicy)((Object)policy)).getPermissions(string).elements();
                while (enumeration.hasMoreElements()) {
                    ((PermissionCollection)permissions).add(enumeration.nextElement());
                }
            }
            permissions.setReadOnly();
            if (logger.isExitLevel()) {
                logger.exit("getPermissions", permissions);
            }
            return permissions;
        }
        throw new RuntimeException("The policy provider does not support getPermissions().");
    }

    public PermissionCollection getPermissions(String string, EvaluationContext evaluationContext) {
        if (logger.isEntryLevel()) {
            logger.entry("getPermissions(String, EvaluationContext)");
        }
        RoleMappingContext roleMappingContext = CommonAuthzRoleMapping.getRoleMappingContext(string);
        Iterator iterator = this.getRoles(roleMappingContext, evaluationContext);
        Permissions permissions = new Permissions();
        Policy policy = CommonAuthzSystemPolicy.getPolicy();
        if (policy instanceof EntitlementPolicy) {
            Enumeration<Permission> enumeration = ((EntitlementPolicy)((Object)policy)).getPermissions(string, evaluationContext, null).elements();
            while (enumeration.hasMoreElements()) {
                ((PermissionCollection)permissions).add(enumeration.nextElement());
            }
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                enumeration = ((EntitlementPolicy)((Object)policy)).getPermissions(string, evaluationContext, string2).elements();
                while (enumeration.hasMoreElements()) {
                    ((PermissionCollection)permissions).add(enumeration.nextElement());
                }
            }
            permissions.setReadOnly();
            if (logger.isExitLevel()) {
                logger.exit("getPermissions(String, EvaluationContext)", permissions);
            }
            return permissions;
        }
        throw new RuntimeException("The policy provider does not support getPermissions(String, EvaluationContext).");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        if (logger.isEntryLevel()) {
            logger.entry("refresh");
        }
        this.lock.beginWrite();
        try {
            this.privateRefresh();
        }
        finally {
            this.lock.endWrite();
        }
        if (logger.isExitLevel()) {
            logger.exit("refresh");
        }
    }

    private void privateRefresh() {
        String string;
        Iterator iterator;
        if (logger.isEntryLevel()) {
            logger.entry("privateRefresh");
        }
        File file = this.runtimeConfig.getDirectory();
        Set set = CollectionFactory.newSet();
        DataProcessingFactory dataProcessingFactory = DataProcessingFactory.getFactory();
        try {
            iterator = dataProcessingFactory.getRoleContextIDList();
        }
        catch (DataProcessingException dataProcessingException) {
            String string2 = CWRGSMessageHelper.getMessage("PE_ROLE_MAPPING_CONTEXT_LIST_ERROR");
            if (logger.isErrorLevel()) {
                logger.error("privateRefresh", string2, dataProcessingException);
            }
            throw new RoleMappingRefreshFailureException(string2, dataProcessingException);
        }
        if (iterator != null) {
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                if (string3 == null) {
                    if (!logger.isWarningLevel()) continue;
                    String string4 = CWRGSMessageHelper.getMessage("PE_NULL_CONTEXT_ID");
                    logger.warning("privateRefresh", string4);
                    continue;
                }
                if (string3.length() == 0) {
                    if (!logger.isWarningLevel()) continue;
                    String string5 = CWRGSMessageHelper.getMessage("PE_EMPTY_CONTEXT_ID");
                    logger.warning("privateRefresh", string5);
                    continue;
                }
                if (logger.isDebugLevel()) {
                    String string6 = CWRGSMessageHelper.getMessage("PE_CHECK_ROLE_MAPPING_CONTEXT_VERSION", new Object[]{string3});
                    logger.debug("privateRefresh", string6);
                }
                set.add(string3);
                try {
                    boolean bl;
                    String string7;
                    OptimizedRoleMappingConfiguration optimizedRoleMappingConfiguration;
                    String string8;
                    IRtRoleDataProcessing iRtRoleDataProcessing;
                    block31: {
                        String string9 = this.runtimeConfig.getClientID(string3);
                        iRtRoleDataProcessing = dataProcessingFactory.getRtRoleInstance(string3, string9);
                        iRtRoleDataProcessing.setMaxReturn(256);
                        string8 = iRtRoleDataProcessing.getCurrentVersion();
                        if (logger.isDebugLevel()) {
                            string = CWRGSMessageHelper.getMessage("PE_STORAGE_VERSION", new Object[]{string8});
                            logger.debug("privateRefresh", string);
                        }
                        if ((optimizedRoleMappingConfiguration = (OptimizedRoleMappingConfiguration)this.roleMap.get(string3)) == null) {
                            if (this.runtimeConfig.useFileSystem() && FileBasedOptimizedRoleMappingConfiguration.exists(string3, this.runtimeConfig)) {
                                try {
                                    optimizedRoleMappingConfiguration = new FileBasedOptimizedRoleMappingConfiguration(string3, this.runtimeConfig, false);
                                    if (((FileBasedOptimizedRoleMappingConfiguration)optimizedRoleMappingConfiguration).isSupported()) {
                                        this.roleMap.put(string3, optimizedRoleMappingConfiguration);
                                        string7 = optimizedRoleMappingConfiguration.getVersion();
                                        break block31;
                                    }
                                    ((FileBasedOptimizedRoleMappingConfiguration)optimizedRoleMappingConfiguration).delete();
                                    optimizedRoleMappingConfiguration = null;
                                    string7 = null;
                                }
                                catch (RuntimeException runtimeException) {
                                    optimizedRoleMappingConfiguration = null;
                                    string7 = null;
                                }
                            } else {
                                string7 = null;
                            }
                        } else {
                            string7 = optimizedRoleMappingConfiguration.getVersion();
                        }
                    }
                    if (logger.isDebugLevel()) {
                        string = CWRGSMessageHelper.getMessage("PE_LOCAL_REPLICA_VERSION", new Object[]{string7});
                        logger.debug("privateRefresh", string);
                    }
                    if (string7 != null && string8 != null && !string7.equals(string8)) {
                        if (logger.isWarningLevel()) {
                            string = CWRGSMessageHelper.getMessage("PE_ROLE_MAPPING_VERSION_INCONSISTENCY", new Object[]{string3, string7, string8});
                            logger.warning("privateRefresh", string);
                        }
                        if (this.runtimeConfig.useFileSystem() && optimizedRoleMappingConfiguration != null) {
                            ((FileBasedOptimizedRoleMappingConfiguration)optimizedRoleMappingConfiguration).delete();
                        }
                        optimizedRoleMappingConfiguration = null;
                        string7 = null;
                        bl = true;
                    } else {
                        bl = string7 == null || string8 == null || !iRtRoleDataProcessing.isCurrent();
                    }
                    if (!bl) continue;
                    if (logger.isDebugLevel()) {
                        string = CWRGSMessageHelper.getMessage("PE_RETRIEVE_ROLE_MAPPING_CONTEXT", new Object[]{string3});
                        logger.debug("privateRefresh", string);
                    }
                    if (this.runtimeConfig.useFileSystem()) {
                        if (string7 == null) {
                            this.full_retrieve(iRtRoleDataProcessing, string3);
                            continue;
                        }
                        this.delta_retrieve(optimizedRoleMappingConfiguration, iRtRoleDataProcessing, string3);
                        continue;
                    }
                    this.full_retrieve(iRtRoleDataProcessing, string3);
                }
                catch (Exception exception) {
                    if (logger.isErrorLevel()) {
                        string = CWRGSMessageHelper.getMessage("PE_ROLE_MAPPING_CONTEXT_REFRESH_ERROR", new Object[]{string3});
                        logger.error("privateRefresh", string, exception);
                    }
                    set.remove(string3);
                    this.roleMap.remove(string3);
                }
            }
        }
        Iterator iterator2 = this.roleMap.keySet().iterator();
        while (iterator2.hasNext()) {
            string = (String)iterator2.next();
            if (set.contains(string)) continue;
            iterator2.remove();
            if (!logger.isDebugLevel()) continue;
            String string10 = CWRGSMessageHelper.getMessage("PE_RMC_REMOVED_FROM_LOCAL_REPLICA", new Object[]{string});
            logger.debug("privateRefresh", string10);
        }
        if (this.runtimeConfig.useFileSystem()) {
            FileBasedOptimizedRoleMappingConfiguration.removeDirectoriesNotInService(file, set);
        }
        if (logger.isExitLevel()) {
            logger.exit("privateRefresh");
        }
    }

    private void full_retrieve(IRtRoleDataProcessing iRtRoleDataProcessing, String string) throws DataProcessingException {
        Set set;
        Principal principal;
        Object object;
        if (logger.isEntryLevel()) {
            logger.entry("full_retrieve(IRtRoleDataProcessing, String)", new Object[]{iRtRoleDataProcessing, string});
        }
        OptimizedRoleMappingConfiguration optimizedRoleMappingConfiguration = this.runtimeConfig.useFileSystem() ? new FileBasedOptimizedRoleMappingConfiguration(string, this.runtimeConfig, true) : new MemoryBasedOptimizedRoleMappingConfiguration(string, this.runtimeConfig);
        String string2 = iRtRoleDataProcessing.getCombiningAlgorithm();
        if (logger.isDebugLevel()) {
            object = CWRGSMessageHelper.getMessage("PE_RETRIEVED_COMBINING_ALGORITHM_ID", new Object[]{string2});
            logger.debug("full_retrieve(IRtRoleDataProcessing, String)", (String)object);
        }
        optimizedRoleMappingConfiguration.setCombiningAlgorithm(string2);
        this.roleMap.put(string, optimizedRoleMappingConfiguration);
        iRtRoleDataProcessing.setExtractType((short)0);
        object = iRtRoleDataProcessing.retrievePrincipals((short)0);
        while (object.hasNext()) {
            principal = (Principal)object.next();
            set = CommonAuthzRoleMapping.retrieveFullRoleConditions(iRtRoleDataProcessing, principal);
            optimizedRoleMappingConfiguration.addToPrincipal(principal, set);
        }
        while ((object = iRtRoleDataProcessing.retrievePrincipals((short)1)).hasNext()) {
            while (object.hasNext()) {
                principal = (Principal)object.next();
                set = CommonAuthzRoleMapping.retrieveFullRoleConditions(iRtRoleDataProcessing, principal);
                optimizedRoleMappingConfiguration.addToPrincipal(principal, set);
            }
        }
        iRtRoleDataProcessing.updateVersion();
        String string3 = iRtRoleDataProcessing.getCurrentVersion();
        if (logger.isDebugLevel()) {
            String string4 = CWRGSMessageHelper.getMessage("PE_RETRIEVED_VERSION", new Object[]{string3});
            logger.debug("full_retrieve(IRtRoleDataProcessing, String)", string4);
        }
        optimizedRoleMappingConfiguration.setVersion(string3);
        optimizedRoleMappingConfiguration.update();
        if (logger.isExitLevel()) {
            logger.exit("full_retrieve(IRtRoleDataProcessing, String)");
        }
    }

    private void delta_retrieve(OptimizedRoleMappingConfiguration optimizedRoleMappingConfiguration, IRtRoleDataProcessing iRtRoleDataProcessing, String string) throws DataProcessingException {
        String string2;
        Principal principal;
        if (logger.isEntryLevel()) {
            logger.entry("delta_retrieve(OptimizedRoleMappingConfiguration, IRtRoleDataProcessing, String)", new Object[]{optimizedRoleMappingConfiguration, iRtRoleDataProcessing, string});
        }
        optimizedRoleMappingConfiguration.invalidateCache();
        iRtRoleDataProcessing.setExtractType((short)1);
        Iterator iterator = iRtRoleDataProcessing.retrievePrincipals((short)0);
        while (iterator.hasNext()) {
            principal = (Principal)iterator.next();
            CommonAuthzRoleMapping.retrieveDeltaRoleConditions(optimizedRoleMappingConfiguration, iRtRoleDataProcessing, principal);
        }
        while ((iterator = iRtRoleDataProcessing.retrievePrincipals((short)1)).hasNext()) {
            while (iterator.hasNext()) {
                principal = (Principal)iterator.next();
                CommonAuthzRoleMapping.retrieveDeltaRoleConditions(optimizedRoleMappingConfiguration, iRtRoleDataProcessing, principal);
            }
        }
        String string3 = iRtRoleDataProcessing.getCombiningAlgorithm();
        if (logger.isDebugLevel()) {
            string2 = CWRGSMessageHelper.getMessage("PE_RETRIEVED_COMBINING_ALGORITHM_ID", new Object[]{string3});
            logger.debug("delta_retrieve(OptimizedRoleMappingConfiguration, IRtRoleDataProcessing, String)", string2);
        }
        optimizedRoleMappingConfiguration.setCombiningAlgorithm(string3);
        iRtRoleDataProcessing.updateVersion();
        string2 = iRtRoleDataProcessing.getCurrentVersion();
        if (logger.isDebugLevel()) {
            String string4 = CWRGSMessageHelper.getMessage("PE_RETRIEVED_VERSION", new Object[]{string2});
            logger.debug("delta_retrieve(OptimizedRoleMappingConfiguration, IRtRoleDataProcessing, String)", string4);
        }
        optimizedRoleMappingConfiguration.setVersion(string2);
        optimizedRoleMappingConfiguration.update();
        if (logger.isExitLevel()) {
            logger.exit("delta_retrieve(OptimizedRoleMappingConfiguration, IRtRoleDataProcessing, String)");
        }
    }

    private static Set retrieveFullRoleConditions(IRtRoleDataProcessing iRtRoleDataProcessing, Principal principal) throws DataProcessingException {
        String string;
        RoleCondition roleCondition;
        if (logger.isEntryLevel()) {
            logger.entry("retrieveFullRoleConditions(IRtRoleDataProcessing, Principal)", new Object[]{iRtRoleDataProcessing, principal});
        }
        Set set = CollectionFactory.newSet();
        Iterator iterator = iRtRoleDataProcessing.retrieveRoles(principal, (short)0);
        while (iterator.hasNext()) {
            roleCondition = (RoleCondition)iterator.next();
            if (logger.isDebugLevel()) {
                string = CWRGSMessageHelper.getMessage("PE_RETRIEVED_ROLE_CONDITION", new Object[]{principal, roleCondition});
                logger.debug("retrieveFullRoleConditions(IRtRoleDataProcessing, Principal)", string);
            }
            set.add(roleCondition);
        }
        while ((iterator = iRtRoleDataProcessing.retrieveRoles(principal, (short)1)).hasNext()) {
            while (iterator.hasNext()) {
                roleCondition = (RoleCondition)iterator.next();
                if (logger.isDebugLevel()) {
                    string = CWRGSMessageHelper.getMessage("PE_RETRIEVED_ROLE_CONDITION", new Object[]{principal, roleCondition});
                    logger.debug("retrieveFullRoleConditions(IRtRoleDataProcessing, Principal)", string);
                }
                set.add(roleCondition);
            }
        }
        if (logger.isExitLevel()) {
            logger.exit("retrieveFullRoleConditions(IRtRoleDataProcessing, Principal)", set);
        }
        return set;
    }

    private static void retrieveDeltaRoleConditions(OptimizedRoleMappingConfiguration optimizedRoleMappingConfiguration, IRtRoleDataProcessing iRtRoleDataProcessing, Principal principal) throws DataProcessingException {
        String string;
        RoleCondition roleCondition;
        DeltaDataObject deltaDataObject;
        if (logger.isEntryLevel()) {
            logger.entry("retrieveDeltaRoleConditions(OptimizedRoleMappingConfiguration, IRtRoleDataProcessing, Principal)", new Object[]{optimizedRoleMappingConfiguration, iRtRoleDataProcessing, principal});
        }
        Iterator iterator = iRtRoleDataProcessing.retrieveRoles(principal, (short)0);
        while (iterator.hasNext()) {
            deltaDataObject = (DeltaDataObject)iterator.next();
            roleCondition = (RoleCondition)deltaDataObject.getData().getValue();
            if (deltaDataObject.getType() == 0) {
                if (logger.isDebugLevel()) {
                    string = CWRGSMessageHelper.getMessage("PE_DELTA_ADDED_ROLE_CONDITION", new Object[]{principal, roleCondition});
                    logger.debug("retrieveDeltaRoleConditions(OptimizedRoleMappingConfiguration, IRtRoleDataProcessing, Principal)", string);
                }
                optimizedRoleMappingConfiguration.addToPrincipal(principal, roleCondition);
                continue;
            }
            if (deltaDataObject.getType() != 1) continue;
            if (logger.isDebugLevel()) {
                string = CWRGSMessageHelper.getMessage("PE_DELTA_REMOVED_ROLE_CONDITION", new Object[]{principal, roleCondition});
                logger.debug("retrieveDeltaRoleConditions(OptimizedRoleMappingConfiguration, IRtRoleDataProcessing, Principal)", string);
            }
            optimizedRoleMappingConfiguration.removeFromPrincipal(principal, roleCondition);
        }
        while ((iterator = iRtRoleDataProcessing.retrieveRoles(principal, (short)1)).hasNext()) {
            while (iterator.hasNext()) {
                deltaDataObject = (DeltaDataObject)iterator.next();
                roleCondition = (RoleCondition)deltaDataObject.getData().getValue();
                if (deltaDataObject.getType() == 0) {
                    if (logger.isDebugLevel()) {
                        string = CWRGSMessageHelper.getMessage("PE_DELTA_ADDED_ROLE_CONDITION", new Object[]{principal, roleCondition});
                        logger.debug("retrieveDeltaRoleConditions(OptimizedRoleMappingConfiguration, IRtRoleDataProcessing, Principal)", string);
                    }
                    optimizedRoleMappingConfiguration.addToPrincipal(principal, roleCondition);
                    continue;
                }
                if (deltaDataObject.getType() != 1) continue;
                if (logger.isDebugLevel()) {
                    string = CWRGSMessageHelper.getMessage("PE_DELTA_REMOVED_ROLE_CONDITION", new Object[]{principal, roleCondition});
                    logger.debug("retrieveDeltaRoleConditions(OptimizedRoleMappingConfiguration, IRtRoleDataProcessing, Principal)", string);
                }
                optimizedRoleMappingConfiguration.removeFromPrincipal(principal, roleCondition);
            }
        }
        if (logger.isExitLevel()) {
            logger.exit("retrieveDeltaRoleConditions(OptimizedRoleMappingConfiguration, IRtRoleDataProcessing, Principal)");
        }
    }

    public Iterator getResources(String string, EvaluationContext evaluationContext, Permission permission) {
        if (logger.isWarningLevel()) {
            String string2 = CWRGSMessageHelper.getMessage("PE_NOT_IMPLEMENTED");
            logger.warning("getResources(String, EvaluationContext, Permission)", string2);
        }
        return CollectionFactory.newSet().iterator();
    }

    public Iterator getResources(Permission permission) {
        if (logger.isWarningLevel()) {
            String string = CWRGSMessageHelper.getMessage("PE_NOT_IMPLEMENTED");
            logger.warning("getResources(Permission)", string);
        }
        return CollectionFactory.newSet().iterator();
    }

    private static RoleMappingContext getRoleMappingContext(String string) {
        if (logger.isEntryLevel()) {
            logger.entry("getRoleMappingContext(String)", string);
        }
        try {
            RoleMappingContext roleMappingContext = ((RoleMappingContextFactory)((Object)CommonAuthzSystemPolicy.getPolicy())).getRoleMappingContext(string);
            if (logger.isExitLevel()) {
                logger.exit("getRoleMappingContext(String)", roleMappingContext);
            }
            return roleMappingContext;
        }
        catch (PolicyContextException policyContextException) {
            if (logger.isErrorLevel()) {
                String string2 = CWRGSMessageHelper.getMessage("PE_FAILED_TO_GET_ROLE_MAPPING_CONTEXT_AT_RUNTIME", new Object[]{string});
                logger.error("getRoleMappingContext(String)", string2, policyContextException);
            }
            if (logger.isExitLevel()) {
                logger.exit("getRoleMappingContext(String)", null);
            }
            return null;
        }
    }

    public boolean checkRoleMembershipAtOrUnderneath(String string) {
        if (logger.isEntryLevel()) {
            logger.entry("checkRoleMembershipAtOrUnderneath(String)", string);
        }
        RoleMappingContext roleMappingContext = CommonAuthzRoleMapping.getRoleMappingContext(PolicyContext.getContextID());
        boolean bl = this._checkRoleMembershipAtOrUnderneath(roleMappingContext, PolicyContextWrapper.POLICY_CONTEXT, string);
        if (logger.isExitLevel()) {
            logger.exit("checkRoleMembershipAtOrUnderneath(String)", bl);
        }
        return bl;
    }

    public boolean checkRoleMembershipAtOrUnderneath(RoleMappingContext roleMappingContext, EvaluationContext evaluationContext, String string) {
        if (logger.isEntryLevel()) {
            logger.entry("checkRoleMembershipAtOrUnderneath(RoleMappingContext, EvaluationContext, String)", new Object[]{roleMappingContext, evaluationContext, string});
        }
        boolean bl = this._checkRoleMembershipAtOrUnderneath(roleMappingContext, evaluationContext, string);
        if (logger.isExitLevel()) {
            logger.exit("checkRoleMembershipAtOrUnderneath(RoleMappingContext, EvaluationContext, String)", bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _checkRoleMembershipAtOrUnderneath(RoleMappingContext roleMappingContext, EvaluationContext evaluationContext, String string) {
        boolean bl;
        if (logger.isEntryLevel()) {
            logger.entry("_checkRoleMembershipAtOrUnderneath(RoleMappingContext, EvaluationContext, String)", new Object[]{roleMappingContext, evaluationContext, string});
        }
        RuntimeUtils.dumpEvaluationContext(roleMappingContext, evaluationContext);
        if (roleMappingContext == null) {
            if (logger.isWarningLevel()) {
                String string2 = CWRGSMessageHelper.getMessage("PE_ROLE_MAPPING_CONTEXT_IS_NULL_AT_RUNTIME");
                logger.warning("_checkRoleMembershipAtOrUnderneath(RoleMappingContext, EvaluationContext, String)", string2);
            }
            if (logger.isExitLevel()) {
                logger.exit("_checkRoleMembershipAtOrUnderneath(RoleMappingContext, EvaluationContext, String)", Boolean.FALSE);
            }
            return false;
        }
        this.lock.beginRead();
        try {
            OptimizedRoleMappingConfiguration optimizedRoleMappingConfiguration = (OptimizedRoleMappingConfiguration)this.roleMap.get(roleMappingContext.getContextID());
            if (optimizedRoleMappingConfiguration == null) {
                if (logger.isDebugLevel()) {
                    String string3 = CWRGSMessageHelper.getMessage("PE_ROLE_MAPPING_CONTEXT_NOT_IN_SERVICE", new Object[]{roleMappingContext.getContextID()});
                    logger.debug("_checkRoleMembershipAtOrUnderneath(RoleMappingContext, EvaluationContext, String)", string3);
                }
                boolean bl2 = false;
                return bl2;
            }
            bl = optimizedRoleMappingConfiguration.checkRoleMembershipAtOrUnderneath(string, evaluationContext);
        }
        finally {
            this.lock.endRead();
        }
        if (logger.isExitLevel()) {
            logger.exit("_checkRoleMembershipAtOrUnderneath(RoleMappingContext, EvaluationContext, String)", bl);
        }
        return bl;
    }

    public boolean hasPermissionAtOrUnderneath(Permission permission) {
        Policy policy;
        if (logger.isEntryLevel()) {
            logger.entry("hasPermissionAtOrUnderneath(Permission)", permission);
        }
        if ((policy = CommonAuthzSystemPolicy.getPolicy()) instanceof EntitlementPolicy) {
            Iterator iterator = ((EntitlementPolicy)((Object)policy)).getRequiredRoles(permission);
            if (iterator == null) {
                if (logger.isExitLevel()) {
                    logger.exit("hasPermissionAtOrUnderneath(Permission)", Boolean.TRUE);
                }
                return true;
            }
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!this.checkRoleMembershipAtOrUnderneath(string)) continue;
                if (logger.isExitLevel()) {
                    logger.exit("hasPermissionAtOrUnderneath(Permission)", Boolean.TRUE);
                }
                return true;
            }
        } else {
            if (logger.isWarningLevel()) {
                String string = CWRGSMessageHelper.getMessage("PE_NOT_IMPLEMENTED");
                logger.warning("hasPermissionAtOrUnderneath(Permission)", string);
            }
            if (logger.isExitLevel()) {
                logger.exit("hasPermissionAtOrUnderneath(Permission)", Boolean.FALSE);
            }
            return false;
        }
        if (logger.isExitLevel()) {
            logger.exit("hasPermissionAtOrUnderneath(Permission)", Boolean.FALSE);
        }
        return false;
    }

    public boolean hasPermissionAtOrUnderneath(String string, EvaluationContext evaluationContext, Permission permission) {
        Policy policy;
        if (logger.isEntryLevel()) {
            logger.entry("hasPermissionAtOrUnderneath(String, EvaluationContext, Permission)", new Object[]{string, evaluationContext, permission});
        }
        if ((policy = CommonAuthzSystemPolicy.getPolicy()) instanceof EntitlementPolicy) {
            Iterator iterator = ((EntitlementPolicy)((Object)policy)).getRequiredRoles(string, evaluationContext, permission);
            if (iterator == null) {
                if (logger.isExitLevel()) {
                    logger.exit("hasPermissionAtOrUnderneath(String, EvaluationContext, Permission)", Boolean.TRUE);
                }
                return true;
            }
            RoleMappingContext roleMappingContext = CommonAuthzRoleMapping.getRoleMappingContext(string);
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (!this.checkRoleMembershipAtOrUnderneath(roleMappingContext, evaluationContext, string2)) continue;
                if (logger.isExitLevel()) {
                    logger.exit("hasPermissionAtOrUnderneath(String, EvaluationContext, Permission)", Boolean.TRUE);
                }
                return true;
            }
        } else {
            if (logger.isWarningLevel()) {
                String string3 = CWRGSMessageHelper.getMessage("PE_NOT_IMPLEMENTED");
                logger.warning("hasPermissionAtOrUnderneath(String, EvaluationContext, Permission)", string3);
            }
            if (logger.isExitLevel()) {
                logger.exit("hasPermissionAtOrUnderneath(String, EvaluationContext, Permission)", Boolean.FALSE);
            }
            return false;
        }
        if (logger.isExitLevel()) {
            logger.exit("hasPermissionAtOrUnderneath(String, EvaluationContext, Permission)", Boolean.FALSE);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getReferencedAttributeNames(RoleMappingContext roleMappingContext) {
        if (logger.isEntryLevel()) {
            logger.entry("getReferencedAttributeNames(RoleMappingContext)", roleMappingContext);
        }
        this.lock.beginRead();
        try {
            OptimizedRoleMappingConfiguration optimizedRoleMappingConfiguration = (OptimizedRoleMappingConfiguration)this.roleMap.get(roleMappingContext.getContextID());
            Set set = optimizedRoleMappingConfiguration.getReferencedAttributeNames();
            if (logger.isExitLevel()) {
                logger.exit("getReferencedAttributeNames(RoleMappingContext)", set);
            }
            Set set2 = set;
            return set2;
        }
        finally {
            this.lock.endRead();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

