/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.authz.provider;

import com.ibm.sec.authz.jaccx.role.RoleCondition;
import com.ibm.sec.authz.jaccx.role.RoleMappingConfiguration;
import com.ibm.sec.authz.jaccx.role.RoleMappingContextException;
import com.ibm.sec.authz.jaccx.xml.XMLSerializable;
import com.ibm.sec.authz.jaccx.xml.XMLSerializationException;
import com.ibm.sec.iauthz.log.SecLogger;
import com.ibm.sec.iauthz.mcc.DataProcessingException;
import com.ibm.sec.iauthz.mcc.DataProcessingFactory;
import com.ibm.sec.iauthz.mcc.ICfgDataProcessing;
import com.ibm.sec.iauthz.mcc.dna.CombiningAlgorithm;
import com.ibm.sec.iauthz.mcc.dna.RoleConfigObject;
import com.ibm.sec.iauthz.util.CWRGSMessageHelper;
import com.ibm.sec.iauthz.util.CollectionFactory;
import com.ibm.sec.iauthz.util.CommonAuthzUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.util.Iterator;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

class CommonAuthzRoleMappingConfiguration
implements RoleMappingConfiguration,
XMLSerializable {
    private ICfgDataProcessing _cfgDP;
    private short _state;
    private String _contextID;
    private SecurityManager _secMgr;
    private static final SecLogger _logger = SecLogger.getLogger(class$com$ibm$sec$authz$provider$CommonAuthzRoleMappingConfiguration == null ? (class$com$ibm$sec$authz$provider$CommonAuthzRoleMappingConfiguration = CommonAuthzRoleMappingConfiguration.class$("com.ibm.sec.authz.provider.CommonAuthzRoleMappingConfiguration")) : class$com$ibm$sec$authz$provider$CommonAuthzRoleMappingConfiguration);
    private static boolean UPDATE_STATE = true;
    private static boolean KEEP_STATE = false;
    static /* synthetic */ Class class$com$ibm$sec$authz$provider$CommonAuthzRoleMappingConfiguration;

    public CommonAuthzRoleMappingConfiguration(String string) throws RoleMappingContextException {
        String string2 = "CommonAuthzRoleMappingConfiguration(String)";
        _logger.entry(string2, string);
        if (string == null) {
            String string3 = CWRGSMessageHelper.getMessage("CONSTRUCT_ROLE_MAPPING_CONTEXT_ID_NULL");
            _logger.error(string2, string3);
            throw new RoleMappingContextException(string3);
        }
        try {
            DataProcessingFactory dataProcessingFactory = DataProcessingFactory.getFactory();
            this._cfgDP = dataProcessingFactory.getCfgInstance(string, string, DataProcessingFactory.IS_ROLE_MAPPING);
            this._contextID = string;
            this._cfgDP.setState((short)0, UPDATE_STATE);
            this._state = this._cfgDP.getState();
        }
        catch (DataProcessingException dataProcessingException) {
            String string4 = CWRGSMessageHelper.getMessage("CONSTRUCT_ROLE_MAPPING_ERROR", new Object[]{string, dataProcessingException.toString()});
            _logger.error(string2, string4, dataProcessingException);
            throw new RoleMappingContextException(string4, dataProcessingException);
        }
        _logger.exit(string2);
    }

    public void addToPrincipal(Principal principal, RoleCondition roleCondition) throws RoleMappingContextException {
        String string = "addToPrincipal(Principal, RoleCondition)";
        _logger.entry(string, new Object[]{principal, roleCondition});
        if (principal == null || roleCondition == null) {
            String string2 = CWRGSMessageHelper.getMessage("ADD_TO_PRINCIPAL_NULL", new Object[]{roleCondition, principal});
            _logger.error(string, string2);
            throw new RoleMappingContextException(string2);
        }
        CommonAuthzUtilities.checkSecurityPermission(string, _logger, this._secMgr);
        CommonAuthzUtilities.checkForValidState(string, _logger, this._state, (short)0);
        RoleConfigObject roleConfigObject = new RoleConfigObject(principal, roleCondition);
        try {
            this._cfgDP.deployPolicy(roleConfigObject);
        }
        catch (DataProcessingException dataProcessingException) {
            String string3 = CWRGSMessageHelper.getMessage("ADD_TO_PRINCIPAL_ERROR", new Object[]{this._contextID, roleCondition, principal, dataProcessingException.toString()});
            _logger.error(string, string3, dataProcessingException);
            throw new RoleMappingContextException(string3, dataProcessingException);
        }
        _logger.exit(string);
    }

    public void removePrincipal(Principal principal) throws RoleMappingContextException {
        String string = "removePrincipal(Principal)";
        _logger.entry(string, principal);
        if (principal == null) {
            String string2 = CWRGSMessageHelper.getMessage("REMOVE_PRINCIPAL_NULL");
            _logger.error(string, string2);
            throw new RoleMappingContextException(string2);
        }
        CommonAuthzUtilities.checkSecurityPermission(string, _logger, this._secMgr);
        CommonAuthzUtilities.checkForValidState(string, _logger, this._state, (short)0);
        RoleConfigObject roleConfigObject = new RoleConfigObject(principal);
        try {
            this._cfgDP.removePolicy(roleConfigObject);
        }
        catch (DataProcessingException dataProcessingException) {
            String string3 = CWRGSMessageHelper.getMessage("REMOVE_PRINCIPAL_ERROR", new Object[]{this._contextID, principal, dataProcessingException.toString()});
            _logger.error(string, string3, dataProcessingException);
            throw new RoleMappingContextException(string3, dataProcessingException);
        }
        _logger.exit(string);
    }

    public void removeFromPrincipal(Principal principal, RoleCondition roleCondition) throws RoleMappingContextException {
        String string = "removeFromPrincipal(Principal, RoleCondition)";
        _logger.entry(string, new Object[]{principal, roleCondition});
        if (principal == null || roleCondition == null) {
            String string2 = CWRGSMessageHelper.getMessage("REMOVE_FROM_PRINCIPAL_NULL", new Object[]{this._contextID, roleCondition, principal});
            _logger.error(string, string2);
            throw new RoleMappingContextException(string2);
        }
        CommonAuthzUtilities.checkSecurityPermission(string, _logger, this._secMgr);
        CommonAuthzUtilities.checkForValidState(string, _logger, this._state, (short)0);
        RoleConfigObject roleConfigObject = new RoleConfigObject(principal, roleCondition);
        try {
            this._cfgDP.removePolicy(roleConfigObject);
        }
        catch (DataProcessingException dataProcessingException) {
            String string3 = CWRGSMessageHelper.getMessage("REMOVE_FROM_PRINCIPAL_ERROR", new Object[]{this._contextID, roleCondition, principal, dataProcessingException.toString()});
            _logger.error(string, string3, dataProcessingException);
            throw new RoleMappingContextException(string3, dataProcessingException);
        }
        _logger.exit(string);
    }

    public Iterator getRoleConditions(Principal principal) throws RoleMappingContextException {
        String string = "getRoleConditions(Principal)";
        _logger.entry(string, principal);
        if (principal == null) {
            String string2 = CWRGSMessageHelper.getMessage("GET_ROLE_CONDITIONS_NULL");
            _logger.error(string, string2);
            throw new RoleMappingContextException(string2);
        }
        Set set = CollectionFactory.newSet();
        CommonAuthzUtilities.checkSecurityPermission(string, _logger, this._secMgr);
        CommonAuthzUtilities.checkForInvalidState(string, _logger, this._state, (short)2);
        RoleConfigObject roleConfigObject = new RoleConfigObject(principal);
        try {
            Iterator iterator = this._cfgDP.retrievePolicy(roleConfigObject);
            while (iterator.hasNext()) {
                RoleConfigObject roleConfigObject2 = (RoleConfigObject)iterator.next();
                RoleCondition roleCondition = roleConfigObject2.getRoleCondition();
                set.add(roleCondition);
            }
        }
        catch (DataProcessingException dataProcessingException) {
            String string3 = CWRGSMessageHelper.getMessage("GET_ROLE_CONDITIONS_ERROR", new Object[]{this._contextID, principal, dataProcessingException.toString()});
            _logger.error(string, string3, dataProcessingException);
            throw new RoleMappingContextException(string3, dataProcessingException);
        }
        _logger.exit(string);
        return set.iterator();
    }

    public Iterator getPrincipals() throws RoleMappingContextException {
        String string = "getPrincipals()";
        _logger.entry(string);
        Set set = CollectionFactory.newSet();
        CommonAuthzUtilities.checkSecurityPermission(string, _logger, this._secMgr);
        CommonAuthzUtilities.checkForInvalidState(string, _logger, this._state, (short)2);
        RoleConfigObject roleConfigObject = new RoleConfigObject();
        try {
            Iterator iterator = this._cfgDP.retrievePolicy(roleConfigObject);
            while (iterator.hasNext()) {
                RoleConfigObject roleConfigObject2 = (RoleConfigObject)iterator.next();
                Principal principal = roleConfigObject2.getPrincipal();
                set.add(principal);
            }
        }
        catch (DataProcessingException dataProcessingException) {
            String string2 = CWRGSMessageHelper.getMessage("GET_PRINCIPALS_ERROR", new Object[]{this._contextID, dataProcessingException.toString()});
            _logger.error(string, string2, dataProcessingException);
            throw new RoleMappingContextException(string2, dataProcessingException);
        }
        _logger.exit(string);
        return set.iterator();
    }

    public void commit() throws RoleMappingContextException {
        String string = "commit()";
        _logger.entry(string);
        CommonAuthzUtilities.checkSecurityPermission(string, _logger, this._secMgr);
        CommonAuthzUtilities.checkForInvalidState(string, _logger, this._state, (short)2);
        if (this._state == 0) {
            _logger.debug(string, CWRGSMessageHelper.getMessage("ROLE_MAPPING_COMMIT", new Object[]{this._contextID}));
            try {
                this._cfgDP.setState((short)1, UPDATE_STATE);
                this._state = this._cfgDP.getState();
            }
            catch (DataProcessingException dataProcessingException) {
                String string2 = CWRGSMessageHelper.getMessage("ROLE_MAPPING_COMMIT_ERROR", new Object[]{this._contextID, dataProcessingException.toString()});
                _logger.error(string, string2, dataProcessingException);
                throw new RoleMappingContextException(string2, dataProcessingException);
            }
        } else {
            _logger.debug(string, CWRGSMessageHelper.getMessage("COMMIT_ON_INSERVICE", new Object[]{this._contextID}));
        }
        _logger.exit(string);
    }

    public void delete() throws RoleMappingContextException {
        String string = "delete()";
        _logger.entry(string);
        CommonAuthzUtilities.checkSecurityPermission(string, _logger, this._secMgr);
        try {
            this._cfgDP.setState((short)2, UPDATE_STATE);
            this._state = this._cfgDP.getState();
        }
        catch (DataProcessingException dataProcessingException) {
            String string2 = CWRGSMessageHelper.getMessage("ROLE_MAPPING_DELETE_ERROR_2", new Object[]{this._contextID, dataProcessingException.toString()});
            _logger.error(string, string2, dataProcessingException);
            throw new RoleMappingContextException(string2, dataProcessingException);
        }
        _logger.exit(string);
    }

    public boolean inService() throws RoleMappingContextException {
        String string = "inService()";
        _logger.exit(string);
        CommonAuthzUtilities.checkSecurityPermission(string, _logger, this._secMgr);
        CommonAuthzUtilities.checkForInvalidState(string, _logger, this._state, (short)2);
        boolean bl = false;
        if (this._state == 1) {
            bl = true;
        }
        _logger.exit(string, new Boolean(bl));
        return bl;
    }

    public void setCombiningAlgorithm(String string) throws RoleMappingContextException {
        String string2 = "setCombiningAlgorithm(String)";
        _logger.entry(string2, string);
        if (string == null) {
            String string3 = CWRGSMessageHelper.getMessage("ROLE_MAPPING_SET_ALGORITHM_NULL");
            _logger.error(string2, string3);
            throw new RoleMappingContextException(string3);
        }
        CommonAuthzUtilities.checkSecurityPermission(string2, _logger, this._secMgr);
        CommonAuthzUtilities.checkForValidState(string2, _logger, this._state, (short)0);
        try {
            this._cfgDP.setCombiningAlgorithm(string);
        }
        catch (DataProcessingException dataProcessingException) {
            String string4 = CWRGSMessageHelper.getMessage("ROLE_MAPPING_SET_ALGORITHM_ERROR", new Object[]{this._contextID, string, dataProcessingException.toString()});
            _logger.error(string2, string4, dataProcessingException);
            throw new RoleMappingContextException(string4, dataProcessingException);
        }
        _logger.exit(string2);
    }

    public String getCombiningAlgorithm() throws RoleMappingContextException {
        String string = "getCombiningAlgorithm()";
        _logger.entry(string);
        String string2 = null;
        CommonAuthzUtilities.checkSecurityPermission(string, _logger, this._secMgr);
        CommonAuthzUtilities.checkForInvalidState(string, _logger, this._state, (short)2);
        try {
            CombiningAlgorithm combiningAlgorithm = this._cfgDP.getCombiningAlgorithm();
            if (combiningAlgorithm != null) {
                string2 = combiningAlgorithm.getAlgorithm();
            } else {
                _logger.debug(string, CWRGSMessageHelper.getMessage("NULL_COMBINING_ALGORITHM"));
            }
        }
        catch (DataProcessingException dataProcessingException) {
            String string3 = CWRGSMessageHelper.getMessage("ROLE_MAPPING_GET_ALGORITHM_ERROR", new Object[]{this._contextID, dataProcessingException.toString()});
            _logger.error(string, string3, dataProcessingException);
            throw new RoleMappingContextException(string3, dataProcessingException);
        }
        if (string2 == null || string2.length() == 0) {
            _logger.debug(string, CWRGSMessageHelper.getMessage("DEFAULT_COMBINING_ALGORITHM"));
            string2 = "block-overrides";
        }
        _logger.exit(string, string2);
        return string2;
    }

    public void deleteCurrentRoles() throws RoleMappingContextException {
        String string = "deleteCurrentRoles()";
        _logger.entry(string);
        CommonAuthzUtilities.checkSecurityPermission(string, _logger, this._secMgr);
        if (this._state != 2) {
            try {
                this._cfgDP.setState((short)2, KEEP_STATE);
            }
            catch (DataProcessingException dataProcessingException) {
                String string2 = CWRGSMessageHelper.getMessage("DELETE_CURRENT_ROLES_ERROR", new Object[]{this._contextID, dataProcessingException.toString()});
                _logger.error(string, string2, dataProcessingException);
                throw new RoleMappingContextException(string2, dataProcessingException);
            }
        } else {
            _logger.debug(string, CWRGSMessageHelper.getMessage("ROLE_POLICY_ALREADY_DELETED"));
        }
        _logger.exit(string);
    }

    public void writeXML(OutputStream outputStream) throws XMLSerializationException, IOException, ParserConfigurationException {
        String string = "writeXML( OutputStream )";
        _logger.entry(string, outputStream);
        if (outputStream == null) {
            String string2 = CWRGSMessageHelper.getMessage("WRITE_XML_NULL");
            _logger.error(string, string2);
            throw new XMLSerializationException(string2);
        }
        CommonAuthzUtilities.checkSecurityPermission(string, _logger, this._secMgr);
        CommonAuthzUtilities.checkForInvalidState(string, _logger, this._state, (short)2);
        try {
            this._cfgDP.retrieveXACML(outputStream);
        }
        catch (DataProcessingException dataProcessingException) {
            String string3 = CWRGSMessageHelper.getMessage("WRITE_XML_ERROR", new Object[]{this._contextID, dataProcessingException.toString()});
            _logger.error(string, string3, dataProcessingException);
            throw new XMLSerializationException(string3, dataProcessingException);
        }
        _logger.exit(string);
    }

    public void readXML(InputStream inputStream) throws XMLSerializationException, IOException, SAXException, ParserConfigurationException {
        String string = "readXML( InputStream )";
        _logger.entry(string);
        if (inputStream == null) {
            String string2 = CWRGSMessageHelper.getMessage("READ_XML_NULL");
            _logger.error(string, string2);
            throw new XMLSerializationException(string2);
        }
        CommonAuthzUtilities.checkSecurityPermission(string, _logger, this._secMgr);
        CommonAuthzUtilities.checkForValidState(string, _logger, this._state, (short)0);
        try {
            this._cfgDP.deployXACML(inputStream);
        }
        catch (DataProcessingException dataProcessingException) {
            String string3 = CWRGSMessageHelper.getMessage("READ_XML_ERROR", new Object[]{this._contextID, dataProcessingException.toString()});
            _logger.error(string, string3, dataProcessingException);
            throw new XMLSerializationException(string3, dataProcessingException);
        }
        _logger.exit(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

