/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.authz.provider;

import java.security.Permission;

public class MethodPermission
extends Permission {
    private static final long serialVersionUID = 7405573625440454079L;
    private final String resourceType;
    private final String attribute;
    private final String action;
    private final String[] separatedResourceTypes;
    private final boolean inherit;

    public MethodPermission(String string, String string2, String string3) {
        super(string + (string2 == null ? "" : ":" + string2));
        if (string == null) {
            throw new IllegalArgumentException("The resource type is null.");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("The action is null.");
        }
        this.resourceType = string;
        this.attribute = string2;
        this.action = string3;
        String[] stringArray = string.split("/");
        if (stringArray[stringArray.length - 1].equals("*")) {
            this.inherit = true;
            this.separatedResourceTypes = new String[stringArray.length - 1];
            for (int i = 0; i < this.separatedResourceTypes.length; ++i) {
                this.separatedResourceTypes[i] = stringArray[i];
            }
        } else {
            this.inherit = false;
            this.separatedResourceTypes = stringArray;
        }
    }

    public MethodPermission(String string, String string2) {
        this(string, null, string2);
    }

    public boolean implies(Permission permission) {
        if (permission instanceof MethodPermission) {
            MethodPermission methodPermission = (MethodPermission)permission;
            if (this.inherit) {
                if (!this.isParent(methodPermission)) {
                    return false;
                }
            } else {
                if (methodPermission.inherit) {
                    return false;
                }
                if (!this.isSame(methodPermission)) {
                    return false;
                }
            }
            if (this.attribute != null) {
                if (methodPermission.attribute == null) {
                    return false;
                }
                if (!this.attribute.equals(methodPermission.attribute)) {
                    return false;
                }
            }
            return this.action.equals(methodPermission.action);
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof MethodPermission) {
            MethodPermission methodPermission = (MethodPermission)object;
            if (!this.resourceType.equals(methodPermission.resourceType)) {
                return false;
            }
            if (!this.action.equals(methodPermission.action)) {
                return false;
            }
            if (this.attribute != null) {
                if (methodPermission.attribute == null) {
                    return false;
                }
                return this.attribute.equals(methodPermission.attribute);
            }
            return methodPermission.attribute == null;
        }
        return false;
    }

    public int hashCode() {
        int n = this.resourceType.hashCode() + this.action.hashCode();
        if (this.attribute == null) {
            return n;
        }
        return n + this.attribute.hashCode();
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public String getActions() {
        return this.action;
    }

    private boolean isParent(MethodPermission methodPermission) {
        if (methodPermission.separatedResourceTypes.length < this.separatedResourceTypes.length) {
            return false;
        }
        for (int i = 0; i < this.separatedResourceTypes.length; ++i) {
            if (methodPermission.separatedResourceTypes[i].equals(this.separatedResourceTypes[i])) continue;
            return false;
        }
        return true;
    }

    private boolean isSame(MethodPermission methodPermission) {
        if (methodPermission.separatedResourceTypes.length != this.separatedResourceTypes.length) {
            return false;
        }
        for (int i = 0; i < this.separatedResourceTypes.length; ++i) {
            if (methodPermission.separatedResourceTypes[i].equals(this.separatedResourceTypes[i])) continue;
            return false;
        }
        return true;
    }
}

