/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.iauthz.mcc;

import com.ibm.sec.iauthz.log.SecLogger;
import com.ibm.sec.iauthz.mcc.DataProcessingException;
import com.ibm.sec.iauthz.mcc.ICfgDataProcessing;
import com.ibm.sec.iauthz.mcc.MCCUtil;
import com.ibm.sec.iauthz.mcc.dna.CombiningAlgorithm;
import com.ibm.sec.iauthz.mcc.dna.GenericTransform;
import com.ibm.sec.iauthz.mcc.dna.InheritedRole;
import com.ibm.sec.iauthz.mcc.dna.XMTObject;
import com.ibm.sec.iauthz.mcc.engine.MCCJavaHandler;
import com.ibm.sec.iauthz.mcc.xml.IXMLImportExport;
import com.ibm.sec.iauthz.mcc.xml.XMLImportExportImpl;
import com.ibm.sec.iauthz.storage.PagedResultSet;
import com.ibm.sec.iauthz.storage.PolicyMgmt;
import com.ibm.sec.iauthz.storage.PolicySet;
import com.ibm.sec.iauthz.storage.PolicyStorageFactory;
import com.ibm.sec.iauthz.storage.PolicyStore;
import com.ibm.sec.iauthz.storage.PolicyStoreException;
import com.ibm.sec.iauthz.storage.StoreRecordQuery;
import com.ibm.sec.iauthz.util.CWRGSMessageHelper;
import com.ibm.sec.iauthz.util.CollectionFactory;
import com.ibm.sec.iauthz.util.CommonAuthProperties;
import com.ibm.sec.iauthz.util.MCCException;
import com.ibm.sec.iauthz.util.MCCUtilException;
import com.ibm.sec.iauthz.util.StorageBuffer;
import com.ibm.sec.iauthz.util.XMLException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.xml.sax.InputSource;

public class CfgDataProcessingImpl
implements ICfgDataProcessing {
    private static SecLogger _logger = SecLogger.getLogger(class$com$ibm$sec$iauthz$mcc$CfgDataProcessingImpl == null ? (class$com$ibm$sec$iauthz$mcc$CfgDataProcessingImpl = CfgDataProcessingImpl.class$("com.ibm.sec.iauthz.mcc.CfgDataProcessingImpl")) : class$com$ibm$sec$iauthz$mcc$CfgDataProcessingImpl);
    private static Properties _props = CommonAuthProperties.getProps();
    private StorageBuffer _storageBuffer = null;
    private String _contextID = null;
    private String _uniqueID = null;
    private short _state = 0;
    private IXMLImportExport _xmlImportExport = null;
    private boolean _isPolicy;
    private MCCJavaHandler _mccJavaHandler = null;
    static /* synthetic */ Class class$com$ibm$sec$iauthz$mcc$CfgDataProcessingImpl;
    static /* synthetic */ Class class$com$ibm$sec$iauthz$storage$PolicyStore;
    static /* synthetic */ Class class$com$ibm$sec$iauthz$mcc$engine$MCCJavaHandler;

    protected CfgDataProcessingImpl(String string, String string2, boolean bl) throws DataProcessingException {
        String string3 = "CfgDataProcessingImpl(String, String boolean)";
        _logger.entry(string3, new Object[]{string, string2, bl});
        if (string == null || string2 == null) {
            String string4 = CWRGSMessageHelper.getMessage("ERROR_CONSTRUCTING_CFGDATAPROCESSINGIIMPL", new Object[]{string, string2});
            _logger.error(string3, string4);
            throw new DataProcessingException(string4);
        }
        if (_props == null) {
            String string5 = CommonAuthProperties.getErrMsg();
            String string6 = CWRGSMessageHelper.getMessage("ERROR_LOADING_PROPERTIES", new Object[]{string5});
            _logger.error(string3, string6);
            throw new DataProcessingException(string6);
        }
        this._contextID = string;
        this._uniqueID = string2;
        this._isPolicy = bl;
        _props.setProperty("CONFIG_OR_RUNTIME", "config");
        if (this._isPolicy) {
            _props.setProperty("POLICY_OR_RM", "policy");
        } else {
            _props.setProperty("POLICY_OR_RM", "rm");
        }
        try {
            PolicyStore policyStore = PolicyStorageFactory.getPolicyStore(this._contextID, this._uniqueID, _props);
            this._storageBuffer = new StorageBuffer(this.getPolicySet(policyStore, this._isPolicy));
        }
        catch (PolicyStoreException policyStoreException) {
            String string7 = CWRGSMessageHelper.getMessage("ERROR_CREATING_REQUIRED CLASS", new Object[]{(class$com$ibm$sec$iauthz$storage$PolicyStore == null ? (class$com$ibm$sec$iauthz$storage$PolicyStore = CfgDataProcessingImpl.class$("com.ibm.sec.iauthz.storage.PolicyStore")) : class$com$ibm$sec$iauthz$storage$PolicyStore).getName()});
            _logger.error(string3, string7, policyStoreException);
            throw new DataProcessingException(string7, policyStoreException);
        }
        this._xmlImportExport = new XMLImportExportImpl(this._storageBuffer, this._isPolicy, this._contextID);
        try {
            this._mccJavaHandler = new MCCJavaHandler();
        }
        catch (MCCException mCCException) {
            String string8 = CWRGSMessageHelper.getMessage("ERROR_CREATING_REQUIRED CLASS", new Object[]{(class$com$ibm$sec$iauthz$mcc$engine$MCCJavaHandler == null ? (class$com$ibm$sec$iauthz$mcc$engine$MCCJavaHandler = CfgDataProcessingImpl.class$("com.ibm.sec.iauthz.mcc.engine.MCCJavaHandler")) : class$com$ibm$sec$iauthz$mcc$engine$MCCJavaHandler).getName()});
            _logger.error(string3, string8, mCCException);
            throw new DataProcessingException(string8, mCCException);
        }
        _logger.exit(string3);
    }

    public void deployXACML(InputStream inputStream) throws DataProcessingException {
        String string = "deployXACML(InputStream)";
        _logger.entry(string, inputStream);
        if (inputStream == null) {
            String string2 = CWRGSMessageHelper.getMessage("ERROR_XACML_IMPORT_NULL_INPUT");
            _logger.error(string, string2);
            throw new DataProcessingException(string2);
        }
        InputSource inputSource = new InputSource(inputStream);
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream inputStream2 = classLoader.getResourceAsStream("import-xacml-transform.xslt");
        if (inputStream2 != null) {
            InputSource inputSource2 = new InputSource(inputStream2);
            try {
                this._xmlImportExport.importXML(inputSource, inputSource2);
            }
            catch (XMLException xMLException) {
                String string3 = CWRGSMessageHelper.getMessage("ERROR_XACML_IMPORT_EXCEPTION", new Object[]{xMLException.getMessage()});
                _logger.error(string, string3, xMLException);
                throw new DataProcessingException(string3, xMLException);
            }
            finally {
                try {
                    inputStream2.close();
                }
                catch (IOException iOException) {}
            }
        }
        String string4 = CWRGSMessageHelper.getMessage("ERROR_XACML_IMPORT_NO_STYLESHEET");
        _logger.error(string, string4);
        throw new DataProcessingException(string4);
        _logger.exit(string);
    }

    public void retrieveXACML(OutputStream outputStream) throws DataProcessingException {
        String string = "retrieveXACML()";
        _logger.entry(string);
        XMLSerializer xMLSerializer = new XMLSerializer(outputStream, new OutputFormat("XML", "ISO-8859-1", true));
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream("export-xacml-transform.xslt");
        if (inputStream != null) {
            InputSource inputSource = new InputSource(inputStream);
            try {
                this._xmlImportExport.exportXML(xMLSerializer.asContentHandler(), inputSource);
            }
            catch (XMLException xMLException) {
                String string2 = CWRGSMessageHelper.getMessage("ERROR_XACML_EXPORT_EXCEPTION");
                _logger.error(string, string2, xMLException);
                throw new DataProcessingException(string2, xMLException);
            }
            catch (IOException iOException) {
                String string3 = CWRGSMessageHelper.getMessage("ERROR_XACML_EXPORT_EXCEPTION");
                _logger.error(string, string3, iOException);
                throw new DataProcessingException(string3, iOException);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        String string4 = CWRGSMessageHelper.getMessage("ERROR_XACML_EXPORT_NO_STYLESHEET");
        _logger.error(string, string4);
        throw new DataProcessingException(string4);
        _logger.exit(string);
    }

    public void deployPolicy(GenericTransform genericTransform) throws DataProcessingException {
        String string = "deployPolicy(GenericTransform)";
        _logger.entry(string, genericTransform);
        if (genericTransform == null) {
            String string2 = CWRGSMessageHelper.getMessage("ERROR_DEPLOY_POLICY_NULL");
            _logger.error(string, string2);
            throw new DataProcessingException(string2);
        }
        XMTObject xMTObject = null;
        try {
            xMTObject = (XMTObject)this._mccJavaHandler.convertJavaObject(genericTransform);
        }
        catch (MCCException mCCException) {
            String string3 = CWRGSMessageHelper.getMessage("ERROR_DEPLOY_POLICY_CONVERT_XMT", new Object[]{genericTransform});
            _logger.error(string, string3, mCCException);
            throw new DataProcessingException(string3, mCCException);
        }
        this._storageBuffer.updatePolicy(xMTObject);
        _logger.exit(string);
    }

    public Iterator retrievePolicy(GenericTransform genericTransform) throws DataProcessingException {
        String string = "retrievePolicy(GenericTransform)";
        _logger.entry(string, genericTransform);
        if (genericTransform == null) {
            String string2 = CWRGSMessageHelper.getMessage("ERROR_RETRIEVE_POLICY_NULL");
            _logger.error(string, string2);
            throw new DataProcessingException(string2);
        }
        Set set = CollectionFactory.newSet();
        Iterator iterator = null;
        StoreRecordQuery storeRecordQuery = MCCUtil.getQuery(genericTransform, this._isPolicy);
        PagedResultSet pagedResultSet = this._storageBuffer.getPolicy(storeRecordQuery);
        while (pagedResultSet != null && pagedResultSet.hasNext()) {
            Iterator iterator2 = null;
            try {
                iterator2 = MCCUtil.convertPagedResultSet(pagedResultSet);
            }
            catch (MCCUtilException mCCUtilException) {
                String string3 = CWRGSMessageHelper.getMessage("ERROR_CONVERT_PAGED_RESULT_SET", new Object[]{mCCUtilException.getMessage()});
                _logger.error(string, string3, mCCUtilException);
                throw new DataProcessingException(string3);
            }
            while (iterator2.hasNext()) {
                set.add(iterator2.next());
            }
            try {
                pagedResultSet.nextPage();
            }
            catch (Exception exception) {
                String string4 = CWRGSMessageHelper.getMessage("ERROR_GET_NEXT_RESULT_PAGE", new Object[]{exception.getMessage()});
                _logger.error(string, string4, exception);
                throw new DataProcessingException(string4);
            }
        }
        if (pagedResultSet != null) {
            pagedResultSet.close();
        }
        if ((iterator = set.iterator()) == null) {
            _logger.debug(string, "The returned iterator is null. Setting to empty iterator.");
            iterator = CollectionFactory.newSet().iterator();
        }
        _logger.exit(string, iterator);
        return iterator;
    }

    public void removePolicy(GenericTransform genericTransform) throws DataProcessingException {
        String string = "removePolicy(GenericTransform)";
        _logger.entry(string, genericTransform);
        if (genericTransform == null) {
            String string2 = CWRGSMessageHelper.getMessage("ERROR_REMOVE_POLICY_NULL");
            _logger.error(string, string2);
            throw new DataProcessingException(string2);
        }
        XMTObject xMTObject = null;
        try {
            xMTObject = (XMTObject)this._mccJavaHandler.convertJavaObject(genericTransform);
        }
        catch (MCCException mCCException) {
            String string3 = CWRGSMessageHelper.getMessage("ERROR_REMOVE_POLICY_CONVERT_XMT", new Object[]{genericTransform});
            _logger.error(string, string3, mCCException);
            throw new DataProcessingException(string3, mCCException);
        }
        this._storageBuffer.removePolicy(xMTObject);
        _logger.exit(string);
    }

    public short getState() throws DataProcessingException {
        return this._state;
    }

    public void setState(short s, boolean bl) throws DataProcessingException {
        String string = "setState(short, boolean)";
        _logger.entry(string, new Object[]{new Short(s), bl});
        if (s != 2 && s != 0 && s != 1) {
            String string2 = CWRGSMessageHelper.getMessage("ERROR_CONFIG_SET_STATE_INVALID", new Object[]{new Short(s)});
            _logger.error(string, string2);
            throw new DataProcessingException(string2);
        }
        if (this._state == 0 && s == 1) {
            _logger.debug(string, "Changing state from open to inService. About to commit policy in storage.");
            this._storageBuffer.commit();
        } else if (this._state != 2 && s == 2) {
            if (bl) {
                _logger.debug(string, "Changing state to deleted. About to remove policy in storage.");
                this._storageBuffer.removeAllPolicy();
            } else {
                _logger.debug(string, "Setting remove flag to true.");
                this._storageBuffer.setRemove(true);
            }
        } else {
            _logger.debug(string, "Set state to " + s + " called when state is " + this._state + ". Doing nothing.");
        }
        if (bl) {
            this._state = s;
        }
        _logger.exit(string);
    }

    public void addLinkedPolicy(String string) throws DataProcessingException {
        String string2 = "addLinkedPolicy(String)";
        _logger.entry(string2, string);
        if (string == null || string.length() == 0) {
            String string3 = CWRGSMessageHelper.getMessage("ERROR_CONFIG_LINK_POLICY_BAD_INPUT");
            _logger.error(string2, string3);
            throw new DataProcessingException(string3);
        }
        PolicyMgmt policyMgmt = null;
        try {
            policyMgmt = PolicyStorageFactory.getPolicyMgmt(_props);
        }
        catch (PolicyStoreException policyStoreException) {
            String string4 = CWRGSMessageHelper.getMessage("ERROR_GETTING_POLICYMGMT_INSTANCE", new Object[]{policyStoreException.getMessage()});
            _logger.error(string2, string4);
            throw new DataProcessingException(string4, policyStoreException);
        }
        if (policyMgmt != null) {
            try {
                policyMgmt.linkConfigurations(this._contextID, string);
            }
            catch (PolicyStoreException policyStoreException) {
                String string5 = CWRGSMessageHelper.getMessage("ERROR_CONFIG_LINK_POLICY_EXCEPTION", new Object[]{this._contextID, string, policyStoreException.getMessage()});
                _logger.error(string2, string5, policyStoreException);
                throw new DataProcessingException(string5, policyStoreException);
            }
        } else {
            String string6 = CWRGSMessageHelper.getMessage("ERROR_POLICY_MGMT_NULL");
            _logger.error(string2, string6);
            throw new DataProcessingException(string6);
        }
        _logger.exit(string2);
    }

    public void addInheritedRole(String string, String string2) throws DataProcessingException {
        String string3 = "addInheritedRole(String, String)";
        _logger.entry(string3, new Object[]{string, string2});
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            String string4 = CWRGSMessageHelper.getMessage("ERROR_CONFIG_INHERIT_ROLE_BAD_INPUT", new Object[]{string, string2});
            _logger.error(string3, string4);
            throw new DataProcessingException(string4);
        }
        InheritedRole inheritedRole = new InheritedRole(string, string2);
        XMTObject xMTObject = null;
        try {
            _logger.debug(string3, "Converting InheritedRole object '" + inheritedRole + "' to XMTObject.");
            xMTObject = (XMTObject)this._mccJavaHandler.convertJavaObject(inheritedRole);
        }
        catch (MCCException mCCException) {
            String string5 = CWRGSMessageHelper.getMessage("ERROR_CONFIG_INHERIT_ROLE_EXCEPTION", new Object[]{string, string2, mCCException.getMessage()});
            _logger.error(string3, string5, mCCException);
            throw new DataProcessingException(string5, mCCException);
        }
        this._storageBuffer.updatePolicy(xMTObject);
        _logger.exit(string3);
    }

    public void setCombiningAlgorithm(String string) throws DataProcessingException {
        String string2 = "setCombiningAlgorithm(String)";
        _logger.entry(string2, string);
        if (string == null || string.length() == 0) {
            String string3 = CWRGSMessageHelper.getMessage("ERROR_CONFIG_COMBINING_ALG_BAD_INPUT");
            _logger.error(string2, string3);
            throw new DataProcessingException(string3);
        }
        CombiningAlgorithm combiningAlgorithm = new CombiningAlgorithm(string);
        XMTObject xMTObject = null;
        try {
            _logger.debug(string2, "Converting CombiningAlgorithm '" + combiningAlgorithm + "' to XMTObject.");
            xMTObject = (XMTObject)this._mccJavaHandler.convertJavaObject(combiningAlgorithm);
        }
        catch (MCCException mCCException) {
            String string4 = CWRGSMessageHelper.getMessage("ERROR_CONFIG_COMBINING_ALG_EXCEPTION", new Object[]{string, mCCException.getMessage()});
            _logger.error(string2, string4, mCCException);
            throw new DataProcessingException(string4, mCCException);
        }
        this._storageBuffer.updatePolicy(xMTObject);
        _logger.exit(string2);
    }

    public Iterator getLinkedPolicy() throws DataProcessingException {
        String string = "getLinkedPolicy()";
        _logger.entry(string);
        Set set = null;
        PolicyMgmt policyMgmt = null;
        try {
            policyMgmt = PolicyStorageFactory.getPolicyMgmt(_props);
        }
        catch (PolicyStoreException policyStoreException) {
            String string2 = CWRGSMessageHelper.getMessage("ERROR_GETTING_POLICYMGMT_INSTANCE", new Object[]{policyStoreException.getMessage()});
            _logger.error(string, string2);
            throw new DataProcessingException(string2, policyStoreException);
        }
        if (policyMgmt != null) {
            try {
                set = policyMgmt.getLinkedContexts(this._contextID);
            }
            catch (PolicyStoreException policyStoreException) {
                String string3 = CWRGSMessageHelper.getMessage("ERROR_CONFIG_LINKED_GET_EXCEPTION", new Object[]{this._contextID});
                _logger.error(string, string3);
                throw new DataProcessingException(string3);
            }
            if (set == null) {
                _logger.debug(string, "No linked contexts found for " + this._contextID + ". Creating empty set.");
                set = CollectionFactory.newSet();
            }
        } else {
            String string4 = CWRGSMessageHelper.getMessage("ERROR_POLICY_MGMT_NULL");
            _logger.error(string, string4);
            throw new DataProcessingException(string4);
        }
        _logger.exit(string);
        return set.iterator();
    }

    public Iterator getInheritedRoles(String string) throws DataProcessingException {
        String string2 = "getInheritedRoles(String)";
        _logger.entry(string2, string);
        if (string == null || string.length() == 0) {
            String string3 = CWRGSMessageHelper.getMessage("ERROR_CONFIG_GET_INHERITED_ROLES_BAD_INPUT");
            _logger.error(string2, string3);
            throw new DataProcessingException(string3);
        }
        InheritedRole inheritedRole = new InheritedRole(string, null);
        StoreRecordQuery storeRecordQuery = MCCUtil.getQuery(inheritedRole, this._isPolicy);
        _logger.debug(string2, "About to retrieve inherited roles. Query is : " + storeRecordQuery);
        PagedResultSet pagedResultSet = this._storageBuffer.getPolicy(storeRecordQuery);
        Set set = CollectionFactory.newSet();
        Iterator iterator = null;
        while (pagedResultSet != null && pagedResultSet.hasNext()) {
            Iterator iterator2 = null;
            try {
                iterator2 = MCCUtil.convertPagedResultSet(pagedResultSet);
            }
            catch (MCCUtilException mCCUtilException) {
                String string4 = CWRGSMessageHelper.getMessage("ERROR_CONVERT_PAGED_RESULT_SET", new Object[]{mCCUtilException.getMessage()});
                _logger.error(string2, string4, mCCUtilException);
                throw new DataProcessingException(string4, mCCUtilException);
            }
            while (iterator2.hasNext()) {
                set.add(iterator2.next());
            }
            try {
                pagedResultSet.nextPage();
            }
            catch (Exception exception) {
                String string5 = CWRGSMessageHelper.getMessage("ERROR_GET_NEXT_RESULT_PAGE", new Object[]{exception.getMessage()});
                _logger.error(string2, string5, exception);
                throw new DataProcessingException(string5, exception);
            }
        }
        if (pagedResultSet != null) {
            pagedResultSet.close();
        }
        if ((iterator = set.iterator()) == null) {
            _logger.debug(string2, "The returned iterator is null. Setting to empty iterator.");
            iterator = CollectionFactory.newSet().iterator();
        }
        _logger.exit(string2, iterator);
        return iterator;
    }

    public CombiningAlgorithm getCombiningAlgorithm() throws DataProcessingException {
        String string = "getCombiningAlgorithm()";
        _logger.entry(string);
        CombiningAlgorithm combiningAlgorithm = null;
        CombiningAlgorithm combiningAlgorithm2 = new CombiningAlgorithm(null);
        StoreRecordQuery storeRecordQuery = MCCUtil.getQuery(combiningAlgorithm2, this._isPolicy);
        _logger.debug(string, "About to retrieve combining algorithm. Query is : " + storeRecordQuery);
        PagedResultSet pagedResultSet = this._storageBuffer.getPolicy(storeRecordQuery);
        if (pagedResultSet != null && pagedResultSet.size() > 1) {
            String string2 = CWRGSMessageHelper.getMessage("ERROR_CONFIG_TOO_MANY_COMBINGING_ALGS", new Object[]{this._contextID, new Integer(pagedResultSet.size())});
            _logger.error(string, string2);
            throw new DataProcessingException(string2);
        }
        Iterator iterator = null;
        try {
            iterator = MCCUtil.convertPagedResultSet(pagedResultSet);
        }
        catch (MCCUtilException mCCUtilException) {
            String string3 = CWRGSMessageHelper.getMessage("ERROR_CONVERT_PAGED_RESULT_SET", new Object[]{mCCUtilException.getMessage()});
            _logger.error(string, string3, mCCUtilException);
            throw new DataProcessingException(string3, mCCUtilException);
        }
        if (iterator != null && iterator.hasNext()) {
            combiningAlgorithm = (CombiningAlgorithm)iterator.next();
        }
        if (pagedResultSet != null) {
            pagedResultSet.close();
        }
        _logger.exit(string);
        return combiningAlgorithm;
    }

    private PolicySet getPolicySet(PolicyStore policyStore, boolean bl) {
        String string = "getPolicySet(boolean)";
        _logger.entry(string, bl);
        PolicySet policySet = null;
        if (bl) {
            _logger.debug(string, "Creating PermPolicySet.");
            policySet = policyStore.getPermPolicy();
        } else {
            _logger.debug(string, "Creating RolePolicySet.");
            policySet = policyStore.getRolePolicy();
        }
        _logger.exit(string, policySet);
        return policySet;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

