/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.iauthz.mcc;

import com.ibm.sec.authz.jaccx.role.RoleMappingContext;
import com.ibm.sec.iauthz.log.SecLogger;
import com.ibm.sec.iauthz.mcc.CfgDataProcessingImpl;
import com.ibm.sec.iauthz.mcc.DataProcessingException;
import com.ibm.sec.iauthz.mcc.ICfgDataProcessing;
import com.ibm.sec.iauthz.mcc.IRtPolicyDataProcessing;
import com.ibm.sec.iauthz.mcc.IRtRoleDataProcessing;
import com.ibm.sec.iauthz.mcc.RoleMappingContextImpl;
import com.ibm.sec.iauthz.mcc.RtPolicyDataProcessingImpl;
import com.ibm.sec.iauthz.mcc.RtRoleDataProcessingImpl;
import com.ibm.sec.iauthz.storage.PolicyMgmt;
import com.ibm.sec.iauthz.storage.PolicyStorageFactory;
import com.ibm.sec.iauthz.storage.PolicyStoreException;
import com.ibm.sec.iauthz.util.CWRGSMessageHelper;
import com.ibm.sec.iauthz.util.CollectionFactory;
import com.ibm.sec.iauthz.util.CommonAuthProperties;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class DataProcessingFactory {
    private static Properties _props = CommonAuthProperties.getProps();
    private static DataProcessingFactory _factory = new DataProcessingFactory();
    private static SecLogger _logger = SecLogger.getLogger(class$com$ibm$sec$iauthz$mcc$DataProcessingFactory == null ? (class$com$ibm$sec$iauthz$mcc$DataProcessingFactory = DataProcessingFactory.class$("com.ibm.sec.iauthz.mcc.DataProcessingFactory")) : class$com$ibm$sec$iauthz$mcc$DataProcessingFactory);
    public static boolean IS_POLICY = true;
    public static boolean IS_ROLE_MAPPING = false;
    private Map _instanceRTPolicyMap = CollectionFactory.newMap();
    private Map _instanceRTRoleMappingMap = CollectionFactory.newMap();
    private Map _instanceCfgPolMap = CollectionFactory.newMap();
    private Map _instanceCfgRMMap = CollectionFactory.newMap();
    static /* synthetic */ Class class$com$ibm$sec$iauthz$mcc$DataProcessingFactory;

    private DataProcessingFactory() {
    }

    public static DataProcessingFactory getFactory() {
        return _factory;
    }

    public synchronized IRtPolicyDataProcessing getRtPolicyInstance(String string, String string2) throws DataProcessingException {
        String string3 = "getRtPolicyInstance(String, String)";
        _logger.entry(string3, new Object[]{string, string2});
        if (string == null || string2 == null || string.length() == 0 || string2.length() == 0) {
            String string4 = CWRGSMessageHelper.getMessage("ERROR_DPF_BAD_FUNCTION_INPUT");
            _logger.error(string3, string4);
            throw new DataProcessingException(string4);
        }
        IRtPolicyDataProcessing iRtPolicyDataProcessing = null;
        String string5 = DataProcessingFactory.getUniqueID(string, string2);
        _logger.debug(string3, "UniqueID is " + string5);
        if (this._instanceRTPolicyMap.containsKey(string5)) {
            iRtPolicyDataProcessing = (IRtPolicyDataProcessing)this._instanceRTPolicyMap.get(string5);
            _logger.debug(string3, "Found instance in Map.");
        } else {
            iRtPolicyDataProcessing = new RtPolicyDataProcessingImpl(string, string5);
            this._instanceRTPolicyMap.put(string5, iRtPolicyDataProcessing);
            _logger.debug(string3, "Created new instance.");
        }
        _logger.exit(string3, iRtPolicyDataProcessing);
        return iRtPolicyDataProcessing;
    }

    public synchronized IRtRoleDataProcessing getRtRoleInstance(String string, String string2) throws DataProcessingException {
        String string3 = "getRtRoleInstance(String, String)";
        _logger.entry(string3, new Object[]{string, string2});
        if (string == null || string2 == null || string.length() == 0 || string2.length() == 0) {
            String string4 = CWRGSMessageHelper.getMessage("ERROR_DPF_BAD_FUNCTION_INPUT");
            _logger.error(string3, string4);
            throw new DataProcessingException(string4);
        }
        IRtRoleDataProcessing iRtRoleDataProcessing = null;
        String string5 = DataProcessingFactory.getUniqueID(string, string2);
        _logger.debug(string3, "UniqueID is" + string5);
        if (this._instanceRTRoleMappingMap.containsKey(string5)) {
            iRtRoleDataProcessing = (IRtRoleDataProcessing)this._instanceRTRoleMappingMap.get(string5);
            _logger.debug(string3, "Found instance in Map.");
        } else {
            iRtRoleDataProcessing = new RtRoleDataProcessingImpl(string, string5);
            this._instanceRTRoleMappingMap.put(string5, iRtRoleDataProcessing);
            _logger.debug(string3, "Created new instance.");
        }
        _logger.exit(string3, iRtRoleDataProcessing);
        return iRtRoleDataProcessing;
    }

    public synchronized ICfgDataProcessing getCfgInstance(String string, String string2, boolean bl) throws DataProcessingException {
        String string3 = "getCfgInstance(String, String, boolean)";
        _logger.entry(string3, new Object[]{string, string2, bl});
        if (string == null || string2 == null || string.length() == 0 || string2.length() == 0) {
            String string4 = CWRGSMessageHelper.getMessage("ERROR_DPF_BAD_FUNCTION_INPUT");
            _logger.error(string3, string4);
            throw new DataProcessingException(string4);
        }
        ICfgDataProcessing iCfgDataProcessing = null;
        String string5 = DataProcessingFactory.getUniqueID(string, string2);
        _logger.debug(string3, "UniqueID is " + string5);
        if (bl == IS_POLICY) {
            if (this._instanceCfgPolMap.containsKey(string5)) {
                iCfgDataProcessing = (ICfgDataProcessing)this._instanceCfgPolMap.get(string5);
                _logger.debug(string3, "Found policy instance in Map.");
            } else {
                iCfgDataProcessing = new CfgDataProcessingImpl(string, string5, bl);
                this._instanceCfgPolMap.put(string5, iCfgDataProcessing);
                _logger.debug(string3, "Created new policy instance.");
            }
        } else if (this._instanceCfgRMMap.containsKey(string5)) {
            iCfgDataProcessing = (ICfgDataProcessing)this._instanceCfgRMMap.get(string5);
            _logger.debug(string3, "Found RoleMapping instance in Map.");
        } else {
            iCfgDataProcessing = new CfgDataProcessingImpl(string, string5, bl);
            this._instanceCfgRMMap.put(string5, iCfgDataProcessing);
            _logger.debug(string3, "Created new RoleMapping instance.");
        }
        _logger.exit(string3, iCfgDataProcessing);
        return iCfgDataProcessing;
    }

    public Iterator getRoleContextIDList() throws DataProcessingException {
        String string = "getRoleContextIDList()";
        _logger.entry(string);
        if (_props == null) {
            String string2 = CommonAuthProperties.getErrMsg();
            String string3 = CWRGSMessageHelper.getMessage("ERROR_LOADING_PROPERTIES", new Object[]{string2});
            _logger.error(string, string3);
            throw new DataProcessingException(string3);
        }
        PolicyMgmt policyMgmt = null;
        try {
            policyMgmt = PolicyStorageFactory.getPolicyMgmt(_props);
        }
        catch (PolicyStoreException policyStoreException) {
            String string4 = CWRGSMessageHelper.getMessage("ERROR_GETTING_POLICYMGMT_INSTANCE", new Object[]{policyStoreException.getMessage()});
            _logger.error(string, string4, policyStoreException);
            throw new DataProcessingException(string4, policyStoreException);
        }
        if (policyMgmt == null) {
            String string5 = CWRGSMessageHelper.getMessage("ERROR_POLICY_MGMT_NULL");
            _logger.error(string, string5);
            throw new DataProcessingException(string5);
        }
        Iterator iterator = null;
        Set set = null;
        try {
            set = policyMgmt.getRoleMapPolicyContexts();
        }
        catch (PolicyStoreException policyStoreException) {
            String string6 = CWRGSMessageHelper.getMessage("ERROR_DPF_GET_ROLE_CONTEXT_EXCEPTION", new Object[]{policyStoreException.getMessage()});
            _logger.error(string, string6, policyStoreException);
            throw new DataProcessingException(string6, policyStoreException);
        }
        if (set == null) {
            set = CollectionFactory.newSet();
            _logger.debug(string, "Null List returned.");
        }
        _logger.debug(string, "Found " + set.size() + " contextIDs.");
        iterator = set.iterator();
        _logger.exit(string);
        return iterator;
    }

    public boolean isUniqueClientID(String string, String string2) throws DataProcessingException {
        String string3 = "isUniqueClientID(String, String)";
        _logger.entry(string3, new Object[]{string, string2});
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            String string4 = CWRGSMessageHelper.getMessage("ERROR_DPF_BAD_FUNCTION_INPUT");
            _logger.error(string3, string4);
            throw new DataProcessingException(string4);
        }
        if (_props == null) {
            String string5 = CommonAuthProperties.getErrMsg();
            String string6 = CWRGSMessageHelper.getMessage("ERROR_LOADING_PROPERTIES", new Object[]{string5});
            _logger.error(string3, string6);
            throw new DataProcessingException(string6);
        }
        PolicyMgmt policyMgmt = null;
        try {
            policyMgmt = PolicyStorageFactory.getPolicyMgmt(_props);
        }
        catch (PolicyStoreException policyStoreException) {
            String string7 = CWRGSMessageHelper.getMessage("ERROR_GETTING_POLICYMGMT_INSTANCE", new Object[]{policyStoreException.getMessage()});
            _logger.error(string3, string7, policyStoreException);
            throw new DataProcessingException(string7, policyStoreException);
        }
        if (policyMgmt == null) {
            String string8 = CWRGSMessageHelper.getMessage("ERROR_POLICY_MGMT_NULL");
            _logger.error(string3, string8);
            throw new DataProcessingException(string8);
        }
        boolean bl = false;
        String string9 = DataProcessingFactory.getUniqueID(string, string2);
        _logger.debug(string3, "UniqueID is " + string9);
        try {
            bl = policyMgmt.isUniqueClientID(string9);
        }
        catch (PolicyStoreException policyStoreException) {
            String string10 = CWRGSMessageHelper.getMessage("ERROR_DPF_CHECK_CONTEXT_UNIQUE", new Object[]{string9, policyStoreException.getMessage()});
            _logger.error(string3, string10, policyStoreException);
            throw new DataProcessingException(string10, policyStoreException);
        }
        _logger.exit(string3, bl);
        return bl;
    }

    public Iterator getPolicyContextIDList() throws DataProcessingException {
        String string = "getPolicyContextIDList()";
        _logger.entry(string);
        if (_props == null) {
            String string2 = CWRGSMessageHelper.getMessage("ERROR_LOADING_PROPERTIES", new Object[]{CommonAuthProperties.getErrMsg()});
            _logger.error(string, string2);
            throw new DataProcessingException(string2);
        }
        PolicyMgmt policyMgmt = null;
        try {
            policyMgmt = PolicyStorageFactory.getPolicyMgmt(_props);
        }
        catch (PolicyStoreException policyStoreException) {
            String string3 = CWRGSMessageHelper.getMessage("ERROR_GETTING_POLICYMGMT_INSTANCE", new Object[]{policyStoreException.getMessage()});
            _logger.error(string, string3, policyStoreException);
            throw new DataProcessingException(string3, policyStoreException);
        }
        if (policyMgmt == null) {
            String string4 = CWRGSMessageHelper.getMessage("ERROR_POLICY_MGMT_NULL");
            _logger.error(string, string4);
            throw new DataProcessingException(string4);
        }
        Iterator iterator = null;
        Set set = null;
        try {
            set = policyMgmt.getPermPolicyContexts();
        }
        catch (PolicyStoreException policyStoreException) {
            String string5 = CWRGSMessageHelper.getMessage("ERROR_DPF_GET_PERM_CONTEXTS", new Object[]{policyStoreException.getMessage()});
            _logger.error(string, string5, policyStoreException);
            throw new DataProcessingException(string5, policyStoreException);
        }
        if (set == null) {
            set = CollectionFactory.newSet();
            _logger.debug(string, "Null List returned.");
        }
        _logger.debug(string, "Found " + set.size() + " contextIDs.");
        iterator = set.iterator();
        _logger.exit(string);
        return iterator;
    }

    public RoleMappingContext getRoleContextID(String string) throws DataProcessingException {
        String string2 = "getRoleContextI(String)";
        _logger.entry(string2, string);
        if (string == null || string.length() == 0 || _props == null) {
            String string3 = CWRGSMessageHelper.getMessage("ERROR_DPF_BAD_FUNCTION_INPUT");
            _logger.error(string2, string3);
            throw new DataProcessingException(string3);
        }
        if (_props == null) {
            String string4 = CommonAuthProperties.getErrMsg();
            String string5 = CWRGSMessageHelper.getMessage("ERROR_LOADING_PROPERTIES", new Object[]{string4});
            _logger.error(string2, string5);
            throw new DataProcessingException(string5);
        }
        PolicyMgmt policyMgmt = null;
        try {
            policyMgmt = PolicyStorageFactory.getPolicyMgmt(_props);
        }
        catch (PolicyStoreException policyStoreException) {
            String string6 = CWRGSMessageHelper.getMessage("ERROR_GETTING_POLICYMGMT_INSTANCE", new Object[]{policyStoreException.getMessage()});
            _logger.error(string2, string6, policyStoreException);
            throw new DataProcessingException(string6, policyStoreException);
        }
        if (policyMgmt == null) {
            String string7 = CWRGSMessageHelper.getMessage("ERROR_POLICY_MGMT_NULL");
            _logger.error(string2, string7);
            throw new DataProcessingException(string7);
        }
        Set set = null;
        try {
            set = policyMgmt.getLinkedContexts(string);
        }
        catch (PolicyStoreException policyStoreException) {
            String string8 = CWRGSMessageHelper.getMessage("ERROR_CONFIG_LINKED_GET_EXCEPTION", new Object[]{string, policyStoreException.getMessage()});
            _logger.error(string2, string8, policyStoreException);
            throw new DataProcessingException(string8, policyStoreException);
        }
        if (set == null) {
            set = CollectionFactory.newSet();
            _logger.debug(string2, "Null Set of linked contexts returned.");
        }
        _logger.debug(string2, "Found " + set.size() + " linked contextIDs.");
        String string9 = null;
        try {
            string9 = policyMgmt.getRoleMapContextID(string);
        }
        catch (PolicyStoreException policyStoreException) {
            String string10 = CWRGSMessageHelper.getMessage("ERROR_DPF_GET_RM_CONTEXT_FOR_POL", new Object[]{string, policyStoreException.getMessage()});
            _logger.error(string2, string10, policyStoreException);
            throw new DataProcessingException(string10, policyStoreException);
        }
        _logger.debug(string2, "RoleMapping context is " + string9);
        RoleMappingContextImpl roleMappingContextImpl = new RoleMappingContextImpl(string9, set);
        _logger.exit(string2, roleMappingContextImpl);
        return roleMappingContextImpl;
    }

    private static String getUniqueID(String string, String string2) {
        String string3 = string + string2;
        int n = string3.hashCode();
        return Integer.toString(n);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

