/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.iauthz.mcc;

import com.ibm.sec.iauthz.log.SecLogger;
import com.ibm.sec.iauthz.mcc.DataProcessingException;
import com.ibm.sec.iauthz.mcc.IRtDataProcessing;
import com.ibm.sec.iauthz.mcc.MCCUtil;
import com.ibm.sec.iauthz.mcc.cache.IObjectCache;
import com.ibm.sec.iauthz.mcc.cache.ObjectCacheEntry;
import com.ibm.sec.iauthz.mcc.cache.ObjectCacheImpl;
import com.ibm.sec.iauthz.mcc.dna.GenericTransform;
import com.ibm.sec.iauthz.storage.PagedResultSet;
import com.ibm.sec.iauthz.storage.PolicySet;
import com.ibm.sec.iauthz.storage.PolicyStorageFactory;
import com.ibm.sec.iauthz.storage.PolicyStore;
import com.ibm.sec.iauthz.storage.PolicyStoreException;
import com.ibm.sec.iauthz.storage.StoreRecordQuery;
import com.ibm.sec.iauthz.util.CWRGSMessageHelper;
import com.ibm.sec.iauthz.util.CollectionFactory;
import com.ibm.sec.iauthz.util.CommonAuthProperties;
import com.ibm.sec.iauthz.util.MCCUtilException;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public abstract class RtDataProcessingImpl
implements IRtDataProcessing {
    protected PolicyStore _policyStore = null;
    protected String _version;
    protected String _contextID = null;
    private String _uniqueID = null;
    protected int _maxReturn = 1000;
    protected short _extractType = 0;
    private IObjectCache _objCache = null;
    protected Properties _props = CommonAuthProperties.getProps();
    private static SecLogger _logger = SecLogger.getLogger(class$com$ibm$sec$iauthz$mcc$RtDataProcessingImpl == null ? (class$com$ibm$sec$iauthz$mcc$RtDataProcessingImpl = RtDataProcessingImpl.class$("com.ibm.sec.iauthz.mcc.RtDataProcessingImpl")) : class$com$ibm$sec$iauthz$mcc$RtDataProcessingImpl);
    static /* synthetic */ Class class$com$ibm$sec$iauthz$mcc$RtDataProcessingImpl;

    protected RtDataProcessingImpl(String string, String string2) throws DataProcessingException {
        String string3 = "RtDataProcessingImpl(String, String)";
        _logger.entry(string3, new Object[]{string, string2});
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            String string4 = CWRGSMessageHelper.getMessage("ERROR_DPF_BAD_FUNCTION_INPUT");
            _logger.error(string3, string4);
            throw new DataProcessingException(string4);
        }
        this._contextID = string;
        this._uniqueID = string2;
        if (this._props == null) {
            String string5 = CommonAuthProperties.getErrMsg();
            String string6 = CWRGSMessageHelper.getMessage("ERROR_LOADING_PROPERTIES", new Object[]{string5});
            _logger.error(string3, string6);
            throw new DataProcessingException(string6);
        }
        this._props.setProperty("CONFIG_OR_RUNTIME", "runtime");
        if (this.isPerm()) {
            this._props.setProperty("POLICY_OR_RM", "policy");
        } else {
            this._props.setProperty("POLICY_OR_RM", "rm");
        }
        this._objCache = new ObjectCacheImpl();
        this._objCache.initialize(this._props);
        try {
            this._policyStore = PolicyStorageFactory.getPolicyStore(this._contextID, this._uniqueID, this.isPerm(), this._props);
        }
        catch (PolicyStoreException policyStoreException) {
            String string7 = CWRGSMessageHelper.getMessage("ERROR_DP_GET_POLICY_STORE", new Object[]{this._contextID, policyStoreException.getMessage()});
            _logger.error(string3, string7, policyStoreException);
            throw new DataProcessingException(string7, policyStoreException);
        }
        _logger.exit(string3);
    }

    protected IObjectCache getObjectCache() {
        return this._objCache;
    }

    public abstract boolean isCurrent() throws DataProcessingException;

    public abstract String getMasterVersion() throws DataProcessingException;

    public abstract void updateVersion() throws DataProcessingException;

    public abstract boolean isPerm();

    public void setExtractType(short s) throws DataProcessingException {
        String string = "setExtractType(short)";
        _logger.entry(string, new Short(s));
        this._extractType = s;
        _logger.exit(string);
    }

    public void setMaxReturn(int n) throws DataProcessingException {
        String string = "setMaxReturn(int)";
        _logger.entry(string, new Integer(n));
        this._maxReturn = n;
        _logger.exit(string);
    }

    public String getCurrentVersion() {
        return this._version;
    }

    public String getContext() {
        return this._contextID;
    }

    protected PagedResultSet performQuery(PolicySet policySet, StoreRecordQuery storeRecordQuery) throws DataProcessingException {
        String string = "performQuery(PolicySet, StoreRecordQuery)";
        _logger.entry(string, new Object[]{policySet, storeRecordQuery});
        if (policySet == null || storeRecordQuery == null) {
            String string2 = CWRGSMessageHelper.getMessage("ERROR_DPF_BAD_FUNCTION_INPUT");
            _logger.error(string, string2);
            throw new DataProcessingException(string2);
        }
        PagedResultSet pagedResultSet = null;
        try {
            pagedResultSet = this._extractType == 0 ? policySet.getFullPolicy(storeRecordQuery, false) : policySet.getDeltaPolicy(storeRecordQuery);
        }
        catch (PolicyStoreException policyStoreException) {
            String string3 = CWRGSMessageHelper.getMessage("ERROR_DP_PERFORM_QUERY");
            _logger.error(string, string3, policyStoreException);
            throw new DataProcessingException(string3, policyStoreException);
        }
        _logger.exit(string, pagedResultSet);
        return pagedResultSet;
    }

    protected void closeCachedEntries() throws DataProcessingException {
        String string = "closeCachedEntries()";
        _logger.entry(string);
        ObjectCacheImpl objectCacheImpl = (ObjectCacheImpl)this.getObjectCache();
        if (objectCacheImpl == null || !objectCacheImpl.isInitialized()) {
            String string2 = CWRGSMessageHelper.getMessage("ERROR_DP_CACHE_NULL");
            _logger.error(string, string2);
            throw new DataProcessingException(string2);
        }
        Set set = objectCacheImpl.getandRemoveAll();
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                ObjectCacheEntry objectCacheEntry = (ObjectCacheEntry)iterator.next();
                PagedResultSet pagedResultSet = (PagedResultSet)objectCacheEntry.getEntry();
                pagedResultSet.close();
            }
        } else {
            _logger.debug(string, "No cached entries to close.");
        }
        _logger.exit(string);
    }

    protected Iterator getResults(GenericTransform genericTransform, String string, short s, PolicySet policySet) throws DataProcessingException {
        String string2 = "getResults(GenericTransform)";
        _logger.entry(string2, new Object[]{genericTransform, string, new Short(s), policySet});
        ObjectCacheImpl objectCacheImpl = (ObjectCacheImpl)this.getObjectCache();
        if (objectCacheImpl == null || !objectCacheImpl.isInitialized()) {
            String string3 = CWRGSMessageHelper.getMessage("ERROR_DP_CACHE_NULL");
            _logger.error(string2, string3);
            throw new DataProcessingException(string3);
        }
        Iterator iterator = null;
        PagedResultSet pagedResultSet = (PagedResultSet)objectCacheImpl.getEntry(string);
        if (pagedResultSet != null) {
            try {
                if (s == 0) {
                    pagedResultSet.firstPage();
                    _logger.debug(string2, "Returning first page");
                }
                pagedResultSet.nextPage();
                _logger.debug(string2, "Returning next page");
            }
            catch (Exception exception) {
                String string4 = CWRGSMessageHelper.getMessage("ERROR_DP_GET_NTH_PAGE", new Object[]{new Short(s)});
                _logger.error(string2, string4, exception);
                throw new DataProcessingException(string4, exception);
            }
        } else {
            StoreRecordQuery storeRecordQuery = MCCUtil.getQuery(genericTransform, this.isPerm());
            storeRecordQuery.setMaxReturn(this._maxReturn);
            _logger.debug(string2, "About to retrieve policy from storage. Query is : " + storeRecordQuery);
            pagedResultSet = this.performQuery(policySet, storeRecordQuery);
            _logger.debug(string2, "Adding results to cache with key : " + string);
            objectCacheImpl.addEntry(string, pagedResultSet);
        }
        try {
            iterator = MCCUtil.convertPagedResultSet(pagedResultSet, this._extractType == 1);
        }
        catch (MCCUtilException mCCUtilException) {
            String string5 = CWRGSMessageHelper.getMessage("ERROR_CONVERT_PAGED_RESULT_SET", new Object[]{mCCUtilException.getMessage()});
            _logger.error(string2, string5, mCCUtilException);
            throw new DataProcessingException(string5, mCCUtilException);
        }
        _logger.exit(string2, iterator);
        return iterator;
    }

    protected Set createReturnSet() {
        Set set = null;
        set = this._extractType == 1 ? CollectionFactory.newOrderedSet() : CollectionFactory.newSet();
        return set;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

