/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.iauthz.mcc;

import com.ibm.sec.iauthz.log.SecLogger;
import com.ibm.sec.iauthz.mcc.DataProcessingException;
import com.ibm.sec.iauthz.mcc.IRtPolicyDataProcessing;
import com.ibm.sec.iauthz.mcc.RtDataProcessingImpl;
import com.ibm.sec.iauthz.mcc.dna.DeltaDataObject;
import com.ibm.sec.iauthz.mcc.dna.InheritedRole;
import com.ibm.sec.iauthz.mcc.dna.PolicyConfigObject;
import com.ibm.sec.iauthz.storage.PolicyMgmt;
import com.ibm.sec.iauthz.storage.PolicyStorageFactory;
import com.ibm.sec.iauthz.storage.PolicyStoreException;
import com.ibm.sec.iauthz.util.CWRGSMessageHelper;
import com.ibm.sec.iauthz.util.CollectionFactory;
import java.security.Permission;
import java.util.Iterator;
import java.util.Set;

public class RtPolicyDataProcessingImpl
extends RtDataProcessingImpl
implements IRtPolicyDataProcessing {
    private static SecLogger _logger = SecLogger.getLogger(class$com$ibm$sec$iauthz$mcc$RtPolicyDataProcessingImpl == null ? (class$com$ibm$sec$iauthz$mcc$RtPolicyDataProcessingImpl = RtPolicyDataProcessingImpl.class$("com.ibm.sec.iauthz.mcc.RtPolicyDataProcessingImpl")) : class$com$ibm$sec$iauthz$mcc$RtPolicyDataProcessingImpl);
    static /* synthetic */ Class class$com$ibm$sec$iauthz$mcc$RtPolicyDataProcessingImpl;

    protected RtPolicyDataProcessingImpl(String string, String string2) throws DataProcessingException {
        super(string, string2);
        String string3 = "RtPolicyDataProcessingImpl(String, String)";
        _logger.entry(string3, new Object[]{string, string2});
        this._version = this._policyStore.getPermPolicy().getVersion();
        _logger.debug(string3, "Version set to " + this._version);
        _logger.exit(string3);
    }

    public boolean isCurrent() throws DataProcessingException {
        String string = "isCurrent()";
        _logger.entry(string);
        boolean bl = false;
        try {
            bl = this._policyStore.getPermPolicy().isCurrent();
        }
        catch (PolicyStoreException policyStoreException) {
            String string2 = CWRGSMessageHelper.getMessage("ERROR_DP_CHECK_CURRENT_VERSION", new Object[]{policyStoreException.getMessage()});
            _logger.error(string, string2, policyStoreException);
            throw new DataProcessingException(string2, policyStoreException);
        }
        _logger.exit(string, bl);
        return bl;
    }

    public String getMasterVersion() throws DataProcessingException {
        String string = "getMasterVersion()";
        _logger.entry(string);
        String string2 = null;
        try {
            string2 = this._policyStore.getPermPolicy().getMasterVersion();
        }
        catch (PolicyStoreException policyStoreException) {
            String string3 = CWRGSMessageHelper.getMessage("ERROR_DP_GET_MASTER_VERSION", new Object[]{policyStoreException.getMessage()});
            _logger.error(string, string3, policyStoreException);
            throw new DataProcessingException(string3, policyStoreException);
        }
        _logger.exit(string, string2);
        return string2;
    }

    public void updateVersion() throws DataProcessingException {
        String string = "updateVersion()";
        _logger.entry(string);
        _logger.debug(string, "Original version is " + this._version);
        try {
            this._policyStore.getPermPolicy().refresh();
        }
        catch (PolicyStoreException policyStoreException) {
            String string2 = CWRGSMessageHelper.getMessage("ERROR_DP_UPDATE_VERSION", new Object[]{policyStoreException.getMessage()});
            _logger.error(string, string2, policyStoreException);
            throw new DataProcessingException(string2, policyStoreException);
        }
        this._version = this._policyStore.getPermPolicy().getVersion();
        _logger.debug(string, "New version is " + this._version);
        this.closeCachedEntries();
        _logger.exit(string);
    }

    public boolean isPerm() {
        return true;
    }

    public Iterator retrieveRoles(short s) throws DataProcessingException {
        String string = "retrieveRoles(short)";
        _logger.entry(string, new Short(s));
        Set set = this.createReturnSet();
        PolicyConfigObject policyConfigObject = new PolicyConfigObject();
        Iterator iterator = this.getResults(policyConfigObject, "Roles_Cache_key", s, this._policyStore.getPermPolicy());
        if (iterator != null) {
            while (iterator.hasNext()) {
                Object object;
                PolicyConfigObject policyConfigObject2 = null;
                if (this._extractType == 1) {
                    _logger.debug(string, "Retrieving DeltaDataObjects.");
                    object = (DeltaDataObject)iterator.next();
                    if (object != null) {
                        policyConfigObject2 = (PolicyConfigObject)((DeltaDataObject)object).getData();
                    }
                } else {
                    _logger.debug(string, "Retrieving PolicyConfigObjects.");
                    policyConfigObject2 = (PolicyConfigObject)iterator.next();
                }
                if (policyConfigObject2 != null) {
                    object = policyConfigObject2.getRoleName();
                    if (object != null) {
                        if (!((String)object).equalsIgnoreCase("_UNCHECKED_") && !((String)object).equalsIgnoreCase("_EXCLUDED_")) {
                            set.add(object);
                            continue;
                        }
                        _logger.debug(string, "Ignoring unchecked or excluded.");
                        continue;
                    }
                    _logger.debug(string, "The rolename is null. Ignoring.");
                    continue;
                }
                _logger.debug(string, "The PolicyConfigObject is null. Ignoring.");
            }
        } else {
            _logger.debug(string, "The iterator for the converted PagedResultSet is null.");
        }
        _logger.exit(string, set);
        return set.iterator();
    }

    public Iterator retrievePolicy(String string, short s) throws DataProcessingException {
        String string2 = "retrievePolicy(String, short)";
        _logger.entry(string2, new Object[]{string, new Short(s)});
        if (string == null || string.length() == 0) {
            String string3 = CWRGSMessageHelper.getMessage("ERROR_DPF_BAD_FUNCTION_INPUT");
            _logger.error(string2, string3);
            throw new DataProcessingException(string3);
        }
        Set set = this.createReturnSet();
        PolicyConfigObject policyConfigObject = new PolicyConfigObject(string);
        Iterator iterator = this.getResults(policyConfigObject, string, s, this._policyStore.getPermPolicy());
        if (iterator != null) {
            while (iterator.hasNext()) {
                Object object;
                if (this._extractType == 1) {
                    _logger.debug(string2, "Retrieving DeltaDataObjects.");
                    object = (DeltaDataObject)iterator.next();
                    if (object != null) {
                        set.add(object);
                        continue;
                    }
                    _logger.debug(string2, "The DeltaDataObject is null. Ignoring.");
                    continue;
                }
                _logger.debug(string2, "Retrieving PolicyConfigObjects.");
                object = (PolicyConfigObject)iterator.next();
                if (object != null) {
                    Permission permission = ((PolicyConfigObject)object).getPermission();
                    if (permission != null) {
                        set.add(permission);
                        continue;
                    }
                    _logger.debug(string2, "The Permission is null. Ignoring.");
                    continue;
                }
                _logger.debug(string2, "The PolicyConfigObject is null. Ignoring.");
            }
        } else {
            _logger.debug(string2, "The iterator for the converted PagedResultSet is null.");
        }
        _logger.exit(string2, set);
        return set.iterator();
    }

    public Iterator getLinkedPolicy(short s) throws DataProcessingException {
        String string = "getLinkedPolicy(short)";
        _logger.entry(string, new Short(s));
        Iterator iterator = null;
        if (s == 0) {
            PolicyMgmt policyMgmt = null;
            try {
                policyMgmt = PolicyStorageFactory.getPolicyMgmt(this._props);
            }
            catch (PolicyStoreException policyStoreException) {
                String string2 = CWRGSMessageHelper.getMessage("ERROR_GETTING_POLICYMGMT_INSTANCE", new Object[]{policyStoreException.getMessage()});
                _logger.error(string, string2, policyStoreException);
                throw new DataProcessingException(string2, policyStoreException);
            }
            if (policyMgmt == null) {
                String string3 = CWRGSMessageHelper.getMessage("ERROR_POLICY_MGMT_NULL");
                _logger.error(string, string3);
                throw new DataProcessingException(string3);
            }
            Set set = null;
            try {
                set = policyMgmt.getLinkedContexts(this._contextID);
            }
            catch (PolicyStoreException policyStoreException) {
                String string4 = CWRGSMessageHelper.getMessage("ERROR_CONFIG_LINKED_GET_EXCEPTION", new Object[]{this._contextID, policyStoreException.getMessage()});
                _logger.error(string, string4, policyStoreException);
                throw new DataProcessingException(string4, policyStoreException);
            }
            if (set != null) {
                _logger.debug(string, "Found " + set.size() + " linked configurations for context " + this._contextID);
                iterator = set.iterator();
            } else {
                _logger.debug(string, "No linked configurations found.");
                set = CollectionFactory.newSet();
                iterator = set.iterator();
            }
        } else {
            _logger.debug(string, "The linked contexts are always returned in first place. Returning empty iterator.");
            iterator = CollectionFactory.newSet().iterator();
        }
        _logger.exit(string, iterator);
        return iterator;
    }

    public Iterator getInheritedRoles(String string, short s) throws DataProcessingException {
        String string2 = "getInheritedRoles(String, short)";
        _logger.entry(string2, new Object[]{string, new Short(s)});
        if (string == null || string.length() == 0) {
            String string3 = CWRGSMessageHelper.getMessage("ERROR_DPF_BAD_FUNCTION_INPUT");
            _logger.error(string2, string3);
            throw new DataProcessingException(string3);
        }
        Set set = this.createReturnSet();
        InheritedRole inheritedRole = new InheritedRole(string, null);
        Iterator iterator = this.getResults(inheritedRole, "Inherited_Roles_Cache_key", s, this._policyStore.getPermPolicy());
        if (iterator != null) {
            while (iterator.hasNext()) {
                Object object;
                if (this._extractType == 1) {
                    _logger.debug(string2, "Retrieving DeltaDataObjects.");
                    object = (DeltaDataObject)iterator.next();
                    if (object != null) {
                        set.add(object);
                        continue;
                    }
                    _logger.debug(string2, "The DeltaDataObject is null. Ignoring.");
                    continue;
                }
                _logger.debug(string2, "Retrieving InheritedRole objects.");
                object = (InheritedRole)iterator.next();
                if (object != null) {
                    String string4 = ((InheritedRole)object).getRoleName();
                    if (string4 != null) {
                        set.add(string4);
                        continue;
                    }
                    _logger.debug(string2, "The RoleName is null. Ignoring.");
                    continue;
                }
                _logger.debug(string2, "The InheritedRole is null. Ignoring.");
            }
        } else {
            _logger.debug(string2, "The iterator for the converted PagedResultSet is null.");
        }
        _logger.exit(string2);
        return set.iterator();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

