/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.iauthz.mcc;

import com.ibm.sec.authz.jaccx.role.RoleCondition;
import com.ibm.sec.iauthz.log.SecLogger;
import com.ibm.sec.iauthz.mcc.DataProcessingException;
import com.ibm.sec.iauthz.mcc.IRtRoleDataProcessing;
import com.ibm.sec.iauthz.mcc.RtDataProcessingImpl;
import com.ibm.sec.iauthz.mcc.dna.CombiningAlgorithm;
import com.ibm.sec.iauthz.mcc.dna.DeltaDataObject;
import com.ibm.sec.iauthz.mcc.dna.RoleConfigObject;
import com.ibm.sec.iauthz.storage.PolicyStoreException;
import com.ibm.sec.iauthz.util.CWRGSMessageHelper;
import java.security.Principal;
import java.util.Iterator;
import java.util.Set;

public class RtRoleDataProcessingImpl
extends RtDataProcessingImpl
implements IRtRoleDataProcessing {
    private static SecLogger _logger = SecLogger.getLogger(class$com$ibm$sec$iauthz$mcc$RtRoleDataProcessingImpl == null ? (class$com$ibm$sec$iauthz$mcc$RtRoleDataProcessingImpl = RtRoleDataProcessingImpl.class$("com.ibm.sec.iauthz.mcc.RtRoleDataProcessingImpl")) : class$com$ibm$sec$iauthz$mcc$RtRoleDataProcessingImpl);
    static /* synthetic */ Class class$com$ibm$sec$iauthz$mcc$RtRoleDataProcessingImpl;

    protected RtRoleDataProcessingImpl(String string, String string2) throws DataProcessingException {
        super(string, string2);
        String string3 = "RtRoleDataProcessingImpl(String, String)";
        _logger.entry(string3, new Object[]{string, string2});
        this._version = this._policyStore.getRolePolicy().getVersion();
        _logger.debug(string3, "Version set to " + this._version);
        _logger.exit(string3);
    }

    public boolean isCurrent() throws DataProcessingException {
        String string = "isCurrent()";
        _logger.entry(string);
        boolean bl = false;
        try {
            bl = this._policyStore.getRolePolicy().isCurrent();
        }
        catch (PolicyStoreException policyStoreException) {
            String string2 = CWRGSMessageHelper.getMessage("ERROR_DP_CHECK_CURRENT_VERSION", new Object[]{policyStoreException.getMessage()});
            _logger.error(string, string2, policyStoreException);
            throw new DataProcessingException(string2, policyStoreException);
        }
        _logger.exit(string, bl);
        return bl;
    }

    public String getMasterVersion() throws DataProcessingException {
        String string = "getMasterVersion()";
        _logger.entry(string);
        String string2 = null;
        try {
            string2 = this._policyStore.getRolePolicy().getMasterVersion();
        }
        catch (PolicyStoreException policyStoreException) {
            String string3 = CWRGSMessageHelper.getMessage("ERROR_DP_GET_MASTER_VERSION", new Object[]{policyStoreException.getMessage()});
            _logger.error(string, string3, policyStoreException);
            throw new DataProcessingException(string3, policyStoreException);
        }
        _logger.exit(string, string2);
        return string2;
    }

    public void updateVersion() throws DataProcessingException {
        String string = "updateVersion()";
        _logger.entry(string);
        _logger.debug(string, "Original version is " + this._version);
        try {
            this._policyStore.getRolePolicy().refresh();
        }
        catch (PolicyStoreException policyStoreException) {
            String string2 = CWRGSMessageHelper.getMessage("ERROR_DP_UPDATE_VERSION", new Object[]{policyStoreException.getMessage()});
            _logger.error(string, string2, policyStoreException);
            throw new DataProcessingException(string2, policyStoreException);
        }
        this._version = this._policyStore.getRolePolicy().getVersion();
        _logger.debug(string, "New version is " + this._version);
        this.closeCachedEntries();
        _logger.exit(string);
    }

    public boolean isPerm() {
        return false;
    }

    public Iterator retrievePrincipals(short s) throws DataProcessingException {
        String string = "retrievePrincipals(short)";
        _logger.entry(string, new Short(s));
        Set set = this.createReturnSet();
        RoleConfigObject roleConfigObject = new RoleConfigObject();
        Iterator iterator = this.getResults(roleConfigObject, "Principals_Cache_key", s, this._policyStore.getRolePolicy());
        if (iterator != null) {
            while (iterator.hasNext()) {
                Object object;
                RoleConfigObject roleConfigObject2 = null;
                if (this._extractType == 1) {
                    _logger.debug(string, "Retrieving DeltaDataObjects.");
                    object = (DeltaDataObject)iterator.next();
                    if (object != null) {
                        roleConfigObject2 = (RoleConfigObject)((DeltaDataObject)object).getData();
                    } else {
                        _logger.debug(string, "The DeltaDataObject is null. Ignoring.");
                    }
                } else {
                    _logger.debug(string, "Retrieving RoleConfigObjects.");
                    roleConfigObject2 = (RoleConfigObject)iterator.next();
                }
                if (roleConfigObject2 != null) {
                    object = roleConfigObject2.getPrincipal();
                    if (object != null) {
                        set.add(object);
                        continue;
                    }
                    _logger.debug(string, "The Principal is null. Ignoring.");
                    continue;
                }
                _logger.debug(string, "The RoleConfigObject is null. Ignoring.");
            }
        } else {
            _logger.debug(string, "The iterator for the converted PagedResultSet is null.");
        }
        _logger.exit(string);
        return set.iterator();
    }

    public Iterator retrieveRoles(Principal principal, short s) throws DataProcessingException {
        String string = "retrieveRoles(Principal, short)";
        _logger.entry(string, new Object[]{principal, new Short(s)});
        if (principal == null || principal.getName() == null) {
            String string2 = CWRGSMessageHelper.getMessage("ERROR_DPF_BAD_FUNCTION_INPUT");
            _logger.error(string, string2);
            throw new DataProcessingException(string2);
        }
        Set set = this.createReturnSet();
        RoleConfigObject roleConfigObject = new RoleConfigObject(principal);
        Iterator iterator = this.getResults(roleConfigObject, principal.getName(), s, this._policyStore.getRolePolicy());
        if (iterator != null) {
            while (iterator.hasNext()) {
                Object object;
                if (this._extractType == 1) {
                    _logger.debug(string, "Retrieving DeltaDataObjects.");
                    object = (DeltaDataObject)iterator.next();
                    if (object != null) {
                        set.add(object);
                        continue;
                    }
                    _logger.debug(string, "The DeltaDataObject is null. Ignoring.");
                    continue;
                }
                _logger.debug(string, "Retrieving RoleConfigObjects.");
                object = (RoleConfigObject)iterator.next();
                if (object != null) {
                    RoleCondition roleCondition = ((RoleConfigObject)object).getRoleCondition();
                    if (roleCondition != null) {
                        set.add(roleCondition);
                        continue;
                    }
                    _logger.debug(string, "The RoleCondition is null. Ignoring.");
                    continue;
                }
                _logger.debug(string, "The RoleConfigObject is null. Ignoring.");
            }
        } else {
            _logger.debug(string, "The iterator for the converted PagedResultSet is null.");
        }
        _logger.exit(string);
        return set.iterator();
    }

    public String getCombiningAlgorithm() throws DataProcessingException {
        String string = "getCombiningAlgorithm()";
        _logger.entry(string);
        String string2 = null;
        CombiningAlgorithm combiningAlgorithm = new CombiningAlgorithm(null);
        Iterator iterator = this.getResults(combiningAlgorithm, "Combining_Algorithm_Cache_key", (short)0, this._policyStore.getRolePolicy());
        if (iterator != null) {
            if (iterator.hasNext()) {
                Object e2 = iterator.next();
                CombiningAlgorithm combiningAlgorithm2 = null;
                if (this._extractType == 1) {
                    _logger.debug(string, "Retrieving DeltaDataObject.");
                    DeltaDataObject deltaDataObject = (DeltaDataObject)e2;
                    if (deltaDataObject != null) {
                        combiningAlgorithm2 = (CombiningAlgorithm)deltaDataObject.getData();
                    } else {
                        _logger.debug(string, "The DeltaDataObject is null. Ignoring.");
                    }
                } else {
                    _logger.debug(string, "Retrieving CombiningAlgorithm Object.");
                    combiningAlgorithm2 = (CombiningAlgorithm)e2;
                }
                if (combiningAlgorithm2 != null) {
                    string2 = combiningAlgorithm2.getAlgorithm();
                } else {
                    _logger.debug(string, "CombiningAlgorithm is null.");
                }
            }
        } else {
            String string3 = "Storage has returned an empty CombiningAlgorithm.";
            _logger.debug(string, string3);
        }
        if (string2 == null || string2.length() == 0) {
            _logger.debug(string, "Using default combining algorithm.");
            string2 = "block-overrides";
        }
        _logger.exit(string, string2);
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

