/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.iauthz.mcc.cache;

import com.ibm.sec.iauthz.log.SecLogger;
import com.ibm.sec.iauthz.mcc.cache.GenericCacheEntry;
import com.ibm.sec.iauthz.util.CollectionFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class GenericCache {
    private static SecLogger _logger = SecLogger.getLogger(class$com$ibm$sec$iauthz$mcc$cache$GenericCache == null ? (class$com$ibm$sec$iauthz$mcc$cache$GenericCache = GenericCache.class$("com.ibm.sec.iauthz.mcc.cache.GenericCache")) : class$com$ibm$sec$iauthz$mcc$cache$GenericCache);
    private int _entryLifeTime;
    private int _maxEntries;
    private Map _objectStore;
    private ExpiryList _keyExpiryList;
    protected static final int CLEAN_DEFAULT = 1;
    static /* synthetic */ Class class$com$ibm$sec$iauthz$mcc$cache$GenericCache;
    static /* synthetic */ Class class$com$ibm$sec$iauthz$mcc$cache$GenericCache$ExpiryList;

    public GenericCache(int n, int n2) {
        String string = "GenericCache( int, int )";
        _logger.entry(string, new Object[]{new Integer(n), new Integer(n2)});
        this._entryLifeTime = n * 60000;
        this._maxEntries = n2;
        this._objectStore = CollectionFactory.newMap();
        this._keyExpiryList = new ExpiryList(this._objectStore);
        _logger.debug(string, "Constructed a generic cache with following settings -->\nEntryLifetime: " + new Integer(n) + ", MaxEntries: " + new Integer(n2));
        _logger.exit(string);
    }

    public void addEntry(String string, GenericCacheEntry genericCacheEntry) {
        String string2 = "addEntry( String, GenericCacheEntry )";
        _logger.entry(string2, new Object[]{string, genericCacheEntry});
        this.removeEntry(string);
        long l = System.currentTimeMillis();
        if (this._keyExpiryList.size() == this._maxEntries) {
            _logger.debug(string2, "Hit size limit removing oldest 1");
            this._keyExpiryList.removeOldest(1, false, 0);
        }
        this._objectStore.put(string, genericCacheEntry);
        ExpiryListEntry expiryListEntry = new ExpiryListEntry(string, l);
        this._keyExpiryList.add(expiryListEntry);
        _logger.debug(string2, "Successfully added entry for key " + string);
        _logger.exit(string2);
    }

    public void removeEntry(String string) {
        String string2 = "removeEntry( String )";
        _logger.entry(string2, string);
        if (this._objectStore.containsKey(string)) {
            this._objectStore.remove(string);
            int n = this._keyExpiryList.indexOf(new ExpiryListEntry(string, 0L));
            if (n >= 0) {
                this._keyExpiryList.remove(n);
            }
            _logger.debug(string2, "Successfully removed entry for key " + string);
        }
        _logger.exit(string2);
    }

    public void removeOldest(int n) {
        this._keyExpiryList.removeOldest(n, false, 0);
    }

    public void removeOldestExpired(int n) {
        this._keyExpiryList.removeOldest(n, true, this._entryLifeTime);
    }

    public GenericCacheEntry getEntry(String string) {
        String string2 = "getEntry( String )";
        _logger.entry(string2, string);
        GenericCacheEntry genericCacheEntry = null;
        long l = System.currentTimeMillis();
        long l2 = l - (long)this._entryLifeTime;
        GenericCacheEntry genericCacheEntry2 = (GenericCacheEntry)this._objectStore.get(string);
        if (genericCacheEntry2 != null && genericCacheEntry2.getTimeStamp() >= l2 && (genericCacheEntry = genericCacheEntry2) != null) {
            _logger.debug(string2, "Successfully retrieved entry for key " + string);
        }
        _logger.exit(string2, genericCacheEntry);
        return genericCacheEntry;
    }

    public void removeAll() {
        this._keyExpiryList.clear();
        this._objectStore.clear();
    }

    protected Collection getAllEntries() {
        return this._objectStore.values();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ExpiryListEntry {
        protected String _cacheKey;
        protected long _timeStamp;

        public ExpiryListEntry(String string, long l) {
            this._cacheKey = string;
            this._timeStamp = l;
        }

        public String getKey() {
            return this._cacheKey;
        }

        public long getTimeStamp() {
            return this._timeStamp;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            ExpiryListEntry expiryListEntry = (ExpiryListEntry)object;
            if (expiryListEntry.getKey().equals(this._cacheKey)) {
                bl = true;
            }
            return bl;
        }
    }

    private static class ExpiryList
    extends ArrayList {
        Map _objectStore;
        private static SecLogger _logger = SecLogger.getLogger(class$com$ibm$sec$iauthz$mcc$cache$GenericCache$ExpiryList == null ? (class$com$ibm$sec$iauthz$mcc$cache$GenericCache$ExpiryList = GenericCache.class$("com.ibm.sec.iauthz.mcc.cache.GenericCache$ExpiryList")) : class$com$ibm$sec$iauthz$mcc$cache$GenericCache$ExpiryList);

        public ExpiryList(Map map) {
            this._objectStore = map;
        }

        public void removeOldest(int n, boolean bl, int n2) {
            int n3;
            String string = "removeOldest( int, boolean, int )";
            _logger.entry(string, new Object[]{new Integer(n), new Boolean(bl), new Integer(n2)});
            long l = System.currentTimeMillis();
            long l2 = l - (long)n2;
            if (n >= this.size()) {
                n = this.size();
            }
            for (n3 = 0; n3 < n; ++n3) {
                ExpiryListEntry expiryListEntry = (ExpiryListEntry)this.get(n3);
                if (expiryListEntry == null) continue;
                if (!bl || bl && expiryListEntry.getTimeStamp() < l2) {
                    _logger.debug(string, "Removing object for key " + expiryListEntry.getKey());
                    this._objectStore.remove(expiryListEntry.getKey());
                    continue;
                }
                if (!bl) continue;
                _logger.debug(string, "Hit unexpired entry -- cleanup finished");
                break;
            }
            this.removeRange(0, n3);
            _logger.debug(string, "Removing entries 0 to " + n3 + " from list");
            _logger.exit(string);
        }
    }
}

