/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.iauthz.mcc.cache;

import com.ibm.sec.iauthz.log.SecLogger;
import com.ibm.sec.iauthz.mcc.cache.GenericCache;
import com.ibm.sec.iauthz.mcc.cache.IObjectCache;
import com.ibm.sec.iauthz.mcc.cache.ObjectCacheEntry;
import com.ibm.sec.iauthz.mcc.cache.ObjectCachePurgeTask;
import com.ibm.sec.iauthz.util.CWRGSMessageHelper;
import com.ibm.sec.iauthz.util.CollectionFactory;
import com.ibm.sec.iauthz.util.GenericUtil;
import com.ibm.sec.iauthz.util.RWLock;
import com.ibm.sec.iauthz.util.RWLockException;
import java.util.Collection;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

public class ObjectCacheImpl
implements IObjectCache {
    private static SecLogger _logger = SecLogger.getLogger(class$com$ibm$sec$iauthz$mcc$cache$ObjectCacheImpl == null ? (class$com$ibm$sec$iauthz$mcc$cache$ObjectCacheImpl = ObjectCacheImpl.class$("com.ibm.sec.iauthz.mcc.cache.ObjectCacheImpl")) : class$com$ibm$sec$iauthz$mcc$cache$ObjectCacheImpl);
    private Properties cfg = null;
    private boolean _initialized = false;
    private GenericCache[] _theCache;
    private RWLock[] _rwLocks;
    Timer _purgeScheduler;
    private int _numCaches;
    static /* synthetic */ Class class$com$ibm$sec$iauthz$mcc$cache$ObjectCacheImpl;

    public ObjectCacheImpl() {
        String string = "ObjectCacheImpl()";
        _logger.entry(string);
        this._initialized = false;
        _logger.exit(string);
    }

    public void initialize(Properties properties) {
        String string = "initialize( Properties )";
        _logger.entry(string, properties);
        this._initialized = false;
        this.cfg = properties;
        String string2 = this.cfg.getProperty("com.ibm.sec.iauthz.mcc.cache.EnableObjectCaching");
        if (string2 == null || string2.equalsIgnoreCase("true")) {
            String string3 = this.cfg.getProperty("com.ibm.sec.iauthz.mcc.cache.ObjectCache.ResourceLifeTime");
            int n = GenericUtil.parseIntProp(string3, 10);
            String string4 = this.cfg.getProperty("com.ibm.sec.iauthz.mcc.cache.ObjectCache.MaxResources");
            int n2 = GenericUtil.parseIntProp(string4, 10000);
            String string5 = this.cfg.getProperty("com.ibm.sec.iauthz.mcc.cache.ObjectCache.NumBuckets");
            this._numCaches = GenericUtil.parseIntProp(string5, 20);
            this._theCache = new GenericCache[this._numCaches];
            this._rwLocks = new RWLock[this._numCaches];
            int n3 = n2 / this._numCaches;
            for (int i = 0; i < this._numCaches; ++i) {
                this._theCache[i] = new GenericCache(n, n3);
                this._rwLocks[i] = new RWLock();
            }
            if (n2 >= 100) {
                this._purgeScheduler = new Timer(true);
                ObjectCachePurgeTask objectCachePurgeTask = new ObjectCachePurgeTask(this, n2 / 100);
                long l = n * 60000 / 2;
                this._purgeScheduler.schedule((TimerTask)objectCachePurgeTask, l, l);
            }
            String string6 = "The protected object cache is enabled with the settings :\nMaxUsers " + n2 + ", PolicyLifeTime: " + n + ", NumBuckets: " + this._numCaches + ".";
            _logger.debug(string, string6);
            this._initialized = true;
        } else {
            String string7 = "The protected object cache is not enabled.";
            _logger.debug(string, string7);
        }
        _logger.exit(string);
    }

    public boolean isInitialized() {
        return this._initialized;
    }

    public void addEntry(String string, Object object) {
        String string2 = "addEntry( String, Object )";
        _logger.entry(string2, new Object[]{string, object});
        if (this._initialized) {
            try {
                int n = this.getCacheNumber(string);
                boolean bl = this._rwLocks[n].getWriterLock();
                if (bl) {
                    ObjectCacheEntry objectCacheEntry = new ObjectCacheEntry(string, object);
                    this._theCache[n].addEntry(string, objectCacheEntry);
                    _logger.debug(string2, "Added new entry for [" + string + "] to cache number [" + n + "]");
                    this._rwLocks[n].releaseLock();
                }
            }
            catch (RWLockException rWLockException) {
                String string3 = CWRGSMessageHelper.getMessage("CACHE_ERROR_EXCEPTION");
                _logger.error(string2, string3, rWLockException);
            }
        } else {
            _logger.debug(string2, "Attempting to perform a cache operation but the cache is not initialized. No action taken.");
        }
        _logger.exit(string2);
    }

    public void removeEntry(String string) {
        String string2 = "removeEntry( String )";
        _logger.entry(string2, string);
        if (this._initialized) {
            try {
                int n = this.getCacheNumber(string);
                boolean bl = this._rwLocks[n].getWriterLock();
                if (bl) {
                    this._theCache[n].removeEntry(string);
                    _logger.debug(string2, "Remove entry for [" + string + "] from cache number [" + n + "]");
                    this._rwLocks[n].releaseLock();
                }
            }
            catch (RWLockException rWLockException) {
                String string3 = CWRGSMessageHelper.getMessage("CACHE_ERROR_EXCEPTION");
                _logger.error(string2, string3, rWLockException);
            }
        } else {
            _logger.debug(string2, "Attempting to perform a cache operation but the cache is not initialized. No action taken.");
        }
        _logger.exit(string2);
    }

    public Object getEntry(String string) {
        String string2 = "getEntry( String )";
        _logger.entry(string2, string);
        Object object = null;
        if (this._initialized) {
            try {
                int n = this.getCacheNumber(string);
                boolean bl = this._rwLocks[n].getReaderLock();
                if (bl) {
                    ObjectCacheEntry objectCacheEntry = (ObjectCacheEntry)this._theCache[n].getEntry(string);
                    if (objectCacheEntry != null) {
                        object = objectCacheEntry.getEntry();
                        _logger.debug(string2, "Retrieved entry for [" + string + "] from cache number [" + n + "]");
                    }
                    this._rwLocks[n].releaseLock();
                }
            }
            catch (RWLockException rWLockException) {
                String string3 = CWRGSMessageHelper.getMessage("CACHE_ERROR_EXCEPTION");
                _logger.error(string2, string3, rWLockException);
            }
        } else {
            _logger.debug(string2, "Attempting to perform a cache operation but the cache is not initialized. No action taken.");
        }
        _logger.exit(string2, object);
        return object;
    }

    public void removeAll() {
        String string = "removeAll()";
        _logger.entry(string);
        if (this._initialized) {
            try {
                for (int i = 0; i < this._numCaches; ++i) {
                    boolean bl = this._rwLocks[i].getWriterLock();
                    if (!bl) continue;
                    this._theCache[i].removeAll();
                    this._rwLocks[i].releaseLock();
                }
            }
            catch (RWLockException rWLockException) {
                String string2 = CWRGSMessageHelper.getMessage("CACHE_ERROR_EXCEPTION");
                _logger.error(string, string2, rWLockException);
            }
        } else {
            _logger.debug(string, "Attempting to perform a cache operation but the cache is not initialized. No action taken.");
        }
        _logger.exit(string);
    }

    public Set getandRemoveAll() {
        String string = "getandRemoveAll()";
        _logger.entry(string);
        Set set = CollectionFactory.newSet();
        if (this._initialized) {
            try {
                for (int i = 0; i < this._numCaches; ++i) {
                    boolean bl = this._rwLocks[i].getWriterLock();
                    if (!bl) continue;
                    Collection collection = this._theCache[i].getAllEntries();
                    set.addAll(collection);
                    this._theCache[i].removeAll();
                    this._rwLocks[i].releaseLock();
                }
            }
            catch (RWLockException rWLockException) {
                String string2 = CWRGSMessageHelper.getMessage("CACHE_ERROR_EXCEPTION");
                _logger.error(string, string2, rWLockException);
            }
        } else {
            _logger.debug(string, "Attempting to perform a cache operation but the cache is not initialized. No action taken.");
        }
        _logger.exit(string, set);
        return set;
    }

    public void removeOldest(int n) {
        String string = "removeOldest( int )";
        _logger.entry(string, new Integer(n));
        if (this._initialized) {
            try {
                for (int i = 0; i < this._numCaches; ++i) {
                    boolean bl = this._rwLocks[i].getWriterLock();
                    if (!bl) continue;
                    this._theCache[i].removeOldest(n);
                    this._rwLocks[i].releaseLock();
                }
            }
            catch (RWLockException rWLockException) {
                String string2 = CWRGSMessageHelper.getMessage("CACHE_ERROR_EXCEPTION");
                _logger.error(string, string2, rWLockException);
            }
        } else {
            _logger.debug(string, "Attempting to perform a cache operation but the cache is not initialized. No action taken.");
        }
        _logger.exit(string);
    }

    public void removeOldestExpired(int n) {
        String string = "removeOldestExpired( int )";
        _logger.entry(string, new Integer(n));
        if (this._initialized) {
            try {
                for (int i = 0; i < this._numCaches; ++i) {
                    boolean bl = this._rwLocks[i].getWriterLock();
                    if (!bl) continue;
                    this._theCache[i].removeOldestExpired(n);
                    this._rwLocks[i].releaseLock();
                }
            }
            catch (RWLockException rWLockException) {
                String string2 = CWRGSMessageHelper.getMessage("CACHE_ERROR_EXCEPTION");
                _logger.error(string, string2, rWLockException);
            }
        } else {
            _logger.debug(string, "Attempting to perform a cache operation but the cache is not initialized. No action taken.");
        }
        _logger.exit(string);
    }

    private int getCacheNumber(String string) {
        int n = 0;
        n = (string.hashCode() & Integer.MAX_VALUE) % this._numCaches;
        return n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

