/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.iauthz.mcc.engine;

import com.ibm.sec.iauthz.log.SecLogger;
import com.ibm.sec.iauthz.mcc.dna.XMTObject;
import com.ibm.sec.iauthz.mcc.engine.IMetatagHandler;
import com.ibm.sec.iauthz.mcc.engine.IXMLDataValueHandler;
import com.ibm.sec.iauthz.mcc.engine.MCCFile;
import com.ibm.sec.iauthz.mcc.engine.MCCJavaHandler;
import com.ibm.sec.iauthz.util.CWRGSMessageHelper;
import com.ibm.sec.iauthz.util.CollectionFactory;
import com.ibm.sec.iauthz.util.CommonAuthProperties;
import com.ibm.sec.iauthz.util.MCCException;
import com.ibm.sec.iauthz.util.XMLException;
import com.ibm.sec.iauthz.util.XMLUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class MCCXMLHandler
implements IMetatagHandler,
IXMLDataValueHandler {
    MCCFile _mccTemplate = null;
    Document _documentFactory;
    private boolean _validateXML = false;
    private static SecLogger _logger = SecLogger.getLogger(class$com$ibm$sec$iauthz$mcc$engine$MCCXMLHandler == null ? (class$com$ibm$sec$iauthz$mcc$engine$MCCXMLHandler = MCCXMLHandler.class$("com.ibm.sec.iauthz.mcc.engine.MCCXMLHandler")) : class$com$ibm$sec$iauthz$mcc$engine$MCCXMLHandler);
    static /* synthetic */ Class class$com$ibm$sec$iauthz$mcc$engine$MCCXMLHandler;
    static /* synthetic */ Class class$com$ibm$sec$iauthz$mcc$dna$XMTObject;

    public MCCXMLHandler() throws MCCException {
        String string = "MCCXMLHandler()";
        _logger.entry(string);
        Properties properties = CommonAuthProperties.getProps();
        if (properties != null) {
            String string2 = properties.getProperty("com.ibm.sec.iauthz.mcc.engine.validateXML");
            if (string2 != null) {
                this._validateXML = Boolean.valueOf(string2);
                _logger.debug(string, "Validating imported data? " + this._validateXML);
            } else {
                _logger.debug(string, "Property com.ibm.sec.iauthz.mcc.engine.validateXML was null, validation of imported XML data disabled.");
            }
        } else {
            _logger.debug(string, "Couldn't load CommonAuthProperties file, validation of imported XML data disabled.");
        }
        this._mccTemplate = MCCFile.getInstance();
        try {
            this._documentFactory = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            String string3 = CWRGSMessageHelper.getMessage("MCC_NO_DOCUMENT_CLASS", new Object[]{parserConfigurationException.getMessage()});
            _logger.error(string, string3, parserConfigurationException);
            throw new MCCException(string3, parserConfigurationException);
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            String string4 = CWRGSMessageHelper.getMessage("MCC_NO_DOCUMENT_CLASS", new Object[]{factoryConfigurationError.getMessage()});
            _logger.error(string, string4, factoryConfigurationError);
            throw new MCCException(string4, factoryConfigurationError);
        }
        _logger.exit(string);
    }

    public XMTObject convertToXMT(Object object, String string) throws MCCException {
        String string2 = "convertToXMT( Object, String )";
        _logger.entry(string2, new Object[]{object, string});
        XMTObject xMTObject = null;
        try {
            String string3;
            Object[] objectArray;
            Object object2;
            if (object instanceof Element) {
                object2 = (Element)object;
                Object object3 = objectArray = object2.getNamespaceURI() == null ? object2.getNodeName() : object2.getLocalName();
                if (objectArray.equalsIgnoreCase("DataValue")) {
                    string3 = object2.getAttribute("DataType");
                    if (string3 != null && !"".equals(string3)) {
                        Object object4;
                        String string4 = null;
                        NodeList nodeList = object2.getChildNodes();
                        int n = nodeList.getLength();
                        for (int i = 0; i < n; ++i) {
                            if (nodeList.item(i).getNodeType() != 1) continue;
                            Element element = (Element)nodeList.item(i);
                            Object object5 = object4 = element.getNamespaceURI() == null ? element.getNodeName() : element.getLocalName();
                            if (!((String)object4).equalsIgnoreCase("ClassName")) continue;
                            string4 = XMLUtils.getNodeText(element);
                            break;
                        }
                        if (string4 != null) {
                            Map map = this._mccTemplate.getPropertiesMap(string, string4);
                            if (map != null) {
                                xMTObject = new XMTObject(string);
                                xMTObject.addElement("ClassName", string4);
                                for (int i = 0; i < n; ++i) {
                                    String string5;
                                    Element element;
                                    String string6;
                                    object4 = nodeList.item(i).getAttributes();
                                    if (object4 == null || (string6 = (element = (Element)nodeList.item(i)).getAttribute("Name")).equals("") || (string5 = (String)map.get(string6)) == null) continue;
                                    Object object6 = this.constructObjectFromXML(element, string5);
                                    if (object6 == null || object6 instanceof XMTObject || object6 instanceof Set) {
                                        xMTObject.addElement(string6, object6);
                                        continue;
                                    }
                                    xMTObject.addElement(string6, object6.toString());
                                }
                            } else {
                                _logger.debug(string2, "Couldn't retrieve properties map for <DataValue> specifying class '" + string4 + "'");
                            }
                        } else {
                            _logger.debug(string2, "No <ClassName> child found.  Returning null.");
                        }
                    } else {
                        _logger.debug(string2, "<DataValue> element has no DataType attribute. Returning null.");
                    }
                } else {
                    _logger.debug(string2, "Expected a <DataValue> element, but got <" + (String)objectArray + ">. Returning null.");
                }
            } else {
                _logger.debug(string2, "MCCXMLHandler only supports conversion of XML elements to XMTObjects. Returning null.");
            }
            if (xMTObject != null && this._validateXML && (objectArray = ((MCCJavaHandler)(object2 = new MCCJavaHandler())).constructFromXMT(xMTObject)) == null) {
                string3 = CWRGSMessageHelper.getMessage("MCC_VALIDATION_OF_CONVERTED_XML_OBJECT_FAILED", new Object[]{(String)xMTObject.getElement("ClassName")});
                _logger.error(string2, string3);
                throw new MCCException(string3);
            }
        }
        catch (XMLException xMLException) {
            String string7 = CWRGSMessageHelper.getMessage("MCC_ERROR_CONVERTING_XML_TO_XMT", new Object[]{xMLException.getMessage()});
            _logger.error(string2, "Caught XMLException, re-throwing as MCCException", xMLException);
            throw new MCCException(string7, xMLException);
        }
        _logger.exit(string2, xMTObject);
        return xMTObject;
    }

    public Object[] constructFromXMT(XMTObject xMTObject) throws MCCException {
        String string = "constructFromXMT( XMTObject )";
        _logger.entry(string, xMTObject);
        Object[] objectArray = null;
        if (xMTObject != null) {
            String string2 = xMTObject.getType();
            String string3 = this._mccTemplate.getMapping("Type", string2, "URN");
            if (string3 == null) {
                String string4 = CWRGSMessageHelper.getMessage("MCC_NO_URN_FOR_XMT_TYPE", new Object[]{string2});
                _logger.error(string, string4);
                throw new MCCException(string4);
            }
            String string5 = (String)xMTObject.getElement("ClassName");
            if (string5 == null) {
                String string6 = CWRGSMessageHelper.getMessage("MCC_NO_CLASSNAME_IN_XMTOBJECT");
                _logger.error(string, string6);
                throw new MCCException(string6);
            }
            Map map = this._mccTemplate.getPropertiesMap(xMTObject.getType(), string5);
            if (map == null) {
                String string7 = CWRGSMessageHelper.getMessage("MCC_NO_PROPERTIES_FOUND", new Object[]{xMTObject.getType(), string5});
                _logger.error(string, string7);
                throw new MCCException(string7);
            }
            objectArray = new Object[2];
            Element element = this._documentFactory.createElement("DataValue");
            element.setAttribute("DataType", string3);
            Element element2 = this._documentFactory.createElement("ClassName");
            Text text = this._documentFactory.createTextNode(string5);
            element2.appendChild(text);
            element.appendChild(element2);
            List list = CollectionFactory.newList();
            Iterator iterator = xMTObject.getKeys().iterator();
            while (iterator.hasNext()) {
                String string8;
                String string9 = (String)iterator.next();
                if (string9.equals("ClassName")) continue;
                Object object = xMTObject.getElement(string9);
                String string10 = (String)map.get(string9);
                try {
                    Element element3 = this.constructXMLFromObject(object, string10);
                    if (element3 != null) {
                        element3.setAttribute("Name", string9);
                        String string11 = string8 = element3.getNamespaceURI() == null ? element3.getNodeName() : element3.getLocalName();
                        if (string8.equalsIgnoreCase("DataValue")) {
                            list.add(element3);
                            continue;
                        }
                        element.appendChild(element3);
                        continue;
                    }
                    string8 = CWRGSMessageHelper.getMessage("MCC_NULL_FROM_XML_CONVERSION", new Object[]{object});
                    _logger.error(string, string8);
                    throw new MCCException(string8);
                }
                catch (XMLException xMLException) {
                    string8 = CWRGSMessageHelper.getMessage("MCC_ERROR_DURING_XML_CONVERSION", new Object[]{object, xMLException.getMessage()});
                    _logger.error(string, string8, xMLException);
                    throw new MCCException(string8, xMLException);
                }
            }
            iterator = list.iterator();
            while (iterator.hasNext()) {
                element.appendChild((Element)iterator.next());
            }
            objectArray[0] = element;
            objectArray[1] = element.getClass();
        }
        _logger.exit(string, objectArray);
        return objectArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object constructObjectFromXML(Element element) throws XMLException {
        String string;
        String string2 = "constructObjectFromXML( Element )";
        _logger.entry(string2, element);
        if (element == null) {
            String string3 = CWRGSMessageHelper.getMessage("MCC_NULL_OBJECT_PASSED_FOR_CONVERSION");
            _logger.error(string2, string3);
            throw new XMLException(string3);
        }
        Object object = null;
        String string4 = string = element.getNamespaceURI() == null ? element.getNodeName() : element.getLocalName();
        if (string.equalsIgnoreCase("ClassName")) {
            String string5 = XMLUtils.getNodeText(element);
            if (string5 == null) {
                String string6 = CWRGSMessageHelper.getMessage("MCC_NO_CLASSNAME_IN_XML");
                _logger.error(string2, string6);
                throw new XMLException(string6);
            }
            try {
                object = Class.forName(string5);
            }
            catch (ClassNotFoundException classNotFoundException) {
                String string7 = CWRGSMessageHelper.getMessage("MCC_CLASS_NOT_FOUND", new Object[]{string5});
                _logger.error(string2, string7);
                throw new XMLException(string7);
            }
        }
        if (!string.equalsIgnoreCase("DataValue") && !string.equalsIgnoreCase("SimpleValue")) {
            String string8 = CWRGSMessageHelper.getMessage("MCC_UNKNOWN_XML_ELEMENT", new Object[]{string});
            _logger.error(string2, string8);
            throw new XMLException(string8);
        }
        String string9 = element.getAttribute("DataType");
        if (string9 == null || "".equals(string9)) {
            String string10 = CWRGSMessageHelper.getMessage("MCC_NO_DATATYPE_IN_XML");
            _logger.error(string2, string10);
            throw new XMLException(string10);
        }
        try {
            String string11 = this._mccTemplate.getMapping("URN", string9, "Type");
            if (string11 == null) {
                String string12 = CWRGSMessageHelper.getMessage("MCC_INVALID_DATATYPE", new Object[]{string9});
                _logger.error(string2, string12);
                throw new XMLException(string12);
            }
            object = this.constructObjectFromXML(element, string11);
        }
        catch (MCCException mCCException) {
            String string13 = CWRGSMessageHelper.getMessage("MCC_ERROR_CONVERTING_XML_TO_XMT", new Object[]{mCCException.getMessage()});
            _logger.error(string2, string13, mCCException);
            throw new XMLException(string13, mCCException);
        }
        _logger.exit(string2, object);
        return object;
    }

    private Object constructObjectFromXML(Element element, String string) throws MCCException, XMLException {
        String string2 = "constructObjectFromXML( Element, String )";
        _logger.entry(string2, new Object[]{element, string});
        Object object = null;
        if (string != null) {
            String string3 = element.getAttribute("is-null");
            if (string3.equals("")) {
                if (string.equals("@STRING")) {
                    object = XMLUtils.getNodeText(element);
                } else if (string.equals("@INT")) {
                    object = new Integer(XMLUtils.getNodeText(element));
                } else if (string.equals("@BOOL")) {
                    object = new Boolean(XMLUtils.getNodeText(element));
                } else if (string.equals("@SHORT")) {
                    object = new Short(XMLUtils.getNodeText(element));
                } else if (string.equals("@LONG")) {
                    object = new Long(XMLUtils.getNodeText(element));
                } else if (string.equals("@DOUBLE")) {
                    object = new Long(XMLUtils.getNodeText(element));
                } else if (string.equals("@FLOAT")) {
                    object = new Long(XMLUtils.getNodeText(element));
                } else if (string.equals("@OBJECT_STRING")) {
                    String string4;
                    String string5 = null;
                    String string6 = null;
                    String string7 = string4 = element.getNamespaceURI() == null ? element.getNodeName() : element.getLocalName();
                    if (string4.equals("SimpleValue")) {
                        string6 = XMLUtils.getNodeText(element);
                        String string8 = element.getAttribute("DataType");
                        string5 = this._mccTemplate.getMapping("URN", string8, "DefaultType");
                    } else if (string4.equals("DataValue")) {
                        NodeList nodeList = element.getChildNodes();
                        int n = nodeList.getLength();
                        for (int i = 0; i < n; ++i) {
                            String string9;
                            if (nodeList.item(i).getNodeType() != 1) continue;
                            Element element2 = (Element)nodeList.item(i);
                            String string10 = string9 = element2.getNamespaceURI() == null ? element2.getNodeName() : element2.getLocalName();
                            if (string9.equalsIgnoreCase("ClassName")) {
                                string5 = XMLUtils.getNodeText(element2);
                                continue;
                            }
                            if (!string9.equalsIgnoreCase("SimpleValue")) continue;
                            string6 = XMLUtils.getNodeText(element2);
                        }
                    }
                    if (string5 != null) {
                        if (string6 == null) {
                            string6 = "";
                        }
                        object = string5 + ":" + string6;
                    } else {
                        _logger.debug(string2, "Couldn't extract class name for object string type, returning null.");
                        object = null;
                    }
                } else if (string.startsWith("@SET_")) {
                    Object object2;
                    Object object3;
                    String string11 = null;
                    NodeList nodeList = element.getChildNodes();
                    int n = nodeList.getLength();
                    for (int i = 0; i < n; ++i) {
                        if (nodeList.item(i).getNodeType() != 1) continue;
                        object3 = (Class[])nodeList.item(i);
                        Object object4 = object2 = object3.getNamespaceURI() == null ? object3.getNodeName() : object3.getLocalName();
                        if (!((String)object2).equalsIgnoreCase("ClassName")) continue;
                        string11 = XMLUtils.getNodeText((Node)object3);
                    }
                    object = null;
                    if (string11 != null) {
                        try {
                            Class<?> clazz = Class.forName(string11);
                            object3 = new Class[]{};
                            object2 = new Object[]{};
                            object = this.createObject(clazz.getConstructor((Class<?>)object3), (Object[])object2);
                        }
                        catch (Exception exception) {
                            object = null;
                        }
                    }
                    if (object == null || !(object instanceof Set)) {
                        _logger.debug(string2, "Either no class specified or specified class doesn't implement the Set interface. Defaulting to HashSet");
                        object = CollectionFactory.newSet();
                    }
                    _logger.debug(string2, "Creating XMTObjects from Elements within set Element.");
                    for (int i = 0; i < n; ++i) {
                        if (nodeList.item(i).getNodeType() != 1) continue;
                        object3 = (Element)nodeList.item(i);
                        Object object5 = object2 = object3.getNamespaceURI() == null ? object3.getNodeName() : object3.getLocalName();
                        if (((String)object2).equalsIgnoreCase("ClassName")) continue;
                        Object object6 = this.constructObjectFromXML((Element)object3);
                        ((Set)object).add(object6);
                    }
                } else if (string.startsWith("@") && string.endsWith("@")) {
                    object = this.convertToXMT(element, string);
                } else {
                    String string12 = "Invalid type '" + string + "'";
                    _logger.debug(string2, string12);
                }
            }
        } else {
            String string13 = "XMT type was null, returning null.";
            _logger.debug(string2, string13);
        }
        _logger.exit(string2, object);
        return object;
    }

    public Element constructXMLFromObject(Object object) throws XMLException {
        String string = "constructXMLFromObject( Object )";
        _logger.entry(string, object);
        if (object == null) {
            String string2 = CWRGSMessageHelper.getMessage("MCC_NULL_OBJECT_PASSED_FOR_CONVERSION");
            _logger.error(string, string2);
            throw new XMLException(string2);
        }
        Element element = null;
        if (object instanceof XMTObject) {
            String string3 = ((XMTObject)object).getType();
            element = this.constructXMLFromObject(object, string3);
        } else {
            try {
                String string4 = this._mccTemplate.getTypeMapping(object.getClass());
                if (string4 == null) {
                    String string5 = CWRGSMessageHelper.getMessage("MCC_NO_TYPE_MAPPED_TO_CLASS", new Object[]{object.getClass().getName()});
                    _logger.error(string, string5);
                    throw new XMLException(string5);
                }
                element = this.constructXMLFromObject(object, string4);
            }
            catch (MCCException mCCException) {
                String string6 = CWRGSMessageHelper.getMessage("MCC_ERROR_CONVERTING_XML_TO_XMT", new Object[]{mCCException.getMessage()});
                _logger.error(string, string6);
                throw new XMLException(string6);
            }
        }
        _logger.exit(string, element);
        return element;
    }

    public Element constructXMLFromObject(int n) throws XMLException {
        return this.constructXMLFromObject(new Integer(n), "@INT");
    }

    public Element constructXMLFromObject(short s) throws XMLException {
        return this.constructXMLFromObject(new Short(s), "@SHORT");
    }

    public Element constructXMLFromObject(float f) throws XMLException {
        return this.constructXMLFromObject(new Float(f), "@FLOAT");
    }

    public Element constructXMLFromObject(double d) throws XMLException {
        return this.constructXMLFromObject(new Double(d), "@DOUBLE");
    }

    public Element constructXMLFromObject(long l) throws XMLException {
        return this.constructXMLFromObject(new Long(l), "@LONG");
    }

    public Element constructXMLFromObject(boolean bl) throws XMLException {
        return this.constructXMLFromObject(new Boolean(bl), "@BOOL");
    }

    /*
     * Unable to fully structure code
     */
    private Element constructXMLFromObject(Object var1_1, String var2_2) throws XMLException {
        var3_3 = "constructXMLFromObject( Object, String )";
        MCCXMLHandler._logger.entry(var3_3, new Object[]{var1_1, var2_2});
        var4_4 = null;
        if (var2_2 != null) {
            if (var2_2.equalsIgnoreCase("@OBJECT_STRING")) {
                try {
                    if (var1_1 != null) {
                        var5_5 = ((String)var1_1).split(":", 2);
                        var6_15 = null;
                        var6_15 = var5_5.length == 2 ? var5_5[1] : "";
                        var7_23 = var5_5[0];
                        var8_26 = this._mccTemplate.getMapping("DefaultType", var7_23, "URN");
                        if (var8_26 != null) {
                            var4_4 = this._documentFactory.createElement("SimpleValue");
                            var4_4.setAttribute("DataType", var8_26);
                            var4_4.appendChild(this._documentFactory.createTextNode(var6_15));
                        }
                        var9_28 = this._mccTemplate.getMapping("Type", "@OBJECT_STRING", "URN");
                        var4_4 = this._documentFactory.createElement("DataValue");
                        var4_4.setAttribute("DataType", var9_28);
                        var10_30 = this._documentFactory.createElement("ClassName");
                        var10_30.appendChild(this._documentFactory.createTextNode(var5_5[0]));
                        var4_4.appendChild(var10_30);
                        var11_31 = this.constructXMLFromObject(var6_15);
                        var4_4.appendChild(var11_31);
                    }
                    var4_4.setAttribute("is-null", "true");
                }
                catch (MCCException var5_6) {
                    var6_16 = CWRGSMessageHelper.getMessage("MCC_ERROR_CONVERTING_TO_XML", new Object[]{var2_2, var5_6.getMessage()});
                    MCCXMLHandler._logger.error(var3_3, var6_16, var5_6);
                    throw new XMLException(var6_16, var5_6);
                }
            } else if (var2_2.startsWith("@SET_")) {
                try {
                    var4_4 = this._documentFactory.createElement("DataValue");
                    var5_7 = this._mccTemplate.getMapping("Type", "@SET_", "URN");
                    var4_4.setAttribute("DataType", var5_7);
                    var6_17 = this._documentFactory.createElement("ClassName");
                    var7_24 = this._documentFactory.createTextNode(var1_1.getClass().getName());
                    var6_17.appendChild(var7_24);
                    var4_4.appendChild(var6_17);
                    var8_27 = ((Set)var1_1).iterator();
                    while (var8_27.hasNext()) {
                        var9_29 = this.constructXMLFromObject(var8_27.next());
                        var4_4.appendChild(var9_29);
                    }
                }
                catch (MCCException var5_8) {
                    var6_18 = CWRGSMessageHelper.getMessage("MCC_ERROR_CONVERTING_TO_XML", new Object[]{var2_2, var5_8.getMessage()});
                    MCCXMLHandler._logger.error(var3_3, var6_18, var5_8);
                    throw new XMLException(var6_18, var5_8);
                }
            } else if (var2_2.equals("@STRING") || var2_2.equals("@INT") || var2_2.equals("@BOOL") || var2_2.equals("@SHORT") || var2_2.equals("@LONG") || var2_2.equals("@FLOAT") || var2_2.equals("@DOUBLE")) {
                MCCXMLHandler._logger.debug(var3_3, "Converting XMT simple type '" + var2_2 + "' to <SimpleValue> element.");
                try {
                    var5_9 = this._mccTemplate.getMapping("Type", var2_2, "URN");
                    if (var5_9 != null) {
                        var4_4 = this._documentFactory.createElement("SimpleValue");
                        var4_4.setAttribute("DataType", var5_9);
                        if (var1_1 != null) {
                            var4_4.appendChild(this._documentFactory.createTextNode(var1_1.toString()));
                        }
                        var4_4.setAttribute("is-null", "true");
                    }
                    var6_19 = CWRGSMessageHelper.getMessage("MCC_NO_URN_FOR_XMT_TYPE", new Object[]{var2_2});
                    MCCXMLHandler._logger.error(var3_3, var6_19);
                    throw new XMLException(var6_19);
                }
                catch (MCCException var5_10) {
                    var6_20 = CWRGSMessageHelper.getMessage("MCC_ERROR_CONVERTING_TO_XML", new Object[]{var2_2, var5_10.getMessage()});
                    MCCXMLHandler._logger.error(var3_3, var6_20, var5_10);
                    throw new XMLException(var6_20, var5_10);
                }
            } else if (var2_2.startsWith("@") && var2_2.endsWith("@")) {
                try {
                    var5_11 = null;
                    if (var1_1 != null && var1_1.getClass() != (MCCXMLHandler.class$com$ibm$sec$iauthz$mcc$dna$XMTObject == null ? (MCCXMLHandler.class$com$ibm$sec$iauthz$mcc$dna$XMTObject = MCCXMLHandler.class$("com.ibm.sec.iauthz.mcc.dna.XMTObject")) : MCCXMLHandler.class$com$ibm$sec$iauthz$mcc$dna$XMTObject)) {
                        MCCXMLHandler._logger.debug(var3_3, "Object is not an XMTObject, attempting conversion to XMTObject of type '" + var2_2 + "'");
                        var6_21 = new MCCJavaHandler();
                        var7_25 = var6_21.convertToXMT(var1_1, var2_2);
                        if (var7_25 != null) {
                            MCCXMLHandler._logger.debug(var3_3, "Conversion succeeded.");
                            var5_11 = var7_25;
                        } else {
                            MCCXMLHandler._logger.debug(var3_3, "Conversion to XMTObject failed.");
                        }
                    } else {
                        var5_11 = (XMTObject)var1_1;
                    }
                    if (var5_11 != null) {
                        var6_21 = this.constructFromXMT(var5_11);
                        if (var6_21 == null) ** GOTO lbl113
                        var4_4 = (Element)var6_21[0];
                    }
                    var6_21 = this._mccTemplate.getMapping("Type", var2_2, "URN");
                    if (var6_21 == null) ** GOTO lbl113
                    var4_4 = this._documentFactory.createElement("DataValue");
                    var4_4.setAttribute("DataType", (String)var6_21);
                    var4_4.setAttribute("is-null", "true");
                }
                catch (MCCException var5_12) {
                    var6_22 = CWRGSMessageHelper.getMessage("MCC_ERROR_CONVERTING_TO_XML", new Object[]{var2_2, var5_12.getMessage()});
                    MCCXMLHandler._logger.error(var3_3, var6_22, var5_12);
                    throw new XMLException(var5_12);
                }
            } else {
                var5_13 = "Invalid XMT type '" + var2_2 + "'";
                MCCXMLHandler._logger.debug(var3_3, var5_13);
            }
        } else {
            var5_14 = "XMT type was null, returning null.";
            MCCXMLHandler._logger.debug(var3_3, var5_14);
        }
lbl113:
        // 12 sources

        MCCXMLHandler._logger.exit(var3_3, var4_4);
        return var4_4;
    }

    private Object createObject(Constructor constructor, Object[] objectArray) {
        String string = "createObject( Constructor, Object[] )";
        _logger.entry(string, new Object[]{constructor, objectArray});
        Object var4_4 = null;
        try {
            var4_4 = constructor.newInstance(objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            _logger.debug(string, "Caught IllegalArgumentException: " + illegalArgumentException.toString());
        }
        catch (InstantiationException instantiationException) {
            _logger.debug(string, "Caught InstantiationException: " + instantiationException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            _logger.debug(string, "Caught IllegalAccessException: " + illegalAccessException.toString());
        }
        catch (InvocationTargetException invocationTargetException) {
            _logger.debug(string, "Caught InvocationTargetException: " + invocationTargetException.toString());
        }
        _logger.exit(string, var4_4);
        return var4_4;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

