/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.iauthz.mcc.engine;

import com.ibm.sec.iauthz.log.SecLogger;
import com.ibm.sec.iauthz.mcc.engine.MCCFile;
import com.ibm.sec.iauthz.util.CWRGSMessageHelper;
import com.ibm.sec.iauthz.util.XMLUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMTFileValidator {
    private String _errorMessage = null;
    private Document _xmlDocument = null;
    private MCCFile _mccFile = null;
    private static SecLogger _logger = SecLogger.getLogger(class$com$ibm$sec$iauthz$mcc$engine$XMTFileValidator == null ? (class$com$ibm$sec$iauthz$mcc$engine$XMTFileValidator = XMTFileValidator.class$("com.ibm.sec.iauthz.mcc.engine.XMTFileValidator")) : class$com$ibm$sec$iauthz$mcc$engine$XMTFileValidator);
    static /* synthetic */ Class class$com$ibm$sec$iauthz$mcc$engine$XMTFileValidator;

    public XMTFileValidator(MCCFile mCCFile) {
        String string = "XMTFileValidator()";
        _logger.entry(string);
        this._mccFile = mCCFile;
        _logger.exit(string);
    }

    public boolean validateFile(InputStream inputStream) {
        boolean bl;
        String string;
        block8: {
            string = "validateFile( File )";
            _logger.entry(string, inputStream);
            bl = false;
            if (inputStream != null) {
                try {
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    documentBuilderFactory.setIgnoringComments(true);
                    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    this._xmlDocument = documentBuilder.parse(new InputSource(inputStream));
                    bl = this.validateBasicStructure();
                    if (!bl) break block8;
                    boolean bl2 = this.validateURNMappings();
                    boolean bl3 = false;
                    if (bl2) {
                        bl3 = this.validateHandlers();
                    }
                    if (!bl2 || !bl3) {
                        bl = false;
                    }
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    this._errorMessage = parserConfigurationException.toString();
                    _logger.error(string, this._errorMessage);
                    bl = false;
                }
                catch (SAXException sAXException) {
                    this._errorMessage = sAXException.toString();
                    _logger.error(string, this._errorMessage);
                    bl = false;
                }
                catch (IOException iOException) {
                    this._errorMessage = iOException.toString();
                    _logger.error(string, this._errorMessage);
                    bl = false;
                }
            } else {
                this._errorMessage = CWRGSMessageHelper.getMessage("MCC_XMTOBJ_NULL_FILE");
            }
        }
        _logger.exit(string, bl);
        return bl;
    }

    private boolean validateBasicStructure() {
        String string = "validateBasicStructure()";
        _logger.entry(string);
        boolean bl = true;
        Element element = this._xmlDocument.getDocumentElement();
        String string2 = element.getNodeName();
        if (!string2.equals("XMT")) {
            bl = false;
            this.logError(string, "MCC_XMTOBJ_INVALID_ROOT", new Object[]{"XMT", string2});
        } else {
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) {
                    if (this.isNonEmptyTextNode(node)) {
                        bl = false;
                        this.logError(string, "MCC_XMTOBJ_INVALID_CHILD");
                    }
                } else {
                    String string3 = node.getNodeName();
                    if (!string3.equals("URNMappings") && !string3.equals("Handlers")) {
                        bl = false;
                        this.logError(string, "MCC_XMTOBJ_INVALID_CHILD2", new Object[]{"XMT", string3});
                    }
                }
                if (!bl) break;
            }
        }
        _logger.exit(string, bl);
        return bl;
    }

    private boolean validateURNMappings() {
        String string = "validateURNMappings";
        _logger.entry(string);
        boolean bl = true;
        NodeList nodeList = this._xmlDocument.getElementsByTagName("URNMappings");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            if (nodeList.item(i).getNodeType() == 1) {
                Element element = (Element)nodeList.item(i);
                NodeList nodeList2 = element.getChildNodes();
                int n2 = nodeList2.getLength();
                for (int j = 0; j < n2; ++j) {
                    Node node = nodeList2.item(j);
                    if (node.getNodeType() == 3) {
                        if (!this.isNonEmptyTextNode(node)) continue;
                        bl = false;
                        this.logError(string, "MCC_XMTOBJ_TEXT_DATA", new Object[]{"URNMappings", node.getNodeValue()});
                        continue;
                    }
                    if (node.getNodeType() == 1) {
                        bl = this.validateIndividualMapping((Element)node);
                        if (bl) continue;
                        break;
                    }
                    bl = false;
                    this.logError(string, "MCC_XMTOBJ_INVALID_NODETYPE", new Object[]{"URNMappings"});
                }
            }
            if (!bl) break;
        }
        _logger.exit(string);
        return bl;
    }

    private boolean validateIndividualMapping(Element element) {
        String string = "validateIndividualMapping( Element )";
        _logger.entry(string, element);
        boolean bl = true;
        String string2 = element.getNodeName();
        if (!string2.equals("Mapping")) {
            bl = false;
            this.logError(string, "MCC_XMTOBJ_EXPECTED", new Object[]{"Mapping", string2});
        } else {
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() == 3) {
                    if (this.isNonEmptyTextNode(node)) {
                        bl = false;
                        this.logError(string, "MCC_XMTOBJ_TEXT_DATA", new Object[]{"Mapping", node.getNodeValue()});
                    }
                } else if (node.getNodeType() == 1) {
                    String string3 = node.getNodeName();
                    String string4 = XMLUtils.getNodeText(node);
                    if (string3.equals("Type")) {
                        if (string4.equals("@ARRAY_")) {
                            bl = false;
                            this.logError(string, "MCC_XMTOBJ_MAPPING_DEF", new Object[]{"@ARRAY_"});
                        } else {
                            bl = this.doesHandlerExist(string4);
                            if (!bl) {
                                this.logError(string, "MCC_XMTOBJ_HANDLER_MISSING", new Object[]{string4, "Type"});
                            }
                        }
                    } else if (string3.equals("DefaultType")) {
                        bl = this.doesClassExist(string4);
                        if (!bl) {
                            this.logError(string, "MCC_XMTOBJ_CLASS_EXIST", new Object[]{string4, "DefaultType"});
                        }
                    } else if (string3.equals("URN") && !(bl = this.isValidURN(string4))) {
                        this.logError(string, "MCC_XMTOBJ_INVALID_URN", new Object[]{string4});
                    }
                } else {
                    bl = false;
                    this.logError(string, "MCC_XMTOBJ_INVALID_NODETYPE", new Object[]{"Mapping"});
                }
                if (!bl) break;
            }
        }
        _logger.exit(string, bl);
        return bl;
    }

    private boolean validateHandlers() {
        String string = "validateHandlers()";
        _logger.entry(string);
        boolean bl = true;
        Element element = this._xmlDocument.getDocumentElement();
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeName().equals("Handlers")) {
                NodeList nodeList2 = node.getChildNodes();
                int n2 = nodeList2.getLength();
                for (int j = 0; j < n2; ++j) {
                    Node node2 = nodeList2.item(j);
                    if (node2.getNodeType() == 3) {
                        if (this.isNonEmptyTextNode(node2)) {
                            bl = false;
                            this.logError(string, "MCC_XMTOBJ_TEXT_DATA", new Object[]{"Handlers", node2.getNodeValue()});
                        }
                    } else if (node2.getNodeType() == 1) {
                        bl = this.validateIndividualHandler((Element)node2);
                        if (!bl) {
                            this.logError(string, "MCC_XMTOBJ_VALIDATE_HANDLER", new Object[]{node2.getNodeName()});
                        }
                    } else {
                        bl = false;
                        this.logError(string, "MCC_XMTOBJ_INVALID_NODETYPE", new Object[]{"Handlers"});
                    }
                    if (!bl) break;
                }
                if (!bl) break;
            }
            if (!bl) break;
        }
        _logger.exit(string, bl);
        return bl;
    }

    private boolean validateIndividualHandler(Element element) {
        String string = "validateIndividualHandler( Element )";
        _logger.entry(string, element);
        boolean bl = true;
        String string2 = element.getNodeName();
        Node node = null;
        Node node2 = null;
        Node node3 = null;
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node4 = nodeList.item(i);
            if (node4.getNodeType() == 3) {
                if (this.isNonEmptyTextNode(node4)) {
                    bl = false;
                    this.logError(string, "MCC_XMTOBJ_TEXT_DATA", new Object[]{element.getNodeName(), node4.getNodeValue()});
                }
            } else if (node4.getNodeType() == 1) {
                String string3 = node4.getNodeName();
                if (string3.equals("Properties")) {
                    node = node4;
                } else if (string3.equals("Supported")) {
                    node2 = node4;
                } else if (string3.equals("Constructors")) {
                    node3 = node4;
                } else {
                    bl = false;
                    this.logError(string, "MCC_XMTOBJ_INVALID_CHILD2", new Object[]{element.getNodeName(), string3});
                }
            } else {
                bl = false;
                this.logError(string, "MCC_XMTOBJ_INVALID_NODETYPE", new Object[]{element.getNodeName()});
            }
            if (!bl) break;
        }
        if (bl) {
            if (node != null && node2 != null && node3 != null) {
                bl = this.validateSupported(node2);
                if (!bl) {
                    this.logError(string, "MCC_XMTOBJ_INVALID_HANDLER_SECTION", new Object[]{"Supported", string2});
                }
                if (bl && !(bl = this.validateProperties(node))) {
                    this.logError(string, "MCC_XMTOBJ_INVALID_HANDLER_SECTION", new Object[]{"Properties", string2});
                }
                if (bl && !(bl = this.validateConstructors(node3, node))) {
                    this.logError(string, "MCC_XMTOBJ_INVALID_HANDLER_SECTION", new Object[]{"Constructors", string2});
                }
            } else {
                if (node2 == null) {
                    this.logError(string, "MCC_XMTOBJ_MISSING_SECTION", new Object[]{string2, "Supported"});
                }
                if (node == null) {
                    this.logError(string, "MCC_XMTOBJ_MISSING_SECTION", new Object[]{string2, "Properties"});
                }
                if (node3 == null) {
                    this.logError(string, "MCC_XMTOBJ_MISSING_SECTION", new Object[]{string2, "Constructors"});
                }
                bl = false;
            }
        }
        _logger.exit(string, bl);
        return bl;
    }

    private boolean validateProperties(Node node) {
        String string = "validateProperties( Node )";
        _logger.entry(string, node);
        boolean bl = true;
        boolean bl2 = false;
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() == 3) {
                if (this.isNonEmptyTextNode(node2)) {
                    bl = false;
                    this.logError(string, "MCC_XMTOBJ_TEXT_DATA", new Object[]{"Properties", node2.getNodeValue()});
                }
            } else if (node2.getNodeType() == 1) {
                String string2 = node2.getNodeName();
                String string3 = XMLUtils.getNodeText(node2);
                if (string3 != null) {
                    if (string2.equalsIgnoreCase("ClassName") && string3.equalsIgnoreCase("@CLASS_STRING")) {
                        bl2 = true;
                    } else if (!(string3.equals("@STRING") || string3.equals("@INT") || string3.equals("@BOOL"))) {
                        if (string3.startsWith("@ARRAY_")) {
                            int n2 = string3.indexOf("{") + 1;
                            int n3 = string3.indexOf("}");
                            String string4 = string3.substring(n2, n3);
                            String[] stringArray = string4.split(":");
                            for (int j = 0; j < stringArray.length; ++j) {
                                String string5 = stringArray[j].substring(1, stringArray[j].length() - 1);
                                bl = this.doesPropertyExist((Element)node, string5);
                                if (bl) continue;
                                this.logError(string, "MCC_XMTOBJ_INVALID_PROPERTY_REFERENCED", new Object[]{string5, "@ARRAY_"});
                                break;
                            }
                        } else if (string3.startsWith("@SET_")) {
                            String string6 = string3.substring("@SET_".length() + 1, string3.length() - 1);
                            bl = this.doesPropertyExist((Element)node, string6);
                            if (!bl) {
                                this.logError(string, "MCC_XMTOBJ_INVALID_PROPERTY_REFERENCED", new Object[]{string6, "@SET_"});
                            }
                        } else if (string3.startsWith("@") && string3.endsWith("@") && !(bl = this.doesHandlerExist(string3))) {
                            this.logError(string, "MCC_XMTOBJ_HANDLER_MISSING", new Object[]{string3, node2.getNodeName()});
                        }
                    }
                }
            } else {
                bl = false;
                this.logError(string, "MCC_XMTOBJ_INVALID_NODETYPE", new Object[]{"Properties"});
            }
            if (!bl) break;
        }
        if (!bl2) {
            bl = false;
            this.logError(string, "MCC_NO_CLASSNAME_IN_PROPERTIES");
        }
        _logger.exit(string, bl);
        return bl;
    }

    private boolean validateSupported(Node node) {
        String string = "validateSupported( Node )";
        _logger.entry(string, node);
        boolean bl = true;
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() == 3) {
                if (this.isNonEmptyTextNode(node2)) {
                    bl = false;
                    this.logError(string, "MCC_XMTOBJ_TEXT_DATA", new Object[]{"Supported", node2.getNodeValue()});
                }
            } else if (node2.getNodeType() == 1) {
                String string2 = node2.getNodeName();
                if (string2.equals("ClassID")) {
                    String string3 = XMLUtils.getNodeText(node2);
                    bl = this.doesClassExist(string3);
                    if (!bl) {
                        this.logError(string, "MCC_XMTOBJ_CLASS_EXIST", new Object[]{string3, "Supported"});
                    }
                } else {
                    bl = false;
                    this.logError(string, "MCC_XMTOBJ_INVALID_CHILD2", new Object[]{"Supported", string2});
                }
            } else {
                bl = false;
                this.logError(string, "MCC_XMTOBJ_INVALID_NODETYPE", new Object[]{"Supported"});
            }
            if (!bl) break;
        }
        _logger.exit(string, bl);
        return bl;
    }

    private boolean validateConstructors(Node node, Node node2) {
        String string = "validateConstructors( Node, Node )";
        _logger.entry(string, new Object[]{node, node2});
        boolean bl = true;
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node3 = nodeList.item(i);
            if (node3.getNodeType() == 1) {
                String string2 = node3.getNodeName();
                String string3 = XMLUtils.getNodeText(node3);
                bl = this.isValidConstructorString(string2, string3, (Element)node2);
            } else if (node3.getNodeType() == 3) {
                if (this.isNonEmptyTextNode(node3)) {
                    this.logError(string, "MCC_XMTOBJ_TEXT_DATA", new Object[]{"Constructors", node3.getNodeValue()});
                    bl = false;
                }
            } else {
                bl = false;
                this.logError(string, "MCC_XMTOBJ_INVALID_NODETYPE", new Object[]{"Constructors"});
            }
            if (!bl) break;
        }
        return bl;
    }

    private boolean isValidConstructorString(String string, String string2, Element element) {
        String string3 = "isValidConstructorString( String, Element )";
        _logger.entry(string3, new Object[]{string2, element});
        boolean bl = true;
        if (string != null && string2 != null) {
            if (string.equals("Constructor")) {
                String[] stringArray = string2.split(",");
                for (int i = 0; i < stringArray.length; ++i) {
                    String string4 = stringArray[i].trim();
                    bl = this.doesPropertyExist(element, string4 = string4.substring(1, string4.length() - 1));
                    if (bl) {
                        continue;
                    }
                    break;
                }
            } else if (string.equals("StaticMember")) {
                int n = string2.indexOf("@");
                int n2 = string2.lastIndexOf("@");
                if (n > 0 && n2 > 0) {
                    String string5 = string2.substring(n + 1, n2);
                    bl = this.doesPropertyExist(element, string5);
                }
            } else if (string.equals("StaticMethod")) {
                int n = string2.indexOf("(") + 1;
                int n3 = string2.indexOf(")");
                if (n3 != string2.length() - 1) {
                    bl = false;
                } else {
                    String string6 = string2.substring(n, n3);
                    bl = this.isValidConstructorString("Constructor", string6, element);
                }
            }
        }
        _logger.exit(string3, bl);
        return bl;
    }

    private boolean doesClassExist(String string) {
        String string2 = "doesClassExist( String )";
        _logger.entry(string2, string);
        boolean bl = true;
        try {
            Class<?> clazz = Class.forName(string);
            if (clazz == null) {
                bl = false;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = false;
            _logger.debug(string2, "Caught ClassNotFoundException when attempting to find '" + string + "'");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            bl = false;
            _logger.debug(string2, "Caught NoClassDefFoundError when attempting to find '" + string + "'");
        }
        _logger.exit(string2, bl);
        return bl;
    }

    private boolean doesHandlerExist(String string) {
        String string2 = "doesHandlerExist( String )";
        _logger.entry(string2, string);
        boolean bl = false;
        if (string.equals("@STRING") || string.equals("@INT") || string.equals("@BOOL") || string.equals("@DOUBLE") || string.equals("@SHORT") || string.equals("@FLOAT") || string.equals("@LONG") || string.equals("@CLASS_STRING") || string.equals("@OBJECT_STRING") || string.equals("@SET_")) {
            bl = true;
        } else if (this._mccFile.doesHandlerExist(string)) {
            bl = true;
        } else {
            String string3 = string.substring(1, string.length() - 1);
            Element element = this._xmlDocument.getDocumentElement();
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            block0: for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                if (!node.getNodeName().equals("Handlers")) continue;
                NodeList nodeList2 = node.getChildNodes();
                int n2 = nodeList2.getLength();
                for (int j = 0; j < n2; ++j) {
                    String string4 = nodeList2.item(j).getNodeName();
                    if (!string4.equals(string3)) continue;
                    bl = true;
                    continue block0;
                }
            }
        }
        _logger.exit(string2, bl);
        return bl;
    }

    private boolean doesPropertyExist(Element element, String string) {
        String string2 = "doesPropertyExist( Element, String )";
        _logger.entry(string2, new Object[]{element, string});
        boolean bl = false;
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (!node.getNodeName().equals(string)) continue;
            bl = true;
        }
        _logger.exit(string2, bl);
        return bl;
    }

    private boolean isValidURN(String string) {
        String string2 = "isValueURN( String )";
        _logger.entry(string2, string);
        boolean bl = true;
        try {
            URI uRI = new URI(string);
            if (uRI == null) {
                bl = false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl = false;
            _logger.debug(string2, "Caught IllegalArgumentException while validating '" + string + "'");
        }
        catch (URISyntaxException uRISyntaxException) {
            bl = false;
            _logger.debug(string2, "Caught URISyntaxException while validating '" + string + "'");
        }
        _logger.exit(string2, bl);
        return bl;
    }

    private boolean isNonEmptyTextNode(Node node) {
        String string;
        String string2 = "isNonEmptyTextNode( Node )";
        _logger.entry(string2, node);
        boolean bl = false;
        if (node.getNodeType() == 3 && !(string = node.getNodeValue().trim()).equals("")) {
            bl = true;
        }
        _logger.exit(string2, bl);
        return bl;
    }

    public String getErrorString() {
        return this._errorMessage;
    }

    private void logError(String string, String string2) {
        this.logError(string, string2, null);
    }

    private void logError(String string, String string2, Object[] objectArray) {
        String string3 = null;
        string3 = objectArray != null ? CWRGSMessageHelper.getMessage(string2, objectArray) : CWRGSMessageHelper.getMessage(string2);
        this._errorMessage = this._errorMessage + "\n" + string3;
        _logger.error(string, string3);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

