/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.iauthz.mcc.xml;

import com.ibm.sec.iauthz.log.SecLogger;
import com.ibm.sec.iauthz.mcc.dna.XMTObject;
import com.ibm.sec.iauthz.mcc.engine.IXMLDataValueHandler;
import com.ibm.sec.iauthz.mcc.engine.MCCXMLHandler;
import com.ibm.sec.iauthz.mcc.xml.StorageExtractHelper;
import com.ibm.sec.iauthz.storage.PolicyMgmt;
import com.ibm.sec.iauthz.storage.PolicyStorageFactory;
import com.ibm.sec.iauthz.storage.PolicyStoreException;
import com.ibm.sec.iauthz.util.CWRGSMessageHelper;
import com.ibm.sec.iauthz.util.CollectionFactory;
import com.ibm.sec.iauthz.util.CommonAuthProperties;
import com.ibm.sec.iauthz.util.MCCException;
import com.ibm.sec.iauthz.util.StorageBuffer;
import com.ibm.sec.iauthz.util.XMLException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class ExportXMLReader
implements XMLReader {
    private Map _featureMap = CollectionFactory.newMap();
    private Map _propertyMap = CollectionFactory.newMap();
    private EntityResolver _entityResolver;
    private DTDHandler _dtdHandler;
    private ContentHandler _contentHandler;
    private ErrorHandler _errorHandler;
    private StorageExtractHelper _extractor;
    private boolean _isPolicy;
    private String _contextID;
    private IXMLDataValueHandler _dataValueHandler;
    private static SecLogger _logger = SecLogger.getLogger(class$com$ibm$sec$iauthz$mcc$xml$ExportXMLReader == null ? (class$com$ibm$sec$iauthz$mcc$xml$ExportXMLReader = ExportXMLReader.class$("com.ibm.sec.iauthz.mcc.xml.ExportXMLReader")) : class$com$ibm$sec$iauthz$mcc$xml$ExportXMLReader);
    private static final String DEFAULT_COMBINING_ALGORITHM = "block-overrides";
    static /* synthetic */ Class class$com$ibm$sec$iauthz$mcc$xml$ExportXMLReader;

    public ExportXMLReader(StorageBuffer storageBuffer, boolean bl, String string) throws MCCException {
        String string2 = "ExportXMLReader( StorageBuffer, boolean, String )";
        _logger.entry(string2, new Object[]{storageBuffer, bl, string});
        this._extractor = new StorageExtractHelper(storageBuffer);
        this._dataValueHandler = new MCCXMLHandler();
        this._isPolicy = bl;
        this._contextID = string;
        _logger.exit(string2);
    }

    public void parse(InputSource inputSource) throws IOException, SAXException {
        String string = "parse( InputSource )";
        _logger.entry(string);
        if (this._contentHandler != null) {
            String string2 = "urn:com:ibm:sec:authz:policy-internal";
            this._contentHandler.startDocument();
            AttributesImpl attributesImpl = new AttributesImpl();
            attributesImpl.addAttribute(null, "context-id", "context-id", "CDATA", this._contextID);
            this._contentHandler.startElement(string2, "Policy", "Policy", attributesImpl);
            if (this._isPolicy) {
                this.writePolicySection(string2);
            } else if (!this._isPolicy) {
                this.writePrincipalToRoleMappingSection(string2);
            }
            this._contentHandler.endElement(string2, "Policy", "Policy");
            this._contentHandler.endDocument();
        } else {
            String string3 = CWRGSMessageHelper.getMessage("NO_CONTENT_HANDLER_SPECIFIED", new Object[]{this._contextID});
            _logger.error(string, string3);
        }
        _logger.exit(string);
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        Boolean bl = (Boolean)this._featureMap.get(string);
        if (bl == null) {
            return false;
        }
        return bl;
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        this._featureMap.put(string, new Boolean(bl));
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this._propertyMap.get(string);
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        this._propertyMap.put(string, object);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this._entityResolver = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return this._entityResolver;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this._dtdHandler = dTDHandler;
    }

    public DTDHandler getDTDHandler() {
        return this._dtdHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        String string = "setContentHandler( ContentHandler )";
        _logger.entry(string, contentHandler);
        this._contentHandler = contentHandler;
        _logger.exit(string);
    }

    public ContentHandler getContentHandler() {
        return this._contentHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this._errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this._errorHandler;
    }

    public void parse(String string) throws IOException, SAXException {
        this.parse(new InputSource(string));
    }

    private void writePermissionSet(String string, Iterator iterator) throws SAXException {
        String string2 = "writePermissionSet( String, Iterator )";
        _logger.entry(string2, new Object[]{string, iterator});
        this._contentHandler.startElement(string, "PermissionSet", "PermissionSet", new AttributesImpl());
        try {
            while (iterator.hasNext()) {
                XMTObject xMTObject = (XMTObject)iterator.next();
                Element element = this._dataValueHandler.constructXMLFromObject(xMTObject);
                if (element == null) continue;
                this.convertDOMtoSAX(string, element);
            }
        }
        catch (XMLException xMLException) {
            String string3 = CWRGSMessageHelper.getMessage("ERROR_CONVERTING_XMTOBJECT_TO_XML", new Object[]{xMLException.getMessage()});
            _logger.error(string2, string3, xMLException);
            throw new SAXException(string3, xMLException);
        }
        this._contentHandler.endElement(string, "PermissionSet", "PermissionSet");
        _logger.exit(string2);
    }

    private void writePolicySection(String string) throws SAXException {
        Object object;
        Object object2;
        Object object3;
        String string2 = "writePolicySection( String )";
        _logger.entry(string2, string);
        AttributesImpl attributesImpl = new AttributesImpl();
        this._contentHandler.startElement(string, "PermissionConfig", "PermissionConfig", new AttributesImpl());
        if (this._extractor.hasExcludedPolicy()) {
            this._contentHandler.startElement(string, "ExcludedPermissions", "ExcludedPermissions", new AttributesImpl());
            this.writePermissionSet(string, this._extractor.getExcludedPolicy());
            this._contentHandler.endElement(string, "ExcludedPermissions", "ExcludedPermissions");
        }
        if (this._extractor.hasUncheckedPolicy()) {
            this._contentHandler.startElement(string, "UncheckedPermissions", "UncheckedPermissions", new AttributesImpl());
            this.writePermissionSet(string, this._extractor.getUncheckedPolicy());
            this._contentHandler.endElement(string, "UncheckedPermissions", "UncheckedPermissions");
        }
        if (this._extractor.hasRoleBasedPolicy()) {
            this._contentHandler.startElement(string, "RoleBasedPermissions", "RoleBasedPermissions", new AttributesImpl());
            object3 = this._extractor.getRoleNames();
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                attributesImpl.clear();
                attributesImpl.addAttribute(null, "role", "role", "CDATA", (String)object);
                this._contentHandler.startElement(string, "Role", "Role", attributesImpl);
                this.writePermissionSet(string, this._extractor.getRoleBasedPolicy((String)object));
                this._contentHandler.endElement(string, "Role", "Role");
            }
            this._contentHandler.endElement(string, "RoleBasedPermissions", "RoleBasedPermissions");
        }
        this._contentHandler.endElement(string, "PermissionConfig", "PermissionConfig");
        object3 = null;
        try {
            object3 = PolicyStorageFactory.getPolicyMgmt(CommonAuthProperties.getProps());
        }
        catch (PolicyStoreException policyStoreException) {
            object = CWRGSMessageHelper.getMessage("ERROR_GETTING_POLICYMGMT_INSTANCE", new Object[]{policyStoreException.getMessage()});
            _logger.error(string2, (String)object, policyStoreException);
            throw new SAXException((String)object, policyStoreException);
        }
        object2 = null;
        try {
            object2 = ((PolicyMgmt)object3).getLinkedContexts(this._contextID);
        }
        catch (PolicyStoreException policyStoreException) {
            String string3 = CWRGSMessageHelper.getMessage("ERROR_RETRIEVING_LINKED_CONTEXTS", new Object[]{this._contextID, policyStoreException.getMessage()});
            _logger.error(string2, string3, policyStoreException);
            throw new SAXException(string3, policyStoreException);
        }
        if (object2 != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                String string4 = (String)object.next();
                if (string4.equals(this._contextID)) continue;
                this._contentHandler.startElement(string, "LinkedPolicyContext", "LinkedPolicyContext", new AttributesImpl());
                this._contentHandler.characters(string4.toCharArray(), 0, string4.length());
                this._contentHandler.endElement(string, "LinkedPolicyContext", "LinkedPolicyContext");
            }
        }
        _logger.exit(string2);
    }

    private void writePrincipalToRoleMappingSection(String string) throws SAXException {
        String string2 = "writePrincipalToRoleMappingSection( String )";
        _logger.entry(string2, string);
        try {
            AttributesImpl attributesImpl = new AttributesImpl();
            String string3 = this._extractor.getRoleCombiningAlgorithm();
            if (string3 == null) {
                string3 = DEFAULT_COMBINING_ALGORITHM;
            }
            attributesImpl.addAttribute(null, "CombiningAlgorithm", "CombiningAlgorithm", "CDATA", string3);
            this._contentHandler.startElement(string, "RoleMappingConfig", "RoleMappingConfig", attributesImpl);
            attributesImpl = new AttributesImpl();
            Set set = this._extractor.getPrincipals();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                attributesImpl.clear();
                this._contentHandler.startElement(string, "RoleMapping", "RoleMapping", attributesImpl);
                this._contentHandler.startElement(string, "Principal", "Principal", attributesImpl);
                Element element = this._dataValueHandler.constructXMLFromObject(e2);
                this.convertDOMtoSAX(string, element);
                this._contentHandler.endElement(string, "Principal", "Principal");
                this._contentHandler.startElement(string, "RoleConditionSet", "RoleConditionSet", attributesImpl);
                Iterator iterator2 = this._extractor.getRoleConditions((XMTObject)e2);
                while (iterator2.hasNext()) {
                    Object e3 = iterator2.next();
                    Element element2 = this._dataValueHandler.constructXMLFromObject(e3);
                    this.convertDOMtoSAX(string, element2);
                }
                this._contentHandler.endElement(string, "RoleConditionSet", "RoleConditionSet");
                this._contentHandler.endElement(string, "RoleMapping", "RoleMapping");
            }
            this._contentHandler.endElement(string, "RoleMappingConfig", "RoleMappingConfig");
        }
        catch (XMLException xMLException) {
            String string4 = CWRGSMessageHelper.getMessage("ERROR_WRITING_ROLE_MAPPING_DATA", new Object[]{xMLException.getMessage()});
            _logger.error(string2, string4, xMLException);
            throw new SAXException(string4, xMLException);
        }
        _logger.exit(string2);
    }

    private void convertDOMtoSAX(String string, Node node) throws SAXException {
        String string2 = "convertDOMtoSAX( String, Node )";
        _logger.entry(string2, new Object[]{string, node});
        if (string != null && node != null) {
            if (node.getNodeType() == 3) {
                String string3 = node.getNodeValue();
                if (string3 != null) {
                    this._contentHandler.characters(string3.toCharArray(), 0, string3.length());
                }
            } else {
                AttributesImpl attributesImpl = new AttributesImpl();
                NamedNodeMap namedNodeMap = node.getAttributes();
                int n = namedNodeMap.getLength();
                for (int i = 0; i < n; ++i) {
                    Node node2 = namedNodeMap.item(i);
                    attributesImpl.addAttribute(null, node2.getNodeName(), node2.getNodeName(), "CDATA", node2.getNodeValue());
                }
                this._contentHandler.startElement(string, node.getNodeName(), node.getNodeName(), attributesImpl);
                NodeList nodeList = node.getChildNodes();
                int n2 = nodeList.getLength();
                for (int i = 0; i < n2; ++i) {
                    this.convertDOMtoSAX(string, nodeList.item(i));
                }
                this._contentHandler.endElement(string, node.getNodeName(), node.getNodeName());
            }
        } else {
            _logger.debug(string2, "Null input to function, no action taken.");
        }
        _logger.exit(string2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

