/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.iauthz.mcc.xml;

import com.ibm.sec.iauthz.log.SecLogger;
import com.ibm.sec.iauthz.mcc.dna.XMTObject;
import com.ibm.sec.iauthz.mcc.engine.IXMLDataValueHandler;
import com.ibm.sec.iauthz.mcc.engine.MCCFile;
import com.ibm.sec.iauthz.mcc.engine.MCCXMLHandler;
import com.ibm.sec.iauthz.storage.PolicyMgmt;
import com.ibm.sec.iauthz.storage.PolicyStorageFactory;
import com.ibm.sec.iauthz.storage.PolicyStoreException;
import com.ibm.sec.iauthz.util.CWRGSMessageHelper;
import com.ibm.sec.iauthz.util.CommonAuthProperties;
import com.ibm.sec.iauthz.util.MCCException;
import com.ibm.sec.iauthz.util.StorageBuffer;
import com.ibm.sec.iauthz.util.XMLException;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ImportContentHandler
extends DefaultHandler {
    private static final String GENERIC_TRANSFORM_KEY = "Key";
    private static final String GENERIC_TRANSFORM_VALUE = "Value";
    private short _parseMode = 0;
    private static final short MODE_UNKNOWN = 0;
    private static final short MODE_POLICY = 1;
    private static final short MODE_ROLEMAPPING = 2;
    private static final short MODE_LINKED_POLICY = 3;
    private short _policyType = 0;
    private static final short POLICY_UNKNOWN = 0;
    private static final short POLICY_EXCLUDED = 1;
    private static final short POLICY_UNCHECKED = 2;
    private static final short POLICY_ROLE_BASED = 3;
    private short _roleMappingPart = 0;
    private static final short RM_UNKNOWN = 0;
    private static final short RM_PRINCIPAL = 1;
    private static final short RM_CONDITION = 2;
    private String _roleName = null;
    private Object _principal = null;
    private Stack _nodeStack;
    private boolean _buildingDOMTree = false;
    private Document _documentFactory;
    private Element _currentElement;
    private StorageBuffer _storageBuffer = null;
    private boolean _isPolicy;
    private String _expectedContext;
    private IXMLDataValueHandler _dataValueHandler;
    private boolean _success = true;
    private String _errorString;
    private static SecLogger _logger = SecLogger.getLogger(class$com$ibm$sec$iauthz$mcc$xml$ImportContentHandler == null ? (class$com$ibm$sec$iauthz$mcc$xml$ImportContentHandler = ImportContentHandler.class$("com.ibm.sec.iauthz.mcc.xml.ImportContentHandler")) : class$com$ibm$sec$iauthz$mcc$xml$ImportContentHandler);
    static /* synthetic */ Class class$com$ibm$sec$iauthz$mcc$xml$ImportContentHandler;
    static /* synthetic */ Class class$com$ibm$sec$iauthz$mcc$dna$GenericTransform;
    static /* synthetic */ Class class$com$ibm$sec$iauthz$mcc$dna$PolicyConfigObject;
    static /* synthetic */ Class class$com$ibm$sec$iauthz$mcc$dna$RoleConfigObject;
    static /* synthetic */ Class class$com$ibm$sec$iauthz$mcc$dna$CombiningAlgorithm;

    public ImportContentHandler(StorageBuffer storageBuffer, boolean bl, String string) throws MCCException {
        String string2 = "ImportContentHandler( StoreBuffer, boolean, String )";
        _logger.entry(string2, new Object[]{storageBuffer, bl, string});
        this._expectedContext = string;
        this._isPolicy = bl;
        this._storageBuffer = storageBuffer;
        this._nodeStack = new Stack();
        this._dataValueHandler = new MCCXMLHandler();
        _logger.exit(string2);
    }

    public void startDocument() {
        String string = "startDocument";
        _logger.entry(string);
        this._nodeStack.clear();
        this._buildingDOMTree = false;
        this._parseMode = 0;
        this._policyType = 0;
        _logger.exit(string);
    }

    public void endDocument() {
        String string = "endDocument";
        _logger.entry(string);
        this._storageBuffer.commit();
        _logger.exit(string);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes2) throws SAXException {
        String string4 = "startElement( String, String, String, Attributes )";
        _logger.entry(string4, new Object[]{string, string2, string3, attributes2});
        if (this._success) {
            if (this._buildingDOMTree) {
                this.startElementDOM(string, string2, string3, attributes2);
            } else if (this._nodeStack.size() == 0) {
                if (string2.equalsIgnoreCase("Policy")) {
                    String string5 = attributes2.getValue("context-id");
                    if (string5 == null || !this._expectedContext.equalsIgnoreCase(string5) && this._isPolicy) {
                        this._success = false;
                        this._errorString = CWRGSMessageHelper.getMessage("XML_FILE_CONTEXTID_MISMATCH", new Object[]{string5, this._expectedContext});
                        _logger.error(string4, this._errorString);
                    }
                } else {
                    this._success = false;
                    this._errorString = CWRGSMessageHelper.getMessage("XML_INCORRECT_ROOT_NODE");
                    _logger.error(string4, this._errorString);
                }
            } else if (string2.equalsIgnoreCase("PermissionConfig")) {
                this._parseMode = 1;
                if (!this._isPolicy) {
                    this._success = false;
                    this._errorString = CWRGSMessageHelper.getMessage("XML_EXPECTED_ROLE_MAPPING_ERROR");
                    _logger.error(string4, this._errorString);
                }
            } else if (string2.equalsIgnoreCase("RoleMappingConfig")) {
                this._parseMode = (short)2;
                String string6 = attributes2.getValue("CombiningAlgorithm");
                this.storeRoleCombiningAlgorithm(string6);
                if (this._isPolicy) {
                    this._success = false;
                    this._errorString = CWRGSMessageHelper.getMessage("XML_EXPECTED_PERMISSIONS_ERROR");
                    _logger.error(string4, this._errorString);
                }
            } else if (string2.equalsIgnoreCase("ExcludedPermissions")) {
                if (this._parseMode == 1) {
                    this._policyType = 1;
                }
            } else if (string2.equalsIgnoreCase("UncheckedPermissions")) {
                if (this._parseMode == 1) {
                    this._policyType = (short)2;
                }
            } else if (string2.equalsIgnoreCase("RoleBasedPermissions")) {
                if (this._parseMode == 1) {
                    this._policyType = (short)3;
                }
            } else if (string2.equalsIgnoreCase("Role")) {
                if (this._parseMode == 1 && this._policyType == 3) {
                    String string7 = attributes2.getValue("role");
                    if (string7 != null) {
                        this._roleName = string7;
                    } else {
                        this._success = false;
                        this._errorString = CWRGSMessageHelper.getMessage("XML_NO_ROLE_NAME_SPECIFIED");
                        _logger.error(string4, this._errorString);
                    }
                }
            } else if (string2.equalsIgnoreCase("Principal")) {
                if (this._parseMode == 2) {
                    this._principal = null;
                    this._roleMappingPart = 1;
                }
            } else if (string2.equalsIgnoreCase("RoleConditionSet")) {
                if (this._parseMode == 2) {
                    this._roleMappingPart = (short)2;
                }
            } else if (string2.equalsIgnoreCase("LinkedPolicyContext")) {
                this._parseMode = (short)3;
            } else if (string2.equalsIgnoreCase("DataValue")) {
                _logger.debug(string4, "<DataValue> found, extracting into DOM tree.");
                this._buildingDOMTree = true;
                try {
                    if (this._documentFactory == null) {
                        this._documentFactory = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                    }
                    this.startElementDOM(string, string2, string3, attributes2);
                }
                catch (Exception exception) {
                    this._success = false;
                    this._errorString = CWRGSMessageHelper.getMessage("XML_NO_CREATE_DOCUMENT", new Object[]{exception.getMessage()});
                    _logger.error(string4, this._errorString);
                }
            }
            this._nodeStack.push(string2);
        }
        _logger.exit(string4);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        String string4 = "endElement( String, String, String )";
        _logger.entry(string4, new Object[]{string, string2, string3});
        if (this._success) {
            this._nodeStack.pop();
            if (this._buildingDOMTree) {
                this.endElementDOM(string, string2, string3);
            } else if (string2.equalsIgnoreCase("ExcludedPermissions") || string2.equalsIgnoreCase("UncheckedPermissions") || string2.equalsIgnoreCase("RoleBasedPermissions")) {
                this._policyType = 0;
            } else if (string2.equalsIgnoreCase("Role")) {
                this._roleName = null;
            } else if (string2.equalsIgnoreCase("RoleMapping")) {
                this._principal = null;
                this._roleMappingPart = 0;
            }
        }
        _logger.exit(string4);
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = "characters( char[], int, int )";
        _logger.entry(string, new Object[]{cArray, new Integer(n), new Integer(n2)});
        if (this._success) {
            String string2 = new String(cArray, n, n2);
            if (this._buildingDOMTree && this._currentElement != null) {
                _logger.debug(string, "Appending text '" + string2 + "' as text node of current DOM element.");
                this._currentElement.appendChild(this._documentFactory.createTextNode(string2));
            } else if (this._parseMode == 3) {
                try {
                    PolicyMgmt policyMgmt = PolicyStorageFactory.getPolicyMgmt(CommonAuthProperties.getProps());
                    policyMgmt.linkConfigurations(this._expectedContext, string2);
                }
                catch (PolicyStoreException policyStoreException) {
                    this._success = false;
                    this._errorString = CWRGSMessageHelper.getMessage("XML_ERROR_LINKING_CONTEXTS", new Object[]{this._expectedContext, string2, policyStoreException.getMessage()});
                    _logger.error(string, this._errorString, policyStoreException);
                }
            }
        }
        _logger.exit(string);
    }

    private void startElementDOM(String string, String string2, String string3, Attributes attributes2) throws SAXException {
        String string4 = "startElementDOM( String, String, String, Attribute )";
        _logger.entry(string4, new Object[]{string, string2, string3, attributes2});
        Element element = "".equals(string) ? this._documentFactory.createElement(string3) : this._documentFactory.createElementNS(string, string3);
        for (int i = 0; i < attributes2.getLength(); ++i) {
            element.setAttribute(attributes2.getQName(i), attributes2.getValue(i));
        }
        if (this._currentElement != null) {
            this._currentElement.appendChild(element);
        }
        this._currentElement = element;
        _logger.exit(string4);
    }

    private void endElementDOM(String string, String string2, String string3) throws SAXException {
        String string4 = "endElementDOM( String, String, String )";
        _logger.entry(string4, new Object[]{string, string2, string3});
        if (this._currentElement != null) {
            Node node = this._currentElement.getParentNode();
            if (node == null) {
                _logger.debug(string4, "End of <DataValue> tree, DOM tree is complete.");
                this._currentElement.normalize();
                this._buildingDOMTree = false;
                this.performStorageAction(this._currentElement);
                this._currentElement = null;
            } else {
                this._currentElement = (Element)this._currentElement.getParentNode();
            }
        }
        _logger.exit(string4);
    }

    private boolean performStorageAction(Element element) throws SAXException {
        String string = "performStorageAction( Element )";
        _logger.entry(string, element);
        boolean bl = false;
        Object object = null;
        try {
            object = this._dataValueHandler.constructObjectFromXML(this._currentElement);
        }
        catch (XMLException xMLException) {
            this._success = false;
        }
        if (object != null) {
            if (this._parseMode == 1) {
                _logger.debug(string, "<DataValue> specifies policy data, storing Permission.");
                try {
                    switch (this._policyType) {
                        case 1: {
                            this.storePermission("_EXCLUDED_", (XMTObject)object);
                            break;
                        }
                        case 2: {
                            this.storePermission("_UNCHECKED_", (XMTObject)object);
                            break;
                        }
                        case 3: {
                            this.storePermission(this._roleName, (XMTObject)object);
                            break;
                        }
                    }
                }
                catch (MCCException mCCException) {
                    this._success = false;
                    this._errorString = CWRGSMessageHelper.getMessage("XML_ERROR_STORING_PERMISSION", new Object[]{mCCException.getMessage()});
                    _logger.error(string, this._errorString, mCCException);
                }
            } else if (this._parseMode == 2) {
                _logger.debug(string, "<DataValue> specifies part of principal-to-role mapping...");
                switch (this._roleMappingPart) {
                    case 1: {
                        _logger.debug(string, "<DataValue> is Principal, storing for later action.");
                        this._principal = object;
                        break;
                    }
                    case 2: {
                        _logger.debug(string, "<DataValue> is RoleCondition, calling storage.");
                        try {
                            this.storeRoleCondition((XMTObject)this._principal, (XMTObject)object);
                        }
                        catch (MCCException mCCException) {
                            this._success = false;
                            this._errorString = CWRGSMessageHelper.getMessage("XML_ERROR_STORING_ROLE_CONDITION", new Object[]{mCCException.getMessage()});
                            _logger.error(string, this._errorString, mCCException);
                        }
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
        } else {
            this._success = false;
            this._errorString = CWRGSMessageHelper.getMessage("XML_ERROR_NULL_CONVERTED_OBJECT");
            _logger.debug(string, this._errorString);
        }
        _logger.exit(string, bl);
        return bl;
    }

    private void storePermission(String string, XMTObject xMTObject) throws MCCException {
        String string2 = "storePermission( String, XMTObject )";
        _logger.entry(string2, new Object[]{string, xMTObject});
        MCCFile mCCFile = MCCFile.getInstance();
        String string3 = mCCFile.getMapping("DefaultType", (class$com$ibm$sec$iauthz$mcc$dna$GenericTransform == null ? (class$com$ibm$sec$iauthz$mcc$dna$GenericTransform = ImportContentHandler.class$("com.ibm.sec.iauthz.mcc.dna.GenericTransform")) : class$com$ibm$sec$iauthz$mcc$dna$GenericTransform).getName(), "Type");
        if (string3 != null) {
            XMTObject xMTObject2 = new XMTObject(string3);
            xMTObject2.addElement("ClassName", (class$com$ibm$sec$iauthz$mcc$dna$PolicyConfigObject == null ? (class$com$ibm$sec$iauthz$mcc$dna$PolicyConfigObject = ImportContentHandler.class$("com.ibm.sec.iauthz.mcc.dna.PolicyConfigObject")) : class$com$ibm$sec$iauthz$mcc$dna$PolicyConfigObject).getName());
            xMTObject2.addElement(GENERIC_TRANSFORM_KEY, string);
            xMTObject2.addElement(GENERIC_TRANSFORM_VALUE, xMTObject);
            this._storageBuffer.updatePolicy(xMTObject2);
        }
        _logger.exit(string2);
    }

    private void storeRoleCondition(XMTObject xMTObject, XMTObject xMTObject2) throws MCCException {
        String string = "storeRoleCondition( XMTObject, XMTObject )";
        _logger.entry(string, new Object[]{xMTObject, xMTObject2});
        MCCFile mCCFile = MCCFile.getInstance();
        String string2 = mCCFile.getMapping("DefaultType", (class$com$ibm$sec$iauthz$mcc$dna$GenericTransform == null ? (class$com$ibm$sec$iauthz$mcc$dna$GenericTransform = ImportContentHandler.class$("com.ibm.sec.iauthz.mcc.dna.GenericTransform")) : class$com$ibm$sec$iauthz$mcc$dna$GenericTransform).getName(), "Type");
        if (string2 != null) {
            XMTObject xMTObject3 = new XMTObject(string2);
            xMTObject3.addElement("ClassName", (class$com$ibm$sec$iauthz$mcc$dna$RoleConfigObject == null ? (class$com$ibm$sec$iauthz$mcc$dna$RoleConfigObject = ImportContentHandler.class$("com.ibm.sec.iauthz.mcc.dna.RoleConfigObject")) : class$com$ibm$sec$iauthz$mcc$dna$RoleConfigObject).getName());
            xMTObject3.addElement(GENERIC_TRANSFORM_KEY, xMTObject);
            xMTObject3.addElement(GENERIC_TRANSFORM_VALUE, xMTObject2);
            this._storageBuffer.updatePolicy(xMTObject3);
        }
        _logger.exit(string);
    }

    private void storeRoleCombiningAlgorithm(String string) {
        String string2 = "storeRoleCombiningAlgorithm( String )";
        _logger.entry(string2, string);
        if (string != null) {
            MCCFile mCCFile = MCCFile.getInstance();
            String string3 = null;
            try {
                string3 = mCCFile.getTypeMapping(class$com$ibm$sec$iauthz$mcc$dna$CombiningAlgorithm == null ? (class$com$ibm$sec$iauthz$mcc$dna$CombiningAlgorithm = ImportContentHandler.class$("com.ibm.sec.iauthz.mcc.dna.CombiningAlgorithm")) : class$com$ibm$sec$iauthz$mcc$dna$CombiningAlgorithm);
            }
            catch (MCCException mCCException) {
                this._success = false;
                this._errorString = CWRGSMessageHelper.getMessage("XML_ERROR_STORING_COMBINING_ALGORITHM");
                _logger.error(string2, this._errorString, mCCException);
            }
            if (string3 != null) {
                XMTObject xMTObject = new XMTObject(string3);
                xMTObject.addElement("ClassName", (class$com$ibm$sec$iauthz$mcc$dna$CombiningAlgorithm == null ? (class$com$ibm$sec$iauthz$mcc$dna$CombiningAlgorithm = ImportContentHandler.class$("com.ibm.sec.iauthz.mcc.dna.CombiningAlgorithm")) : class$com$ibm$sec$iauthz$mcc$dna$CombiningAlgorithm).getName());
                xMTObject.addElement("Algorithm", string);
                this._storageBuffer.updatePolicy(xMTObject);
            }
        } else {
            _logger.debug(string2, "Passed combining algorithm is null, no action taken.");
        }
        _logger.exit(string2);
    }

    public boolean getSuccess() {
        return this._success;
    }

    public String getErrorMessage() {
        if (this._success) {
            return "";
        }
        return this._errorString;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

