/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.iauthz.mcc.xml;

import com.ibm.sec.iauthz.log.SecLogger;
import com.ibm.sec.iauthz.mcc.DataProcessingConstants;
import com.ibm.sec.iauthz.mcc.DataProcessingException;
import com.ibm.sec.iauthz.mcc.MCCUtil;
import com.ibm.sec.iauthz.mcc.dna.CombiningAlgorithm;
import com.ibm.sec.iauthz.mcc.dna.XMTObject;
import com.ibm.sec.iauthz.storage.PagedResultSet;
import com.ibm.sec.iauthz.storage.SimpleQueryExpr;
import com.ibm.sec.iauthz.storage.StoreRecordQuery;
import com.ibm.sec.iauthz.util.CWRGSMessageHelper;
import com.ibm.sec.iauthz.util.CollectionFactory;
import com.ibm.sec.iauthz.util.StorageBuffer;
import java.util.Iterator;
import java.util.Set;

public class StorageExtractHelper {
    private static final String GENERIC_TRANSFORM_KEY = "Key";
    private static final String GENERIC_TRANSFORM_VALUE = "Value";
    private static final String PRINCIPAL_NAME = "Name";
    private static final String COMBINING_ALGORITHM_KEY = "Algorithm";
    private static final String STORE_RECORD_POLICY = DataProcessingConstants.PCO_XMT_TYPE;
    private static final String STORE_RECORD_ROLE_MAPPING = DataProcessingConstants.RCO_XMT_TYPE;
    private static SecLogger _logger = SecLogger.getLogger(class$com$ibm$sec$iauthz$mcc$xml$StorageExtractHelper == null ? (class$com$ibm$sec$iauthz$mcc$xml$StorageExtractHelper = StorageExtractHelper.class$("com.ibm.sec.iauthz.mcc.xml.StorageExtractHelper")) : class$com$ibm$sec$iauthz$mcc$xml$StorageExtractHelper);
    private StorageBuffer _storage;
    private Set _allRoles = CollectionFactory.newSet();
    private Set _allPrincipals = CollectionFactory.newSet();
    boolean _retrievedPrincipals = false;
    boolean _retrievedRoles = false;
    static /* synthetic */ Class class$com$ibm$sec$iauthz$mcc$xml$StorageExtractHelper;
    static /* synthetic */ Class class$com$ibm$sec$iauthz$mcc$dna$PolicyConfigObject;
    static /* synthetic */ Class class$com$ibm$sec$iauthz$mcc$dna$RoleConfigObject;
    static /* synthetic */ Class class$com$ibm$sec$iauthz$mcc$dna$CombiningAlgorithm;

    public StorageExtractHelper(StorageBuffer storageBuffer) {
        String string = "StorageExtractHelper( StorageBuffer)";
        _logger.entry(string, storageBuffer);
        this._storage = storageBuffer;
        _logger.exit(string);
    }

    public boolean hasExcludedPolicy() {
        String string = "hasExcludedPolicy()";
        _logger.entry(string);
        this.retrieveRoleNames();
        boolean bl = false;
        Iterator iterator = this._allRoles.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (string2 == null || !string2.equalsIgnoreCase("_EXCLUDED_")) continue;
            _logger.debug(string, "At least one permission has been found for the 'excluded' role.");
            bl = true;
            break;
        }
        _logger.exit(string, bl);
        return bl;
    }

    public boolean hasUncheckedPolicy() {
        String string = "hasUncheckedPolicy()";
        _logger.entry(string);
        this.retrieveRoleNames();
        boolean bl = false;
        Iterator iterator = this._allRoles.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (string2 == null || !string2.equalsIgnoreCase("_UNCHECKED_")) continue;
            _logger.debug(string, "At least one permission has been found for the 'unchecked' role.");
            bl = true;
            break;
        }
        _logger.exit(string, bl);
        return bl;
    }

    public boolean hasRoleBasedPolicy() {
        String string = "hasRoleBasedPolicy()";
        _logger.entry(string);
        this.retrieveRoleNames();
        boolean bl = false;
        Iterator iterator = this._allRoles.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (string2 == null || string2.equalsIgnoreCase("_EXCLUDED_") || string2.equalsIgnoreCase("_UNCHECKED_")) continue;
            _logger.debug(string, "At least one permission has been found that is not for 'excluded' or 'unchecked'.");
            bl = true;
            break;
        }
        _logger.exit(string, bl);
        return bl;
    }

    public Iterator getExcludedPolicy() {
        String string = "getExcludedPolicy()";
        _logger.entry(string);
        Iterator iterator = this.getRoleBasedPolicy("_EXCLUDED_");
        _logger.exit(string, iterator);
        return iterator;
    }

    public Iterator getUncheckedPolicy() {
        String string = "getUncheckedPolicy()";
        _logger.entry(string);
        Iterator iterator = this.getRoleBasedPolicy("_UNCHECKED_");
        _logger.exit(string, iterator);
        return iterator;
    }

    public Set getRoleNames() {
        String string = "getRoleNames()";
        _logger.entry(string);
        Set set = CollectionFactory.newSet();
        this.retrieveRoleNames();
        if (this._allRoles != null) {
            Iterator iterator = this._allRoles.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (string2.equalsIgnoreCase("_EXCLUDED_") || string2.equalsIgnoreCase("_UNCHECKED_") || set.contains(string2)) continue;
                _logger.debug(string, "Found role '" + string2 + "' in policy.");
                set.add(string2);
            }
        }
        _logger.exit(string, set);
        return set;
    }

    public Iterator getRoleBasedPolicy(String string) {
        Object object;
        String string2 = "getRoleBasedPolicy( String )";
        _logger.entry(string2, string);
        Set set = CollectionFactory.newSet();
        StoreRecordQuery storeRecordQuery = new StoreRecordQuery(STORE_RECORD_POLICY);
        storeRecordQuery.setClassname((class$com$ibm$sec$iauthz$mcc$dna$PolicyConfigObject == null ? (class$com$ibm$sec$iauthz$mcc$dna$PolicyConfigObject = StorageExtractHelper.class$("com.ibm.sec.iauthz.mcc.dna.PolicyConfigObject")) : class$com$ibm$sec$iauthz$mcc$dna$PolicyConfigObject).getName());
        storeRecordQuery.setAttrName(GENERIC_TRANSFORM_KEY);
        storeRecordQuery.setAttrValue(string);
        storeRecordQuery.setSearchDepth(1);
        PagedResultSet pagedResultSet = this._storage.getPolicy(storeRecordQuery);
        while (pagedResultSet.hasNext()) {
            object = null;
            try {
                object = (XMTObject)pagedResultSet.next();
            }
            catch (Exception exception) {
                String string3 = CWRGSMessageHelper.getMessage("ERROR_EXTRACTING_POLICY", new Object[]{string, exception.getMessage()});
                _logger.error(string2, string3, exception);
            }
            set.add(((XMTObject)object).getElement(GENERIC_TRANSFORM_VALUE));
        }
        object = set.iterator();
        _logger.exit(string2, object);
        return object;
    }

    public boolean hasRoleMappings() {
        String string = "hasRoleMappings()";
        _logger.entry(string);
        boolean bl = false;
        this.retrievePrincipals();
        bl = !this._allPrincipals.isEmpty();
        _logger.exit(string, bl);
        return bl;
    }

    public Set getPrincipals() {
        String string = "getPrincipals()";
        _logger.entry(string);
        this.retrievePrincipals();
        Set set = this._allPrincipals;
        _logger.exit(string, set);
        return set;
    }

    public Iterator getRoleConditions(XMTObject xMTObject) {
        Object object;
        String string = "getRoleConditions( XMTObject )";
        _logger.entry(string, xMTObject);
        Set set = CollectionFactory.newSet();
        StoreRecordQuery storeRecordQuery = new StoreRecordQuery(STORE_RECORD_ROLE_MAPPING);
        storeRecordQuery.setClassname((class$com$ibm$sec$iauthz$mcc$dna$RoleConfigObject == null ? (class$com$ibm$sec$iauthz$mcc$dna$RoleConfigObject = StorageExtractHelper.class$("com.ibm.sec.iauthz.mcc.dna.RoleConfigObject")) : class$com$ibm$sec$iauthz$mcc$dna$RoleConfigObject).getName());
        storeRecordQuery.setAttrName(GENERIC_TRANSFORM_KEY);
        StoreRecordQuery storeRecordQuery2 = new StoreRecordQuery(xMTObject.getType());
        storeRecordQuery2.setClassname((String)xMTObject.getElement("ClassName"));
        storeRecordQuery2.setAttrName(PRINCIPAL_NAME);
        storeRecordQuery2.setAttrValue((String)xMTObject.getElement(PRINCIPAL_NAME));
        _logger.debug(string, "Creating expression query. Operation is 0, srq is " + storeRecordQuery + " and prinSrq is " + storeRecordQuery2);
        SimpleQueryExpr simpleQueryExpr = new SimpleQueryExpr(1, storeRecordQuery, storeRecordQuery2);
        StoreRecordQuery storeRecordQuery3 = new StoreRecordQuery(STORE_RECORD_ROLE_MAPPING);
        storeRecordQuery3.setClassname((class$com$ibm$sec$iauthz$mcc$dna$RoleConfigObject == null ? (class$com$ibm$sec$iauthz$mcc$dna$RoleConfigObject = StorageExtractHelper.class$("com.ibm.sec.iauthz.mcc.dna.RoleConfigObject")) : class$com$ibm$sec$iauthz$mcc$dna$RoleConfigObject).getName());
        storeRecordQuery3.setAttrName(GENERIC_TRANSFORM_VALUE);
        storeRecordQuery3.setSearchDepth(1);
        storeRecordQuery3.setQueryExpr(simpleQueryExpr);
        PagedResultSet pagedResultSet = this._storage.getPolicy(storeRecordQuery3);
        while (pagedResultSet.hasNext()) {
            XMTObject xMTObject2;
            object = null;
            try {
                object = (XMTObject)pagedResultSet.next();
            }
            catch (Exception exception) {
                String string2 = CWRGSMessageHelper.getMessage("ERROR_EXTRACTING_ROLE_MAPPING", new Object[]{(String)xMTObject.getElement(PRINCIPAL_NAME), exception.getMessage()});
                _logger.error(string, string2, exception);
            }
            if (!(xMTObject2 = (XMTObject)((XMTObject)object).getElement(GENERIC_TRANSFORM_KEY)).equals(xMTObject)) continue;
            set.add(((XMTObject)object).getElement(GENERIC_TRANSFORM_VALUE));
        }
        _logger.debug(string, "Retrieved " + set.size() + " role conditions for principal '" + (String)xMTObject.getElement(PRINCIPAL_NAME) + "'");
        object = set.iterator();
        _logger.exit(string, object);
        return object;
    }

    public String getRoleCombiningAlgorithm() {
        String string = "getRoleCombiningAlgorithm()";
        _logger.entry(string);
        String string2 = null;
        try {
            StoreRecordQuery storeRecordQuery = MCCUtil.getQuery(new CombiningAlgorithm(null), false);
            PagedResultSet pagedResultSet = this._storage.getPolicy(storeRecordQuery);
            if (pagedResultSet.hasNext()) {
                XMTObject xMTObject = (XMTObject)pagedResultSet.next();
                if (xMTObject.getElement("ClassName").equals((class$com$ibm$sec$iauthz$mcc$dna$CombiningAlgorithm == null ? (class$com$ibm$sec$iauthz$mcc$dna$CombiningAlgorithm = StorageExtractHelper.class$("com.ibm.sec.iauthz.mcc.dna.CombiningAlgorithm")) : class$com$ibm$sec$iauthz$mcc$dna$CombiningAlgorithm).getName())) {
                    string2 = (String)xMTObject.getElement(COMBINING_ALGORITHM_KEY);
                }
            } else {
                String string3 = "No combining algorithms found.";
                _logger.debug(string, string3);
            }
        }
        catch (DataProcessingException dataProcessingException) {
            String string4 = CWRGSMessageHelper.getMessage("ERROR_EXTRACTING_COMBINING_ALGORITHM", new Object[]{dataProcessingException.getMessage()});
            _logger.error(string, string4, dataProcessingException);
        }
        catch (Exception exception) {
            String string5 = CWRGSMessageHelper.getMessage("ERROR_EXTRACTING_COMBINING_ALGORITHM", new Object[]{exception.getMessage()});
            _logger.error(string, string5, exception);
        }
        _logger.exit(string, string2);
        return string2;
    }

    public void clearStoredData() {
        String string = "clearStoredData()";
        _logger.entry(string);
        _logger.debug(string, "Clearing all found policy and principal-to-role mapping data.");
        this._allPrincipals.clear();
        this._allRoles.clear();
        this._retrievedPrincipals = false;
        this._retrievedRoles = false;
        _logger.exit(string);
    }

    private void retrieveRoleNames() {
        String string = "retrieveRoleNames";
        _logger.entry(string);
        if (!this._retrievedRoles) {
            _logger.debug(string, "Extracting known role names from storage.");
            StoreRecordQuery storeRecordQuery = new StoreRecordQuery(STORE_RECORD_POLICY);
            storeRecordQuery.setClassname((class$com$ibm$sec$iauthz$mcc$dna$PolicyConfigObject == null ? (class$com$ibm$sec$iauthz$mcc$dna$PolicyConfigObject = StorageExtractHelper.class$("com.ibm.sec.iauthz.mcc.dna.PolicyConfigObject")) : class$com$ibm$sec$iauthz$mcc$dna$PolicyConfigObject).getName());
            storeRecordQuery.setAttrName(GENERIC_TRANSFORM_KEY);
            PagedResultSet pagedResultSet = this._storage.getPolicy(storeRecordQuery);
            if (pagedResultSet != null) {
                while (pagedResultSet.hasNext()) {
                    Object object = null;
                    try {
                        object = pagedResultSet.next();
                    }
                    catch (Exception exception) {
                        String string2 = CWRGSMessageHelper.getMessage("ERROR_EXTRACTING_ROLE_NAMES", new Object[]{exception.getMessage()});
                        _logger.error(string, string2, exception);
                        break;
                    }
                    if (object == null) continue;
                    this._allRoles.add(((XMTObject)object).getElement(GENERIC_TRANSFORM_KEY));
                }
            } else {
                _logger.debug(string, "Retrieved null PagedResultSet from storage.");
            }
            this._retrievedRoles = true;
        }
        _logger.exit(string);
    }

    private void retrievePrincipals() {
        String string = "retrievePrincipals";
        _logger.entry(string);
        if (!this._retrievedPrincipals) {
            _logger.debug(string, "Extracting all known principals from storage.");
            StoreRecordQuery storeRecordQuery = new StoreRecordQuery(STORE_RECORD_ROLE_MAPPING);
            storeRecordQuery.setSearchDepth(1);
            storeRecordQuery.setClassname((class$com$ibm$sec$iauthz$mcc$dna$RoleConfigObject == null ? (class$com$ibm$sec$iauthz$mcc$dna$RoleConfigObject = StorageExtractHelper.class$("com.ibm.sec.iauthz.mcc.dna.RoleConfigObject")) : class$com$ibm$sec$iauthz$mcc$dna$RoleConfigObject).getName());
            storeRecordQuery.setAttrName(GENERIC_TRANSFORM_KEY);
            PagedResultSet pagedResultSet = this._storage.getPolicy(storeRecordQuery);
            if (pagedResultSet != null) {
                while (pagedResultSet.hasNext()) {
                    Object object;
                    XMTObject xMTObject = null;
                    try {
                        xMTObject = (XMTObject)pagedResultSet.next();
                    }
                    catch (Exception exception) {
                        object = CWRGSMessageHelper.getMessage("ERROR_EXTRACTING_PRINCIPALS", new Object[]{exception.getMessage()});
                        _logger.error(string, (String)object, exception);
                        break;
                    }
                    String string2 = (String)xMTObject.getElement("ClassName");
                    if (string2 != null && string2.equals((class$com$ibm$sec$iauthz$mcc$dna$RoleConfigObject == null ? StorageExtractHelper.class$("com.ibm.sec.iauthz.mcc.dna.RoleConfigObject") : class$com$ibm$sec$iauthz$mcc$dna$RoleConfigObject).getName())) {
                        object = (XMTObject)xMTObject.getElement(GENERIC_TRANSFORM_KEY);
                        if (object == null || this._allPrincipals.contains(object)) continue;
                        this._allPrincipals.add(object);
                        continue;
                    }
                    _logger.debug(string, "Expected RoleConfigObject, got '" + string2 + "' instead. Ignoring this result.");
                }
            }
            this._retrievedPrincipals = true;
        }
        _logger.debug(string, "Known Principals: " + this._allPrincipals.size());
        _logger.exit(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

