/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.iauthz.mcc.xml;

import com.ibm.sec.iauthz.log.SecLogger;
import com.ibm.sec.iauthz.mcc.xml.ExportXMLReader;
import com.ibm.sec.iauthz.mcc.xml.IXMLImportExport;
import com.ibm.sec.iauthz.mcc.xml.ImportContentHandler;
import com.ibm.sec.iauthz.util.CWRGSMessageHelper;
import com.ibm.sec.iauthz.util.MCCException;
import com.ibm.sec.iauthz.util.StorageBuffer;
import com.ibm.sec.iauthz.util.XMLException;
import java.io.IOException;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLImportExportImpl
implements IXMLImportExport {
    public static final boolean IMPORT_POLICY = true;
    public static final boolean IMPORT_ROLE_MAPPING = false;
    private StorageBuffer _store;
    private boolean _isPolicy;
    private String _contextID;
    private static SecLogger _logger = SecLogger.getLogger(class$com$ibm$sec$iauthz$mcc$xml$XMLImportExportImpl == null ? (class$com$ibm$sec$iauthz$mcc$xml$XMLImportExportImpl = XMLImportExportImpl.class$("com.ibm.sec.iauthz.mcc.xml.XMLImportExportImpl")) : class$com$ibm$sec$iauthz$mcc$xml$XMLImportExportImpl);
    private static String PROPERTY_INCREMENTAL_TRANSFORM = "http://xml.apache.org/xalan/features/incremental";
    private static String PROPERTY_HANDLE_LEXICAL_EVENTS = "http://xml.org/sax/properties/lexical-handler";
    static /* synthetic */ Class class$com$ibm$sec$iauthz$mcc$xml$XMLImportExportImpl;

    public XMLImportExportImpl(StorageBuffer storageBuffer, boolean bl, String string) {
        String string2 = "XMLImportExportImpl( StorageBuffer, boolean, String )";
        _logger.entry(string2, new Object[]{storageBuffer, bl, string});
        this._store = storageBuffer;
        this._contextID = string;
        this._isPolicy = bl;
        _logger.exit(string2);
    }

    public void importXML(InputSource inputSource, InputSource inputSource2) throws XMLException {
        String string = "importXML( InputSource, InputSource )";
        _logger.entry(string, new Object[]{inputSource, inputSource2});
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            try {
                transformerFactory.setAttribute(PROPERTY_INCREMENTAL_TRANSFORM, Boolean.TRUE);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                _logger.debug(string, "Attempted to force incremental transform, but the attribute was not recognised.");
            }
            if (transformerFactory.getFeature("http://javax.xml.transform.sax.SAXSource/feature") && transformerFactory.getFeature("http://javax.xml.transform.sax.SAXResult/feature")) {
                _logger.debug(string, "Loading XSLT stylesheet for transforming document to internal format.");
                SAXTransformerFactory sAXTransformerFactory = (SAXTransformerFactory)transformerFactory;
                TemplatesHandler templatesHandler = sAXTransformerFactory.newTemplatesHandler();
                XMLReader xMLReader = XMLReaderFactory.createXMLReader();
                xMLReader.setContentHandler(templatesHandler);
                xMLReader.parse(inputSource2);
                Templates templates = templatesHandler.getTemplates();
                TransformerHandler transformerHandler = sAXTransformerFactory.newTransformerHandler(templates);
                xMLReader.setContentHandler(transformerHandler);
                xMLReader.setProperty(PROPERTY_HANDLE_LEXICAL_EVENTS, transformerHandler);
                ImportContentHandler importContentHandler = new ImportContentHandler(this._store, this._isPolicy, this._contextID);
                SAXResult sAXResult = new SAXResult(importContentHandler);
                transformerHandler.setResult(sAXResult);
                _logger.debug(string, "Parsing input document.");
                xMLReader.parse(inputSource);
                if (!importContentHandler.getSuccess()) {
                    String string2 = CWRGSMessageHelper.getMessage("ERROR_IMPORTING_XML", new Object[]{this._contextID, importContentHandler.getErrorMessage()});
                    XMLException xMLException = new XMLException(string2);
                    _logger.error(string, string2, xMLException);
                    throw xMLException;
                }
            } else {
                _logger.debug(string, "TransformerFactory instance doesn't support SAX-based transforms.");
            }
        }
        catch (SAXException sAXException) {
            String string3 = CWRGSMessageHelper.getMessage("ERROR_IMPORTING_XML", new Object[]{this._contextID, sAXException.getMessage()});
            _logger.error(string, string3, sAXException);
            throw new XMLException(string3, sAXException);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            String string4 = CWRGSMessageHelper.getMessage("ERROR_IMPORTING_XML", new Object[]{this._contextID, transformerConfigurationException.getMessage()});
            _logger.error(string, string4, transformerConfigurationException);
            throw new XMLException(string4, transformerConfigurationException);
        }
        catch (IOException iOException) {
            String string5 = CWRGSMessageHelper.getMessage("ERROR_IMPORTING_XML", new Object[]{this._contextID, iOException.getMessage()});
            _logger.error(string, string5, iOException);
            throw new XMLException(string5, iOException);
        }
        catch (MCCException mCCException) {
            String string6 = CWRGSMessageHelper.getMessage("ERROR_IMPORTING_XML", new Object[]{this._contextID, mCCException.getMessage()});
            _logger.error(string, string6, mCCException);
            throw new XMLException(string6, mCCException);
        }
        _logger.exit(string);
    }

    public void exportXML(ContentHandler contentHandler, InputSource inputSource) throws XMLException {
        String string = "exportXML( ContentHandler, InputSource )";
        _logger.entry(string, new Object[]{contentHandler, inputSource});
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            try {
                transformerFactory.setAttribute(PROPERTY_INCREMENTAL_TRANSFORM, Boolean.TRUE);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                _logger.debug(string, "Attempted to force incremental transform, but the attribute was not recognised.");
            }
            if (transformerFactory.getFeature("http://javax.xml.transform.sax.SAXSource/feature") && transformerFactory.getFeature("http://javax.xml.transform.sax.SAXResult/feature")) {
                _logger.debug(string, "Loading XSLT stylesheet for transforming document to desired output format.");
                SAXTransformerFactory sAXTransformerFactory = (SAXTransformerFactory)transformerFactory;
                TemplatesHandler templatesHandler = sAXTransformerFactory.newTemplatesHandler();
                XMLReader xMLReader = XMLReaderFactory.createXMLReader();
                xMLReader.setContentHandler(templatesHandler);
                xMLReader.parse(inputSource);
                xMLReader = new ExportXMLReader(this._store, this._isPolicy, this._contextID);
                Templates templates = templatesHandler.getTemplates();
                TransformerHandler transformerHandler = sAXTransformerFactory.newTransformerHandler(templates);
                xMLReader.setContentHandler(transformerHandler);
                xMLReader.setProperty(PROPERTY_HANDLE_LEXICAL_EVENTS, transformerHandler);
                SAXResult sAXResult = new SAXResult(contentHandler);
                transformerHandler.setResult(sAXResult);
                _logger.debug(string, "Commencing policy export.");
                xMLReader.parse(new InputSource());
            } else {
                _logger.debug(string, "TransformerFactory instance doesn't support SAX-based transforms.");
            }
        }
        catch (SAXException sAXException) {
            String string2 = CWRGSMessageHelper.getMessage("ERROR_EXPORTING_XML", new Object[]{this._contextID, sAXException.getMessage()});
            _logger.error(string, string2, sAXException);
            throw new XMLException(string2, sAXException);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            String string3 = CWRGSMessageHelper.getMessage("ERROR_EXPORTING_XML", new Object[]{this._contextID, transformerConfigurationException.getMessage()});
            _logger.error(string, string3, transformerConfigurationException);
            throw new XMLException(string3, transformerConfigurationException);
        }
        catch (IOException iOException) {
            String string4 = CWRGSMessageHelper.getMessage("ERROR_EXPORTING_XML", new Object[]{this._contextID, iOException.getMessage()});
            _logger.error(string, string4, iOException);
            throw new XMLException(string4, iOException);
        }
        catch (MCCException mCCException) {
            String string5 = CWRGSMessageHelper.getMessage("ERROR_EXPORTING_XML", new Object[]{this._contextID, mCCException.getMessage()});
            _logger.error(string, string5, mCCException);
            throw new XMLException(string5, mCCException);
        }
        _logger.exit(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

