/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.iauthz.runtime;

import com.ibm.sec.iauthz.log.SecLogger;
import com.ibm.sec.iauthz.runtime.FileBasedHashMapImpl;
import com.ibm.sec.iauthz.runtime.RuntimeFileUtils;
import com.ibm.sec.iauthz.util.CWRGSMessageHelper;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public abstract class FileBasedHashMap
implements Map {
    private static final SecLogger logger = SecLogger.getLogger(class$com$ibm$sec$iauthz$runtime$FileBasedHashMap == null ? (class$com$ibm$sec$iauthz$runtime$FileBasedHashMap = FileBasedHashMap.class$("com.ibm.sec.iauthz.runtime.FileBasedHashMap")) : class$com$ibm$sec$iauthz$runtime$FileBasedHashMap);
    private final Map cacheMap;
    private final boolean cacheEnabled = true;
    protected final File root;
    static /* synthetic */ Class class$com$ibm$sec$iauthz$runtime$FileBasedHashMap;

    public static Map getFileBasedHashMap(File file, int n) {
        if (logger.isEntryLevel()) {
            logger.entry("getFileBasedHashMap", new Object[]{file.getAbsolutePath(), Integer.toString(n)});
        }
        FileBasedHashMapImpl fileBasedHashMapImpl = new FileBasedHashMapImpl(file, n);
        if (logger.isExitLevel()) {
            logger.exit("getFileBasedHashMap", fileBasedHashMapImpl);
        }
        return fileBasedHashMapImpl;
    }

    public FileBasedHashMap(File file, final int n) {
        if (logger.isEntryLevel()) {
            logger.entry("<init>", new Object[]{file.getAbsolutePath(), Integer.toString(n)});
        }
        this.root = file;
        if (!RuntimeFileUtils.exists(this.root)) {
            RuntimeFileUtils.mkdirs(this.root);
        } else if (RuntimeFileUtils.isFile(this.root)) {
            String string = CWRGSMessageHelper.getMessage("PE_RUNTIME_DIR_IS_NOT_A_DIR", new Object[]{file.getAbsolutePath()});
            if (logger.isErrorLevel()) {
                logger.error("<init>", string);
            }
            throw new RuntimeException(string);
        }
        this.cacheMap = new LinkedHashMap(n + 1, 0.75f, true){
            private static final long serialVersionUID = 2980312356805154880L;

            public boolean removeEldestEntry(Map.Entry entry) {
                return super.size() > n;
            }
        };
        if (logger.isExitLevel()) {
            logger.exit("<init>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invalidateCache() {
        if (logger.isEntryLevel()) {
            logger.entry("invalidateCache");
        }
        Map map = this.cacheMap;
        synchronized (map) {
            this.cacheMap.clear();
        }
        if (logger.isExitLevel()) {
            logger.exit("invalidateCache");
        }
    }

    public final File getRoot() {
        return this.root;
    }

    public int size() {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        if (logger.isEntryLevel()) {
            logger.entry("clear");
        }
        this.invalidateCache();
        RuntimeFileUtils.deleteDirectory(this.root, true);
        if (logger.isExitLevel()) {
            logger.exit("clear");
        }
    }

    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    public abstract boolean containsKey(Object var1);

    public boolean containsValue(Object object) {
        throw new UnsupportedOperationException();
    }

    public Collection values() {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map map) {
        throw new UnsupportedOperationException();
    }

    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    public Set keySet() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object get(Object object) {
        Object object2;
        if (logger.isEntryLevel()) {
            logger.entry("get", object);
        }
        this.getClass();
        Map map = this.cacheMap;
        synchronized (map) {
            Object v = this.cacheMap.get(object);
            if (v != null) {
                object2 = v;
            } else {
                object2 = this._get(object);
                if (object2 != null) {
                    Map map2 = this.cacheMap;
                    synchronized (map2) {
                        this.cacheMap.put(object, object2);
                    }
                }
            }
        }
        if (logger.isExitLevel()) {
            logger.exit("get", object2);
        }
        return object2;
    }

    protected abstract Object _get(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object object) {
        if (logger.isEntryLevel()) {
            logger.entry("remove", object);
        }
        Map map = this.cacheMap;
        synchronized (map) {
            this.cacheMap.remove(object);
        }
        if (logger.isExitLevel()) {
            logger.exit("remove", null);
        }
        return null;
    }

    public abstract Object put(Object var1, Object var2);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

