/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.iauthz.runtime;

import com.ibm.sec.authz.jaccx.role.RoleAssignmentCondition;
import com.ibm.sec.authz.jaccx.role.RoleBlockCondition;
import com.ibm.sec.authz.jaccx.role.RoleCondition;
import com.ibm.sec.iauthz.log.SecLogger;
import com.ibm.sec.iauthz.runtime.FileBasedHashMap;
import com.ibm.sec.iauthz.runtime.OptimizedRoleMappingConfiguration;
import com.ibm.sec.iauthz.runtime.RuntimeConfiguration;
import com.ibm.sec.iauthz.runtime.RuntimeFileUtils;
import com.ibm.sec.iauthz.runtime.RuntimeUtils;
import com.ibm.sec.iauthz.runtime.algorithm.OptimizedRoleConditionCollection;
import com.ibm.sec.iauthz.util.CWRGSMessageHelper;
import com.ibm.sec.iauthz.util.CollectionFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class FileBasedOptimizedRoleMappingConfiguration
extends OptimizedRoleMappingConfiguration {
    private static final SecLogger logger = SecLogger.getLogger(class$com$ibm$sec$iauthz$runtime$FileBasedOptimizedRoleMappingConfiguration == null ? (class$com$ibm$sec$iauthz$runtime$FileBasedOptimizedRoleMappingConfiguration = FileBasedOptimizedRoleMappingConfiguration.class$("com.ibm.sec.iauthz.runtime.FileBasedOptimizedRoleMappingConfiguration")) : class$com$ibm$sec$iauthz$runtime$FileBasedOptimizedRoleMappingConfiguration);
    private final File root;
    private final File CONFIGURATION_PROPERTY_FILE;
    private static final String CONFIGURATION_PROPERTY = "configuration.properties";
    private final Properties configurationProperties;
    private static final String VERSION = "version";
    private static final String ALGORITHM = "algorithm";
    private static final String SYNTAX = "syntax";
    private static final String CURRENT_SYNTAX = "RUNTIME-REPLICA SYNTAX VERSION 600, DATE 2005/08/25";
    private String syntax;
    private static final String ROLE_2_COUNT_PROPERTY = "role.properties";
    private static final String AN_2_COUNT_PROPERTY = "attribute.properties";
    private final File ROLE_2_COUNT_PROPERTY_FILE;
    private final File AN_2_COUNT_PROPERTY_FILE;
    static /* synthetic */ Class class$com$ibm$sec$iauthz$runtime$FileBasedOptimizedRoleMappingConfiguration;

    public FileBasedOptimizedRoleMappingConfiguration(String string, RuntimeConfiguration runtimeConfiguration, boolean bl) {
        super(string, runtimeConfiguration);
        this.root = ((FileBasedHashMap)this.principalToRoleConditionMap).getRoot();
        this.configurationProperties = new Properties();
        this.CONFIGURATION_PROPERTY_FILE = new File(this.root, CONFIGURATION_PROPERTY);
        this.ROLE_2_COUNT_PROPERTY_FILE = new File(this.root, ROLE_2_COUNT_PROPERTY);
        this.AN_2_COUNT_PROPERTY_FILE = new File(this.root, AN_2_COUNT_PROPERTY);
        if (bl) {
            this.cleanup();
            this.syntax = CURRENT_SYNTAX;
            this.configurationProperties.setProperty(SYNTAX, CURRENT_SYNTAX);
        } else {
            Object object;
            if (RuntimeFileUtils.exists(this.CONFIGURATION_PROPERTY_FILE)) {
                object = RuntimeFileUtils.getFileInputStream(this.CONFIGURATION_PROPERTY_FILE);
                try {
                    this.configurationProperties.load((InputStream)object);
                }
                catch (IOException iOException) {
                    String string2 = CWRGSMessageHelper.getMessage("PE_FILE_INPUT_STREAM_READ_ERROR", new Object[]{this.CONFIGURATION_PROPERTY_FILE.getAbsolutePath()});
                    if (logger.isErrorLevel()) {
                        logger.error("<init>", string2, iOException);
                    }
                    throw new RuntimeException(string2, iOException);
                }
                finally {
                    try {
                        ((InputStream)object).close();
                    }
                    catch (IOException iOException) {}
                }
            }
            String string3 = CWRGSMessageHelper.getMessage("PE_FILE_NOT_FOUND_AT_REFRESH", new Object[]{this.CONFIGURATION_PROPERTY_FILE.getAbsolutePath()});
            if (logger.isErrorLevel()) {
                logger.error("<init>", string3);
            }
            throw new RuntimeException(string3);
            this.algorithmID = this.configurationProperties.getProperty(ALGORITHM);
            this.version = this.configurationProperties.getProperty(VERSION);
            this.syntax = this.configurationProperties.getProperty(SYNTAX);
            if (RuntimeFileUtils.exists(this.AN_2_COUNT_PROPERTY_FILE)) {
                object = RuntimeFileUtils.getFileInputStream(this.AN_2_COUNT_PROPERTY_FILE);
                try {
                    this.attributeNameToCountProperties.load((InputStream)object);
                }
                catch (IOException iOException) {
                    String string4 = CWRGSMessageHelper.getMessage("PE_FILE_INPUT_STREAM_READ_ERROR", new Object[]{this.AN_2_COUNT_PROPERTY_FILE.getAbsolutePath()});
                    if (logger.isErrorLevel()) {
                        logger.error("<init>", string4, iOException);
                    }
                    throw new RuntimeException(string4, iOException);
                }
                finally {
                    try {
                        ((InputStream)object).close();
                    }
                    catch (IOException iOException) {}
                }
            }
            object = CWRGSMessageHelper.getMessage("PE_FILE_NOT_FOUND_AT_REFRESH", new Object[]{this.AN_2_COUNT_PROPERTY_FILE.getAbsolutePath()});
            if (logger.isErrorLevel()) {
                logger.error("<init>", (String)object);
            }
            throw new RuntimeException((String)object);
            if (RuntimeFileUtils.exists(this.ROLE_2_COUNT_PROPERTY_FILE)) {
                object = RuntimeFileUtils.getFileInputStream(this.ROLE_2_COUNT_PROPERTY_FILE);
                try {
                    this.roleToCountProperties.load((InputStream)object);
                }
                catch (IOException iOException) {
                    String string5 = CWRGSMessageHelper.getMessage("PE_FILE_INPUT_STREAM_READ_ERROR", new Object[]{this.ROLE_2_COUNT_PROPERTY_FILE.getAbsolutePath()});
                    if (logger.isErrorLevel()) {
                        logger.error("<init>", string5, iOException);
                    }
                    throw new RuntimeException(string5, iOException);
                }
                finally {
                    try {
                        ((InputStream)object).close();
                    }
                    catch (IOException iOException) {}
                }
            }
            object = CWRGSMessageHelper.getMessage("PE_FILE_NOT_FOUND_AT_REFRESH", new Object[]{this.ROLE_2_COUNT_PROPERTY_FILE.getAbsolutePath()});
            if (logger.isErrorLevel()) {
                logger.error("<init>", (String)object);
            }
            throw new RuntimeException((String)object);
        }
    }

    public void cleanup() {
        String string = "cleanup";
        if (logger.isEntryLevel()) {
            logger.entry(string);
        }
        if (RuntimeFileUtils.exists(this.CONFIGURATION_PROPERTY_FILE)) {
            RuntimeFileUtils.deleteFile(this.CONFIGURATION_PROPERTY_FILE);
        }
        if (RuntimeFileUtils.exists(this.ROLE_2_COUNT_PROPERTY_FILE)) {
            RuntimeFileUtils.deleteFile(this.ROLE_2_COUNT_PROPERTY_FILE);
        }
        if (RuntimeFileUtils.exists(this.AN_2_COUNT_PROPERTY_FILE)) {
            RuntimeFileUtils.deleteFile(this.AN_2_COUNT_PROPERTY_FILE);
        }
        this.principalToRoleConditionMap.clear();
        if (logger.isExitLevel()) {
            logger.exit(string);
        }
    }

    public void delete() {
        String string = "delete";
        if (logger.isEntryLevel()) {
            logger.entry(string);
        }
        this.cleanup();
        if (RuntimeFileUtils.exists(this.root)) {
            RuntimeFileUtils.deleteDirectory(this.root, false);
        }
        if (logger.isExitLevel()) {
            logger.exit(string);
        }
    }

    public static boolean exists(String string, RuntimeConfiguration runtimeConfiguration) {
        String string2 = "exists";
        if (logger.isEntryLevel()) {
            logger.entry(string2, new Object[]{string, runtimeConfiguration});
        }
        String string3 = RuntimeUtils.contextID2fileName(string);
        File file = new File(runtimeConfiguration.getDirectory(), string3);
        boolean bl = RuntimeFileUtils.exists(file);
        if (logger.isExitLevel()) {
            logger.exit(string2, bl);
        }
        return bl;
    }

    public static final void removeDirectoriesNotInService(File file, Set set) {
        File[] fileArray;
        if (logger.isEntryLevel()) {
            logger.entry("removeDirectoriesNotInService", new Object[]{file.getAbsolutePath(), set});
        }
        if ((fileArray = RuntimeFileUtils.listFiles(file)) != null) {
            Set set2 = CollectionFactory.newSet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                set2.add(RuntimeUtils.contextID2fileName((String)iterator.next()));
            }
            for (int i = 0; i < fileArray.length; ++i) {
                String string;
                if (!RuntimeFileUtils.isDirectory(fileArray[i]) || set2.contains(string = fileArray[i].getName())) continue;
                File file2 = new File(file, string);
                RuntimeFileUtils.deleteDirectory(file2, false);
                if (!logger.isDebugLevel()) continue;
                String string2 = CWRGSMessageHelper.getMessage("PE_RMC_REMOVED_FROM_FILE_BASED_LOCAL_REPLICA", new Object[]{file2.getAbsolutePath()});
                logger.debug("removeDirectoriesNotInService", string2);
            }
        }
        if (logger.isExitLevel()) {
            logger.exit("removeDirectoriesNotInService");
        }
    }

    protected Map newMap(int n) {
        Object object;
        String string = RuntimeUtils.contextID2fileName(this.roleMappingContextID);
        if (logger.isDebugLevel()) {
            object = CWRGSMessageHelper.getMessage("PE_ROLE_MAPPING_CONTEXT_FILE_NAME", new Object[]{this.roleMappingContextID, string});
            logger.debug("newMap", (String)object);
        }
        object = new File(this.runtimeConfiguration.getDirectory(), string);
        return FileBasedHashMap.getFileBasedHashMap((File)object, n);
    }

    private void storeConfiguration() {
        if (logger.isEntryLevel()) {
            logger.entry("storeConfiguration");
        }
        OutputStream outputStream = RuntimeFileUtils.getFileOutputStream(this.CONFIGURATION_PROPERTY_FILE);
        try {
            this.configurationProperties.store(outputStream, "Role mapping configurations for " + this.roleMappingContextID);
        }
        catch (IOException iOException) {
            String string = CWRGSMessageHelper.getMessage("PE_FILE_OUTPUT_STREAM_WRITE_ERROR", new Object[]{this.CONFIGURATION_PROPERTY_FILE.getAbsolutePath()});
            if (logger.isErrorLevel()) {
                logger.error("storeConfiguration", string, iOException);
            }
            throw new RuntimeException(string, iOException);
        }
        finally {
            try {
                outputStream.flush();
                outputStream.close();
            }
            catch (IOException iOException) {}
        }
        if (logger.isExitLevel()) {
            logger.exit("storeConfiguration");
        }
    }

    private void storeCounts() {
        if (logger.isEntryLevel()) {
            logger.entry("storeCounts");
        }
        OutputStream outputStream = RuntimeFileUtils.getFileOutputStream(this.ROLE_2_COUNT_PROPERTY_FILE);
        try {
            this.roleToCountProperties.store(outputStream, "Role counts for " + this.roleMappingContextID);
        }
        catch (IOException iOException) {
            String string = CWRGSMessageHelper.getMessage("PE_FILE_OUTPUT_STREAM_WRITE_ERROR", new Object[]{this.ROLE_2_COUNT_PROPERTY_FILE.getAbsolutePath()});
            if (logger.isErrorLevel()) {
                logger.error("storeCounts", string, iOException);
            }
            throw new RuntimeException(string, iOException);
        }
        finally {
            try {
                outputStream.flush();
                outputStream.close();
            }
            catch (IOException iOException) {}
        }
        outputStream = RuntimeFileUtils.getFileOutputStream(this.AN_2_COUNT_PROPERTY_FILE);
        try {
            this.attributeNameToCountProperties.store(outputStream, "Attribute name counts for " + this.roleMappingContextID);
        }
        catch (IOException iOException) {
            String string = CWRGSMessageHelper.getMessage("PE_FILE_OUTPUT_STREAM_WRITE_ERROR", new Object[]{this.AN_2_COUNT_PROPERTY_FILE.getAbsolutePath()});
            if (logger.isErrorLevel()) {
                logger.error("storeCounts", string, iOException);
            }
            throw new RuntimeException(string, iOException);
        }
        finally {
            try {
                outputStream.flush();
                outputStream.close();
            }
            catch (IOException iOException) {}
        }
        if (logger.isExitLevel()) {
            logger.exit("storeCounts");
        }
    }

    public void addToPrincipal(Principal principal, RoleCondition roleCondition) {
        OptimizedRoleConditionCollection optimizedRoleConditionCollection;
        if (logger.isEntryLevel()) {
            logger.entry("addToPrincipal(Principal, RoleCondition)", new Object[]{principal, roleCondition});
        }
        if ((optimizedRoleConditionCollection = (OptimizedRoleConditionCollection)this.principalToRoleConditionMap.get(principal)) != null) {
            if (optimizedRoleConditionCollection.contains(principal, roleCondition)) {
                if (logger.isDebugLevel()) {
                    String string = CWRGSMessageHelper.getMessage("PE_DELTA_ADD_EXISTING_ROLE_CONDITION", new Object[]{principal, roleCondition});
                    logger.debug("addToPrincipal(Principal, RoleCondition)", string);
                }
                return;
            }
        } else {
            optimizedRoleConditionCollection = new OptimizedRoleConditionCollection(CollectionFactory.newSet(), CollectionFactory.newSet());
        }
        this.updateCounts(0, principal, roleCondition);
        if (roleCondition instanceof RoleAssignmentCondition) {
            optimizedRoleConditionCollection.getRoleAssignmentConditionSet().add(roleCondition);
        } else if (roleCondition instanceof RoleBlockCondition) {
            optimizedRoleConditionCollection.getRoleBlockConditionSet().add(roleCondition);
        }
        optimizedRoleConditionCollection.updateSortedRoleConditions();
        this.principalToRoleConditionMap.put(principal, optimizedRoleConditionCollection);
        if (logger.isExitLevel()) {
            logger.exit("addToPrincipal(Principal, RoleCondition)");
        }
    }

    public void removeFromPrincipal(Principal principal, RoleCondition roleCondition) {
        if (logger.isEntryLevel()) {
            logger.entry("removeFromPrincipal(Principal, RoleCondition)", new Object[]{principal, roleCondition});
        }
        OptimizedRoleConditionCollection optimizedRoleConditionCollection = (OptimizedRoleConditionCollection)this.principalToRoleConditionMap.get(principal);
        boolean bl = true;
        if (optimizedRoleConditionCollection != null) {
            if (!optimizedRoleConditionCollection.contains(principal, roleCondition)) {
                bl = false;
            }
        } else {
            bl = false;
        }
        if (!bl) {
            if (logger.isDebugLevel()) {
                String string = CWRGSMessageHelper.getMessage("PE_DELTA_REMOVE_NOT_EXISTING_ROLE_CONDITION", new Object[]{principal, roleCondition});
                logger.debug("removeFromPrincipal(Principal, RoleCondition)", string);
            }
            return;
        }
        this.updateCounts(1, principal, roleCondition);
        if (roleCondition instanceof RoleAssignmentCondition) {
            optimizedRoleConditionCollection.getRoleAssignmentConditionSet().remove(roleCondition);
        } else if (roleCondition instanceof RoleBlockCondition) {
            optimizedRoleConditionCollection.getRoleBlockConditionSet().remove(roleCondition);
        }
        if (optimizedRoleConditionCollection.getRoleAssignmentConditionSet().isEmpty() && optimizedRoleConditionCollection.getRoleBlockConditionSet().isEmpty()) {
            this.principalToRoleConditionMap.remove(principal);
        } else {
            optimizedRoleConditionCollection.updateSortedRoleConditions();
            this.principalToRoleConditionMap.put(principal, optimizedRoleConditionCollection);
        }
        if (logger.isExitLevel()) {
            logger.exit("removeFromPrincipal(Principal, RoleCondition)");
        }
    }

    public void invalidateCache() {
        if (logger.isEntryLevel()) {
            logger.entry("invalidateCache");
        }
        ((FileBasedHashMap)this.principalToRoleConditionMap).invalidateCache();
        if (logger.isExitLevel()) {
            logger.exit("invalidateCache");
        }
    }

    public void setVersion(String string) {
        if (logger.isEntryLevel()) {
            logger.entry("setVersion", string);
        }
        super.setVersion(string);
        this.configurationProperties.setProperty(VERSION, this.version);
        if (logger.isExitLevel()) {
            logger.exit("setVersion");
        }
    }

    public void setCombiningAlgorithm(String string) {
        if (logger.isEntryLevel()) {
            logger.entry("setCombiningAlgorithm", string);
        }
        super.setCombiningAlgorithm(string);
        this.configurationProperties.setProperty(ALGORITHM, this.algorithmID);
        if (logger.isExitLevel()) {
            logger.exit("setCombiningAlgorithm");
        }
    }

    public void update() {
        if (logger.isEntryLevel()) {
            logger.entry("update");
        }
        this.storeConfiguration();
        this.storeCounts();
        if (logger.isExitLevel()) {
            logger.exit("update");
        }
    }

    public boolean isSupported() {
        boolean bl;
        if (logger.isEntryLevel()) {
            logger.entry("isSupported");
        }
        if (this.syntax == null) {
            bl = false;
        } else {
            bl = this.syntax.equals(CURRENT_SYNTAX);
            if (!bl && logger.isDebugLevel()) {
                String string = CWRGSMessageHelper.getMessage("PE_UNSUPPORTED_ROLE_MAPPING_LOCAL_REPLICA_SYNTAX", new Object[]{CURRENT_SYNTAX, this.syntax});
                logger.debug("isSupported", string);
            }
        }
        if (logger.isExitLevel()) {
            logger.exit("isSupported", bl);
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

