/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.iauthz.runtime;

import com.ibm.sec.authz.jaccx.EvaluationContext;
import com.ibm.sec.authz.jaccx.condition.AttributeName;
import com.ibm.sec.authz.jaccx.role.RoleAssignmentCondition;
import com.ibm.sec.authz.jaccx.role.RoleBlockCondition;
import com.ibm.sec.authz.jaccx.role.RoleCondition;
import com.ibm.sec.iauthz.log.SecLogger;
import com.ibm.sec.iauthz.runtime.RuntimeConfiguration;
import com.ibm.sec.iauthz.runtime.algorithm.AssignmentOverrides;
import com.ibm.sec.iauthz.runtime.algorithm.BlockOverrides;
import com.ibm.sec.iauthz.runtime.algorithm.CombiningAlgorithm;
import com.ibm.sec.iauthz.runtime.algorithm.MostSpecificAssignmentOverrides;
import com.ibm.sec.iauthz.runtime.algorithm.MostSpecificBlockOverrides;
import com.ibm.sec.iauthz.runtime.algorithm.OptimizedRoleConditionCollection;
import com.ibm.sec.iauthz.util.CollectionFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public abstract class OptimizedRoleMappingConfiguration {
    private static final SecLogger logger = SecLogger.getLogger(class$com$ibm$sec$iauthz$runtime$OptimizedRoleMappingConfiguration == null ? (class$com$ibm$sec$iauthz$runtime$OptimizedRoleMappingConfiguration = OptimizedRoleMappingConfiguration.class$("com.ibm.sec.iauthz.runtime.OptimizedRoleMappingConfiguration")) : class$com$ibm$sec$iauthz$runtime$OptimizedRoleMappingConfiguration);
    protected final String roleMappingContextID;
    protected final RuntimeConfiguration runtimeConfiguration;
    protected final Map principalToRoleConditionMap;
    protected final PropertiesForCounts attributeNameToCountProperties;
    protected final PropertiesForCounts roleToCountProperties;
    protected static final int INCREMENT = 0;
    protected static final int DECREMENT = 1;
    protected String version;
    protected String algorithmID;
    protected CombiningAlgorithm algorithm;
    static /* synthetic */ Class class$com$ibm$sec$iauthz$runtime$OptimizedRoleMappingConfiguration;

    public OptimizedRoleMappingConfiguration(String string, RuntimeConfiguration runtimeConfiguration) {
        if (logger.isEntryLevel()) {
            logger.entry("<init>");
        }
        this.roleMappingContextID = string;
        this.runtimeConfiguration = runtimeConfiguration;
        this.principalToRoleConditionMap = this.newMap(runtimeConfiguration.getCacheSize());
        this.attributeNameToCountProperties = new PropertiesForCounts(1);
        this.roleToCountProperties = new PropertiesForCounts(0);
        if (logger.isExitLevel()) {
            logger.exit("<init>");
        }
    }

    public final Map getPrincipalToRoleConditionMap() {
        return this.principalToRoleConditionMap;
    }

    public void addToPrincipal(Principal principal, Set set) {
        if (logger.isEntryLevel()) {
            logger.entry("addToPrincipal(Principal, Set)", new Object[]{principal, set});
        }
        Set set2 = CollectionFactory.newSet();
        Set set3 = CollectionFactory.newSet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            RoleCondition roleCondition = (RoleCondition)iterator.next();
            this.updateCounts(0, principal, roleCondition);
            if (roleCondition instanceof RoleBlockCondition) {
                set3.add(roleCondition);
                continue;
            }
            if (!(roleCondition instanceof RoleAssignmentCondition)) continue;
            set2.add(roleCondition);
        }
        OptimizedRoleConditionCollection optimizedRoleConditionCollection = new OptimizedRoleConditionCollection(set3, set2);
        this.principalToRoleConditionMap.put(principal, optimizedRoleConditionCollection);
        if (logger.isExitLevel()) {
            logger.exit("addToPrincipal(Principal, Set)");
        }
    }

    protected void updateCounts(int n, Principal principal, RoleCondition roleCondition) {
        if (logger.isEntryLevel()) {
            logger.entry("updateCounts(int, Principal, RoleCondition)", new Object[]{Integer.toString(n), principal, roleCondition});
        }
        String string = roleCondition.getRole();
        int n2 = this.roleToCountProperties.getCount(string);
        if (n == 0) {
            this.roleToCountProperties.setCount(string, ++n2);
        } else {
            this.roleToCountProperties.setCount(string, --n2);
        }
        Set set = roleCondition.getReferencedAttributeNames();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            AttributeName attributeName = (AttributeName)iterator.next();
            n2 = this.attributeNameToCountProperties.getCount(attributeName);
            if (n == 0) {
                this.attributeNameToCountProperties.setCount(attributeName, ++n2);
                continue;
            }
            this.attributeNameToCountProperties.setCount(attributeName, --n2);
        }
        if (logger.isExitLevel()) {
            logger.exit("updateCounts(int, Principal, RoleCondition)");
        }
    }

    private final CombiningAlgorithm getCombiningAlgorithm(String string) {
        if (logger.isEntryLevel()) {
            logger.entry("getCombiningAlgorithm", string);
        }
        CombiningAlgorithm combiningAlgorithm = string == null ? null : (string.equals("block-overrides") ? BlockOverrides.newInstance(this) : (string.equals("assignment-overrides") ? AssignmentOverrides.newInstance(this) : (string.equals("most-specific-block-overrides") ? MostSpecificBlockOverrides.newInstance(this) : (string.equals("most-specific-assignment-overrides") ? MostSpecificAssignmentOverrides.newInstance(this) : null))));
        if (logger.isExitLevel()) {
            logger.exit("getCombiningAlgorithm", combiningAlgorithm);
        }
        return combiningAlgorithm;
    }

    public void setCombiningAlgorithm(String string) {
        if (logger.isEntryLevel()) {
            logger.entry("setCombiningAlgorithm", string);
        }
        this.algorithmID = string;
        this.algorithm = this.getCombiningAlgorithm(string);
        if (logger.isExitLevel()) {
            logger.exit("setCombiningAlgorithm");
        }
    }

    public final String getCombiningAlgorithmID() {
        return this.algorithmID;
    }

    public final CombiningAlgorithm getCombiningAlgorithm() {
        return this.algorithm;
    }

    public String getContextID() {
        return this.roleMappingContextID;
    }

    public void setVersion(String string) {
        if (logger.isEntryLevel()) {
            logger.entry("setVersion", string);
        }
        this.version = string;
        if (logger.isExitLevel()) {
            logger.exit("setVersion");
        }
    }

    public final String getVersion() {
        return this.version;
    }

    public final Set getReferencedAttributeNames() {
        if (logger.isEntryLevel()) {
            logger.entry("getReferencedAttributeNames");
        }
        Set set = this.attributeNameToCountProperties.getPropertyNames();
        if (logger.isExitLevel()) {
            logger.exit("getReferencedAttributeNames", set);
        }
        return set;
    }

    public final Iterator getDefinedRoles() {
        if (logger.isEntryLevel()) {
            logger.entry("getDefinedRoles");
        }
        Set set = this.roleToCountProperties.getPropertyNames();
        if (logger.isExitLevel()) {
            logger.exit("getDefinedRoles", set);
        }
        return set.iterator();
    }

    public final Iterator getRoles(EvaluationContext evaluationContext) {
        if (logger.isEntryLevel()) {
            logger.entry("getRoles", evaluationContext);
        }
        Set set = CollectionFactory.newSet();
        Iterator iterator = this.getDefinedRoles();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!this.checkRoleMembership(string, evaluationContext)) continue;
            set.add(string);
        }
        if (logger.isExitLevel()) {
            logger.exit("getRoles", set);
        }
        return set.iterator();
    }

    public final boolean checkRoleMembership(String string, EvaluationContext evaluationContext) {
        if (logger.isEntryLevel()) {
            logger.entry("checkRoleMembership", new Object[]{evaluationContext, string});
        }
        boolean bl = this.getCombiningAlgorithm().checkRoleMembership(string, evaluationContext);
        if (logger.isExitLevel()) {
            logger.exit("checkRoleMembership", bl);
        }
        return bl;
    }

    public final boolean checkRoleMembershipAtOrUnderneath(String string, EvaluationContext evaluationContext) {
        if (logger.isEntryLevel()) {
            logger.entry("checkRoleMembershipAtOrUnderneath", new Object[]{evaluationContext, string});
        }
        boolean bl = this.getCombiningAlgorithm().checkRoleMembershipAtOrUnderneath(string, evaluationContext);
        if (logger.isExitLevel()) {
            logger.exit("checkRoleMembershipAtOrUnderneath", bl);
        }
        return bl;
    }

    public abstract void addToPrincipal(Principal var1, RoleCondition var2);

    public abstract void removeFromPrincipal(Principal var1, RoleCondition var2);

    public abstract void update();

    public abstract void invalidateCache();

    abstract Map newMap(int var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static class PropertiesForCounts {
        private final int type;
        private final Properties properties;
        private final Set propertyNames;
        static final int ROLE = 0;
        static final int ATTRIBUTE = 1;
        private static final String SUBJECT_PREFIX = "SUBJECT: ";
        private static final String REQUEST_CONTEXT_PREFIX = "REQUEST_CONTEXT: ";
        private static final String RESOURCE_CONTEXT_PREFIX = "RESOURCE_CONTEXT: ";

        PropertiesForCounts(int n) {
            this.type = n;
            this.properties = new Properties();
            this.propertyNames = CollectionFactory.newSet();
        }

        void setCount(Object object, int n) {
            if (n != 0) {
                this.propertyNames.add(object);
                this.properties.setProperty(this.convert2String(object), Integer.toString(n));
            } else {
                this.propertyNames.remove(object);
                this.properties.remove(this.convert2String(object));
            }
        }

        int getCount(Object object) {
            String string = this.properties.getProperty(object.toString());
            if (string == null) {
                return 0;
            }
            return Integer.parseInt(string);
        }

        Set getPropertyNames() {
            return Collections.unmodifiableSet(this.propertyNames);
        }

        void load(InputStream inputStream) throws IOException {
            this.properties.load(inputStream);
            Iterator<Object> iterator = this.properties.keySet().iterator();
            while (iterator.hasNext()) {
                this.propertyNames.add(this.convert2Object((String)iterator.next()));
            }
        }

        void store(OutputStream outputStream, String string) throws IOException {
            this.properties.store(outputStream, string);
        }

        private Object convert2Object(String string) {
            if (this.type == 1) {
                AttributeName attributeName;
                if (string.startsWith(SUBJECT_PREFIX)) {
                    attributeName = new AttributeName(1, string.substring(SUBJECT_PREFIX.length()));
                } else if (string.startsWith(REQUEST_CONTEXT_PREFIX)) {
                    attributeName = new AttributeName(2, string.substring(REQUEST_CONTEXT_PREFIX.length()));
                } else if (string.startsWith(RESOURCE_CONTEXT_PREFIX)) {
                    attributeName = new AttributeName(3, string.substring(RESOURCE_CONTEXT_PREFIX.length()));
                } else {
                    throw new RuntimeException("an invalid attribute name: " + string);
                }
                return attributeName;
            }
            return string;
        }

        private String convert2String(Object object) {
            if (this.type == 1) {
                AttributeName attributeName = (AttributeName)object;
                StringBuffer stringBuffer = new StringBuffer();
                switch (attributeName.getSource()) {
                    case 1: {
                        stringBuffer.append(SUBJECT_PREFIX);
                        break;
                    }
                    case 2: {
                        stringBuffer.append(REQUEST_CONTEXT_PREFIX);
                        break;
                    }
                    case 3: {
                        stringBuffer.append(RESOURCE_CONTEXT_PREFIX);
                        break;
                    }
                    default: {
                        throw new RuntimeException("an invalid attribute name: " + object);
                    }
                }
                stringBuffer.append(attributeName.getAttributeName());
                return stringBuffer.toString();
            }
            return object.toString();
        }
    }
}

