/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.iauthz.runtime;

import com.ibm.sec.iauthz.log.SecLogger;
import com.ibm.sec.iauthz.mcc.DataProcessingException;
import com.ibm.sec.iauthz.mcc.DataProcessingFactory;
import com.ibm.sec.iauthz.runtime.RuntimeFileUtils;
import com.ibm.sec.iauthz.storage.PolicyStoreException;
import com.ibm.sec.iauthz.storage.adapter.impl.AdapterUtils;
import com.ibm.sec.iauthz.storage.adapter.impl.mem.MemoryBackedAdapterImpl;
import com.ibm.sec.iauthz.util.CWRGSMessageHelper;
import com.ibm.sec.iauthz.util.CommonAuthProperties;
import com.ibm.sec.iauthz.util.Uuid;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public class RuntimeConfiguration {
    private static final SecLogger logger;
    private static final String CLIENT_IDENTIFIERS = "client identifiers";
    private final boolean useRuntimeDir;
    private static final String RUNTIME_DIR_CONFIG_PROPERTY = "com.ibm.sec.authz.provider.runtimedir";
    private static final String RUNTIME_DIR_SYSTEM_PROPERTY = "commonauthz.runtimedir";
    private static final String RUNTIME_DIR_PATH_SUFFIX;
    private static final File rootDir;
    public static final String POLICY = "policy";
    public static final String ROLE_MAPPING = "role";
    private final File configDir;
    private static final String CLIENT_PROPERTIES = "client.properties";
    private final Properties contextID2clientID;
    private static final String CACHE_SIZE_SUFFIX = ".cacheSize";
    private static final String PRINCIPAL_LIMIT_SIZE_SUFFIX = ".maxNumOfPrincipals";
    private static final String ROLE_LIMIT_SIZE_SUFFIX = ".maxNumOfRoles";
    private static final String PERMISSION_LIMIT_SIZE_SUFFIX = ".maxNumOfPermissions";
    private static final String ROLE_CONDITION_LIMIT_SIZE_SUFFIX = ".maxNumOfRoleConditions";
    private static final String USE_FILE_SYSTEM_SUFFIX = ".useFileSystem";
    private static final String DEFAULT_USE_FILE_SYSTEM_VALUE;
    private static final String DEFAULT_CACHE_SIZE_VALUE = "20";
    private static final String DEFAULT_LIMIT_SIZE_VALUE = "50";
    private final boolean useFileSystem;
    private final int cacheSize;
    private final int maxNumOfRoles;
    private final int maxNumOfPermissions;
    static /* synthetic */ Class class$com$ibm$sec$iauthz$runtime$RuntimeConfiguration;
    static /* synthetic */ Class class$com$ibm$sec$authz$provider$CommonAuthzPolicy;
    static /* synthetic */ Class class$com$ibm$sec$authz$provider$CommonAuthzRoleMapping;

    public RuntimeConfiguration(String string) {
        boolean bl;
        Object object;
        Object object2;
        Object object3;
        Properties properties = CommonAuthProperties.getProps();
        if (properties == null) {
            if (logger.isErrorLevel()) {
                logger.error("<init>", CommonAuthProperties.getErrMsg());
                object3 = CWRGSMessageHelper.getMessage("PE_COMMON_AUTHZ_PROPERTIES_IS_NULL");
                logger.error("<init>", (String)object3);
            }
            this.useFileSystem = true;
            this.cacheSize = Integer.parseInt(DEFAULT_CACHE_SIZE_VALUE);
            this.maxNumOfRoles = Integer.parseInt(DEFAULT_LIMIT_SIZE_VALUE);
            this.maxNumOfPermissions = Integer.parseInt(DEFAULT_LIMIT_SIZE_VALUE);
        } else {
            String string2;
            object3 = string.equals(POLICY) ? (class$com$ibm$sec$authz$provider$CommonAuthzPolicy == null ? (class$com$ibm$sec$authz$provider$CommonAuthzPolicy = RuntimeConfiguration.class$("com.ibm.sec.authz.provider.CommonAuthzPolicy")) : class$com$ibm$sec$authz$provider$CommonAuthzPolicy).getName() + USE_FILE_SYSTEM_SUFFIX : (class$com$ibm$sec$authz$provider$CommonAuthzRoleMapping == null ? (class$com$ibm$sec$authz$provider$CommonAuthzRoleMapping = RuntimeConfiguration.class$("com.ibm.sec.authz.provider.CommonAuthzRoleMapping")) : class$com$ibm$sec$authz$provider$CommonAuthzRoleMapping).getName() + USE_FILE_SYSTEM_SUFFIX;
            this.useFileSystem = Boolean.valueOf(properties.getProperty((String)object3, DEFAULT_USE_FILE_SYSTEM_VALUE));
            if (logger.isDebugLevel()) {
                string2 = CWRGSMessageHelper.getMessage("PE_CONFIG_PROPERTY", new Object[]{object3, Boolean.toString(this.useFileSystem)});
                logger.debug("<init>", string2);
            }
            string2 = string.equals(POLICY) ? (class$com$ibm$sec$authz$provider$CommonAuthzPolicy == null ? (class$com$ibm$sec$authz$provider$CommonAuthzPolicy = RuntimeConfiguration.class$("com.ibm.sec.authz.provider.CommonAuthzPolicy")) : class$com$ibm$sec$authz$provider$CommonAuthzPolicy).getName() + CACHE_SIZE_SUFFIX : (class$com$ibm$sec$authz$provider$CommonAuthzRoleMapping == null ? (class$com$ibm$sec$authz$provider$CommonAuthzRoleMapping = RuntimeConfiguration.class$("com.ibm.sec.authz.provider.CommonAuthzRoleMapping")) : class$com$ibm$sec$authz$provider$CommonAuthzRoleMapping).getName() + CACHE_SIZE_SUFFIX;
            this.cacheSize = Integer.parseInt(properties.getProperty(string2, DEFAULT_CACHE_SIZE_VALUE));
            if (logger.isDebugLevel()) {
                object2 = CWRGSMessageHelper.getMessage("PE_CONFIG_PROPERTY", new Object[]{string2, Integer.toString(this.cacheSize)});
                logger.debug("<init>", (String)object2);
            }
            object2 = string.equals(POLICY) ? (class$com$ibm$sec$authz$provider$CommonAuthzPolicy == null ? (class$com$ibm$sec$authz$provider$CommonAuthzPolicy = RuntimeConfiguration.class$("com.ibm.sec.authz.provider.CommonAuthzPolicy")) : class$com$ibm$sec$authz$provider$CommonAuthzPolicy).getName() + ROLE_LIMIT_SIZE_SUFFIX : (class$com$ibm$sec$authz$provider$CommonAuthzRoleMapping == null ? (class$com$ibm$sec$authz$provider$CommonAuthzRoleMapping = RuntimeConfiguration.class$("com.ibm.sec.authz.provider.CommonAuthzRoleMapping")) : class$com$ibm$sec$authz$provider$CommonAuthzRoleMapping).getName() + PRINCIPAL_LIMIT_SIZE_SUFFIX;
            this.maxNumOfRoles = Integer.parseInt(properties.getProperty((String)object2, DEFAULT_LIMIT_SIZE_VALUE));
            if (logger.isDebugLevel()) {
                object = CWRGSMessageHelper.getMessage("PE_CONFIG_PROPERTY", new Object[]{object2, Integer.toString(this.maxNumOfRoles)});
                logger.debug("<init>", (String)object);
            }
            object = string.equals(POLICY) ? (class$com$ibm$sec$authz$provider$CommonAuthzPolicy == null ? (class$com$ibm$sec$authz$provider$CommonAuthzPolicy = RuntimeConfiguration.class$("com.ibm.sec.authz.provider.CommonAuthzPolicy")) : class$com$ibm$sec$authz$provider$CommonAuthzPolicy).getName() + PERMISSION_LIMIT_SIZE_SUFFIX : (class$com$ibm$sec$authz$provider$CommonAuthzRoleMapping == null ? (class$com$ibm$sec$authz$provider$CommonAuthzRoleMapping = RuntimeConfiguration.class$("com.ibm.sec.authz.provider.CommonAuthzRoleMapping")) : class$com$ibm$sec$authz$provider$CommonAuthzRoleMapping).getName() + ROLE_CONDITION_LIMIT_SIZE_SUFFIX;
            this.maxNumOfPermissions = Integer.parseInt(properties.getProperty((String)object, DEFAULT_LIMIT_SIZE_VALUE));
            if (logger.isDebugLevel()) {
                String string3 = CWRGSMessageHelper.getMessage("PE_CONFIG_PROPERTY", new Object[]{object, Integer.toString(this.maxNumOfPermissions)});
                logger.debug("<init>", string3);
            }
        }
        try {
            object3 = AdapterUtils.getAdapter(properties);
            bl = string.equals(POLICY) ? !(object3 instanceof MemoryBackedAdapterImpl) : !(object3 instanceof MemoryBackedAdapterImpl) || this.useFileSystem;
        }
        catch (PolicyStoreException policyStoreException) {
            throw new RuntimeException(policyStoreException);
        }
        this.useRuntimeDir = bl;
        this.contextID2clientID = new Properties();
        if (this.useRuntimeDir) {
            if (!RuntimeFileUtils.exists(rootDir)) {
                RuntimeFileUtils.mkdirs(rootDir);
            }
            if (!RuntimeFileUtils.canRead(rootDir)) {
                object2 = CWRGSMessageHelper.getMessage("PE_READ_RUNTIME_DIR_ERROR", new Object[]{rootDir.getAbsolutePath()});
                if (logger.isErrorLevel()) {
                    logger.error("<init>", (String)object2);
                }
                throw new RuntimeException((String)object2);
            }
            if (!RuntimeFileUtils.canWrite(rootDir)) {
                object2 = CWRGSMessageHelper.getMessage("PE_WRITE_RUNTIME_DIR_ERROR", new Object[]{rootDir.getAbsolutePath()});
                if (logger.isErrorLevel()) {
                    logger.error("<init>", (String)object2);
                }
                throw new RuntimeException((String)object2);
            }
            if (!RuntimeFileUtils.isDirectory(rootDir)) {
                object2 = CWRGSMessageHelper.getMessage("PE_RUNTIME_DIR_IS_NOT_A_DIR", new Object[]{rootDir.getAbsolutePath()});
                if (logger.isErrorLevel()) {
                    logger.error("<init>", (String)object2);
                }
                throw new RuntimeException((String)object2);
            }
        }
        this.configDir = new File(rootDir, string);
        if (this.useRuntimeDir) {
            if (!RuntimeFileUtils.exists(this.configDir)) {
                RuntimeFileUtils.mkdirs(this.configDir);
            }
            if (!RuntimeFileUtils.canRead(this.configDir)) {
                object2 = CWRGSMessageHelper.getMessage("PE_READ_RUNTIME_DIR_ERROR", new Object[]{this.configDir.getAbsolutePath()});
                if (logger.isErrorLevel()) {
                    logger.error("<init>", (String)object2);
                }
                throw new RuntimeException((String)object2);
            }
            if (!RuntimeFileUtils.canWrite(this.configDir)) {
                object2 = CWRGSMessageHelper.getMessage("PE_WRITE_RUNTIME_DIR_ERROR", new Object[]{this.configDir.getAbsolutePath()});
                if (logger.isErrorLevel()) {
                    logger.error("<init>", (String)object2);
                }
                throw new RuntimeException((String)object2);
            }
            if (!RuntimeFileUtils.isDirectory(this.configDir)) {
                object2 = CWRGSMessageHelper.getMessage("PE_RUNTIME_DIR_IS_NOT_A_DIR", new Object[]{this.configDir.getAbsolutePath()});
                if (logger.isErrorLevel()) {
                    logger.error("<init>", (String)object2);
                }
                throw new RuntimeException((String)object2);
            }
        }
        if (this.useRuntimeDir && RuntimeFileUtils.exists((File)(object2 = new File(this.configDir, CLIENT_PROPERTIES)))) {
            object = RuntimeFileUtils.getFileInputStream((File)object2);
            try {
                this.contextID2clientID.load((InputStream)object);
            }
            catch (IOException iOException) {
                String string4 = CWRGSMessageHelper.getMessage("PE_FILE_INPUT_STREAM_READ_ERROR", new Object[]{((File)object2).getAbsolutePath()});
                if (logger.isErrorLevel()) {
                    logger.error("<init>", string4, iOException);
                }
                throw new RuntimeException(string4, iOException);
            }
            finally {
                try {
                    ((InputStream)object).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static File getRootDirectory() {
        return rootDir;
    }

    public File getDirectory() {
        return this.configDir;
    }

    public boolean useFileSystem() {
        return this.useFileSystem;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public int getRoleOrPrincipalLimitSize() {
        return this.maxNumOfRoles;
    }

    public int getPermissionOrRoleConditionLimitSize() {
        return this.maxNumOfPermissions;
    }

    public String getClientID(String string) {
        String string2;
        if (logger.isEntryLevel()) {
            logger.entry("getClientID", string);
        }
        if ((string2 = (String)this.contextID2clientID.get(string)) == null) {
            String string3 = null;
            boolean bl = false;
            for (int i = 0; i < 100; ++i) {
                Object object;
                block19: {
                    string3 = Uuid.generateUuid();
                    try {
                        bl = DataProcessingFactory.getFactory().isUniqueClientID(string, string3);
                    }
                    catch (DataProcessingException dataProcessingException) {
                        if (!logger.isErrorLevel()) break block19;
                        object = CWRGSMessageHelper.getMessage("PE_FAILED_TO_CHECK_UNIQUNESS", new Object[]{string});
                        logger.error("getClientID", (String)object, dataProcessingException);
                    }
                }
                if (!bl) continue;
                this.contextID2clientID.put(string, string3);
                if (!this.useRuntimeDir) break;
                File file = new File(this.configDir, CLIENT_PROPERTIES);
                object = RuntimeFileUtils.getFileOutputStream(file);
                try {
                    this.contextID2clientID.store((OutputStream)object, CLIENT_IDENTIFIERS);
                    break;
                }
                catch (IOException iOException) {
                    String string4 = CWRGSMessageHelper.getMessage("PE_FILE_INPUT_STREAM_READ_ERROR", new Object[]{file.getAbsolutePath()});
                    if (logger.isErrorLevel()) {
                        logger.error("getClientID", string4, iOException);
                    }
                    throw new RuntimeException(string4, iOException);
                }
                finally {
                    try {
                        ((OutputStream)object).flush();
                        ((OutputStream)object).close();
                    }
                    catch (IOException iOException) {}
                }
            }
            if (bl) {
                string2 = string3;
            } else {
                String string5 = CWRGSMessageHelper.getMessage("PE_FAILED_TO_CREATE_A_UNIQUNE_CLIENT_ID", new Object[]{string});
                if (logger.isErrorLevel()) {
                    logger.error("getClientID", string5);
                }
                throw new RuntimeException(string5);
            }
        }
        if (logger.isExitLevel()) {
            logger.exit("getClientID", string2);
        }
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static {
        String string;
        block11: {
            block12: {
                logger = SecLogger.getLogger(class$com$ibm$sec$iauthz$runtime$RuntimeConfiguration == null ? (class$com$ibm$sec$iauthz$runtime$RuntimeConfiguration = RuntimeConfiguration.class$("com.ibm.sec.iauthz.runtime.RuntimeConfiguration")) : class$com$ibm$sec$iauthz$runtime$RuntimeConfiguration);
                RUNTIME_DIR_PATH_SUFFIX = "ibmsecauthz" + File.separator + "runtime";
                Properties properties = CommonAuthProperties.getProps();
                if (properties == null) break block12;
                string = properties.getProperty(RUNTIME_DIR_CONFIG_PROPERTY);
                if (string != null) {
                    if (logger.isDebugLevel()) {
                        String string2 = CWRGSMessageHelper.getMessage("PE_CONFIG_PROPERTY", new Object[]{RUNTIME_DIR_CONFIG_PROPERTY, string});
                        logger.debug("static", string2);
                    }
                    rootDir = new File(string, RUNTIME_DIR_PATH_SUFFIX);
                    break block11;
                } else {
                    String string3 = System.getProperty(RUNTIME_DIR_SYSTEM_PROPERTY);
                    if (string3 != null) {
                        String string4;
                        if (logger.isDebugLevel()) {
                            string4 = CWRGSMessageHelper.getMessage("PE_SYSTEM_PROPERTY", new Object[]{RUNTIME_DIR_SYSTEM_PROPERTY, string3});
                            logger.debug("static", string4);
                        }
                        if ((string = System.getProperty(string3)) != null) {
                            if (logger.isDebugLevel()) {
                                string4 = CWRGSMessageHelper.getMessage("PE_SYSTEM_PROPERTY", new Object[]{string3, string});
                                logger.debug("static", string4);
                            }
                            rootDir = new File(string, RUNTIME_DIR_PATH_SUFFIX);
                            break block11;
                        } else {
                            string4 = CWRGSMessageHelper.getMessage("PE_SYSTEM_PROPERTY_NOT_SET", new Object[]{string3});
                            if (logger.isErrorLevel()) {
                                logger.error("static", string4);
                            }
                            throw new RuntimeException(string4);
                        }
                    }
                    rootDir = new File(CommonAuthProperties.getHome(), RUNTIME_DIR_PATH_SUFFIX);
                }
                break block11;
            }
            if (logger.isErrorLevel()) {
                logger.error("static", CommonAuthProperties.getErrMsg());
                string = CWRGSMessageHelper.getMessage("PE_COMMON_AUTHZ_PROPERTIES_IS_NULL");
                logger.error("static", string);
            }
            rootDir = new File(RUNTIME_DIR_PATH_SUFFIX);
        }
        if (logger.isDebugLevel()) {
            string = CWRGSMessageHelper.getMessage("PE_RUNTIME_DIR", new Object[]{rootDir.getAbsolutePath()});
            logger.debug("static", string);
        }
        DEFAULT_USE_FILE_SYSTEM_VALUE = Boolean.toString(true);
    }
}

