/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.iauthz.runtime;

import com.ibm.sec.iauthz.log.SecLogger;
import com.ibm.sec.iauthz.util.CWRGSMessageHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class RuntimeFileUtils {
    private static final SecLogger logger = SecLogger.getLogger(class$com$ibm$sec$iauthz$runtime$RuntimeFileUtils == null ? (class$com$ibm$sec$iauthz$runtime$RuntimeFileUtils = RuntimeFileUtils.class$("com.ibm.sec.iauthz.runtime.RuntimeFileUtils")) : class$com$ibm$sec$iauthz$runtime$RuntimeFileUtils);
    private static final SecurityManager sm = System.getSecurityManager();
    static /* synthetic */ Class class$com$ibm$sec$iauthz$runtime$RuntimeFileUtils;

    public static boolean exists(final File file) {
        if (sm != null) {
            try {
                Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() {
                        return RuntimeFileUtils._exists(file);
                    }
                });
                return bl;
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new RuntimeException(privilegedActionException);
            }
        }
        return RuntimeFileUtils._exists(file);
    }

    private static boolean _exists(File file) {
        return file.exists();
    }

    public static boolean isFile(final File file) {
        if (sm != null) {
            try {
                Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() {
                        return RuntimeFileUtils._isFile(file);
                    }
                });
                return bl;
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new RuntimeException(privilegedActionException);
            }
        }
        return RuntimeFileUtils._isFile(file);
    }

    private static boolean _isFile(File file) {
        return file.isFile();
    }

    public static boolean isDirectory(final File file) {
        if (sm != null) {
            try {
                Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() {
                        return RuntimeFileUtils._isDirectory(file);
                    }
                });
                return bl;
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new RuntimeException(privilegedActionException);
            }
        }
        return RuntimeFileUtils._isDirectory(file);
    }

    private static boolean _isDirectory(File file) {
        return file.isDirectory();
    }

    public static boolean canRead(final File file) {
        if (sm != null) {
            try {
                Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() {
                        return RuntimeFileUtils._canRead(file);
                    }
                });
                return bl;
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new RuntimeException(privilegedActionException);
            }
        }
        return RuntimeFileUtils._canRead(file);
    }

    private static boolean _canRead(File file) {
        return file.canRead();
    }

    public static boolean canWrite(final File file) {
        if (sm != null) {
            try {
                Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() {
                        return RuntimeFileUtils._canWrite(file);
                    }
                });
                return bl;
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new RuntimeException(privilegedActionException);
            }
        }
        return RuntimeFileUtils._canWrite(file);
    }

    private static boolean _canWrite(File file) {
        return file.canWrite();
    }

    public static File[] listFiles(final File file) {
        if (sm != null) {
            try {
                return (File[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() {
                        return RuntimeFileUtils._listFiles(file);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new RuntimeException(privilegedActionException);
            }
        }
        return RuntimeFileUtils._listFiles(file);
    }

    private static File[] _listFiles(File file) {
        return file.listFiles();
    }

    public static void deleteDirectory(final File file, final boolean bl) {
        if (sm != null) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() {
                        RuntimeFileUtils._deleteDirectory(file, bl);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new RuntimeException(privilegedActionException);
            }
        } else {
            RuntimeFileUtils._deleteDirectory(file, bl);
        }
    }

    private static void _deleteDirectory(File file, boolean bl) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                for (int i = 0; i < fileArray.length; ++i) {
                    if (fileArray[i].isDirectory()) {
                        RuntimeFileUtils.deleteDirectory(fileArray[i], false);
                        continue;
                    }
                    RuntimeFileUtils.deleteFile(fileArray[i]);
                }
            }
            if (!bl) {
                RuntimeFileUtils.deleteFile(file);
            }
        } else {
            RuntimeFileUtils.deleteFile(file);
        }
    }

    public static void deleteFile(final File file) {
        if (sm != null) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() {
                        RuntimeFileUtils._deleteFile(file);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new RuntimeException(privilegedActionException);
            }
        } else {
            RuntimeFileUtils._deleteFile(file);
        }
    }

    private static void _deleteFile(File file) {
        if (!file.exists()) {
            return;
        }
        boolean bl = file.delete();
        if (!bl) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            bl = file.delete();
            if (!bl && logger.isWarningLevel()) {
                String string = CWRGSMessageHelper.getMessage("PE_FILE_DELETION_ERROR", new Object[]{file.getAbsolutePath()});
                logger.warning("_deleteFile", string);
            }
        }
    }

    public static void mkdirs(final File file) {
        if (sm != null) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() {
                        RuntimeFileUtils._mkdirs(file);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new RuntimeException(privilegedActionException);
            }
        } else {
            RuntimeFileUtils._mkdirs(file);
        }
    }

    private static void _mkdirs(File file) {
        boolean bl = file.mkdirs();
        if (!bl) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            bl = file.mkdirs();
            if (!bl && logger.isWarningLevel()) {
                String string = CWRGSMessageHelper.getMessage("PE_MKDIRS_ERROR", new Object[]{file.getAbsolutePath()});
                logger.warning("_mkdirs", string);
            }
        }
    }

    public static OutputStream getFileOutputStream(final File file) {
        if (sm != null) {
            try {
                return (OutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() {
                        return RuntimeFileUtils._getFileOutputStream(file);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new RuntimeException(privilegedActionException);
            }
        }
        return RuntimeFileUtils._getFileOutputStream(file);
    }

    private static OutputStream _getFileOutputStream(File file) {
        try {
            return new BufferedOutputStream(new FileOutputStream(file));
        }
        catch (IOException iOException) {
            if (logger.isWarningLevel()) {
                String string = CWRGSMessageHelper.getMessage("PE_FILE_OUTPUT_STREAM_OPEN_ERROR", new Object[]{file.getAbsolutePath()});
                logger.warning("_getFileOutputStream", string, iOException);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                return new BufferedOutputStream(new FileOutputStream(file));
            }
            catch (IOException iOException2) {
                RuntimeException runtimeException = new RuntimeException(iOException2);
                if (logger.isErrorLevel()) {
                    String string = CWRGSMessageHelper.getMessage("PE_FILE_OUTPUT_STREAM_OPEN_ERROR", new Object[]{file.getAbsolutePath()});
                    logger.error("_getFileOutputStream", string, runtimeException);
                }
                throw runtimeException;
            }
        }
    }

    public static InputStream getFileInputStream(final File file) {
        if (sm != null) {
            try {
                return (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() {
                        return RuntimeFileUtils._getFileInputStream(file);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new RuntimeException(privilegedActionException);
            }
        }
        return RuntimeFileUtils._getFileInputStream(file);
    }

    private static InputStream _getFileInputStream(File file) {
        try {
            return new BufferedInputStream(new FileInputStream(file));
        }
        catch (IOException iOException) {
            if (logger.isWarningLevel()) {
                String string = CWRGSMessageHelper.getMessage("PE_FILE_INPUT_STREAM_OPEN_ERROR", new Object[]{file.getAbsolutePath()});
                logger.warning("_getFileInputStream", string, iOException);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                return new BufferedInputStream(new FileInputStream(file));
            }
            catch (IOException iOException2) {
                RuntimeException runtimeException = new RuntimeException(iOException2);
                if (logger.isErrorLevel()) {
                    String string = CWRGSMessageHelper.getMessage("PE_FILE_INPUT_STREAM_OPEN_ERROR", new Object[]{file.getAbsolutePath()});
                    logger.error("_getFileInputStream", string, runtimeException);
                }
                throw runtimeException;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

