/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.iauthz.runtime;

import com.ibm.sec.authz.jaccx.EvaluationContext;
import com.ibm.sec.authz.jaccx.condition.RequestContext;
import com.ibm.sec.authz.jaccx.resource.Resource;
import com.ibm.sec.authz.jaccx.resource.ResourceContext;
import com.ibm.sec.iauthz.log.SecLogger;
import com.ibm.sec.iauthz.util.CWRGSMessageHelper;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContextException;

public class RuntimeUtils {
    private static final SecLogger logger = SecLogger.getLogger(class$com$ibm$sec$iauthz$runtime$RuntimeUtils == null ? (class$com$ibm$sec$iauthz$runtime$RuntimeUtils = RuntimeUtils.class$("com.ibm.sec.iauthz.runtime.RuntimeUtils")) : class$com$ibm$sec$iauthz$runtime$RuntimeUtils);
    private static final String _2A = "%2A";
    private static final String STAR = "\\*";
    private static final String UTF_8 = "UTF-8";
    private static final String SUBJECT_KEY = "javax.security.auth.Subject.container";
    static /* synthetic */ Class class$com$ibm$sec$iauthz$runtime$RuntimeUtils;

    public static final String contextID2fileName(String string) {
        if (logger.isEntryLevel()) {
            logger.entry("contextID2fileName(String)", string);
        }
        try {
            String string2 = URLEncoder.encode(string, UTF_8);
            string2 = string2.replaceAll(STAR, _2A);
            if (logger.isExitLevel()) {
                logger.exit("contextID2fileName(String)", string2);
            }
            return string2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string3 = CWRGSMessageHelper.getMessage("PE_FAILED_TO_CONVERT_A_CONTEXT_ID", new Object[]{string});
            if (logger.isErrorLevel()) {
                logger.error("contextID2fileName(String)", string3, unsupportedEncodingException);
            }
            throw new RuntimeException(string3, unsupportedEncodingException);
        }
    }

    public static void dumpEvaluationContext(Object object, EvaluationContext evaluationContext) {
        if (!logger.isDebugLevel()) {
            return;
        }
        if (evaluationContext == null) {
            return;
        }
        Set set = evaluationContext.getKeys();
        Iterator iterator = set.iterator();
        Object object2 = null;
        Resource resource = null;
        Subject subject = null;
        RequestContext requestContext = null;
        ResourceContext resourceContext = null;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            object2 = null;
            try {
                object2 = evaluationContext.getContext(string);
            }
            catch (PolicyContextException policyContextException) {
                String string2 = CWRGSMessageHelper.getMessage("PE_FAILED_TO_GET_POLICY_CONTEXT_OBJECT", new Object[]{string, object.toString()});
                logger.warning("dumpEvaluationContext", string2, policyContextException);
            }
            if (object2 == null) continue;
            String string3 = CWRGSMessageHelper.getMessage("PE_POLICY_CONTEXT_OBJECT", new Object[]{string, object2});
            logger.debug("dumpEvaluationContext", string3);
            if (string.equals(Resource.JACC_RESOURCE_KEY)) {
                resource = object2 instanceof Resource ? (Resource)object2 : null;
            }
            if (string.equals(ResourceContext.JACC_RESOURCE_CONTEXT_KEY)) {
                resourceContext = object2 instanceof ResourceContext ? (ResourceContext)object2 : null;
            }
            if (string.equals(RequestContext.JACC_REQUEST_CONTEXT_KEY)) {
                requestContext = object2 instanceof RequestContext ? (RequestContext)object2 : null;
            }
            if (!string.equals(SUBJECT_KEY)) continue;
            if (object2 instanceof Subject) {
                subject = (Subject)object2;
                continue;
            }
            subject = null;
        }
        if (requestContext != null) {
            RuntimeUtils.dumpRequestContext(requestContext);
        }
        if (resourceContext != null) {
            RuntimeUtils.dumpResourceContext(resourceContext, resource, subject);
        }
    }

    private static void dumpResourceContext(ResourceContext resourceContext, Resource resource, Subject subject) {
        Set set = resourceContext.getAttributeNames();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object object = resourceContext.getAttribute(resource, string, subject);
            if (object == null) continue;
            String string2 = CWRGSMessageHelper.getMessage("PE_RESOURCE_ATTRIBUTE", new Object[]{string, object});
            logger.debug("dumpResourceContext", string2);
        }
    }

    private static void dumpRequestContext(RequestContext requestContext) {
        Set set = requestContext.getAttributeNames();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object object = requestContext.getAttribute(string);
            if (object == null) continue;
            String string2 = CWRGSMessageHelper.getMessage("PE_REQUEST_ATTRIBUTE", new Object[]{string, object});
            logger.debug("dumpRequstContext", string2);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

