/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.iauthz.runtime.algorithm;

import com.ibm.sec.auth.subjectx.SubjectAttributes;
import com.ibm.sec.auth.subjectx.VirtualPrincipal;
import com.ibm.sec.authz.jaccx.EvaluationContext;
import com.ibm.sec.authz.jaccx.resource.Resource;
import com.ibm.sec.iauthz.log.SecLogger;
import com.ibm.sec.iauthz.runtime.OptimizedRoleMappingConfiguration;
import com.ibm.sec.iauthz.runtime.algorithm.CombiningAlgorithm;
import com.ibm.sec.iauthz.util.CWRGSMessageHelper;
import com.ibm.sec.iauthz.util.CollectionFactory;
import java.security.Principal;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContextException;

public abstract class AbstractCombiningAlgorithm
implements CombiningAlgorithm {
    private static final SecLogger logger = SecLogger.getLogger(class$com$ibm$sec$iauthz$runtime$algorithm$AbstractCombiningAlgorithm == null ? (class$com$ibm$sec$iauthz$runtime$algorithm$AbstractCombiningAlgorithm = AbstractCombiningAlgorithm.class$("com.ibm.sec.iauthz.runtime.algorithm.AbstractCombiningAlgorithm")) : class$com$ibm$sec$iauthz$runtime$algorithm$AbstractCombiningAlgorithm);
    protected final OptimizedRoleMappingConfiguration ormc;
    private static final SubjectAttributes defaultSubjectAttributes = new SubjectAttributes();
    private static final String SUBJECT_KEY = "javax.security.auth.Subject.container";
    static /* synthetic */ Class class$com$ibm$sec$iauthz$runtime$algorithm$AbstractCombiningAlgorithm;

    AbstractCombiningAlgorithm(OptimizedRoleMappingConfiguration optimizedRoleMappingConfiguration) {
        this.ormc = optimizedRoleMappingConfiguration;
    }

    static Principal getUserPrincipal(Subject subject, SubjectAttributes subjectAttributes) {
        if (logger.isEntryLevel()) {
            logger.entry("getUserPrincipal", subject);
        }
        Principal principal = (Principal)subjectAttributes.getAttribute(subject, "user");
        if (logger.isDebugLevel()) {
            String string = principal != null ? CWRGSMessageHelper.getMessage("PE_USER_PRINCIPAL", new Object[]{principal}) : CWRGSMessageHelper.getMessage("PE_NO_USER_PRINCIPAL");
            logger.debug("getUserPrincipal", string);
        }
        if (logger.isExitLevel()) {
            logger.exit("getUserPrincipal", principal);
        }
        return principal;
    }

    static Set getGroupPrincipals(Subject subject, SubjectAttributes subjectAttributes) {
        Object object;
        if (logger.isEntryLevel()) {
            logger.entry("getGroupPrincipals", subject);
        }
        Set set = (Set)subjectAttributes.getAttribute(subject, "group");
        if (logger.isDebugLevel()) {
            object = set != null ? CWRGSMessageHelper.getMessage("PE_GROUP_PRINCIPAL", new Object[]{set}) : CWRGSMessageHelper.getMessage("PE_NO_GROUP_PRINCIPAL");
            logger.debug("getGroupPrincipals", (String)object);
        }
        object = AbstractCombiningAlgorithm.getUserPrincipal(subject, subjectAttributes);
        if (set == null) {
            set = CollectionFactory.newSet();
        }
        set.add(VirtualPrincipal.Everyone);
        if (object != null && !object.equals(VirtualPrincipal.AnonymousUser)) {
            set.add(VirtualPrincipal.AllAuthenticatedUsers);
        }
        if (logger.isExitLevel()) {
            logger.exit("getGroupPrincipals", set);
        }
        return set;
    }

    static Subject getSubject(EvaluationContext evaluationContext) {
        try {
            return (Subject)evaluationContext.getContext(SUBJECT_KEY);
        }
        catch (PolicyContextException policyContextException) {
            return null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    static SubjectAttributes getSubjectAttributes(EvaluationContext evaluationContext) {
        try {
            if (evaluationContext.getKeys().contains(SubjectAttributes.JACC_SUBJECT_ATTRIBUTES_KEY)) {
                return (SubjectAttributes)evaluationContext.getContext(SubjectAttributes.JACC_SUBJECT_ATTRIBUTES_KEY);
            }
            return defaultSubjectAttributes;
        }
        catch (PolicyContextException policyContextException) {
            return null;
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class ContextImpl
    implements EvaluationContext {
        private final EvaluationContext evaluationContext;
        private Resource resource;

        ContextImpl(EvaluationContext evaluationContext) {
            this.evaluationContext = evaluationContext;
        }

        void setResource(Resource resource) {
            this.resource = resource;
        }

        public Object getContext(String string) throws PolicyContextException {
            if (string.equals(Resource.JACC_RESOURCE_KEY)) {
                return this.resource;
            }
            return this.evaluationContext.getContext(string);
        }

        public Set getKeys() {
            return this.evaluationContext.getKeys();
        }
    }
}

