/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.iauthz.runtime.algorithm;

import com.ibm.sec.authz.jaccx.EvaluationContext;
import com.ibm.sec.authz.jaccx.role.RoleAssignmentCondition;
import com.ibm.sec.authz.jaccx.role.RoleBlockCondition;
import com.ibm.sec.authz.jaccx.role.RoleCondition;
import com.ibm.sec.iauthz.util.CollectionFactory;
import java.io.Serializable;
import java.security.Principal;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;

public final class OptimizedRoleConditionCollection
implements Serializable {
    private static final long serialVersionUID = -274531522742071364L;
    private final Set roleBlockConditionSet;
    private final Set roleAssignmentConditionSet;
    private Object[] mostSpecificBlockOverridesArray;
    private Object[] mostSpecificAssignmentOverridesArray;

    public OptimizedRoleConditionCollection(Set set, Set set2) {
        this.roleBlockConditionSet = set;
        this.roleAssignmentConditionSet = set2;
        this.updateSortedRoleConditions();
    }

    public Set getRoleBlockConditionSet() {
        return this.roleBlockConditionSet;
    }

    public Set getRoleAssignmentConditionSet() {
        return this.roleAssignmentConditionSet;
    }

    public Object[] getMostSpecificBlockOverridesArray() {
        return this.mostSpecificBlockOverridesArray;
    }

    public Object[] getMostSpecificAssignmentOverridesArray() {
        return this.mostSpecificAssignmentOverridesArray;
    }

    public boolean contains(Principal principal, RoleCondition roleCondition) {
        if (roleCondition instanceof RoleAssignmentCondition) {
            return this.getRoleAssignmentConditionSet().contains(roleCondition);
        }
        if (roleCondition instanceof RoleBlockCondition) {
            return this.getRoleBlockConditionSet().contains(roleCondition);
        }
        return false;
    }

    public void updateSortedRoleConditions() {
        Set set = CollectionFactory.newSet();
        set.addAll(this.roleAssignmentConditionSet);
        set.addAll(this.roleBlockConditionSet);
        Set set2 = OptimizedRoleConditionCollection.convertForAssignmentOverrides(set);
        Object[] objectArray = set2.toArray();
        Arrays.sort(objectArray);
        this.mostSpecificAssignmentOverridesArray = objectArray;
        set2 = OptimizedRoleConditionCollection.convertForBlockOverrides(set);
        objectArray = set2.toArray();
        Arrays.sort(objectArray);
        this.mostSpecificBlockOverridesArray = objectArray;
    }

    private static final Set convertForBlockOverrides(Set set) {
        Set set2 = CollectionFactory.newSet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            RoleCondition roleCondition = (RoleCondition)iterator.next();
            set2.add(new BlockOverridesComparableRoleCondition(roleCondition));
        }
        return set2;
    }

    private static final Set convertForAssignmentOverrides(Set set) {
        Set set2 = CollectionFactory.newSet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            RoleCondition roleCondition = (RoleCondition)iterator.next();
            set2.add(new AssignmentOverridesComparableRoleCondition(roleCondition));
        }
        return set2;
    }

    private static final class BlockOverridesComparableRoleCondition
    extends ComparableRoleCondition {
        private static final long serialVersionUID = 7478657917393085495L;

        public BlockOverridesComparableRoleCondition(RoleCondition roleCondition) {
            super(roleCondition);
        }

        int compare(boolean bl, boolean bl2) {
            if (bl && !bl2) {
                return 1;
            }
            if (!bl && bl2) {
                return -1;
            }
            return 0;
        }
    }

    private static final class AssignmentOverridesComparableRoleCondition
    extends ComparableRoleCondition {
        private static final long serialVersionUID = 3507483410500422741L;

        public AssignmentOverridesComparableRoleCondition(RoleCondition roleCondition) {
            super(roleCondition);
        }

        int compare(boolean bl, boolean bl2) {
            if (bl && !bl2) {
                return -1;
            }
            if (!bl && bl2) {
                return 1;
            }
            return 0;
        }
    }

    public static abstract class ComparableRoleCondition
    implements Comparable,
    Serializable {
        private static final long serialVersionUID = 7801430087144972033L;
        static final int ASSIGNMENT = 1;
        static final int BLOCK = 2;
        static final int NOT_APPLICABLE = 3;
        private final RoleCondition roleCondition;
        private final boolean ruling;

        ComparableRoleCondition(RoleCondition roleCondition) {
            this.roleCondition = roleCondition;
            this.ruling = this.roleCondition instanceof RoleAssignmentCondition;
        }

        abstract int compare(boolean var1, boolean var2);

        public int compareTo(Object object) {
            ComparableRoleCondition comparableRoleCondition = (ComparableRoleCondition)object;
            int n = this.roleCondition.getSpecificationLevel() - comparableRoleCondition.roleCondition.getSpecificationLevel();
            if (n == 0) {
                return this.compare(this.ruling, comparableRoleCondition.ruling);
            }
            return n;
        }

        int checkRoleMembership(String string, EvaluationContext evaluationContext) {
            if (this.ruling) {
                boolean bl = ((RoleAssignmentCondition)this.roleCondition).assigns(string, evaluationContext);
                if (bl) {
                    return 1;
                }
                return 3;
            }
            boolean bl = ((RoleBlockCondition)this.roleCondition).blocks(string, evaluationContext);
            if (bl) {
                return 2;
            }
            return 3;
        }

        Iterator getResources(String string, EvaluationContext evaluationContext) {
            if (this.roleCondition instanceof RoleAssignmentCondition) {
                return ((RoleAssignmentCondition)this.roleCondition).getResources(string, evaluationContext);
            }
            return null;
        }

        public boolean equals(Object object) {
            if (object instanceof ComparableRoleCondition) {
                ComparableRoleCondition comparableRoleCondition = (ComparableRoleCondition)object;
                return this.ruling == comparableRoleCondition.ruling && this.roleCondition.equals(comparableRoleCondition.roleCondition);
            }
            return false;
        }

        public int hashCode() {
            if (this.ruling) {
                return this.roleCondition.hashCode();
            }
            return this.roleCondition.hashCode() * -1;
        }
    }
}

