/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.iauthz.storage;

import com.ibm.sec.iauthz.log.SecLogger;
import com.ibm.sec.iauthz.mcc.DataProcessingConstants;
import com.ibm.sec.iauthz.mcc.engine.MCCStoreHandler;
import com.ibm.sec.iauthz.storage.StoreRecordQuery;
import com.ibm.sec.iauthz.storage.adapter.AdapterException;
import com.ibm.sec.iauthz.storage.adapter.AdapterResultSet;
import com.ibm.sec.iauthz.util.CWRGSMessageHelper;
import com.ibm.sec.iauthz.util.MCCException;
import com.ibm.sec.iauthz.util.StoreRecordUtil;
import java.util.Iterator;
import java.util.Set;

public class PagedResultSet {
    private static final String PagedResultSet_java_sourceCodeID = "$Id: @(#)71  1.8 src/ws/code/argus/src/com/ibm/sec/iauthz/storage/PagedResultSet.java, argus.store, argus600, 051020a 05/08/26 15:55:58 @(#) $";
    private static SecLogger logger = SecLogger.getLogger(class$com$ibm$sec$iauthz$storage$PagedResultSet == null ? (class$com$ibm$sec$iauthz$storage$PagedResultSet = PagedResultSet.class$("com.ibm.sec.iauthz.storage.PagedResultSet")) : class$com$ibm$sec$iauthz$storage$PagedResultSet);
    protected boolean doAdd_ = false;
    protected boolean autoFetch_ = false;
    protected boolean firstPage_ = true;
    protected Set set_ = null;
    protected Iterator iterator_ = null;
    protected AdapterResultSet rs_;
    private StoreRecordQuery query_ = null;
    private String queryType_ = null;
    private MCCStoreHandler mccStoreHandler = new MCCStoreHandler();
    boolean deltaExtract = false;
    static /* synthetic */ Class class$com$ibm$sec$iauthz$storage$PagedResultSet;

    public PagedResultSet(AdapterResultSet adapterResultSet) throws AdapterException {
        this.rs_ = adapterResultSet;
        this.setPage(this.rs_.first());
        this.firstPage_ = true;
    }

    public PagedResultSet(AdapterResultSet adapterResultSet, StoreRecordQuery storeRecordQuery) throws AdapterException {
        this.query_ = storeRecordQuery;
        this.queryType_ = storeRecordQuery.getType();
        if (this.queryType_.equals(DataProcessingConstants.DDO_XMT_TYPE)) {
            this.deltaExtract = true;
        }
        this.rs_ = adapterResultSet;
        if (this.deltaExtract) {
            this.setPage(this.wrapSetWithDeltas(this.rs_.first()));
        } else {
            this.setPage(this.rs_.first());
        }
        this.firstPage_ = true;
    }

    public void close() {
        this.rs_.close();
    }

    public void setAutoFetch(boolean bl) {
        this.autoFetch_ = bl;
    }

    public boolean getAutoFetch() {
        return this.autoFetch_;
    }

    public int size() {
        if (this.set_ == null) {
            return 0;
        }
        return this.set_.size();
    }

    public boolean isEmpty() {
        if (this.set_ == null) {
            return true;
        }
        return this.set_.isEmpty();
    }

    public boolean contains(Object object) {
        return this.set_.contains(object);
    }

    public boolean hasNext() {
        return this.iterator_ != null && this.iterator_.hasNext();
    }

    public void first() throws AdapterException {
        if (this.firstPage_) {
            this.setPage(this.set_);
        } else {
            if (this.autoFetch_) {
                if (this.deltaExtract) {
                    this.setPage(this.wrapSetWithDeltas(this.rs_.first()));
                } else {
                    this.setPage(this.rs_.first());
                }
            }
            this.firstPage_ = true;
        }
    }

    public Object next() throws AdapterException {
        if (this.set_ == null && this.autoFetch_) {
            Set set = this.rs_.getNextPage();
            if (this.deltaExtract) {
                set = this.wrapSetWithDeltas(set);
            }
            this.setPage(set);
        }
        if (this.set_ == null) {
            return null;
        }
        return this.iterator_.next();
    }

    public void firstPage() throws AdapterException {
        if (!this.firstPage_) {
            if (this.deltaExtract) {
                this.setPage(this.wrapSetWithDeltas(this.rs_.first()));
            } else {
                this.setPage(this.rs_.first());
            }
        }
        this.first();
    }

    public void nextPage() throws AdapterException {
        Set set = this.rs_.getNextPage();
        if (this.deltaExtract) {
            set = this.wrapSetWithDeltas(set);
        }
        if (this.set_ == null || !this.doAdd_) {
            this.setPage(set);
        } else {
            this.set_.addAll(set);
        }
    }

    public boolean hasNextPage() {
        return this.rs_ != null && this.rs_.hasMore();
    }

    protected void setPage(Set set) {
        String string = "setPage( Set )";
        logger.entry(string, set);
        if (set == null) {
            this.set_ = null;
            this.iterator_ = null;
            return;
        }
        if (set != this.set_) {
            try {
                this.set_ = this.mccStoreHandler.getXMT(set, this.queryType_);
            }
            catch (MCCException mCCException) {
                String string2 = CWRGSMessageHelper.getMessage("WARNING_STORAGE_SET_RESULT_PAGE", new Object[]{mCCException.getMessage()});
                logger.warning(string, string2);
                this.set_ = null;
            }
        }
        if (this.set_ != null) {
            this.iterator_ = this.set_.iterator();
        }
        logger.exit(string);
    }

    private Set wrapSetWithDeltas(Set set) {
        Set set2 = null;
        if (set != null) {
            set2 = StoreRecordUtil.wrapInDelta(set, logger);
        }
        return set2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

