/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.iauthz.storage;

import com.ibm.sec.iauthz.log.SecLogger;
import com.ibm.sec.iauthz.mcc.DataProcessingConstants;
import com.ibm.sec.iauthz.mcc.DataProcessingException;
import com.ibm.sec.iauthz.mcc.MCCUtil;
import com.ibm.sec.iauthz.mcc.dna.GenericTransform;
import com.ibm.sec.iauthz.mcc.dna.XMTObject;
import com.ibm.sec.iauthz.mcc.engine.MCCJavaHandler;
import com.ibm.sec.iauthz.mcc.engine.MCCStoreHandler;
import com.ibm.sec.iauthz.storage.ClientSession;
import com.ibm.sec.iauthz.storage.ConfigTableEntry;
import com.ibm.sec.iauthz.storage.PagedResultSet;
import com.ibm.sec.iauthz.storage.PolicyStore;
import com.ibm.sec.iauthz.storage.PolicyStoreException;
import com.ibm.sec.iauthz.storage.StoreRecord;
import com.ibm.sec.iauthz.storage.StoreRecordQuery;
import com.ibm.sec.iauthz.storage.adapter.AdapterException;
import com.ibm.sec.iauthz.storage.adapter.AdapterResultSet;
import com.ibm.sec.iauthz.storage.adapter.IPolicyAdapter;
import com.ibm.sec.iauthz.storage.adapter.StorageAdapter;
import com.ibm.sec.iauthz.util.CWRGSMessageHelper;
import com.ibm.sec.iauthz.util.CollectionFactory;
import com.ibm.sec.iauthz.util.MCCException;
import com.ibm.sec.iauthz.util.StoreRecordUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class PolicySet {
    private static final String PolicySet_java_sourceCodeID = "$Id: @(#)73  1.19 src/ws/code/argus/src/com/ibm/sec/iauthz/storage/PolicySet.java, argus.store, argus600, 051020a 05/09/30 14:08:32 @(#) $";
    private static SecLogger logger = SecLogger.getLogger(class$com$ibm$sec$iauthz$storage$PolicySet == null ? (class$com$ibm$sec$iauthz$storage$PolicySet = PolicySet.class$("com.ibm.sec.iauthz.storage.PolicySet")) : class$com$ibm$sec$iauthz$storage$PolicySet);
    private IPolicyAdapter adapter_ = null;
    private ClientSession session_ = null;
    private PolicyStore parent_;
    private MCCStoreHandler mccHandler_ = new MCCStoreHandler();
    private MCCJavaHandler mccJavaHandler_ = null;
    static /* synthetic */ Class class$com$ibm$sec$iauthz$storage$PolicySet;

    public PolicySet(PolicyStore policyStore, StorageAdapter storageAdapter, ClientSession clientSession) throws PolicyStoreException {
        String string = "PolicySet( PolicyStore, StorageAdapter, ClientSession )";
        logger.entry(string, new Object[]{policyStore, storageAdapter, clientSession});
        this.parent_ = policyStore;
        this.setImpl(storageAdapter);
        this.session_ = clientSession;
        try {
            this.mccJavaHandler_ = new MCCJavaHandler();
        }
        catch (MCCException mCCException) {
            String string2 = CWRGSMessageHelper.getMessage("ERROR_GETTING_MCCJAVAHANDLER_INSTANCE", new Object[]{mCCException.getMessage()});
            logger.error(string, string2, mCCException);
            throw new PolicyStoreException(string2, mCCException);
        }
        logger.exit(string);
    }

    protected IPolicyAdapter getImpl() {
        return this.adapter_;
    }

    protected void setImpl(IPolicyAdapter iPolicyAdapter) {
        this.adapter_ = iPolicyAdapter;
    }

    protected abstract String getTableID(ConfigTableEntry var1);

    protected abstract void setTableID(ConfigTableEntry var1, String var2);

    protected abstract String generateTableID(String var1);

    protected abstract ConfigTableEntry newConfigEntry(String var1);

    protected abstract ConfigTableEntry getConfigEntry(String var1) throws PolicyStoreException;

    protected abstract boolean isPolicy();

    public String getContextID() {
        return this.session_.getContextID();
    }

    public String getClientID() {
        return this.session_.getClientID();
    }

    protected ClientSession getClientSession() {
        return this.session_;
    }

    void initSession() throws PolicyStoreException {
        if (!this.isValid()) {
            this.connect();
        }
    }

    protected synchronized void connect() throws PolicyStoreException {
        String string = "connect()";
        logger.entry(string);
        String string2 = this.session_.getClientID();
        String string3 = this.session_.getContextID();
        if (string2 == null) {
            String string4 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_NO_CLIENT_ID");
            logger.error(string, string4);
            throw new PolicyStoreException(string4);
        }
        if (string3 == null) {
            String string5 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_NO_CONTEXT_ID");
            logger.error(string, string5);
            throw new PolicyStoreException(string5);
        }
        logger.debug(string, "Connecting client " + string2);
        logger.debug(string, "Connecting context " + string3);
        this.session_.connect();
        logger.exit(string);
    }

    public boolean isValid() throws PolicyStoreException {
        boolean bl = false;
        if (this.session_.isOpen() && this.session_.isValid()) {
            bl = true;
        }
        return bl;
    }

    public String getMasterVersion() throws PolicyStoreException {
        this.initSession();
        return this.adapter_.policyGetMasterVersion(this.session_.nativeSession_);
    }

    public boolean isCurrent() throws PolicyStoreException {
        return this.isValid() && StoreRecordUtil.compareVersions(this.getVersion(), this.getMasterVersion(), logger) != 2;
    }

    public String getVersion() {
        return this.session_.nativeSession_.getEffectiveVersion();
    }

    public PagedResultSet getFullPolicy(StoreRecordQuery storeRecordQuery, boolean bl) throws PolicyStoreException {
        String string = "getFullPolicy( StoreRecordQuery, boolean )";
        logger.entry(string, new Object[]{storeRecordQuery, bl});
        this.initSession();
        PagedResultSet pagedResultSet = null;
        AdapterResultSet adapterResultSet = this.adapter_.policyGetFull(this.session_.nativeSession_, storeRecordQuery, bl);
        try {
            pagedResultSet = new PagedResultSet(adapterResultSet, storeRecordQuery);
        }
        catch (AdapterException adapterException) {
            String string2 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_CREATE_RESULT_SET", new Object[]{adapterException.getMessage()});
            logger.error(string, string2, adapterException);
            throw new PolicyStoreException(string2, adapterException);
        }
        logger.exit(string, pagedResultSet);
        return pagedResultSet;
    }

    public void updatePolicy(XMTObject xMTObject) throws PolicyStoreException {
        this.initSession();
        Set set = CollectionFactory.newSet();
        set.add(xMTObject);
        this.updatePolicy(set);
    }

    public void updatePolicy(Collection collection) throws PolicyStoreException {
        this.updatePolicy(collection, true);
    }

    public void updatePolicy(Collection collection, boolean bl) throws PolicyStoreException {
        this.updatePolicy(collection, bl, false);
    }

    public void updatePolicy(Collection collection, boolean bl, boolean bl2) throws PolicyStoreException {
        Object object;
        Iterator<Object> iterator;
        Object object2;
        String string = "updatePolicy( Collection, boolean, boolean )";
        logger.entry(string);
        this.initSession();
        Set set = CollectionFactory.newSet();
        Object object3 = collection.iterator();
        while (object3.hasNext()) {
            object2 = (XMTObject)object3.next();
            try {
                iterator = this.mccHandler_.getSR((XMTObject)object2);
                set.addAll(iterator);
            }
            catch (MCCException mCCException) {
                String string2 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_UPDATE_POLICY_CONVERT_TO_SR", new Object[]{mCCException.getMessage()});
                logger.error(string, string2, mCCException);
                throw new PolicyStoreException(string2, mCCException);
            }
        }
        object3 = CollectionFactory.newSet();
        object2 = CollectionFactory.newSet();
        if (!bl) {
            Object object4;
            Object object5;
            Object object6;
            Object[] objectArray;
            iterator = CollectionFactory.newSet();
            object = collection.iterator();
            while (object.hasNext()) {
                XMTObject xMTObject = (XMTObject)object.next();
                objectArray = null;
                try {
                    objectArray = this.mccJavaHandler_.constructFromXMT(xMTObject);
                }
                catch (MCCException mCCException) {
                    String string3 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_UPDATE_POLICY_CONVERT_TO_JAVA", new Object[]{mCCException.getMessage()});
                    logger.error(string, string3, mCCException);
                    throw new PolicyStoreException(string3, mCCException);
                }
                if (objectArray == null || objectArray.length <= 0 || objectArray[0] == null) continue;
                iterator.add(objectArray[0]);
            }
            object = CollectionFactory.newSet();
            boolean bl3 = true;
            objectArray = iterator.iterator();
            while (objectArray.hasNext()) {
                try {
                    object6 = (GenericTransform)objectArray.next();
                    if (bl3 && ((GenericTransform)object6).getValue() != null) {
                        logger.debug(string, "GenericTransform has a value. Setting flag to match all linked records before delete.");
                        bl3 = false;
                    }
                    object5 = MCCUtil.getQuery((GenericTransform)object6, this.isPolicy());
                    object4 = this.adapter_.policyGetFull(this.session_.nativeSession_, (StoreRecordQuery)object5, false);
                    object.addAll(((AdapterResultSet)object4).first());
                    while (((AdapterResultSet)object4).hasMore()) {
                        object.addAll(((AdapterResultSet)object4).getNextPage());
                    }
                    if (object4 == null) continue;
                    ((AdapterResultSet)object4).close();
                }
                catch (DataProcessingException dataProcessingException) {
                    object5 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_UPDATE_POLICY_SEARCH_EXCEPTION", new Object[]{dataProcessingException.getMessage()});
                    logger.error(string, (String)object5, dataProcessingException);
                }
                catch (AdapterException adapterException) {
                    object5 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_UPDATE_POLICY_SEARCH_EXCEPTION", new Object[]{adapterException.getMessage()});
                    logger.error(string, (String)object5, adapterException);
                }
            }
            object6 = StoreRecordUtil.groupStoreRecords(set, logger);
            object5 = object6.iterator();
            while (object5.hasNext()) {
                StoreRecord storeRecord;
                object4 = (Map)object5.next();
                Set set2 = (Set)object4.get("RECORDS");
                Set set3 = StoreRecordUtil.doRecordsExist((Set)object, set2, storeRecord = StoreRecordUtil.getFirstStoreRecord(set2, logger), bl3, logger);
                if (set3 != null && !set3.isEmpty()) {
                    Iterator iterator2 = set3.iterator();
                    while (iterator2.hasNext()) {
                        StoreRecord storeRecord2 = (StoreRecord)iterator2.next();
                        if (storeRecord2 == null) continue;
                        Set set4 = StoreRecordUtil.getLevelRecords((Set)object, storeRecord2, logger);
                        Iterator iterator3 = set4.iterator();
                        while (iterator3.hasNext()) {
                            StoreRecord storeRecord3 = (StoreRecord)iterator3.next();
                            object2.add(storeRecord3);
                            Set set5 = StoreRecordUtil.getRelatedRecords((Set)object, storeRecord3, logger);
                            object2.addAll(set5);
                        }
                    }
                    continue;
                }
                logger.debug(string, "No records to delete.");
            }
        }
        iterator = null;
        iterator = bl ? set.iterator() : object2.iterator();
        while (iterator.hasNext()) {
            object = (StoreRecord)iterator.next();
            ((StoreRecord)object).setAction(bl ? 1 : 2);
            if (!((StoreRecord)object).getClassname().equals(DataProcessingConstants.CACN)) continue;
            ((StoreRecord)object).setXMTID(DataProcessingConstants.CA_XMT_ID);
        }
        if (bl) {
            set.addAll(object3);
            this.adapter_.policyUpdate(this.session_.nativeSession_, set);
        } else {
            this.adapter_.policyUpdate(this.session_.nativeSession_, (Set)object2);
        }
        if (bl2) {
            logger.debug(string, "Auto-saving.");
            this.internalSave(false);
        }
        logger.exit(string);
    }

    public void deletePolicy(StoreRecordQuery storeRecordQuery) throws PolicyStoreException {
        this.deletePolicy(storeRecordQuery, false);
    }

    public void deletePolicy(StoreRecordQuery storeRecordQuery, boolean bl) throws PolicyStoreException {
        String string = "deletePolicy( StoreRecordQuery, boolean )";
        logger.entry(string, new Object[]{storeRecordQuery, bl});
        this.initSession();
        AdapterResultSet adapterResultSet = null;
        try {
            adapterResultSet = this.adapter_.policyGetFull(this.session_.nativeSession_, storeRecordQuery, false);
            while (adapterResultSet.hasMore()) {
                Set set = adapterResultSet.getNextPage();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    StoreRecord storeRecord = (StoreRecord)iterator.next();
                    storeRecord.setAction(2);
                }
                this.adapter_.policyUpdate(this.session_.nativeSession_, set);
            }
            if (bl) {
                this.adapter_.policyCommit(this.session_.nativeSession_, false);
            }
        }
        catch (PolicyStoreException policyStoreException) {
            String string2 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_DELETE_POLICY_EXCEPTION", new Object[]{policyStoreException.getMessage()});
            logger.error(string, string2, policyStoreException);
            throw policyStoreException;
        }
        catch (AdapterException adapterException) {
            String string3 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_DELETE_POLICY_EXCEPTION", new Object[]{adapterException.getMessage()});
            logger.error(string, string3, adapterException);
            throw new PolicyStoreException(string3, adapterException);
        }
        finally {
            if (adapterResultSet != null) {
                adapterResultSet.close();
            }
        }
        logger.exit(string);
    }

    public PagedResultSet getDeltaPolicy(StoreRecordQuery storeRecordQuery) throws PolicyStoreException {
        String string = "getDeltaPolicy( StoreRecordQuery )";
        logger.entry(string, storeRecordQuery);
        this.initSession();
        PagedResultSet pagedResultSet = null;
        AdapterResultSet adapterResultSet = this.adapter_.policyGetDelta(this.session_.nativeSession_, this.session_.getDbVersion(), storeRecordQuery);
        try {
            storeRecordQuery.setType(DataProcessingConstants.DDO_XMT_TYPE);
            pagedResultSet = new PagedResultSet(adapterResultSet, storeRecordQuery);
        }
        catch (AdapterException adapterException) {
            String string2 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_GET_DELTA_EXCEPTION", new Object[]{adapterException.getMessage()});
            logger.error(string, string2, adapterException);
            throw new PolicyStoreException(string2, adapterException);
        }
        logger.exit(string, pagedResultSet);
        return pagedResultSet;
    }

    public void destroyPolicy() throws PolicyStoreException {
        if (this.session_.isOpen()) {
            this.getImpl().policyDestroy(this.session_.nativeSession_);
            this.session_.disconnect();
        }
    }

    public void save(boolean bl) throws PolicyStoreException {
        this.initSession();
        this.internalSave(bl);
    }

    protected void internalSave(boolean bl) throws PolicyStoreException {
        if (this.session_.isOpen()) {
            this.getImpl().policyCommit(this.session_.nativeSession_, bl);
        }
    }

    public void refresh() throws PolicyStoreException {
        String string = "refresh()";
        logger.entry(string);
        this.adapter_.policyRefresh(this.session_.nativeSession_);
        logger.exit(string);
    }

    public PolicyStore getParent() {
        return this.parent_;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

