/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.iauthz.storage;

import com.ibm.sec.iauthz.log.SecLogger;
import com.ibm.sec.iauthz.storage.ClientSession;
import com.ibm.sec.iauthz.storage.ConfigTable;
import com.ibm.sec.iauthz.storage.PermPolicySet;
import com.ibm.sec.iauthz.storage.PolicySet;
import com.ibm.sec.iauthz.storage.PolicyStoreException;
import com.ibm.sec.iauthz.storage.RolePolicySet;
import com.ibm.sec.iauthz.storage.SessionTable;
import com.ibm.sec.iauthz.storage.adapter.StorageAdapter;
import com.ibm.sec.iauthz.util.CWRGSMessageHelper;

public class PolicyStore {
    private static final String PolicyStore_java_sourceCodeID = "$Id: @(#)75  1.8 src/ws/code/argus/src/com/ibm/sec/iauthz/storage/PolicyStore.java, argus.store, argus600, 051020a 05/09/30 14:08:32 @(#) $";
    private static SecLogger logger = SecLogger.getLogger(class$com$ibm$sec$iauthz$storage$PolicyStore == null ? (class$com$ibm$sec$iauthz$storage$PolicyStore = PolicyStore.class$("com.ibm.sec.iauthz.storage.PolicyStore")) : class$com$ibm$sec$iauthz$storage$PolicyStore);
    protected String clientID_ = null;
    private boolean isPolicyStore_;
    protected PermPolicySet permPolicy_ = null;
    protected RolePolicySet rolePolicy_ = null;
    protected ConfigTable configTable_ = null;
    protected SessionTable sessionTable_ = null;
    protected ClientSession permSession_ = null;
    protected ClientSession roleSession_ = null;
    static /* synthetic */ Class class$com$ibm$sec$iauthz$storage$PolicyStore;

    public PolicyStore() {
    }

    public PolicyStore(StorageAdapter storageAdapter, boolean bl) throws PolicyStoreException {
        String string = "PolicyStore( StorageAdapter, boolean )";
        logger.entry(string, new Object[]{storageAdapter, bl});
        this.isPolicyStore_ = bl;
        this.configTable_ = new ConfigTable(storageAdapter);
        this.sessionTable_ = new SessionTable(storageAdapter);
        this.permSession_ = new ClientSession(this.sessionTable_, this.configTable_);
        this.roleSession_ = new ClientSession(this.sessionTable_, this.configTable_);
        try {
            this.permPolicy_ = new PermPolicySet(this, storageAdapter, this.permSession_);
            this.rolePolicy_ = new RolePolicySet(this, storageAdapter, this.roleSession_);
        }
        catch (PolicyStoreException policyStoreException) {
            String string2 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_CREATE_POLICY_SETS", new Object[]{policyStoreException.getMessage()});
            logger.error(string, string2, policyStoreException);
            throw new PolicyStoreException(string2, policyStoreException);
        }
        logger.exit(string);
    }

    public void initPolicySessions() {
        String string = "initPolicySessions()";
        logger.entry(string);
        try {
            if (this.isPolicyStore_ && !this.permSession_.isOpen()) {
                this.permPolicy_.initSession();
            } else if (!this.isPolicyStore_ && !this.roleSession_.isOpen()) {
                this.rolePolicy_.initSession();
            }
        }
        catch (PolicyStoreException policyStoreException) {
            String string2 = CWRGSMessageHelper.getMessage("WARNING_STORAGE_INIT_SESSION", new Object[]{policyStoreException.getMessage()});
            logger.warning(string, string2);
        }
        logger.exit(string);
    }

    public void setClientID(String string) {
        this.clientID_ = string;
        if (!this.permSession_.isOpen()) {
            this.permPolicy_.setClientID(string);
        }
        if (!this.roleSession_.isOpen()) {
            this.rolePolicy_.setClientID(string);
        }
    }

    public void setContextID(String string) {
        if (this.isPolicyStore_) {
            if (!this.permSession_.isOpen()) {
                this.permPolicy_.setContextID(string);
            }
        } else if (!this.roleSession_.isOpen()) {
            this.rolePolicy_.setContextID(string);
        }
    }

    public String getClientID() {
        return this.clientID_;
    }

    public PermPolicySet getPermPolicy() {
        return this.permPolicy_;
    }

    public RolePolicySet getRolePolicy() {
        return this.rolePolicy_;
    }

    public PolicySet getPolicySet() {
        if (this.isPolicyStore_) {
            return this.getPermPolicy();
        }
        return this.getRolePolicy();
    }

    protected ConfigTable getConfigTable() {
        return this.configTable_;
    }

    protected SessionTable getSessionTable() {
        return this.sessionTable_;
    }

    public void linkConfiguration(String string) throws PolicyStoreException {
        this.getConfigTable().linkConfiguration(this.getPermPolicy().getContextID(), string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

