/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.iauthz.storage.adapter.impl;

import com.ibm.sec.iauthz.log.SecLogger;
import com.ibm.sec.iauthz.storage.PolicyStoreException;
import com.ibm.sec.iauthz.storage.adapter.AdapterException;
import com.ibm.sec.iauthz.storage.adapter.AdapterResultSet;
import com.ibm.sec.iauthz.storage.adapter.StorageAdapter;
import com.ibm.sec.iauthz.storage.adapter.TableRow;
import com.ibm.sec.iauthz.util.CWRGSMessageHelper;
import com.ibm.sec.iauthz.util.CommonAuthProperties;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class AdapterUtils {
    private static final String AdapterUtils_java_sourceCodeID = "$Id: @(#)63  1.6 src/ws/code/argus/src/com/ibm/sec/iauthz/storage/adapter/impl/AdapterUtils.java, argus.store, argus600, 051020a 05/08/26 15:56:01 @(#) $";
    private static SecLogger logger = SecLogger.getLogger(class$com$ibm$sec$iauthz$storage$adapter$impl$AdapterUtils == null ? (class$com$ibm$sec$iauthz$storage$adapter$impl$AdapterUtils = AdapterUtils.class$("com.ibm.sec.iauthz.storage.adapter.impl.AdapterUtils")) : class$com$ibm$sec$iauthz$storage$adapter$impl$AdapterUtils);
    public static final String STORAGE_ADAPTER_IMPL = "com.ibm.sec.iauthz.storage.adapter.impl";
    private static final Class DEFAULT_ADAPTER_CLASS = class$com$ibm$sec$iauthz$storage$adapter$impl$FileSystemAdapter == null ? (class$com$ibm$sec$iauthz$storage$adapter$impl$FileSystemAdapter = AdapterUtils.class$("com.ibm.sec.iauthz.storage.adapter.impl.FileSystemAdapter")) : class$com$ibm$sec$iauthz$storage$adapter$impl$FileSystemAdapter;
    static /* synthetic */ Class class$com$ibm$sec$iauthz$storage$adapter$impl$AdapterUtils;
    static /* synthetic */ Class class$com$ibm$sec$iauthz$storage$adapter$impl$FileSystemAdapter;
    static /* synthetic */ Class class$java$util$Properties;

    private AdapterUtils() {
    }

    public static StorageAdapter getAdapter(Properties properties) throws PolicyStoreException {
        Object object;
        String string;
        String string2 = "getAdapter( Properties )";
        logger.entry(string2);
        Class clazz = null;
        if (properties == null) {
            properties = new Properties();
        }
        if ((string = properties.getProperty(STORAGE_ADAPTER_IMPL)) == null) {
            object = CWRGSMessageHelper.getMessage("INFO_STORAGE_USING_DEFAULT_ADAPTER");
            logger.debug(string2, (String)object);
            clazz = DEFAULT_ADAPTER_CLASS;
        } else {
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                String string3 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_INVALID_ADAPTER_CLASS", new Object[]{string, classNotFoundException.getMessage()});
                logger.error(string2, string3, classNotFoundException);
                throw new PolicyStoreException(string3, classNotFoundException);
            }
        }
        object = null;
        StorageAdapter storageAdapter = null;
        try {
            object = clazz.getDeclaredMethod("getAdapter", class$java$util$Properties == null ? (class$java$util$Properties = AdapterUtils.class$("java.util.Properties")) : class$java$util$Properties);
            storageAdapter = (StorageAdapter)((Method)object).invoke(null, properties);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String string4 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_NO_GETADAPTER_METHOD", new Object[]{clazz.getName(), noSuchMethodException.getMessage()});
            logger.error(string2, string4, noSuchMethodException);
            throw new PolicyStoreException(string4, noSuchMethodException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string5 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_NO_GETADAPTER_METHOD", new Object[]{clazz.getName(), illegalArgumentException.getMessage()});
            logger.error(string2, string5, illegalArgumentException);
            throw new PolicyStoreException(illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            String string6 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_NO_GETADAPTER_METHOD", new Object[]{clazz.getName(), invocationTargetException.getMessage()});
            logger.error(string2, string6, invocationTargetException);
            throw new PolicyStoreException(string6, invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            String string7 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_NO_GETADAPTER_METHOD", new Object[]{clazz.getName(), illegalAccessException.getMessage()});
            logger.error(string2, string7, illegalAccessException);
            throw new PolicyStoreException(string7, illegalAccessException);
        }
        logger.exit(string2, storageAdapter);
        return storageAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpTable(StorageAdapter storageAdapter, String[] stringArray) {
        String string = stringArray[1];
        if (string == null) {
            System.out.println("No table.");
            return;
        }
        if (string.equalsIgnoreCase("CONFIG")) {
            string = storageAdapter.getConfigTableName();
        } else if (string.equalsIgnoreCase("SESSION")) {
            string = storageAdapter.getSessionTableName();
        }
        if (string == null) {
            System.out.println("No such table.");
            return;
        }
        AdapterResultSet adapterResultSet = null;
        System.out.println("Dumping " + string);
        try {
            adapterResultSet = storageAdapter.dumpTable(string);
            if (adapterResultSet == null) {
                System.out.println("No results.");
                return;
            }
            long l = 0L;
            Set set = adapterResultSet.first();
            while (set != null) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Object e2 = iterator.next();
                    ++l;
                    if (!(e2 instanceof TableRow)) continue;
                    TableRow tableRow = (TableRow)e2;
                    if (tableRow.isDeleted()) {
                        System.out.print("d");
                    } else {
                        System.out.print(" ");
                    }
                    System.out.print(l);
                    System.out.println(" : " + tableRow.toString());
                }
                set = adapterResultSet.getNextPage();
            }
        }
        catch (AdapterException adapterException) {
            adapterException.printStackTrace();
        }
        catch (PolicyStoreException policyStoreException) {
            policyStoreException.printStackTrace();
        }
        finally {
            if (adapterResultSet != null) {
                adapterResultSet.close();
            }
        }
        System.out.println("Dump complete");
    }

    private static void rebuildTable(StorageAdapter storageAdapter, String[] stringArray) {
        String string = "rebuildTable";
        logger.entry(string);
        String string2 = stringArray[1];
        storageAdapter.rebuildTable(string2, true);
        logger.exit(string);
    }

    public static void main(String[] stringArray) {
        String string = "commonauthz.home";
        System.out.println("Gathering current configuration from " + System.getProperty(string));
        Properties properties = CommonAuthProperties.getProps();
        if (properties == null) {
            System.out.println("No configuration available.");
        }
        try {
            StorageAdapter storageAdapter = AdapterUtils.getAdapter(properties);
            String string2 = properties.getProperty(STORAGE_ADAPTER_IMPL);
            if (string2 == null) {
                System.out.println("Using default storage adapter.");
            } else {
                System.out.println("Using configured adapter " + string2);
            }
            String string3 = stringArray[0];
            if (string3.equalsIgnoreCase("dump")) {
                AdapterUtils.dumpTable(storageAdapter, stringArray);
            } else if (string3.equalsIgnoreCase("rebuild")) {
                AdapterUtils.rebuildTable(storageAdapter, stringArray);
            } else {
                System.err.println("Unknown command '" + string3 + "'");
            }
        }
        catch (PolicyStoreException policyStoreException) {
            policyStoreException.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

