/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.iauthz.storage.adapter.impl.fs;

import com.ibm.sec.iauthz.log.SecLogger;
import com.ibm.sec.iauthz.storage.ConfigTableEntry;
import com.ibm.sec.iauthz.storage.PolicyStoreException;
import com.ibm.sec.iauthz.storage.SessionTableEntry;
import com.ibm.sec.iauthz.storage.StoreRecord;
import com.ibm.sec.iauthz.storage.StoreRecordQuery;
import com.ibm.sec.iauthz.storage.adapter.AdapterResultSet;
import com.ibm.sec.iauthz.storage.adapter.AdapterSession;
import com.ibm.sec.iauthz.storage.adapter.IAdapterSession;
import com.ibm.sec.iauthz.storage.adapter.StorageAdapter;
import com.ibm.sec.iauthz.storage.adapter.TableRow;
import com.ibm.sec.iauthz.storage.adapter.TableVersion;
import com.ibm.sec.iauthz.storage.adapter.impl.BasicSchema;
import com.ibm.sec.iauthz.storage.adapter.impl.SchemaDataType;
import com.ibm.sec.iauthz.storage.adapter.impl.SearchAction;
import com.ibm.sec.iauthz.storage.adapter.impl.SearchOptions;
import com.ibm.sec.iauthz.storage.adapter.impl.SearchResults;
import com.ibm.sec.iauthz.storage.adapter.impl.SearchWhere;
import com.ibm.sec.iauthz.storage.adapter.impl.TableTransaction;
import com.ibm.sec.iauthz.storage.adapter.impl.fs.FSAdapterResultSet;
import com.ibm.sec.iauthz.storage.adapter.impl.fs.FSDBTable;
import com.ibm.sec.iauthz.storage.adapter.impl.fs.FSException;
import com.ibm.sec.iauthz.storage.adapter.impl.fs.FSQuery;
import com.ibm.sec.iauthz.storage.adapter.impl.fs.FSSchemaColumn;
import com.ibm.sec.iauthz.storage.adapter.impl.fs.FSSession;
import com.ibm.sec.iauthz.storage.adapter.impl.fs.FSTableSchema;
import com.ibm.sec.iauthz.storage.adapter.impl.fs.FSTableTransaction;
import com.ibm.sec.iauthz.storage.adapter.impl.fs.SMFileUtils;
import com.ibm.sec.iauthz.storage.adapter.impl.fs.TableAddAction;
import com.ibm.sec.iauthz.util.CWRGSMessageHelper;
import com.ibm.sec.iauthz.util.CollectionFactory;
import com.ibm.sec.iauthz.util.RWLock;
import com.ibm.sec.iauthz.util.RWLockException;
import com.ibm.sec.iauthz.util.StoreRecordUtil;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;

public class FSAdapterImpl
extends StorageAdapter {
    private static SecLogger _logger = SecLogger.getLogger(class$com$ibm$sec$iauthz$storage$adapter$impl$fs$FSAdapterImpl == null ? (class$com$ibm$sec$iauthz$storage$adapter$impl$fs$FSAdapterImpl = FSAdapterImpl.class$("com.ibm.sec.iauthz.storage.adapter.impl.fs.FSAdapterImpl")) : class$com$ibm$sec$iauthz$storage$adapter$impl$fs$FSAdapterImpl);
    private static final String FSAdapterImpl_java_sourceCodeID = "$Id: @(#)20  1.36 src/ws/code/argus/src/com/ibm/sec/iauthz/storage/adapter/impl/fs/FSAdapterImpl.java, argus.store, argus600, 060223a 06/02/23 13:11:52 @(#) $";
    protected static final String CONFIG_TABLENAME = "c" + "CONFIGURATION".hashCode();
    protected static FSTableSchema configSchema_ = new FSTableSchema();
    public static final int COLUMN_CONFIG_POLICYCTXID = 0;
    public static final int COLUMN_CONFIG_ROLEMAPCTXID = 1;
    public static final int COLUMN_CONFIG_PERMTABLEID = 2;
    public static final int COLUMN_CONFIG_ROLETABLEID = 3;
    public static final int COLUMN_CONFIG_PERMCTXSVC = 4;
    public static final int COLUMN_CONFIG_ROLECTXSVC = 5;
    public static final int COLUMN_CONFIG_LINKPERMID = 6;
    protected static final String SESSION_TABLENAME = "s" + -"SESSION".hashCode();
    protected static FSTableSchema sessionSchema_ = new FSTableSchema();
    public static final int COLUMN_SESSION_POLICYCTXID = SessionTableEntry.POLICYCTXID;
    public static final int COLUMN_SESSION_CLIENTID = SessionTableEntry.CLIENTID;
    public static final int COLUMN_SESSION_DBVERSION = SessionTableEntry.DBVERSION;
    public static final int COLUMN_SESSION_MODTIME = SessionTableEntry.MODTIME;
    protected static FSTableSchema permPolicySchema_ = new FSTableSchema();
    public static final int COLUMN_POLICY_XMTID = StoreRecord.XMTID;
    public static final int COLUMN_POLICY_CONTEXT_ID = StoreRecord.CONTEXTID;
    public static final int COLUMN_POLICY_UPDATEVERSION = StoreRecord.UPDATEVERSION;
    public static final int COLUMN_POLICY_UPDATETIME = StoreRecord.UPDATETIME;
    public static final int COLUMN_POLICY_ACTION = StoreRecord.ACTION;
    public static final int COLUMN_POLICY_PERMTYPE = StoreRecord.PERMTYPE;
    public static final int COLUMN_POLICY_CLASSNAME = StoreRecord.CLASSNAME;
    public static final int COLUMN_POLICY_ATTR_NAME = StoreRecord.ATTR_NAME;
    public static final int COLUMN_POLICY_ATTR_VALUE_XMTID = StoreRecord.ATTR_VALUE_XMTID;
    public static final int COLUMN_POLICY_ATTR_VALUE_STRING = StoreRecord.ATTR_VALUE_STRING;
    public static final int COLUMN_POLICY_ORDER = StoreRecord.ORDER;
    protected static final String PROP_ROOT_DIR = "ROOTDIR";
    protected static final String PROP_SESSIONS_DIR = "SESSIONSDIR";
    protected static final String PROP_CONFIG_OR_RUNTIME = "CONFIG_OR_RUNTIME";
    protected static final String PROP_POLICY_OR_RM = "POLICY_OR_RM";
    private static final String ROLE_NAME = "_role";
    protected static final String compDir_ = "ibmsecauthz";
    protected static final String policyDir_;
    protected static String rootDir_;
    protected static String sessionsDir_;
    private boolean keepArchives_ = false;
    private RWLock _rwLockSandboxCopy = new RWLock();
    private static RWLock _rwLockMaster;
    private RWLock _rwLockSandbox = new RWLock();
    private static RWLock _rwLockSession;
    private static RWLock _rwLockConfig;
    private RWLock _rwLockDeltas = new RWLock();
    static /* synthetic */ Class class$com$ibm$sec$iauthz$storage$adapter$impl$fs$FSAdapterImpl;

    public FSAdapterImpl(Properties properties) throws FSException {
        String string = "FSAdapterImpl( Properties )";
        _logger.entry(string, properties);
        Properties properties2 = this.createConfiguration(properties);
        this.setConfiguration(properties2);
        this.initialize();
        _logger.exit(string);
    }

    private synchronized Properties createConfiguration(Properties properties) {
        String string;
        String string2;
        _logger.entry("createConfiguration( Properties )");
        Properties properties2 = new Properties();
        if (rootDir_ == null) {
            _logger.debug("createConfiguration( Properties )", "Setting FS Adapter policy tree.");
            string2 = properties.getProperty("com.ibm.sec.authz.storage.policydir");
            if (string2 != null) {
                string2 = string2 + File.separator + policyDir_;
            }
            if (string2 == null && (string = System.getProperty("commonauthz.policydir")) != null) {
                if ((string = System.getProperty(string)) != null) {
                    string2 = string = string + File.separator + policyDir_;
                } else {
                    String string3 = CWRGSMessageHelper.getMessage("WARNING_STORAGE_FS_NULL_PROPERTY", new Object[]{"commonauthz.policydir", System.getProperty("commonauthz.policydir")});
                    _logger.warning("createConfiguration( Properties )", string3);
                }
            }
            if (string2 == null && (string = System.getProperty("commonauthz.home")) != null) {
                string2 = string = string + File.separator + policyDir_;
            }
            if (string2 == null) {
                string2 = File.separator + "var" + File.separator + policyDir_;
            }
            rootDir_ = string2;
            string = properties.getProperty("com.ibm.sec.authz.storage.sessions");
            string = string == null ? rootDir_ : string + File.separator + policyDir_;
            sessionsDir_ = string + File.separator + "sessions";
        }
        properties2.setProperty(PROP_ROOT_DIR, rootDir_);
        properties2.setProperty(PROP_SESSIONS_DIR, sessionsDir_);
        string2 = (String)properties.get(PROP_CONFIG_OR_RUNTIME);
        if (string2 != null) {
            properties2.setProperty(PROP_CONFIG_OR_RUNTIME, string2);
        }
        if ((string = (String)properties.get(PROP_POLICY_OR_RM)) != null) {
            properties2.setProperty(PROP_POLICY_OR_RM, string);
        }
        _logger.debug("createConfiguration( Properties )", "FS Configuration: " + properties2);
        _logger.exit("createConfiguration( Properties )");
        return properties2;
    }

    protected void initialize() throws FSException {
        String string = "initialize()";
        _logger.entry(string);
        Properties properties = this.getConfiguration();
        File file = null;
        try {
            file = new File(properties.getProperty(PROP_ROOT_DIR));
            file.mkdirs();
            file = new File(properties.getProperty(PROP_SESSIONS_DIR));
            file.mkdirs();
        }
        catch (SecurityException securityException) {
            String string2 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_FS_CREATE_DIRS", new Object[]{securityException.getMessage()});
            _logger.error(string, string2, securityException);
            throw new FSException(string2, securityException);
        }
        _logger.exit(string);
    }

    public String getConfigTableName() {
        return CONFIG_TABLENAME;
    }

    public String getSessionTableName() {
        return SESSION_TABLENAME;
    }

    protected static void configInitialize() {
        String string = "configInitialize()";
        _logger.entry(string);
        configSchema_.addColumn(new FSSchemaColumn("POLICYCTXID", SchemaDataType.VARCHAR));
        configSchema_.addColumn(new FSSchemaColumn("ROLEMAPCTXID", SchemaDataType.VARCHAR));
        configSchema_.addColumn(new FSSchemaColumn("PERMTABLEID", SchemaDataType.CHAR, 64));
        configSchema_.addColumn(new FSSchemaColumn("ROLETABLEID", SchemaDataType.CHAR, 64));
        configSchema_.addColumn(new FSSchemaColumn("PERMCTXSVC", SchemaDataType.VARCHAR));
        configSchema_.addColumn(new FSSchemaColumn("ROLECTXSVC", SchemaDataType.VARCHAR));
        configSchema_.addColumn(new FSSchemaColumn("LINKPERMID", SchemaDataType.VARCHAR));
        configSchema_.setMagic((byte)1);
        _logger.exit(string);
    }

    protected static void sessionInitialize() {
        String string = "sessionInitialize()";
        _logger.entry(string);
        sessionSchema_.addColumn(new FSSchemaColumn("POLICYCTXID", SchemaDataType.VARCHAR));
        sessionSchema_.addColumn(new FSSchemaColumn("CLIENTID", SchemaDataType.VARCHAR));
        sessionSchema_.addColumn(new FSSchemaColumn("DBVERSION", SchemaDataType.INT));
        sessionSchema_.addColumn(new FSSchemaColumn("MODTIME", SchemaDataType.DATE));
        sessionSchema_.setMagic((byte)2);
        _logger.exit(string);
    }

    protected static void policyInitialize() {
        String string = "policyInitialize()";
        _logger.entry(string);
        permPolicySchema_.addColumn(new FSSchemaColumn("XMTID", SchemaDataType.VARCHAR));
        permPolicySchema_.addColumn(new FSSchemaColumn("CONTEXTID", SchemaDataType.VARCHAR));
        permPolicySchema_.addColumn(new FSSchemaColumn("UPDATEVERSION", SchemaDataType.INT));
        permPolicySchema_.addColumn(new FSSchemaColumn("UPDATETIME", SchemaDataType.DATE));
        permPolicySchema_.addColumn(new FSSchemaColumn("ACTION", SchemaDataType.INT));
        permPolicySchema_.addColumn(new FSSchemaColumn("PERMTYPE", SchemaDataType.VARCHAR));
        permPolicySchema_.addColumn(new FSSchemaColumn("CLASSNAME", SchemaDataType.VARCHAR));
        permPolicySchema_.addColumn(new FSSchemaColumn("ATTR_NAME", SchemaDataType.VARCHAR));
        permPolicySchema_.addColumn(new FSSchemaColumn("ATTR_VALUE_XMTID", SchemaDataType.VARCHAR));
        permPolicySchema_.addColumn(new FSSchemaColumn("ATTR_VALUE_STRING", SchemaDataType.VARCHAR));
        permPolicySchema_.addColumn(new FSSchemaColumn("ORDER", SchemaDataType.INT));
        permPolicySchema_.setMagic((byte)3);
        _logger.exit(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void configUpdate(ConfigTableEntry configTableEntry) throws PolicyStoreException {
        String string = "configUpdate( ConfigTableEntry )";
        _logger.entry(string, configTableEntry);
        ConfigTableEntry configTableEntry2 = configTableEntry;
        SearchOptions searchOptions = new SearchOptions();
        if (configTableEntry == null) {
            String string2 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_FS_NULL_INPUT");
            _logger.error(string, string2);
            throw new PolicyStoreException(string2);
        }
        searchOptions.WHERE = configTableEntry.getPermContextID() != null ? new SearchWhere(new int[]{0}) : (configTableEntry.getRoleContextID() != null ? new SearchWhere(new int[]{1}) : new SearchWhere(configTableEntry));
        SearchAction searchAction = null;
        FSTableTransaction fSTableTransaction = null;
        fSTableTransaction = this.configOpen(null, true);
        fSTableTransaction.insert(configTableEntry2, searchOptions, searchAction);
        Object var9_8 = null;
        try {
            this.configClose(fSTableTransaction);
        }
        catch (FSException fSException) {
            String string3 = CWRGSMessageHelper.getMessage("WARNING_STORAGE_CLOSE_TRANSACTION", new Object[]{fSException.getMessage()});
            _logger.warning(string, string3);
        }
        {
            catch (FSException fSException) {
                throw new PolicyStoreException(fSException);
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            try {
                this.configClose(fSTableTransaction);
            }
            catch (FSException fSException) {
                String string4 = CWRGSMessageHelper.getMessage("WARNING_STORAGE_CLOSE_TRANSACTION", new Object[]{fSException.getMessage()});
                _logger.warning(string, string4);
            }
            throw throwable;
        }
        _logger.exit(string);
    }

    /*
     * Loose catch block
     */
    private void configRemoveEntry(ConfigTableEntry configTableEntry) throws PolicyStoreException {
        block7: {
            _logger.entry("configRemoveEntry");
            FSTableTransaction fSTableTransaction = null;
            fSTableTransaction = this.configOpen(fSTableTransaction, true);
            fSTableTransaction.remove(configTableEntry);
            Object var7_3 = null;
            try {
                this.configClose(fSTableTransaction);
            }
            catch (FSException fSException) {
                String string = CWRGSMessageHelper.getMessage("WARNING_STORAGE_CLOSE_TRANSACTION", new Object[]{fSException.getMessage()});
                _logger.warning("configRemoveEntry", string);
            }
            break block7;
            {
                catch (FSException fSException) {
                    String string = CWRGSMessageHelper.getMessage("ERROR_STORAGE_FS_TRANSACTION_REMOVE_FAILED", new Object[]{fSException.getMessage()});
                    _logger.error("configRemoveEntry", string, fSException);
                    throw new PolicyStoreException(string, fSException);
                }
            }
            catch (Throwable throwable) {
                Object var7_4 = null;
                try {
                    this.configClose(fSTableTransaction);
                }
                catch (FSException fSException) {
                    String string = CWRGSMessageHelper.getMessage("WARNING_STORAGE_CLOSE_TRANSACTION", new Object[]{fSException.getMessage()});
                    _logger.warning("configRemoveEntry", string);
                }
                throw throwable;
            }
        }
        _logger.exit("configRemoveEntry");
    }

    public void configDeleteAll() throws PolicyStoreException {
        String string = "configDeleteAll()";
        _logger.entry(string);
        this.configDeleteAll(null, true);
        _logger.exit(string);
    }

    private void configDeleteAll(FSTableTransaction fSTableTransaction, boolean bl) throws PolicyStoreException {
        String string = "configDeleteAll( FSTableTransaction, boolean )";
        _logger.entry(string, new Object[]{fSTableTransaction, bl});
        try {
            if (fSTableTransaction == null) {
                fSTableTransaction = this.configOpen(null, true);
            }
            this.configClose(fSTableTransaction);
            if (bl) {
                this.configCreate();
            }
        }
        catch (FSException fSException) {
            String string2 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_FS_CLOSE_TRANSACTION", new Object[]{fSException.getMessage()});
            _logger.error(string, string2, fSException);
            throw new PolicyStoreException(string2, fSException);
        }
    }

    public void configCreate() throws PolicyStoreException {
        String string = "configCreate()";
        _logger.entry(string);
        boolean bl = false;
        FSTableTransaction fSTableTransaction = new FSTableTransaction(this.getConfiguration());
        if (!((TableTransaction)fSTableTransaction).existsTable(CONFIG_TABLENAME)) {
            try {
                bl = _rwLockConfig.lock(true);
                if (!bl) {
                    String string2 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_SESSION_EXCLUSIVE_LOCK");
                    _logger.error(string, string2);
                    throw new PolicyStoreException(string2);
                }
                ((TableTransaction)fSTableTransaction).createTable(CONFIG_TABLENAME, configSchema_);
            }
            catch (Exception exception) {
                String string3 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_FS_CREATE_TABLE", new Object[]{CONFIG_TABLENAME, exception.getMessage()});
                _logger.error(string, string3, exception);
                throw new PolicyStoreException(string3, exception);
            }
            finally {
                if (bl) {
                    _rwLockConfig.releaseLock();
                    bl = false;
                }
            }
        }
        _logger.exit(string);
    }

    private FSTableTransaction configOpen(FSTableTransaction fSTableTransaction, boolean bl) throws PolicyStoreException {
        String string = "configOpen( FSTableTransaction )";
        _logger.entry(string, fSTableTransaction);
        if (fSTableTransaction == null) {
            fSTableTransaction = new FSTableTransaction(this.getConfiguration());
        }
        try {
            boolean bl2 = _rwLockConfig.lock(bl);
            if (!bl2) {
                String string2 = "";
                string2 = bl ? CWRGSMessageHelper.getMessage("ERROR_STORAGE_SESSION_EXCLUSIVE_LOCK") : CWRGSMessageHelper.getMessage("ERROR_STORAGE_SESSION_SHARED_LOCK");
                _logger.error(string, string2);
                throw new PolicyStoreException(string2);
            }
            fSTableTransaction.openBaseTable(CONFIG_TABLENAME, configSchema_);
        }
        catch (Exception exception) {
            try {
                this.configClose(fSTableTransaction, false);
            }
            catch (FSException fSException) {
                _logger.error(string, fSException.getLocalizedMessage());
            }
            throw new PolicyStoreException(exception.getLocalizedMessage());
        }
        _logger.exit(string, fSTableTransaction);
        return fSTableTransaction;
    }

    private void configClose(FSTableTransaction fSTableTransaction) throws FSException {
        this.configClose(fSTableTransaction, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configClose(FSTableTransaction fSTableTransaction, boolean bl) throws FSException {
        String string = "configClose()";
        _logger.entry(string, Boolean.toString(bl));
        try {
            if (fSTableTransaction != null) {
                fSTableTransaction.closeTable(bl);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            boolean bl2 = _rwLockConfig.releaseLock();
            if (!bl2) {
                _logger.debug(string, "Lock not released");
            }
            throw throwable;
        }
        boolean bl3 = _rwLockConfig.releaseLock();
        if (!bl3) {
            _logger.debug(string, "Lock not released");
        }
        _logger.exit(string);
    }

    public void configDestroy() throws PolicyStoreException {
        String string = "configDestroy()";
        _logger.entry(string);
        this.configDestroy(true);
        _logger.exit(string);
    }

    private void configDestroy(boolean bl) throws PolicyStoreException {
        String string = "configDestroy( boolean )";
        _logger.entry(string, bl);
        FSTableTransaction fSTableTransaction = null;
        fSTableTransaction = this.configOpen(null, true);
        Set set = this.configGetEntries(fSTableTransaction);
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                ConfigTableEntry configTableEntry = (ConfigTableEntry)iterator.next();
                String string2 = configTableEntry.getPermTableID();
                String string3 = fSTableTransaction.getBaseDir(string2);
                this.policyDestroyTable(string2, string3);
                string2 = configTableEntry.getRoleTableID();
                string3 = fSTableTransaction.getBaseDir(string2);
                this.policyDestroyTable(string2, string3);
            }
        }
        this.configDeleteAll(fSTableTransaction, true);
        _logger.exit(string);
    }

    private void policyDestroyTable(String string, String string2) {
        Object object;
        String string3 = "policyDestroyTable( String, String )";
        _logger.entry(string3, new Object[]{string, string2});
        List list = this.policyListDeltas(string2, string, TableVersion.getInitialVersion("1"), null);
        if (list != null && !list.isEmpty()) {
            object = list.iterator();
            while (object.hasNext()) {
                FSDBTable fSDBTable = (FSDBTable)object.next();
                fSDBTable.deleteFile(false);
            }
        }
        if (SMFileUtils.fileExists(string2).booleanValue()) {
            object = new FSDBTable(string2, string);
            ((FSDBTable)object).deleteFile(true);
        }
        _logger.exit(string3);
    }

    protected String configGetTableID(String string) throws PolicyStoreException {
        String string2 = "configGetTableID( String )";
        _logger.entry(string2, string);
        String string3 = null;
        ConfigTableEntry configTableEntry = this.configGetEntry(string);
        if (configTableEntry != null) {
            string3 = configTableEntry.getPermTableID();
        }
        _logger.exit(string2, string3);
        return string3;
    }

    public ConfigTableEntry configGetEntry(String string) throws PolicyStoreException {
        String string2 = "configGetEntry( String )";
        _logger.entry(string2, string);
        ConfigTableEntry configTableEntry = null;
        ConfigTableEntry configTableEntry2 = new ConfigTableEntry(string);
        configTableEntry = this.configGetEntry(configTableEntry2);
        _logger.exit(string2, configTableEntry);
        return configTableEntry;
    }

    /*
     * Loose catch block
     */
    public ConfigTableEntry configGetEntry(ConfigTableEntry configTableEntry) throws PolicyStoreException {
        Iterator iterator;
        TableRow tableRow;
        SearchResults searchResults;
        ConfigTableEntry configTableEntry2;
        String string;
        block8: {
            string = "configGetEntry( ConfigTableEntry )";
            _logger.entry(string, configTableEntry);
            configTableEntry2 = null;
            FSTableTransaction fSTableTransaction = null;
            SearchOptions searchOptions = new SearchOptions();
            searchOptions.FIRSTONLY = true;
            searchOptions.SKIP_DELETED = true;
            searchOptions.CACHE_LOCATION = false;
            searchOptions.WHERE = new SearchWhere(configTableEntry);
            SearchAction searchAction = new SearchAction();
            searchAction.setCollect(true);
            fSTableTransaction = this.configOpen(null, true);
            searchResults = fSTableTransaction.searchTable(configTableEntry, searchOptions, searchAction);
            Object var11_8 = null;
            try {
                this.configClose(fSTableTransaction);
            }
            catch (FSException fSException) {
                String string2 = CWRGSMessageHelper.getMessage("WARNING_STORAGE_CLOSE_TRANSACTION", new Object[]{fSException.getMessage()});
                _logger.warning(string, string2);
            }
            break block8;
            {
                catch (FSException fSException) {
                    String string3 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_FS_SEARCH_TABLE", new Object[]{fSException.getMessage()});
                    _logger.error(string, string3, fSException);
                    throw new PolicyStoreException(string3, fSException);
                }
            }
            catch (Throwable throwable) {
                Object var11_9 = null;
                try {
                    this.configClose(fSTableTransaction);
                }
                catch (FSException fSException) {
                    String string4 = CWRGSMessageHelper.getMessage("WARNING_STORAGE_CLOSE_TRANSACTION", new Object[]{fSException.getMessage()});
                    _logger.warning(string, string4);
                }
                throw throwable;
            }
        }
        Set set = (Set)searchResults.getValue();
        if (set != null && (tableRow = (TableRow)(iterator = set.iterator()).next()) != null) {
            configTableEntry2 = new ConfigTableEntry(tableRow);
        }
        _logger.exit(string, configTableEntry2);
        return configTableEntry2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set configGetContexts() throws PolicyStoreException {
        String string = "configGetContexts()";
        _logger.entry(string);
        Set set = null;
        set = this.configGetEntries(null);
        _logger.exit(string, set);
        return set;
    }

    /*
     * Loose catch block
     */
    private Set configGetEntries(FSTableTransaction fSTableTransaction) throws PolicyStoreException {
        SearchResults searchResults;
        String string;
        block10: {
            string = "configGetEntries( FSTableTransaction )";
            _logger.entry(string, fSTableTransaction);
            boolean bl = false;
            if (fSTableTransaction == null) {
                fSTableTransaction = this.configOpen(null, false);
                bl = true;
            }
            TableRow tableRow = new TableRow();
            SearchOptions searchOptions = new SearchOptions();
            searchOptions.FIRSTONLY = false;
            searchOptions.SKIP_DELETED = true;
            searchOptions.CACHE_LOCATION = false;
            searchOptions.WHERE = new SearchWhere();
            searchOptions.WHERE.setMatchAll(true);
            SearchAction searchAction = new SearchAction(){

                public TableRow doAction(TableRow tableRow) {
                    if (this.doCollect()) {
                        Set set = (Set)this.getResults().getValue();
                        if (set == null) {
                            set = CollectionFactory.newSet();
                        }
                        set.add(new ConfigTableEntry(tableRow));
                        this.getResults().setValue(set);
                    }
                    return tableRow;
                }
            };
            searchAction.setCollect(true);
            searchResults = fSTableTransaction.searchTable(tableRow, searchOptions, searchAction);
            Object var11_8 = null;
            try {
                if (bl) {
                    this.configClose(fSTableTransaction);
                }
                break block10;
            }
            catch (FSException fSException) {
                String string2 = CWRGSMessageHelper.getMessage("WARNING_STORAGE_CLOSE_TRANSACTION", new Object[]{fSException.getMessage()});
                _logger.warning(string, string2);
            }
            break block10;
            {
                catch (FSException fSException) {
                    String string3 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_FS_SEARCH_TABLE", new Object[]{fSException.getMessage()});
                    _logger.error(string, string3, fSException);
                    throw new PolicyStoreException(string3, fSException);
                }
            }
            catch (Throwable throwable) {
                Object var11_9 = null;
                try {
                    if (bl) {
                        this.configClose(fSTableTransaction);
                    }
                }
                catch (FSException fSException) {
                    String string4 = CWRGSMessageHelper.getMessage("WARNING_STORAGE_CLOSE_TRANSACTION", new Object[]{fSException.getMessage()});
                    _logger.warning(string, string4);
                }
                throw throwable;
            }
        }
        Set set = (Set)searchResults.getValue();
        _logger.exit(string, set);
        return set;
    }

    public String configGetRoleContext(String string) throws PolicyStoreException {
        String string2 = "configGetRoleContext( String )";
        _logger.entry(string2, string);
        String string3 = null;
        ConfigTableEntry configTableEntry = this.configGetEntry(string);
        if (configTableEntry != null) {
            string3 = configTableEntry.getRoleContextID();
            if (string3 == null) {
                string3 = string + ROLE_NAME;
                configTableEntry.setRoleContextID(string3);
                this.configUpdate(configTableEntry);
            }
        } else {
            String string4 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_POLICY_CONTEXT_NOT_FOUND", new Object[]{string});
            _logger.error(string2, string4);
            throw new PolicyStoreException(string4);
        }
        _logger.exit(string2, string3);
        return string3;
    }

    public Set configGetPolicyContexts() throws PolicyStoreException {
        String string = "configGetPolicyContexts()";
        _logger.entry(string);
        Set set = this.configGetContexts();
        Set set2 = null;
        if (set != null) {
            set2 = CollectionFactory.newSet(set.size());
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                ConfigTableEntry configTableEntry = (ConfigTableEntry)iterator.next();
                String string2 = configTableEntry.getPermContextID();
                if (string2 == null) continue;
                set2.add(string2);
            }
        }
        _logger.exit(string);
        return set2;
    }

    public Set configGetRoleContexts() throws PolicyStoreException {
        String string = "configGetRoleContexts()";
        _logger.entry(string);
        Set set = this.configGetContexts();
        Set set2 = null;
        if (set != null) {
            set2 = CollectionFactory.newSet(set.size());
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                ConfigTableEntry configTableEntry = (ConfigTableEntry)iterator.next();
                String string2 = configTableEntry.getRoleContextID();
                if (string2 == null || !configTableEntry.isRoleInService()) continue;
                set2.add(string2);
            }
        }
        _logger.exit(string, set2);
        return set2;
    }

    public Set configGetLinkedContexts(String string) throws PolicyStoreException {
        String string2 = "configGetLinkedContexts( String )";
        _logger.entry(string2, string);
        Set set = CollectionFactory.newSet();
        Set set2 = this.configGetContexts();
        if (set2 != null) {
            ConfigTableEntry configTableEntry;
            String string3 = null;
            Iterator iterator = set2.iterator();
            while (iterator.hasNext()) {
                configTableEntry = (ConfigTableEntry)iterator.next();
                if (!configTableEntry.getPermContextID().equals(string)) continue;
                string3 = configTableEntry.getRoleContextID();
                break;
            }
            if (string3 != null) {
                iterator = set2.iterator();
                while (iterator.hasNext()) {
                    configTableEntry = (ConfigTableEntry)iterator.next();
                    if (configTableEntry.getRoleContextID() == null || !configTableEntry.getRoleContextID().equals(string3)) continue;
                    set.add(configTableEntry.getPermContextID());
                }
            }
        }
        _logger.exit(string2, set);
        return set;
    }

    public void configLinkContexts(String string, String string2) throws PolicyStoreException {
        String string3 = "configLinkContexts( String, String )";
        _logger.entry(string3, new Object[]{string, string2});
        ConfigTableEntry configTableEntry = this.configGetEntry(string);
        ConfigTableEntry configTableEntry2 = this.configGetEntry(string2);
        if (configTableEntry == null) {
            String string4 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_LINK_CONTEXT_NO_CONTEXT", new Object[]{string});
            _logger.error(string3, string4);
            throw new PolicyStoreException(string4);
        }
        if (configTableEntry2 == null) {
            String string5 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_LINK_CONTEXT_NO_CONTEXT", new Object[]{string2});
            _logger.error(string3, string5);
            throw new PolicyStoreException(string5);
        }
        if (configTableEntry.getRoleContextID() == null && configTableEntry2.getRoleContextID() == null) {
            this.configGetRoleContext(string);
            configTableEntry = this.configGetEntry(string);
        }
        if (configTableEntry.getRoleContextID() != null) {
            configTableEntry2.setLinkPerm(configTableEntry.getPermContextID());
            this.configUpdate(configTableEntry2);
        } else if (configTableEntry2.getRoleContextID() != null) {
            configTableEntry2.setLinkPerm(configTableEntry.getPermContextID());
            this.configUpdate(configTableEntry2);
            configTableEntry.setLinkPerm(configTableEntry2.getPermContextID());
            this.configUpdate(configTableEntry);
        }
        _logger.exit(string3);
    }

    private void policyCreate(String string) throws PolicyStoreException {
        String string2 = "policyCreate( String )";
        _logger.entry(string2, string);
        FSTableTransaction fSTableTransaction = new FSTableTransaction(this.getConfiguration());
        try {
            fSTableTransaction.createTable(string, permPolicySchema_);
        }
        catch (FSException fSException) {
            String string3 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_FS_CREATE_TABLE", new Object[]{string, fSException.getMessage()});
            _logger.error(string2, string3, fSException);
            throw new PolicyStoreException(string3, fSException);
        }
        _logger.exit(string2);
    }

    public void policyUpdate(IAdapterSession iAdapterSession, Set set) throws PolicyStoreException {
        String string = "policyUpdate( IAdapterSession, Set )";
        _logger.entry(string, new Object[]{iAdapterSession, set});
        this.policyUpdateCollection(iAdapterSession, set);
        _logger.exit(string);
    }

    private void policyUpdateCollection(IAdapterSession iAdapterSession, Collection collection) throws PolicyStoreException {
        String string = "policyUpdateCollection( IAdapterSession, Collection )";
        _logger.entry(string, new Object[]{iAdapterSession, collection});
        if (iAdapterSession == null) {
            String string2 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_FS_NO_SESSION");
            _logger.error(string, string2);
            throw new PolicyStoreException(string2);
        }
        FSSession fSSession = this.policyInitializeSession(iAdapterSession, true);
        String string3 = fSSession.getSandboxTableName();
        if (string3 == null) {
            string3 = this.policyGetTableID(fSSession);
            fSSession.setSandboxTableName(string3);
        }
        if (string3 == null) {
            fSSession.unLock();
            return;
        }
        FSTableTransaction fSTableTransaction = null;
        try {
            fSTableTransaction = (FSTableTransaction)fSSession.getPolicyTxn();
            if (fSTableTransaction == null) {
                fSTableTransaction = new FSTableTransaction(this.getConfiguration());
                fSSession.setPolicyTxn(fSTableTransaction);
                fSTableTransaction.openClientDeltaTable(fSSession.getClientID(), string3, null, permPolicySchema_);
            }
        }
        catch (Exception exception) {
            String string4 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_FS_ADD_TO_TABLE", new Object[]{exception.getMessage()});
            _logger.error(string, string4, exception);
            fSSession.unLock();
            PolicyStoreException policyStoreException = new PolicyStoreException(string4, exception);
            throw policyStoreException;
        }
        try {
            fSTableTransaction.add(collection);
        }
        catch (FSException fSException) {
            String string5 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_FS_ADD_TO_TABLE", new Object[]{fSException.getMessage()});
            _logger.error(string, string5, fSException);
            PolicyStoreException policyStoreException = new PolicyStoreException(string5, fSException);
            throw policyStoreException;
        }
        finally {
            fSSession.unLock();
        }
        _logger.exit(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void policyDestroy(IAdapterSession iAdapterSession) throws PolicyStoreException {
        Object object;
        Object object2;
        String string;
        Object object3;
        Object object4;
        String string2;
        FSTableTransaction fSTableTransaction;
        String string3;
        FSSession fSSession;
        String string4;
        block42: {
            block40: {
                Object object5;
                Object object62222;
                String string5;
                block41: {
                    TableVersion tableVersion;
                    String string6;
                    block37: {
                        string4 = "policyDestroy( IAdapterSession )";
                        _logger.entry(string4, iAdapterSession);
                        fSSession = this.policyInitializeSession(iAdapterSession, true);
                        if (fSSession == null) {
                            String string7 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_FS_NO_SESSION");
                            _logger.error(string4, string7);
                            throw new PolicyStoreException(string7);
                        }
                        String string8 = fSSession.getClientID();
                        string6 = fSSession.getContextID();
                        _logger.debug(string4, "Destroying policy for " + string8 + "/" + string6);
                        string3 = fSSession.getSandboxTableName();
                        if (string3 == null) {
                            string3 = this.policyGetTableID(fSSession);
                            fSSession.setSandboxTableName(string3);
                        }
                        _logger.debug(string4, "Policy table is " + string3);
                        if (string3 == null) {
                            fSSession.unLock();
                            return;
                        }
                        tableVersion = this.getMasterVersion(iAdapterSession);
                        boolean bl = false;
                        try {
                            bl = this._rwLockSandboxCopy.getWriterLock();
                            if (bl) {
                                FSQuery.commitDBTable(fSSession.getVersionTableName());
                                fSSession.setDBTable(null);
                                this._rwLockSandboxCopy.releaseLock();
                                bl = false;
                                break block37;
                            }
                            String string9 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_FS_NO_LOCK", new Object[]{"_rwLockSandboxCopy"});
                            _logger.error(string4, string9);
                            throw new PolicyStoreException(string9);
                        }
                        catch (RWLockException rWLockException) {
                            String string10 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_FS_DELETE_ALL", new Object[]{rWLockException.getMessage()});
                            _logger.error(string4, string10);
                            fSSession.unLock();
                            throw new PolicyStoreException(string10, rWLockException);
                        }
                        finally {
                            if (bl) {
                                this._rwLockSandboxCopy.releaseLock();
                                bl = false;
                            }
                        }
                    }
                    _logger.debug(string4, "Checking for pending deltas.");
                    FSTableTransaction fSTableTransaction2 = (FSTableTransaction)fSSession.getPolicyTxn();
                    if (fSTableTransaction2 != null) {
                        _logger.debug(string4, "Removing pending update.");
                        this.policyRolebackDelta(fSSession);
                    }
                    _logger.debug(string4, "Clearing client session for this context.");
                    this.sessionDestroy(null, string6, false);
                    _logger.debug(string4, "Removing primary db and deltas.");
                    boolean bl = false;
                    fSTableTransaction = new FSTableTransaction(this.getConfiguration());
                    string2 = fSTableTransaction.getBaseDir(string3);
                    TableVersion tableVersion2 = new TableVersion(tableVersion);
                    tableVersion2.increment();
                    try {
                        bl = _rwLockMaster.getWriterLock();
                        if (bl) {
                            object4 = string2 + File.separator + "delta" + "." + this.convertTStoFN(tableVersion2.getVersion());
                            object3 = new FSTableTransaction(this.getConfiguration());
                            if (((FSTableTransaction)object3).existsTable(string3)) {
                                ((FSTableTransaction)object3).openBaseTable(string3, permPolicySchema_);
                                ((FSTableTransaction)object3).moveToDelta((String)object4, 2);
                                ((FSTableTransaction)object3).closeTable(true);
                            }
                            _rwLockMaster.releaseLock();
                            bl = false;
                        }
                    }
                    catch (RWLockException rWLockException) {
                        String string11 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_FS_DELETE_ALL", new Object[]{rWLockException.getMessage()});
                        _logger.error(string4, string11);
                        fSSession.unLock();
                        throw new PolicyStoreException(string11, rWLockException);
                    }
                    catch (FSException fSException) {
                        String string12 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_FS_DELETE_ALL", new Object[]{fSException.getMessage()});
                        _logger.error(string4, string12);
                        fSSession.unLock();
                        throw new PolicyStoreException(string12, fSException);
                    }
                    finally {
                        if (bl) {
                            _rwLockMaster.releaseLock();
                            bl = false;
                        }
                    }
                    this.setVersionTableName(fSSession);
                    object4 = fSSession.getConfigEntry();
                    if (object4 == null) {
                        return;
                    }
                    object3 = ((ConfigTableEntry)object4).getRoleContextID();
                    string = ((ConfigTableEntry)object4).getRoleTableID();
                    _logger.debug(string4, "Cleaning linked configuration table.");
                    if (!fSSession.getPolicyConfig()) break block40;
                    fSTableTransaction = this.configOpen(fSTableTransaction, true);
                    fSTableTransaction.remove((TableRow)object4);
                    string5 = null;
                    try {
                        this.configClose(fSTableTransaction);
                    }
                    catch (FSException object62222) {
                        String string13 = CWRGSMessageHelper.getMessage("WARNING_STORAGE_CLOSE_TRANSACTION", new Object[]{((Throwable)object62222).getMessage()});
                        _logger.warning(string4, string13);
                    }
                    break block41;
                    {
                        catch (FSException fSException) {
                            fSSession.unLock();
                            String string14 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_FS_TRANSACTION_REMOVE_FAILED", new Object[]{fSException.getMessage()});
                            _logger.error(string4, string14, fSException);
                            throw new PolicyStoreException(string14, fSException);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var20_28 = null;
                        try {
                            this.configClose(fSTableTransaction);
                        }
                        catch (FSException fSException) {
                            String string15 = CWRGSMessageHelper.getMessage("WARNING_STORAGE_CLOSE_TRANSACTION", new Object[]{fSException.getMessage()});
                            _logger.warning(string4, string15);
                        }
                        throw throwable;
                    }
                }
                object2 = this.configGetContexts();
                if (object2 != null) {
                    object = object2.iterator();
                    while (object.hasNext()) {
                        object5 = (ConfigTableEntry)object.next();
                        if (((ConfigTableEntry)object5).getLinkPerm() == null || !((ConfigTableEntry)object5).getLinkPerm().equals(fSSession.getContextID())) continue;
                        ((ConfigTableEntry)object5).setLinkPerm(null);
                        this.configUpdate((ConfigTableEntry)object5);
                    }
                }
                if ((object = ((ConfigTableEntry)object4).getRoleContextID()) == null || (object5 = this.configGetRoleContexts()) == null || object5.contains(object)) break block42;
                string5 = ((ConfigTableEntry)object4).getRoleTableID();
                _logger.debug(string4, "About to delete the last role context " + (String)object);
                object62222 = new FSSession(null, (String)object);
                ((AdapterSession)object62222).setSandboxTableName(string5);
                ((FSSession)object62222).setPolicyConfig(false);
                ((AdapterSession)object62222).setInitialized(true);
                this.policyDestroy((IAdapterSession)object62222);
                break block42;
            }
            object2 = this.configGetContexts();
            if (object2 != null) {
                object = object2.iterator();
                while (object.hasNext()) {
                    ConfigTableEntry configTableEntry = (ConfigTableEntry)object.next();
                    if (configTableEntry.getRoleContextID() == null || !configTableEntry.getRoleContextID().equals(fSSession.getContextID())) continue;
                    configTableEntry.setRoleTableID(null);
                    configTableEntry.setRoleCtxState((short)2);
                    this.configUpdate(configTableEntry);
                }
            }
        }
        _logger.debug(string4, "Checking for orphaned role mapping configuration.");
        try {
            if (string != null) {
                object2 = new ConfigTableEntry();
                ((ConfigTableEntry)object2).setRoleContextID((String)object3);
                ((ConfigTableEntry)object2).setRoleTableID(string);
                _logger.debug(string4, "Searching for references for " + (String)object3);
                object = this.configGetEntry((ConfigTableEntry)object2);
                if (object == null) {
                    _logger.debug(string4, "No references to table " + string);
                    string2 = fSTableTransaction.getBaseDir(string);
                    this.policyDestroyTable(string3, string2);
                }
            }
            _logger.debug(string4, "Clearing session.");
            ((TableRow)object4).clear();
            fSSession.clear();
        }
        finally {
            fSSession.unLock();
        }
        _logger.exit(string4);
    }

    public void policyRefresh(IAdapterSession iAdapterSession) throws PolicyStoreException {
        TableVersion tableVersion;
        FSSession fSSession;
        String string;
        block12: {
            String string2;
            string = "policyRefresh( IAdapterSession )";
            _logger.entry(string, iAdapterSession);
            if (iAdapterSession == null) {
                String string3 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_FS_NO_SESSION");
                _logger.error(string, string3);
                throw new PolicyStoreException(string3);
            }
            fSSession = (FSSession)iAdapterSession;
            tableVersion = fSSession.getVersion();
            if (tableVersion == null && (tableVersion = this.policyGetMasterTableVersion(iAdapterSession)) == null) {
                string2 = CWRGSMessageHelper.getMessage("WARNING_STORAGE_REFRESH_NULL_MASTER", new Object[]{fSSession.getClientID(), fSSession.getContextID()});
                _logger.warning(string, string2);
                tableVersion = new TableVersion(0L);
            }
            if (tableVersion == null) {
                string2 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_REFRESH_NULL_MASTER", new Object[]{fSSession.getClientID(), fSSession.getContextID()});
                _logger.error(string, string2);
                throw new PolicyStoreException(string2);
            }
            this.sessionUpdate(fSSession.getClientID(), fSSession.getContextID(), tableVersion);
            if (!tableVersion.equals(this.policyGetMasterVersion(iAdapterSession))) {
                boolean bl = false;
                try {
                    bl = this._rwLockSandboxCopy.getWriterLock();
                    if (bl) {
                        FSDBTable fSDBTable = fSSession.getDBTable();
                        if (fSDBTable != null) {
                            FSQuery.commitDBTable(fSSession.getVersionTableName());
                        }
                        fSSession.setDBTable(null);
                        this._rwLockSandboxCopy.releaseLock();
                        bl = false;
                        break block12;
                    }
                    String string4 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_FS_NO_LOCK", new Object[]{"_rwLockSandboxCopy"});
                    _logger.error(string, string4);
                    throw new PolicyStoreException(string4);
                }
                catch (RWLockException rWLockException) {
                    String string5 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_REFRESH_EXCEPTION", new Object[]{fSSession.getClientID(), fSSession.getContextID(), rWLockException.getMessage()});
                    _logger.error(string, string5);
                    throw new PolicyStoreException(string5, rWLockException);
                }
                finally {
                    if (bl) {
                        this._rwLockSandboxCopy.releaseLock();
                        bl = false;
                    }
                }
            }
        }
        fSSession.setVersion(null);
        fSSession.setEffectiveVersion(tableVersion);
        _logger.exit(string);
    }

    private void sessionRemoveEntry(FSTableTransaction fSTableTransaction, String string, String string2) throws FSException {
        String string3 = "sessionRemoveEntry( FSTableTransaction, String, String )";
        _logger.entry(string3, new Object[]{fSTableTransaction, string, string2});
        SessionTableEntry sessionTableEntry = new SessionTableEntry(string, string2);
        fSTableTransaction.remove(sessionTableEntry);
        _logger.exit(string3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AdapterResultSet policyGetFull(IAdapterSession iAdapterSession, StoreRecordQuery storeRecordQuery, boolean bl) throws PolicyStoreException {
        Object object;
        Object object2;
        String string = "policyGetFull( IAdapterSession, StoreRecordQuery, boolean )";
        _logger.entry(string, new Object[]{iAdapterSession, storeRecordQuery, bl});
        FSSession fSSession = this.policyInitializeSession(iAdapterSession, true);
        if (!bl && fSSession.getVersion() == null) {
            boolean bl2 = this._rwLockSandboxCopy.getWriterLock();
            if (!bl2) {
                String string2 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_FS_NO_LOCK", new Object[]{"_rwLockSandboxCopy"});
                _logger.error(string, string2);
                throw new PolicyStoreException(string2);
            }
            FSQuery.commitDBTable(fSSession.getVersionTableName());
            fSSession.setDBTable(null);
            this._rwLockSandboxCopy.releaseLock();
            bl2 = false;
            object2 = new FSTableTransaction(this.getConfiguration());
            object = fSSession.getClientID();
            String string3 = fSSession.getContextID();
            String string4 = fSSession.getSandboxTableName();
            this.policyCreateSandbox((FSTableTransaction)object2, (String)object, string3, string4);
        }
        FSDBTable fSDBTable = null;
        object2 = null;
        object = null;
        boolean bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            block25: {
                try {
                    try {
                        Object object3;
                        Object object4;
                        bl3 = this._rwLockSandboxCopy.getWriterLock();
                        if (!bl3) {
                            String string8 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_FS_NO_LOCK", new Object[]{"_rwLockSandboxCopy"});
                            _logger.error(string, string8);
                            throw new PolicyStoreException(string8);
                        }
                        FSTableTransaction fSTableTransaction = new FSTableTransaction(this.getConfiguration());
                        fSDBTable = fSSession.getDBTable();
                        if (fSDBTable == null || !fSTableTransaction.existsPath(fSDBTable.getPathName())) {
                            fSDBTable = null;
                            object4 = fSSession.getSandboxTableName();
                            if (object4 == null) {
                                object4 = this.policyGetTableID(fSSession);
                                fSSession.setSandboxTableName((String)object4);
                            }
                            if ((object3 = this.policyGetMasterTableVersion(iAdapterSession)) != null) {
                                if (fSSession.getVersion() == null) {
                                    fSSession.setVersion((TableVersion)object3);
                                }
                                object2 = (String)object4 + this.convertTStoFN(((TableVersion)object3).getVersion());
                                String string5 = fSSession.getClientID();
                                if (!fSTableTransaction.existsTable(string5, (String)object4, (String)object2)) {
                                    bl4 = _rwLockMaster.getWriterLock();
                                    if (!bl4) {
                                        String string6 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_FS_NO_LOCK", new Object[]{"_rwLockMaster"});
                                        _logger.error(string, string6);
                                        throw new PolicyStoreException(string6);
                                    }
                                    if (((TableVersion)object3).getVersionNumber() != 0L) {
                                        fSTableTransaction.copyTable(string5, (String)object4, (String)object2);
                                    }
                                    _rwLockMaster.releaseLock();
                                    bl4 = false;
                                }
                                if (((TableVersion)object3).getVersionNumber() != 0L) {
                                    String string7 = fSTableTransaction.getClientDir(fSSession.getClientID(), (String)object4);
                                    fSDBTable = new FSDBTable(string7, (String)object2);
                                    fSSession.setDBTable(fSDBTable);
                                }
                            } else {
                                _logger.debug(string, "The master version is null. Nothing to return.");
                            }
                        }
                        if (fSDBTable != null) {
                            object2 = fSDBTable.getDBTableName();
                            object4 = CollectionFactory.newList(1);
                            object4.add(fSDBTable);
                            object3 = new FSQuery(this, (String)object2, (List)object4, storeRecordQuery, new int[]{COLUMN_POLICY_XMTID, COLUMN_POLICY_ATTR_VALUE_XMTID}, false);
                            object = new FSAdapterResultSet((FSQuery)object3);
                        } else {
                            object = new FSAdapterResultSet((Set)null);
                        }
                        this._rwLockSandboxCopy.releaseLock();
                        bl3 = false;
                        Object var17_29 = null;
                        if (!bl3) break block25;
                    }
                    catch (FSException fSException) {
                        String string9 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_GET_FULL_EXCEPTION", new Object[]{fSSession.getClientID(), fSSession.getContextID(), fSException.getMessage()});
                        _logger.error(string, string9, fSException);
                        throw new PolicyStoreException(string9, fSException);
                    }
                    catch (RWLockException rWLockException) {
                        String string10 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_GET_FULL_EXCEPTION", new Object[]{fSSession.getClientID(), fSSession.getContextID(), rWLockException.getMessage()});
                        _logger.error(string, string10, rWLockException);
                        throw new PolicyStoreException(string10, rWLockException);
                    }
                    catch (Exception exception) {
                        String string11 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_GET_FULL_EXCEPTION", new Object[]{fSSession.getClientID(), fSSession.getContextID(), exception.getMessage()});
                        _logger.error(string, string11, exception);
                        PolicyStoreException policyStoreException = new PolicyStoreException(string11, exception);
                        throw policyStoreException;
                    }
                }
                catch (Throwable throwable) {
                    Object var17_30 = null;
                    if (bl3) {
                        this._rwLockSandboxCopy.releaseLock();
                        bl3 = false;
                    }
                    if (bl4) {
                        _rwLockMaster.releaseLock();
                        bl4 = false;
                    }
                    fSSession.unLock();
                    throw throwable;
                }
                this._rwLockSandboxCopy.releaseLock();
                bl3 = false;
            }
            if (bl4) {
                _rwLockMaster.releaseLock();
                bl4 = false;
            }
            fSSession.unLock();
        } else {
            fSSession.unLock();
            _logger.debug(string, "The return Set is null. Changing to an empty Set.");
            object = new FSAdapterResultSet(CollectionFactory.newSet());
        }
        _logger.exit(string, object);
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AdapterResultSet policyGetDelta(IAdapterSession iAdapterSession, String string, StoreRecordQuery storeRecordQuery) throws PolicyStoreException {
        FSSession fSSession;
        FSAdapterResultSet fSAdapterResultSet;
        String string2;
        block16: {
            string2 = "policyGetDelta(IAdapterSession, String, StoreRecordQuery)";
            _logger.entry(string2, new Object[]{iAdapterSession, string, storeRecordQuery});
            fSAdapterResultSet = null;
            fSSession = this.policyInitializeSession(iAdapterSession, false);
            boolean bl = false;
            try {
                try {
                    Object object;
                    if (fSSession.getVersion() == null) {
                        object = this.policyGetMasterTableVersion(iAdapterSession);
                        if (object == null) {
                            _logger.debug(string2, "Null master version. Nothing to retrieve.");
                        }
                        fSSession.setVersion((TableVersion)object);
                    }
                    string = fSSession.getEffectiveVersion();
                    object = new FSTableTransaction(this.getConfiguration());
                    String string3 = fSSession.getSandboxTableName();
                    if (string3 == null) {
                        string3 = this.policyGetTableID(fSSession);
                        fSSession.setSandboxTableName(string3);
                    }
                    if (string3 != null) {
                        String string4 = ((FSTableTransaction)object).getBaseDir(string3);
                        bl = this._rwLockDeltas.getWriterLock();
                        if (!bl) {
                            String string5 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_FS_NO_LOCK", new Object[]{"_rwLockDeltas"});
                            _logger.error(string2, string5);
                            throw new PolicyStoreException(string5);
                        }
                        List list = this.policyListDeltas(string4, string3, string, fSSession.getVersion().getVersion());
                        if (list != null && !list.isEmpty()) {
                            Collections.sort(list);
                            FSQuery fSQuery = new FSQuery(this, string3, list, storeRecordQuery, new int[]{COLUMN_POLICY_XMTID, COLUMN_POLICY_ATTR_VALUE_XMTID}, true);
                            fSAdapterResultSet = new FSAdapterResultSet(fSQuery);
                        } else {
                            _logger.debug(string2, "No deltas found for this client.");
                            fSAdapterResultSet = new FSAdapterResultSet((Set)null);
                        }
                        this._rwLockDeltas.releaseLock();
                        bl = false;
                    } else {
                        String string6 = CWRGSMessageHelper.getMessage("WARNING_STORAGE_GET_DELTA_SANDBOX");
                        _logger.warning(string2, string6);
                        fSAdapterResultSet = new FSAdapterResultSet((Set)null);
                    }
                }
                catch (RWLockException rWLockException) {
                    String string7 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_GET_DELTA_EXCEPTION", new Object[]{rWLockException.getMessage()});
                    _logger.error(string2, string7, rWLockException);
                    throw new PolicyStoreException(string7, rWLockException);
                }
                catch (FSException fSException) {
                    String string8 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_GET_DELTA_EXCEPTION", new Object[]{fSException.getMessage()});
                    _logger.error(string2, string8, fSException);
                    throw new PolicyStoreException(string8, fSException);
                }
                catch (Exception exception) {
                    String string9 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_GET_DELTA_EXCEPTION", new Object[]{exception.getMessage()});
                    _logger.error(string2, string9, exception);
                    throw new PolicyStoreException(string9, exception);
                }
                Object var14_21 = null;
                if (!bl) break block16;
            }
            catch (Throwable throwable) {
                Object var14_22 = null;
                if (bl) {
                    this._rwLockDeltas.releaseLock();
                    bl = false;
                }
                fSSession.unLock();
                throw throwable;
            }
            this._rwLockDeltas.releaseLock();
            bl = false;
        }
        fSSession.unLock();
        _logger.exit(string2, fSAdapterResultSet);
        return fSAdapterResultSet;
    }

    private List policyListDeltas(String string, String string2, String string3, String string4) {
        String string5 = "policyListDeltas( String, String, String, String )";
        _logger.entry(string5, new Object[]{string, string2, string3, string4});
        String string6 = "delta.";
        String[] stringArray = SMFileUtils.listFileNames(string, string6 + "*");
        if (stringArray.length == 0) {
            return null;
        }
        List list = CollectionFactory.newList(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            String string7 = stringArray[i];
            String string8 = string7.substring(string6.length());
            String string9 = this.convertFNtoTS(string8);
            short s = 0;
            if (string3 != null) {
                s = StoreRecordUtil.compareVersions(string9, string3, _logger);
            }
            int n = 1;
            if (string4 != null) {
                n = StoreRecordUtil.compareVersions(string9, string4, _logger);
            }
            if (s != 0 || n <= 0) continue;
            FSDBTable fSDBTable = new FSDBTable(string, string7, string9);
            fSDBTable.setDelta(true);
            list.add(fSDBTable);
        }
        _logger.exit(string5);
        return list;
    }

    private String policyGetTableID(FSSession fSSession) throws PolicyStoreException {
        String string = "policyGetTableID( FSSession )";
        _logger.entry(string, fSSession);
        String string2 = null;
        ConfigTableEntry configTableEntry = fSSession.getConfigEntry();
        String string3 = fSSession.getContextID();
        string2 = configTableEntry != null && configTableEntry.getPermContextID() != null && configTableEntry.getPermContextID().equals(string3) ? configTableEntry.getPermTableID() : (configTableEntry != null && configTableEntry.getRoleContextID() != null && configTableEntry.getRoleContextID().equals(string3) ? configTableEntry.getRoleTableID() : this.configGetTableID(string3));
        _logger.exit(string, string2);
        return string2;
    }

    protected TableVersion getMasterVersion(IAdapterSession iAdapterSession) throws PolicyStoreException {
        String string = "getMasterVersion(IAdapterSession)";
        _logger.entry(string, iAdapterSession);
        if (iAdapterSession == null) {
            String string2 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_FS_NO_SESSION");
            _logger.error(string, string2);
            throw new PolicyStoreException(string2);
        }
        FSSession fSSession = (FSSession)iAdapterSession;
        SessionTableEntry sessionTableEntry = this.sessionGetEntry("0", fSSession.getContextID());
        TableVersion tableVersion = null;
        if (sessionTableEntry != null) {
            tableVersion = new TableVersion(sessionTableEntry);
        }
        if (tableVersion == null) {
            _logger.debug(string, "Creating initial master DB version.");
            tableVersion = new TableVersion(1L);
        }
        _logger.exit(string, tableVersion);
        return tableVersion;
    }

    protected void setMasterVersion(IAdapterSession iAdapterSession, TableVersion tableVersion) throws PolicyStoreException {
        String string = "setMasterVersion( IAdapterSession, String )";
        _logger.entry(string, new Object[]{iAdapterSession, tableVersion});
        if (iAdapterSession == null) {
            String string2 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_FS_NO_SESSION");
            _logger.error(string, string2);
            throw new PolicyStoreException(string2);
        }
        FSSession fSSession = (FSSession)iAdapterSession;
        SessionTableEntry sessionTableEntry = new SessionTableEntry("0", fSSession.getContextID());
        TableVersion.setSessionEntry(tableVersion, sessionTableEntry);
        this.sessionUpdate(sessionTableEntry);
        _logger.exit(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void policyCommit(IAdapterSession iAdapterSession, boolean bl) throws PolicyStoreException {
        Object object;
        Object object22222;
        ConfigTableEntry configTableEntry;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        FSSession fSSession;
        String string;
        block63: {
            FSTableTransaction fSTableTransaction;
            FSTableTransaction fSTableTransaction2;
            boolean bl2;
            boolean bl3;
            boolean bl4;
            block61: {
                block60: {
                    string = "policyCommit(IAdapterSession, boolean)";
                    _logger.entry(string, new Object[]{iAdapterSession, bl});
                    fSSession = this.policyInitializeSession(iAdapterSession, true);
                    boolean bl5 = true;
                    FSTableTransaction fSTableTransaction3 = (FSTableTransaction)fSSession.getPolicyTxn();
                    if (fSTableTransaction3 == null) {
                        fSSession.setPolicyTxn(null);
                        _logger.debug(string, "No policy to commit.");
                        bl5 = false;
                    }
                    bl4 = false;
                    bl3 = false;
                    bl2 = false;
                    fSTableTransaction2 = null;
                    fSTableTransaction = null;
                    bl4 = this._rwLockSandboxCopy.getWriterLock();
                    if (!bl4) {
                        String string2 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_FS_NO_LOCK", new Object[]{"_rwLockSandboxCopy"});
                        _logger.error(string, string2);
                        throw new PolicyStoreException(string2);
                    }
                    FSQuery.commitDBTable(fSSession.getVersionTableName());
                    fSSession.setDBTable(null);
                    this._rwLockSandboxCopy.releaseLock();
                    bl4 = false;
                    object7 = this.getMasterVersion(iAdapterSession);
                    TableVersion tableVersion = new TableVersion((TableVersion)object7);
                    tableVersion.increment();
                    object6 = null;
                    bl3 = _rwLockMaster.getWriterLock();
                    bl2 = this._rwLockSandbox.getWriterLock();
                    if (bl3 && bl2) {
                        if (bl) {
                            object5 = new FSTableTransaction(this.getConfiguration());
                            if (((FSTableTransaction)object5).existsTable((String)(object4 = fSSession.getSandboxTableName()))) {
                                object3 = ((FSTableTransaction)object5).getBaseDir((String)object4) + File.separator + "delta" + "." + this.convertTStoFN(tableVersion.getVersion());
                                ((FSTableTransaction)object5).openBaseTable((String)object4, permPolicySchema_);
                                ((FSTableTransaction)object5).moveToDelta((String)object3, 2);
                            }
                            ((FSTableTransaction)object5).clearAll();
                            ((FSTableTransaction)object5).closeTable();
                            object3 = new FSDBTable(((FSTableTransaction)object5).getClientDir(fSSession.getClientID(), (String)object4), (String)object4);
                            ((FSDBTable)object3).deleteFile(false);
                            this.policyCreateClient(fSSession.getClientID(), fSSession.getContextID(), (String)object4);
                            tableVersion.increment();
                        }
                        fSSession.setPolicyTxn(null);
                        if (bl5) {
                            fSTableTransaction2 = new FSTableTransaction(this.getConfiguration());
                            fSTableTransaction2.openBaseTable(fSSession.getSandboxTableName(), permPolicySchema_);
                            fSTableTransaction = new FSTableTransaction(this.getConfiguration());
                            fSTableTransaction.openClientTable(fSSession.getClientID(), fSSession.getSandboxTableName(), permPolicySchema_);
                            object5 = new int[]{COLUMN_POLICY_XMTID, COLUMN_POLICY_PERMTYPE, COLUMN_POLICY_CLASSNAME, COLUMN_POLICY_ATTR_NAME, COLUMN_POLICY_ATTR_VALUE_XMTID};
                            fSTableTransaction.applyTable(fSTableTransaction3, (int[])object5, tableVersion, COLUMN_POLICY_UPDATEVERSION);
                            object4 = fSTableTransaction2.getPath();
                            object6 = fSTableTransaction2.getDir();
                            fSTableTransaction2.closeTable();
                            object3 = FSTableTransaction.archive((String)object4, this.convertTStoFN(((TableVersion)object7).getVersion()));
                            fSTableTransaction.rebuild((String)object4);
                            fSTableTransaction.closeTable(true);
                            if (!this.keepArchives_) {
                                SMFileUtils.deleteFile((String)object3, false);
                            }
                        }
                    } else {
                        String string3 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_FS_NO_LOCK", new Object[]{"_rwLockMaster & _rwLockSandbox"});
                        _logger.error(string, string3);
                        throw new PolicyStoreException(string3);
                    }
                    this.policyCreateClient(fSSession.getClientID(), fSSession.getContextID(), fSSession.getSandboxTableName());
                    _rwLockMaster.releaseLock();
                    bl3 = false;
                    this._rwLockSandbox.releaseLock();
                    bl2 = false;
                    this.setMasterVersion(iAdapterSession, tableVersion);
                    if (!bl5) break block60;
                    object5 = fSTableTransaction3.getPath();
                    fSTableTransaction3.closeTable();
                    FSTableTransaction.moveDB((String)object5, object6, "delta." + this.convertTStoFN(tableVersion.getVersion()));
                    object4 = new FSTableTransaction(this.getConfiguration());
                    ((FSTableTransaction)object4).createClientDeltaTable(fSSession.getClientID(), fSSession.getSandboxTableName(), null, permPolicySchema_);
                }
                configTableEntry = null;
                if (!bl3) break block61;
                _rwLockMaster.releaseLock();
                bl3 = false;
            }
            if (bl4) {
                this._rwLockSandboxCopy.releaseLock();
                bl4 = false;
            }
            if (bl2) {
                this._rwLockSandbox.releaseLock();
                bl2 = false;
            }
            try {
                if (fSTableTransaction2 != null && fSTableTransaction2.isOpen()) {
                    fSTableTransaction2.closeTable();
                }
            }
            catch (FSException object22222) {
                object = CWRGSMessageHelper.getMessage("WARNING_STORAGE_CLOSE_TRANSACTION", new Object[]{((Throwable)object22222).getMessage()});
                _logger.warning(string, (String)object);
            }
            try {
                if (fSTableTransaction != null && fSTableTransaction.isOpen()) {
                    fSTableTransaction.closeTable();
                }
                break block63;
            }
            catch (FSException object22222) {
                object = CWRGSMessageHelper.getMessage("WARNING_STORAGE_CLOSE_TRANSACTION", new Object[]{((Throwable)object22222).getMessage()});
                _logger.warning(string, (String)object);
            }
            break block63;
            {
                catch (FSException fSException) {
                    fSSession.unLock();
                    String string4 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_COMMIT_EXCEPTION", new Object[]{fSException.getMessage()});
                    _logger.error(string, string4, fSException);
                    throw new PolicyStoreException(string4, fSException);
                }
                catch (RWLockException rWLockException) {
                    fSSession.unLock();
                    String string5 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_COMMIT_EXCEPTION", new Object[]{rWLockException.getMessage()});
                    _logger.error(string, string5, rWLockException);
                    throw new PolicyStoreException(string5, rWLockException);
                }
            }
            catch (Throwable throwable) {
                String string6;
                Object var19_30 = null;
                if (bl3) {
                    _rwLockMaster.releaseLock();
                    bl3 = false;
                }
                if (bl4) {
                    this._rwLockSandboxCopy.releaseLock();
                    bl4 = false;
                }
                if (bl2) {
                    this._rwLockSandbox.releaseLock();
                    bl2 = false;
                }
                try {
                    if (fSTableTransaction2 != null && fSTableTransaction2.isOpen()) {
                        fSTableTransaction2.closeTable();
                    }
                }
                catch (FSException fSException) {
                    string6 = CWRGSMessageHelper.getMessage("WARNING_STORAGE_CLOSE_TRANSACTION", new Object[]{fSException.getMessage()});
                    _logger.warning(string, string6);
                }
                try {
                    if (fSTableTransaction != null && fSTableTransaction.isOpen()) {
                        fSTableTransaction.closeTable();
                    }
                }
                catch (FSException fSException) {
                    string6 = CWRGSMessageHelper.getMessage("WARNING_STORAGE_CLOSE_TRANSACTION", new Object[]{fSException.getMessage()});
                    _logger.warning(string, string6);
                }
                throw throwable;
            }
        }
        try {
            this.cleanupDeltas(iAdapterSession);
        }
        catch (RuntimeException runtimeException) {
            _logger.debug(string, "Delta cleanup encountered errors. " + runtimeException.getLocalizedMessage());
        }
        this.setVersionTableName(fSSession);
        object7 = null;
        try {
            boolean bl6 = false;
            object6 = this.configGetEntries(null);
            if (fSSession.getPolicyConfig()) {
                Iterator iterator;
                boolean bl7 = false;
                object4 = null;
                object3 = null;
                if (object6 != null) {
                    iterator = object6.iterator();
                    while (iterator.hasNext()) {
                        configTableEntry = (ConfigTableEntry)iterator.next();
                        object22222 = (String)configTableEntry.getColumn(6);
                        if (object22222 == null || !((String)object22222).equals(fSSession.getContextID())) continue;
                        bl7 = true;
                        if (configTableEntry.getLinkPerm() == null) continue;
                        object = this.configGetEntry(configTableEntry.getLinkPerm());
                        if (((ConfigTableEntry)object).getLinkPerm() != null && ((ConfigTableEntry)object).getLinkPerm().equals(configTableEntry.getPermContextID())) {
                            object4 = ((ConfigTableEntry)object).getRoleContextID();
                            ((ConfigTableEntry)object).setRoleContextID(configTableEntry.getRoleContextID());
                            ((ConfigTableEntry)object).setRoleTableID(configTableEntry.getRoleTableID());
                            ((ConfigTableEntry)object).setRoleCtxState(configTableEntry.getRoleCtxState());
                            ((ConfigTableEntry)object).setLinkPerm(null);
                            this.configUpdate((ConfigTableEntry)object);
                            bl6 = true;
                            object3 = object;
                        } else if (((ConfigTableEntry)object).getRoleContextID() != null) {
                            object4 = configTableEntry.getRoleContextID();
                            configTableEntry.setRoleContextID(((ConfigTableEntry)object).getRoleContextID());
                            configTableEntry.setRoleTableID(((ConfigTableEntry)object).getRoleTableID());
                            ((ConfigTableEntry)object).setRoleCtxState(configTableEntry.getRoleCtxState());
                            object3 = configTableEntry;
                        } else {
                            _logger.debug(string, "A bad state has been encountered.");
                        }
                        configTableEntry.setLinkPerm(null);
                        this.configUpdate(configTableEntry);
                        bl6 = true;
                    }
                }
                if (!bl7) {
                    iterator = fSSession.getConfigEntry();
                    ((ConfigTableEntry)((Object)iterator)).setPermCtxState((short)1);
                    this.configUpdate((ConfigTableEntry)((Object)iterator));
                    bl6 = true;
                    _logger.debug(string, "Adding policy context to table " + fSSession.getContextID());
                }
                if (object4 != null && object3 != null) {
                    iterator = this.configGetEntries(null).iterator();
                    while (iterator.hasNext()) {
                        configTableEntry = (ConfigTableEntry)iterator.next();
                        if (configTableEntry.getRoleContextID() == null || !configTableEntry.getRoleContextID().equals(object4)) continue;
                        configTableEntry.setRoleContextID(((ConfigTableEntry)object3).getRoleContextID());
                        configTableEntry.setRoleTableID(((ConfigTableEntry)object3).getRoleTableID());
                        configTableEntry.setRoleCtxState(((ConfigTableEntry)object3).getRoleCtxState());
                        this.configUpdate(configTableEntry);
                        bl6 = true;
                    }
                }
            } else if (object6 != null) {
                object5 = object6.iterator();
                while (object5.hasNext()) {
                    object4 = (ConfigTableEntry)object5.next();
                    object3 = ((ConfigTableEntry)object4).getRoleContextID();
                    if (object3 == null || !((String)object3).equals(fSSession.getContextID())) continue;
                    if (!((ConfigTableEntry)object4).isRoleInService()) {
                        if (((ConfigTableEntry)object4).getRoleTableID() == null) {
                            ((ConfigTableEntry)object4).setRoleTableID(fSSession.getSandboxTableName());
                        }
                        ((ConfigTableEntry)object4).setRoleCtxState((short)1);
                        this.configUpdate((ConfigTableEntry)object4);
                        bl6 = true;
                    }
                    _logger.debug(string, "Adding role context to table " + fSSession.getContextID());
                }
            } else if (fSSession.getConfigEntry() != null) {
                this.configUpdate(fSSession.getConfigEntry());
                bl6 = true;
            }
            if (bl6) {
                object7 = new FSTableTransaction(this.getConfiguration());
                String string7 = ((FSTableTransaction)object7).getBaseDir(CONFIG_TABLENAME) + File.separator + CONFIG_TABLENAME + ".tbl";
                boolean bl8 = false;
                try {
                    bl8 = _rwLockConfig.lock(true);
                    if (bl8) {
                        this.rebuildTable(string7, false);
                    }
                }
                finally {
                    if (bl8) {
                        _rwLockConfig.releaseLock();
                    }
                }
            }
            Object var24_38 = null;
        }
        catch (Throwable throwable) {
            Object var24_39 = null;
            fSSession.unLock();
            try {
                if (object7 != null) {
                    ((FSTableTransaction)object7).closeTable();
                }
            }
            catch (FSException fSException) {
                String string8 = CWRGSMessageHelper.getMessage("WARNING_STORAGE_CLOSE_TRANSACTION", new Object[]{fSException.getMessage()});
                _logger.warning(string, string8);
            }
            throw throwable;
        }
        fSSession.unLock();
        try {
            if (object7 != null) {
                ((FSTableTransaction)object7).closeTable();
            }
        }
        catch (FSException fSException) {
            String string9 = CWRGSMessageHelper.getMessage("WARNING_STORAGE_CLOSE_TRANSACTION", new Object[]{fSException.getMessage()});
            _logger.warning(string, string9);
        }
        _logger.exit(string);
    }

    private FSSession policyInitializeSession(IAdapterSession iAdapterSession, boolean bl) throws PolicyStoreException {
        _logger.entry("policyInitializeSession");
        if (iAdapterSession == null) {
            String string = CWRGSMessageHelper.getMessage("ERROR_STORAGE_FS_NO_SESSION");
            _logger.error("policyInitializeSession", string);
            throw new PolicyStoreException(string);
        }
        FSSession fSSession = (FSSession)iAdapterSession;
        this.initializeSession(fSSession);
        boolean bl2 = iAdapterSession.lock(bl);
        if (!bl2) {
            String string = "";
            string = bl ? CWRGSMessageHelper.getMessage("ERROR_STORAGE_SESSION_EXCLUSIVE_LOCK") : CWRGSMessageHelper.getMessage("ERROR_STORAGE_SESSION_SHARED_LOCK");
            _logger.error("policyInitializeSession", string);
            throw new PolicyStoreException(string);
        }
        _logger.exit("policyInitializeSession");
        return fSSession;
    }

    private boolean policyRolebackDelta(FSSession fSSession) {
        String string = "policyRolebackDelta( FSSession )";
        _logger.entry(string, fSSession);
        boolean bl = true;
        FSTableTransaction fSTableTransaction = (FSTableTransaction)fSSession.getPolicyTxn();
        if (fSTableTransaction != null) {
            try {
                fSTableTransaction.rollback();
            }
            catch (FSException fSException) {
                String string2 = CWRGSMessageHelper.getMessage("WARNING_STORAGE_ROLLBACK_EXCEPTION");
                _logger.warning(string, string2);
                bl = false;
            }
        }
        _logger.exit(string, bl);
        return bl;
    }

    private void policyCreateClient(String string, String string2, String string3) throws FSException {
        String string4 = "policyCreateClient( String, String, String )";
        _logger.entry(string4, new Object[]{string, string2, string3});
        FSTableTransaction fSTableTransaction = new FSTableTransaction(this.getConfiguration());
        fSTableTransaction.createReplica(string, string3);
        _logger.exit(string4);
    }

    protected FSTableTransaction sessionOpen(FSTableTransaction fSTableTransaction, boolean bl) throws PolicyStoreException {
        String string = "sessionOpen( FSTableTransaction )";
        _logger.entry(string, fSTableTransaction);
        if (fSTableTransaction == null) {
            fSTableTransaction = new FSTableTransaction(this.getConfiguration());
        }
        try {
            boolean bl2 = _rwLockSession.lock(bl);
            if (!bl2) {
                String string2 = "";
                string2 = bl ? CWRGSMessageHelper.getMessage("ERROR_STORAGE_SESSION_EXCLUSIVE_LOCK") : CWRGSMessageHelper.getMessage("ERROR_STORAGE_SESSION_SHARED_LOCK");
                _logger.error(string, string2);
                throw new PolicyStoreException(string2);
            }
            fSTableTransaction.openBaseTable(SESSION_TABLENAME, sessionSchema_);
        }
        catch (Exception exception) {
            try {
                this.sessionClose(fSTableTransaction, false);
            }
            catch (FSException fSException) {
                _logger.error(string, fSException.getLocalizedMessage());
            }
            throw new PolicyStoreException(exception.getLocalizedMessage());
        }
        _logger.exit(string, fSTableTransaction);
        return fSTableTransaction;
    }

    private void sessionClose(FSTableTransaction fSTableTransaction) throws FSException {
        this.sessionClose(fSTableTransaction, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sessionClose(FSTableTransaction fSTableTransaction, boolean bl) throws FSException {
        String string = "sessionClose";
        _logger.entry(string, Boolean.toString(bl));
        try {
            if (fSTableTransaction != null) {
                fSTableTransaction.closeTable(bl);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            boolean bl2 = _rwLockSession.releaseLock();
            if (!bl2) {
                _logger.debug(string, "Lock not released");
            }
            throw throwable;
        }
        boolean bl3 = _rwLockSession.releaseLock();
        if (!bl3) {
            _logger.debug(string, "Lock not released");
        }
        _logger.exit(string);
    }

    public boolean sessionIsClientUnique(String string) throws PolicyStoreException {
        String string2 = "sessionIsClientUnique( String )";
        _logger.entry(string2, string);
        boolean bl = true;
        SessionTableEntry sessionTableEntry = this.sessionGetEntry(string, null);
        if (sessionTableEntry != null) {
            bl = false;
        }
        _logger.exit(string2, bl);
        return bl;
    }

    public boolean sessionIsContextUnique(String string) throws PolicyStoreException {
        String string2 = "sessionIsContextUnique( String )";
        _logger.entry(string2, string);
        boolean bl = true;
        SessionTableEntry sessionTableEntry = this.sessionGetEntry(null, string);
        if (sessionTableEntry != null) {
            bl = false;
        }
        _logger.exit(string2, bl);
        return bl;
    }

    public boolean sessionAddClient(String string, String string2) throws PolicyStoreException {
        String string3 = "sessionAddClient( String, String )";
        _logger.entry(string3, new Object[]{string, string2});
        String string4 = null;
        if (string == null) {
            string4 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_NO_CLIENT_ID");
        }
        if (string2 == null) {
            string4 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_NO_CONTEXT_ID");
        }
        if (string4 != null) {
            throw new PolicyStoreException(string4);
        }
        SessionTableEntry sessionTableEntry = this.sessionGetEntry(string, string2, true);
        _logger.exit(string3);
        return sessionTableEntry == null;
    }

    public void sessionCreate() throws PolicyStoreException {
        String string = "sessionCreate()";
        _logger.entry(string);
        FSTableTransaction fSTableTransaction = new FSTableTransaction(this.getConfiguration());
        if (!((TableTransaction)fSTableTransaction).existsTable(SESSION_TABLENAME)) {
            try {
                ((TableTransaction)fSTableTransaction).createTable(SESSION_TABLENAME, sessionSchema_);
            }
            catch (Exception exception) {
                String string2 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_FS_CREATE_TABLE", new Object[]{SESSION_TABLENAME, exception.getMessage()});
                _logger.error(string, string2, exception);
                throw new PolicyStoreException(string2, exception);
            }
        }
        _logger.exit(string);
    }

    public void sessionDestroy() throws PolicyStoreException {
        String string = "sessionDestroy()";
        _logger.entry(string);
        this.sessionDestroy(null, null, true);
        _logger.exit(string);
    }

    private void sessionDestroy(String string, String string2, boolean bl) throws PolicyStoreException {
        Object object;
        String string3 = "sessionDestroy( String, String, boolean )";
        _logger.entry(string3, new Object[]{string, string2, bl});
        if (string == null && string2 == null) {
            object = "Destroying ALL session table entries.";
            _logger.debug(string3, (String)object);
        }
        if (string != null && string.equals("0")) {
            object = "Attempting to remove master record for context id " + string2 + " (ignored).";
            _logger.debug(string3, (String)object);
            return;
        }
        object = null;
        try {
            Object object2;
            object = this.sessionOpen(null, true);
            Set set = this.sessionGetEntries((FSTableTransaction)object);
            if (set != null) {
                Set set2 = this.configGetContexts();
                object2 = set.iterator();
                while (object2.hasNext()) {
                    SessionTableEntry sessionTableEntry = (SessionTableEntry)object2.next();
                    String string4 = sessionTableEntry.getClientID();
                    if (string4.equals("0")) continue;
                    String string5 = sessionTableEntry.getContextID();
                    if (string != null && !string.equals(string4) || string2 != null && !string2.equals(string5) || set2 == null) continue;
                    Iterator iterator = set2.iterator();
                    while (iterator.hasNext()) {
                        ConfigTableEntry configTableEntry = (ConfigTableEntry)iterator.next();
                        boolean bl2 = false;
                        if (string2 != null) {
                            String string6;
                            String string7 = configTableEntry.getPermContextID();
                            if (string2.equals(string7)) {
                                bl2 = true;
                            }
                            if (string2.equals(string6 = configTableEntry.getRoleContextID())) {
                                bl2 = true;
                            }
                        } else {
                            bl2 = true;
                        }
                        if (!bl2) continue;
                        this.sessionDestroyEntry((FSTableTransaction)object, string4, configTableEntry);
                    }
                }
            } else {
                _logger.debug(string3, "No client entries in the session table.");
            }
            if (!bl) {
                try {
                    this.sessionRemoveEntry((FSTableTransaction)object, string, string2);
                }
                catch (FSException fSException) {
                    object2 = CWRGSMessageHelper.getMessage("WARNING_STORAGE_REMOVE_SESSION_ENTRY", new Object[]{string2, string, fSException.getMessage()});
                    _logger.warning(string3, (String)object2);
                }
            }
            this.sessionClose((FSTableTransaction)object, bl);
            if (bl) {
                this.sessionCreate();
            }
        }
        catch (FSException fSException) {
            String string8 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_DESTROY_SESSION_EXCEPTION", new Object[]{string, string2, fSException.getMessage()});
            _logger.error(string3, string8, fSException);
            throw new PolicyStoreException(string8, fSException);
        }
        _logger.exit(string3);
    }

    private void sessionDestroyEntry(FSTableTransaction fSTableTransaction, String string, ConfigTableEntry configTableEntry) {
        FSDBTable fSDBTable;
        String string2 = "sessionDestroyEntry( FSTableTransaction, String, ConfigTableEntry )";
        _logger.entry(string2, new Object[]{fSTableTransaction, string, configTableEntry});
        if (string == null) {
            String string3 = CWRGSMessageHelper.getMessage("WARNING_STORAGE_SESSION_NULL_SESSION");
            _logger.warning(string2, string3);
            return;
        }
        String string4 = configTableEntry.getPermTableID();
        String string5 = fSTableTransaction.getClientDir(string, string4);
        if (SMFileUtils.fileExists(string5).booleanValue()) {
            fSDBTable = new FSDBTable(string5, string4);
            fSDBTable.deleteFile(true);
        }
        if (SMFileUtils.fileExists(string5 = fSTableTransaction.getClientDir(string, string4 = configTableEntry.getRoleTableID())).booleanValue()) {
            fSDBTable = new FSDBTable(string5, string4);
            fSDBTable.deleteFile(true);
        }
        _logger.exit(string2);
    }

    private Set sessionGetEntries() throws PolicyStoreException {
        String string = "sessionGetEntries()";
        _logger.entry(string);
        Set set = this.sessionGetEntries(null);
        _logger.exit(string, set);
        return set;
    }

    /*
     * Loose catch block
     */
    private Set sessionGetEntries(FSTableTransaction fSTableTransaction) throws PolicyStoreException {
        Set set;
        String string;
        block10: {
            string = "sessionGetEntries( FSTableTransaction )";
            _logger.entry(string, fSTableTransaction);
            boolean bl = false;
            if (fSTableTransaction == null) {
                fSTableTransaction = this.sessionOpen(null, false);
                bl = true;
            }
            TableRow tableRow = new TableRow();
            SearchOptions searchOptions = new SearchOptions();
            searchOptions.FIRSTONLY = false;
            searchOptions.SKIP_DELETED = true;
            searchOptions.WHERE = new SearchWhere();
            searchOptions.WHERE.setMatchAll(true);
            SearchAction searchAction = new SearchAction(){

                public TableRow doAction(TableRow tableRow) {
                    if (this.doCollect()) {
                        Set set = (Set)this.getResults().getValue();
                        if (set == null) {
                            set = CollectionFactory.newSet();
                        }
                        set.add(new SessionTableEntry(tableRow));
                        this.getResults().setValue(set);
                    }
                    return tableRow;
                }
            };
            searchAction.setCollect(true);
            set = null;
            SearchResults searchResults = fSTableTransaction.searchTable(tableRow, searchOptions, searchAction);
            set = (Set)searchResults.getValue();
            Object var12_9 = null;
            try {
                if (bl) {
                    this.sessionClose(fSTableTransaction);
                }
                break block10;
            }
            catch (FSException fSException) {
                String string2 = CWRGSMessageHelper.getMessage("WARNING_STORAGE_CLOSE_TRANSACTION", new Object[]{fSException.getMessage()});
                _logger.warning(string, string2);
            }
            break block10;
            {
                catch (FSException fSException) {
                    String string3 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_SESSION_GET_ENTRIES_EXCEPTION", new Object[]{fSException.getMessage()});
                    _logger.error(string, string3, fSException);
                    throw new PolicyStoreException(string3, fSException);
                }
            }
            catch (Throwable throwable) {
                Object var12_10 = null;
                try {
                    if (bl) {
                        this.sessionClose(fSTableTransaction);
                    }
                }
                catch (FSException fSException) {
                    String string4 = CWRGSMessageHelper.getMessage("WARNING_STORAGE_CLOSE_TRANSACTION", new Object[]{fSException.getMessage()});
                    _logger.warning(string, string4);
                }
                throw throwable;
            }
        }
        _logger.exit(string, set);
        return set;
    }

    public SessionTableEntry sessionGetEntry(String string, String string2) throws PolicyStoreException {
        String string3 = "sessionGetEntry( String, String)";
        _logger.entry(string3, new Object[]{string, string2});
        SessionTableEntry sessionTableEntry = this.sessionGetEntry(string, string2, false);
        _logger.exit(string3, sessionTableEntry);
        return sessionTableEntry;
    }

    /*
     * Loose catch block
     */
    public SessionTableEntry sessionGetEntry(String string, String string2, boolean bl) throws PolicyStoreException {
        SessionTableEntry sessionTableEntry;
        String string3;
        block14: {
            FSTableTransaction fSTableTransaction;
            block13: {
                string3 = "sessionGetEntry( String, String, boolean )";
                _logger.entry(string3, new Object[]{string, string2, bl});
                fSTableTransaction = null;
                sessionTableEntry = null;
                fSTableTransaction = this.sessionOpen(null, bl);
                TableRow tableRow = new TableRow();
                if (string2 != null) {
                    tableRow.setColumn(COLUMN_SESSION_POLICYCTXID, string2);
                }
                if (string != null) {
                    tableRow.setColumn(COLUMN_SESSION_CLIENTID, string);
                }
                SearchOptions searchOptions = new SearchOptions();
                searchOptions.FIRSTONLY = true;
                searchOptions.SKIP_DELETED = true;
                searchOptions.WHERE = new SearchWhere(new int[]{COLUMN_SESSION_POLICYCTXID, COLUMN_SESSION_CLIENTID});
                SearchAction searchAction = new SearchAction();
                searchAction.setCollect(true);
                SearchResults searchResults = fSTableTransaction.searchTable(tableRow, searchOptions, searchAction);
                Set set = (Set)searchResults.getValue();
                if (set != null) {
                    Iterator iterator = set.iterator();
                    try {
                        TableRow tableRow2 = (TableRow)iterator.next();
                        if (tableRow2 != null) {
                            sessionTableEntry = new SessionTableEntry(tableRow2);
                        }
                        break block13;
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        String string4 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_SESSION_GET_ENTRIES_EXCEPTION", new Object[]{noSuchElementException.getMessage()});
                        _logger.error(string3, string4, noSuchElementException);
                        throw new PolicyStoreException(string4, noSuchElementException);
                    }
                }
                if (!bl) break block13;
                fSTableTransaction.add(tableRow);
            }
            Object var16_18 = null;
            try {
                this.sessionClose(fSTableTransaction);
            }
            catch (FSException fSException) {
                String string5 = CWRGSMessageHelper.getMessage("WARNING_STORAGE_CLOSE_TRANSACTION", new Object[]{fSException.getMessage()});
                _logger.warning(string3, string5);
            }
            break block14;
            {
                catch (FSException fSException) {
                    String string6 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_SESSION_GET_ENTRIES_EXCEPTION", new Object[]{fSException.getMessage()});
                    _logger.error(string3, string6, fSException);
                    throw new PolicyStoreException(string6, fSException);
                }
            }
            catch (Throwable throwable) {
                Object var16_19 = null;
                try {
                    this.sessionClose(fSTableTransaction);
                }
                catch (FSException fSException) {
                    String string7 = CWRGSMessageHelper.getMessage("WARNING_STORAGE_CLOSE_TRANSACTION", new Object[]{fSException.getMessage()});
                    _logger.warning(string3, string7);
                }
                throw throwable;
            }
        }
        _logger.exit(string3, sessionTableEntry);
        return sessionTableEntry;
    }

    public IAdapterSession newSession(SessionTableEntry sessionTableEntry) throws PolicyStoreException {
        String string = "newSession( SessionTableEntry )";
        _logger.entry(string, sessionTableEntry);
        String string2 = sessionTableEntry.getContextID();
        String string3 = sessionTableEntry.getClientID();
        FSSession fSSession = new FSSession(string3, string2);
        if (this.isRuntime()) {
            SessionTableEntry sessionTableEntry2 = this.sessionGetEntry(string3, string2);
            if (sessionTableEntry2 == null) {
                sessionTableEntry2 = sessionTableEntry;
                this.sessionUpdate(sessionTableEntry2);
            }
            TableVersion tableVersion = new TableVersion(sessionTableEntry2);
            if (sessionTableEntry2.getDBVersion() != 0L && sessionTableEntry2.getModTime() != null) {
                fSSession.setEffectiveVersion(tableVersion);
            }
        }
        _logger.exit(string, fSSession);
        return fSSession;
    }

    private synchronized IAdapterSession initializeSession(FSSession fSSession) throws PolicyStoreException {
        Object object;
        Object object2;
        Object object3;
        String string = "initializeSession(FSSession)";
        _logger.entry(string, fSSession);
        if (!fSSession.isInitialized()) {
            object3 = fSSession.getContextID();
            object2 = fSSession.getClientID();
            fSSession.setPolicyConfig(this.isPermAdapter());
            object = null;
            object = this.isPermAdapter() ? BasicSchema.generatePermTableID((String)object3) : BasicSchema.generateRoleTableID((String)object3);
            FSTableTransaction fSTableTransaction = new FSTableTransaction(this.getConfiguration());
            this.policyCreateSandbox(fSTableTransaction, (String)object2, (String)object3, (String)object);
            fSSession.setSandboxTableName((String)object);
            this.setVersionTableName(fSSession);
            if (this.isConfig()) {
                try {
                    fSTableTransaction.createClientDeltaTable(fSSession.getClientID(), (String)object, null, permPolicySchema_);
                }
                catch (FSException fSException) {
                    String string2 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_INIT_SESSION_EXCEPTION", new Object[]{fSException.getMessage()});
                    _logger.error(string, string2);
                    throw new PolicyStoreException(string2, fSException);
                }
                fSSession.setSandboxDeltaTableName(fSTableTransaction.getTableName());
            }
            fSSession.setInitialized(true);
        } else {
            _logger.debug(string, "Session already initialized.");
        }
        if (fSSession.getConfigEntry() == null) {
            if (fSSession.getPolicyConfig()) {
                object3 = this.configGetEntry(fSSession.getContextID());
                if (object3 == null) {
                    object3 = new ConfigTableEntry(fSSession.getContextID());
                    ((ConfigTableEntry)object3).setPermTableID(fSSession.getSandboxTableName());
                }
                fSSession.setConfigEntry((ConfigTableEntry)object3);
            } else {
                object3 = this.configGetContexts();
                if (object3 != null) {
                    object2 = object3.iterator();
                    while (object2.hasNext()) {
                        object = (ConfigTableEntry)object2.next();
                        if (((ConfigTableEntry)object).getRoleContextID() == null || !((ConfigTableEntry)object).getRoleContextID().equals(fSSession.getContextID())) continue;
                        if (((ConfigTableEntry)object).getRoleTableID() == null) {
                            ((ConfigTableEntry)object).setRoleTableID(fSSession.getSandboxTableName());
                        }
                        fSSession.setConfigEntry((ConfigTableEntry)object);
                        break;
                    }
                }
            }
        }
        if (fSSession.getConfigEntry() == null) {
            object3 = new ConfigTableEntry(fSSession.getContextID());
            ((ConfigTableEntry)object3).setPermTableID(fSSession.getSandboxTableName());
            fSSession.setConfigEntry((ConfigTableEntry)object3);
            _logger.debug(string, "An error was encountered. The details are : unknown CTX ID");
        }
        _logger.exit(string, fSSession);
        return fSSession;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void policyCreateSandbox(FSTableTransaction fSTableTransaction, String string, String string2, String string3) throws PolicyStoreException {
        boolean bl;
        block11: {
            _logger.entry("policyCreateSandbox");
            boolean bl2 = false;
            bl = false;
            try {
                try {
                    bl2 = _rwLockMaster.getWriterLock();
                    bl = this._rwLockSandbox.getWriterLock();
                    if (bl2 && bl) {
                        if (!fSTableTransaction.existsTable(string3)) {
                            _logger.debug("policyCreateSandbox", "Master DB does not exist for contextID " + string2 + ". Creating empty DB.");
                            this.policyCreate(string3);
                        }
                        this.policyCreateClient(string, string2, string3);
                        _rwLockMaster.releaseLock();
                        bl2 = false;
                        this._rwLockSandbox.releaseLock();
                        bl = false;
                    }
                }
                catch (PolicyStoreException policyStoreException) {
                    String string4 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_INIT_SESSION_EXCEPTION", new Object[]{policyStoreException.getMessage()});
                    _logger.error("policyCreateSandbox", string4);
                    throw new PolicyStoreException(string4, policyStoreException);
                }
                catch (RWLockException rWLockException) {
                    String string5 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_INIT_SESSION_EXCEPTION", new Object[]{rWLockException.getMessage()});
                    _logger.error("policyCreateSandbox", string5);
                    throw new PolicyStoreException(string5, rWLockException);
                }
                catch (FSException fSException) {
                    String string6 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_INIT_SESSION_EXCEPTION", new Object[]{fSException.getMessage()});
                    _logger.error("policyCreateSandbox", string6);
                    throw new PolicyStoreException(string6, fSException);
                }
                Object var11_7 = null;
                if (!bl2) break block11;
            }
            catch (Throwable throwable) {
                Object var11_8 = null;
                if (bl2) {
                    _rwLockMaster.releaseLock();
                    bl2 = false;
                }
                if (bl) {
                    this._rwLockSandbox.releaseLock();
                    bl = false;
                }
                throw throwable;
            }
            _rwLockMaster.releaseLock();
            bl2 = false;
        }
        if (bl) {
            this._rwLockSandbox.releaseLock();
            bl = false;
        }
        _logger.exit("policyCreateSandbox");
    }

    private void sessionUpdate(String string, String string2, TableVersion tableVersion) throws PolicyStoreException {
        String string3 = "sessionUpdate( String, String, String, String )";
        _logger.entry(string3, new Object[]{string, string2, tableVersion});
        SessionTableEntry sessionTableEntry = new SessionTableEntry(string, string2);
        sessionTableEntry.setDBVersion(tableVersion.getVersionNumber());
        sessionTableEntry.setModTime(tableVersion.getModTime());
        this.sessionUpdate(sessionTableEntry);
        _logger.exit(string3);
    }

    /*
     * Loose catch block
     */
    public void sessionUpdate(SessionTableEntry sessionTableEntry) throws PolicyStoreException {
        String string;
        block7: {
            string = "sessionUpdate( SessionTableEntry )";
            _logger.entry(string, sessionTableEntry);
            SessionTableEntry sessionTableEntry2 = sessionTableEntry;
            SearchOptions searchOptions = new SearchOptions();
            searchOptions.WHERE = new SearchWhere(new int[]{COLUMN_SESSION_POLICYCTXID, COLUMN_SESSION_CLIENTID});
            searchOptions.FIRSTONLY = true;
            searchOptions.SKIP_DELETED = true;
            FSTableTransaction fSTableTransaction = new FSTableTransaction(this.getConfiguration());
            SearchAction searchAction = null;
            this.sessionOpen(fSTableTransaction, true);
            fSTableTransaction.insert(sessionTableEntry2, searchOptions, searchAction);
            fSTableTransaction.closeTable();
            String string2 = fSTableTransaction.getBaseDir(SESSION_TABLENAME) + File.separator + SESSION_TABLENAME + ".tbl";
            this.rebuildTable(string2, false);
            Object var9_10 = null;
            try {
                this.sessionClose(fSTableTransaction);
            }
            catch (FSException fSException) {
                String string3 = CWRGSMessageHelper.getMessage("WARNING_STORAGE_CLOSE_TRANSACTION", new Object[]{fSException.getMessage()});
                _logger.warning(string, string3);
            }
            break block7;
            {
                catch (FSException fSException) {
                    String string4 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_SESSION_UPDATE_EXCEPTION", new Object[]{fSException.getMessage()});
                    _logger.error(string, string4, fSException);
                    throw new PolicyStoreException(string4, fSException);
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    this.sessionClose(fSTableTransaction);
                }
                catch (FSException fSException) {
                    String string5 = CWRGSMessageHelper.getMessage("WARNING_STORAGE_CLOSE_TRANSACTION", new Object[]{fSException.getMessage()});
                    _logger.warning(string, string5);
                }
                throw throwable;
            }
        }
        _logger.exit(string);
    }

    public void sessionRemove(String string) throws PolicyStoreException {
        String string2 = "removeSession( String )";
        _logger.entry(string2, string);
        TableRow tableRow = new TableRow();
        tableRow.setColumn(COLUMN_SESSION_CLIENTID, string);
        FSTableTransaction fSTableTransaction = this.sessionOpen(null, true);
        try {
            fSTableTransaction.remove(tableRow);
            this.sessionClose(fSTableTransaction);
        }
        catch (FSException fSException) {
            String string3 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_SESSION_REMOVE_EXCEPTION", new Object[]{string, fSException.getMessage()});
            _logger.error(string2, string3, fSException);
            throw new PolicyStoreException(string3, fSException);
        }
        _logger.exit(string2);
    }

    public AdapterResultSet dumpTable(String string) throws PolicyStoreException {
        String string2 = "dumpTable( String )";
        _logger.entry(string2, string);
        FSTableTransaction fSTableTransaction = new FSTableTransaction(this.getConfiguration());
        SearchResults searchResults = null;
        try {
            searchResults = fSTableTransaction.searchPath(string, null, null);
        }
        catch (FSException fSException) {
            String string3 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_DUMP_TABLE_EXCEPTION", new Object[]{string, fSException.getMessage()});
            _logger.error(string2, string3, fSException);
            throw new PolicyStoreException(string3, fSException);
        }
        Set set = (Set)searchResults.getValue();
        FSAdapterResultSet fSAdapterResultSet = new FSAdapterResultSet(set);
        _logger.exit(string2, fSAdapterResultSet);
        return fSAdapterResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void rebuildTable(String string, boolean bl) {
        String string2;
        block16: {
            String string3;
            string2 = "rebuildTable( String, boolean )";
            _logger.entry(string2, new Object[]{string, bl});
            FSTableTransaction fSTableTransaction = new FSTableTransaction(this.getConfiguration());
            FSTableTransaction fSTableTransaction2 = null;
            fSTableTransaction2 = fSTableTransaction.clonePath(string);
            FSTableSchema fSTableSchema = fSTableTransaction2.getSchema();
            fSTableTransaction.createPath(string, fSTableSchema);
            SearchOptions searchOptions = new SearchOptions();
            searchOptions.SKIP_DELETED = true;
            searchOptions.FIRSTONLY = false;
            SearchWhere searchWhere = new SearchWhere();
            searchWhere.setMatchAll(true);
            searchOptions.WHERE = searchWhere;
            TableAddAction tableAddAction = new TableAddAction(fSTableTransaction, TableVersion.getInitialVersion("1"), -1);
            tableAddAction.setCollect(false);
            fSTableTransaction2.searchTable((TableRow)null, searchOptions, (SearchAction)tableAddAction);
            Object var11_12 = null;
            try {
                fSTableTransaction.closeTable();
            }
            catch (FSException fSException) {
                string3 = CWRGSMessageHelper.getMessage("WARNING_STORAGE_CLOSE_TRANSACTION", new Object[]{fSException.getMessage()});
                _logger.warning(string2, string3);
            }
            try {
                if (fSTableTransaction2 != null) {
                    fSTableTransaction2.closeTable(!bl);
                }
                break block16;
            }
            catch (FSException fSException) {
                string3 = CWRGSMessageHelper.getMessage("WARNING_STORAGE_CLOSE_TRANSACTION", new Object[]{fSException.getMessage()});
                _logger.warning(string2, string3);
            }
            break block16;
            {
                catch (FSException fSException) {
                    String string4;
                    String string5 = CWRGSMessageHelper.getMessage("WARNING_STORAGE_REBUILD_TABLE_EXCEPTION", new Object[]{string, fSException.getMessage()});
                    _logger.warning(string2, string5);
                    Object var11_13 = null;
                    try {
                        fSTableTransaction.closeTable();
                    }
                    catch (FSException fSException2) {
                        string4 = CWRGSMessageHelper.getMessage("WARNING_STORAGE_CLOSE_TRANSACTION", new Object[]{fSException2.getMessage()});
                        _logger.warning(string2, string4);
                    }
                    try {
                        if (fSTableTransaction2 != null) {
                            fSTableTransaction2.closeTable(!bl);
                        }
                        break block16;
                    }
                    catch (FSException fSException2) {
                        string4 = CWRGSMessageHelper.getMessage("WARNING_STORAGE_CLOSE_TRANSACTION", new Object[]{fSException2.getMessage()});
                        _logger.warning(string2, string4);
                    }
                }
            }
            catch (Throwable throwable) {
                String string6;
                Object var11_14 = null;
                try {
                    fSTableTransaction.closeTable();
                }
                catch (FSException fSException) {
                    string6 = CWRGSMessageHelper.getMessage("WARNING_STORAGE_CLOSE_TRANSACTION", new Object[]{fSException.getMessage()});
                    _logger.warning(string2, string6);
                }
                try {
                    if (fSTableTransaction2 != null) {
                        fSTableTransaction2.closeTable(!bl);
                    }
                }
                catch (FSException fSException) {
                    string6 = CWRGSMessageHelper.getMessage("WARNING_STORAGE_CLOSE_TRANSACTION", new Object[]{fSException.getMessage()});
                    _logger.warning(string2, string6);
                }
                throw throwable;
            }
        }
        _logger.exit(string2);
    }

    private String convertTStoFN(String string) {
        String string2 = "convertTStoFN( String )";
        _logger.entry(string2, string);
        string = string.replaceAll("\\ ", "_S_");
        string = string.replaceAll("\\:", "_C_");
        string = string.replaceAll("\\.", "_F_");
        _logger.exit(string2, string);
        return string;
    }

    private String convertFNtoTS(String string) {
        String string2 = "convertFNtoTS( String )";
        _logger.entry(string2, string);
        string = string.replaceAll("_S_", " ");
        string = string.replaceAll("_C_", ":");
        string = string.replaceAll("_F_", ".");
        _logger.exit(string2, string);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupDeltas(IAdapterSession iAdapterSession) {
        String string = "clenaupDeltas(IAdapterSession)";
        _logger.entry(string, iAdapterSession);
        FSSession fSSession = (FSSession)iAdapterSession;
        try {
            Set set = this.getCurrentSessionVersions(iAdapterSession);
            FSTableTransaction fSTableTransaction = new FSTableTransaction(this.getConfiguration());
            String string2 = fSSession.getSandboxTableName();
            if (string2 == null) {
                string2 = this.policyGetTableID(fSSession);
            }
            if (string2 != null) {
                String string3;
                String string4 = fSTableTransaction.getBaseDir(string2);
                String[] stringArray = SMFileUtils.listFileNames(string4, (string3 = "delta.") + "*");
                if (stringArray != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        short s;
                        String string5;
                        boolean bl = true;
                        String string6 = stringArray[i];
                        String string7 = string6.substring(string3.length());
                        String string8 = this.convertFNtoTS(string7);
                        Iterator iterator = set.iterator();
                        while (iterator.hasNext()) {
                            string5 = (String)iterator.next();
                            s = StoreRecordUtil.compareVersions(string8, string5, _logger);
                            if (s != 0) continue;
                            bl = false;
                            break;
                        }
                        if (!bl) continue;
                        string5 = string4 + File.separator + stringArray[i];
                        _logger.debug(string, "About to delete delta " + string5);
                        s = 0;
                        try {
                            s = (short)(this._rwLockDeltas.getWriterLock() ? 1 : 0);
                            if (s == 0) continue;
                            SMFileUtils.deleteFile(string5, false);
                            this._rwLockDeltas.releaseLock();
                            s = 0;
                            continue;
                        }
                        catch (RWLockException rWLockException) {
                            String string9 = CWRGSMessageHelper.getMessage("WARNING_STORAGE_CLEANUP_DELTA_EXCEPTION", new Object[]{rWLockException.getMessage()});
                            _logger.warning(string, string9);
                            continue;
                        }
                        finally {
                            if (s != 0) {
                                this._rwLockDeltas.releaseLock();
                                s = 0;
                            }
                        }
                    }
                }
            } else {
                _logger.debug(string, "Tablename was null. Not deleting deltas.");
            }
        }
        catch (PolicyStoreException policyStoreException) {
            String string10 = CWRGSMessageHelper.getMessage("WARNING_STORAGE_CLEANUP_DELTA_EXCEPTION", new Object[]{policyStoreException.getMessage()});
            _logger.warning(string, string10);
        }
        _logger.exit(string);
    }

    private Set getCurrentSessionVersions(IAdapterSession iAdapterSession) throws PolicyStoreException {
        String string = "getCurrentSessionVersions(IAdapterSession)";
        _logger.entry(string, iAdapterSession);
        FSSession fSSession = (FSSession)iAdapterSession;
        Set set = CollectionFactory.newSet();
        try {
            Set set2 = this.sessionGetEntries();
            if (set2 == null) {
                _logger.debug(string, "Null Set of session entries retrieved. Creating empty Set.");
                set2 = CollectionFactory.newSet();
            }
            Iterator iterator = set2.iterator();
            while (iterator.hasNext()) {
                String string2;
                String string3;
                SessionTableEntry sessionTableEntry = (SessionTableEntry)iterator.next();
                if (sessionTableEntry == null || (string3 = sessionTableEntry.getContextID()) == null || !string3.equals(fSSession.getContextID()) || (string2 = TableVersion.getSessionVersion(sessionTableEntry)) == null) continue;
                set.add(string2);
            }
        }
        catch (RWLockException rWLockException) {
            String string4 = CWRGSMessageHelper.getMessage("WARNING_STORAGE_GET_CURRENT_SESSION_VERSIONS_EXCEPTION", new Object[]{rWLockException.getMessage()});
            _logger.warning(string, string4);
        }
        _logger.exit(string, set);
        return set;
    }

    public String policyGetMasterVersion(IAdapterSession iAdapterSession) throws PolicyStoreException {
        String string = "policyGetMasterVersion(IAdapterSession)";
        _logger.entry(string, iAdapterSession);
        TableVersion tableVersion = this.policyGetMasterTableVersion(iAdapterSession);
        String string2 = tableVersion.getVersion();
        _logger.exit(string, string2);
        return string2;
    }

    private TableVersion policyGetMasterTableVersion(IAdapterSession iAdapterSession) throws PolicyStoreException {
        String string = "policyGetMasterTableVersion(IAdapterSession)";
        _logger.entry(string, iAdapterSession);
        TableVersion tableVersion = null;
        FSSession fSSession = (FSSession)iAdapterSession;
        SessionTableEntry sessionTableEntry = this.sessionGetEntry("0", fSSession.getContextID());
        if (sessionTableEntry != null) {
            tableVersion = new TableVersion(sessionTableEntry);
        } else {
            TableVersion tableVersion2 = new TableVersion(0L);
            this.sessionUpdate("0", fSSession.getContextID(), tableVersion2);
            tableVersion = tableVersion2;
        }
        _logger.exit(string, tableVersion);
        return tableVersion;
    }

    public void setVersionTableName(FSSession fSSession) throws PolicyStoreException {
        String string = "setVersionTableName( FSSession )";
        _logger.entry(string, fSSession);
        String string2 = fSSession.getSandboxTableName();
        String string3 = this.policyGetMasterVersion(fSSession);
        if (string3 != null && string2 != null) {
            String string4 = string2 + this.convertTStoFN(string3);
            fSSession.setVersionTableName(string4);
        }
        _logger.exit(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        FSAdapterImpl.configInitialize();
        FSAdapterImpl.sessionInitialize();
        FSAdapterImpl.policyInitialize();
        policyDir_ = compDir_ + File.separator + "policy";
        rootDir_ = null;
        sessionsDir_ = null;
        _rwLockMaster = new RWLock();
        _rwLockSession = new RWLock();
        _rwLockConfig = new RWLock();
    }
}

