/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.iauthz.storage.adapter.impl.fs;

import com.ibm.sec.iauthz.log.SecLogger;
import com.ibm.sec.iauthz.storage.adapter.impl.fs.SMFileUtils;
import com.ibm.sec.iauthz.util.CWRGSMessageHelper;
import com.ibm.sec.iauthz.util.StoreRecordUtil;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

public class FSDBTable
implements Comparable {
    private static final String FSDelta_java_sourceCodeID = "$Id: @(#)69  1.6 src/ws/code/argus/src/com/ibm/sec/iauthz/storage/adapter/impl/fs/FSDBTable.java, argus.store, argus600, 051025a 05/10/20 12:52:46 @(#) $";
    private static SecLogger logger_ = SecLogger.getLogger(class$com$ibm$sec$iauthz$storage$adapter$impl$fs$FSDBTable == null ? (class$com$ibm$sec$iauthz$storage$adapter$impl$fs$FSDBTable = FSDBTable.class$("com.ibm.sec.iauthz.storage.adapter.impl.fs.FSDBTable")) : class$com$ibm$sec$iauthz$storage$adapter$impl$fs$FSDBTable);
    private String dbName_ = null;
    private String dbDir_ = null;
    private boolean isDelta_ = false;
    private FSDBLock fsLock_ = null;
    public static final String DBEXT = ".tbl";
    public static final String DEFAULT_DELTA_EXT = "delta";
    private String version_ = "";
    static /* synthetic */ Class class$com$ibm$sec$iauthz$storage$adapter$impl$fs$FSDBTable;

    public FSDBTable(String string, String string2, String string3) {
        this.dbDir_ = string;
        this.dbName_ = string2;
        this.version_ = string3;
    }

    public FSDBTable(String string, String string2) {
        this.dbDir_ = string;
        this.dbName_ = string2;
    }

    public String getPathName() {
        String string = this.getDBDir() + File.separator + this.getDBTableName();
        if (this.isDelta_) {
            return string;
        }
        return string + DBEXT;
    }

    public String getDBDir() {
        return this.dbDir_;
    }

    public String getDBTableName() {
        return this.dbName_;
    }

    public void setDBDir(String string) {
        this.dbDir_ = string;
    }

    public void setDBTableName(String string) {
        this.dbName_ = string;
    }

    public int compareTo(Object object) {
        if (object == this) {
            return 0;
        }
        if (!(object instanceof FSDBTable)) {
            return 0;
        }
        FSDBTable fSDBTable = (FSDBTable)object;
        short s = StoreRecordUtil.compareVersions(this.version_, fSDBTable.version_, logger_);
        if (s == 0) {
            return 1;
        }
        if (s == 1) {
            return 0;
        }
        if (s == 2) {
            return -1;
        }
        return 0;
    }

    public boolean isDelta() {
        return this.isDelta_;
    }

    public void setDelta(boolean bl) {
        this.isDelta_ = bl;
    }

    public void deleteFile(boolean bl) {
        String string = "deleteFile( boolean )";
        logger_.entry(string, bl);
        SMFileUtils.deleteFile(this.getPathName(), bl);
        logger_.exit(string);
    }

    public String toString() {
        return "[ " + this.dbDir_ + " | " + this.dbName_ + " | " + this.version_ + " ]";
    }

    public void readLock() {
        FSDBLock fSDBLock = this.getLock();
        fSDBLock.readLock();
    }

    public void unlock() {
        FSDBLock fSDBLock = this.getLock();
        fSDBLock.unlock();
    }

    private synchronized FSDBLock getLock() {
        if (this.fsLock_ == null) {
            this.fsLock_ = new FSDBLock(this.getPathName());
        }
        return this.fsLock_;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class FSDBLock {
        private String path_ = null;
        private File file_;
        private RandomAccessFile raf_ = null;
        private FileChannel fc_ = null;
        private FileLock lock_ = null;

        FSDBLock() {
        }

        FSDBLock(String string) {
            this.setPath(string);
        }

        public void setPath(String string) {
            this.path_ = string;
        }

        public synchronized void readLock() {
            String string = "readLock()";
            if (this.path_ != null) {
                try {
                    this.file_ = new File(this.path_);
                    this.raf_ = SMFileUtils.openFile(this.file_, "r");
                    this.fc_ = this.raf_.getChannel();
                    this.lock_ = this.fc_.lock(0L, Long.MAX_VALUE, true);
                }
                catch (IOException iOException) {
                    String string2 = CWRGSMessageHelper.getMessage("WARNING_STORAGE_DBTABLE_LOCK", new Object[]{iOException.getMessage()});
                    logger_.warning(string, string2);
                }
            }
        }

        public synchronized void unlock() {
            String string = "unlock()";
            if (this.lock_ != null) {
                try {
                    this.lock_.release();
                    this.lock_ = null;
                    this.fc_.close();
                    this.fc_ = null;
                    this.raf_.close();
                    this.raf_ = null;
                }
                catch (IOException iOException) {
                    String string2 = CWRGSMessageHelper.getMessage("WARNING_STORAGE_DBTABLE_LOCK", new Object[]{iOException.getMessage()});
                    logger_.warning(string, string2);
                }
            }
        }
    }
}

