/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.iauthz.storage.adapter.impl.fs;

import com.ibm.sec.iauthz.log.SecLogger;
import com.ibm.sec.iauthz.storage.adapter.impl.fs.SMFileUtils;
import com.ibm.sec.iauthz.util.CWRGSMessageHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

public class FSFile {
    private static final String FSFile_java_sourceCodeID = "$Id: @(#)19  1.3 src/ws/code/argus/src/com/ibm/sec/iauthz/storage/adapter/impl/fs/FSFile.java, argus.store, argus600, 051109a 05/11/09 10:47:52 @(#) $";
    private static SecLogger logger_ = SecLogger.getLogger(class$com$ibm$sec$iauthz$storage$adapter$impl$fs$FSFile == null ? (class$com$ibm$sec$iauthz$storage$adapter$impl$fs$FSFile = FSFile.class$("com.ibm.sec.iauthz.storage.adapter.impl.fs.FSFile")) : class$com$ibm$sec$iauthz$storage$adapter$impl$fs$FSFile);
    private static final int MAX_ATTEMPTS = 10;
    private RandomAccessFile file_ = null;
    private FileChannel fileChannel_ = null;
    private FileLock fileLock_ = null;
    private String pathName_;
    private String mode_;
    private long size_;
    static /* synthetic */ Class class$com$ibm$sec$iauthz$storage$adapter$impl$fs$FSFile;

    public FSFile(String string, String string2) {
        this.pathName_ = string;
        this.mode_ = string2;
    }

    public FileChannel getFileChannel() {
        return this.fileChannel_;
    }

    public String getPathName() {
        return this.pathName_;
    }

    public boolean isOpen() {
        return this.fileChannel_ != null;
    }

    public void open(boolean bl) throws IOException {
        this.open(bl, false);
    }

    public void open(boolean bl, boolean bl2) throws IOException {
        Object object;
        Serializable serializable;
        File file;
        logger_.entry("open", bl);
        if (bl && (file = (serializable = new File(this.pathName_)).getParentFile()) != null) {
            file.mkdirs();
        }
        serializable = null;
        file = new File(this.pathName_);
        for (int i = 1; i < 10; ++i) {
            try {
                if (this.file_ == null) {
                    this.file_ = SMFileUtils.openFile(file, "rw");
                }
                if (this.fileChannel_ == null) {
                    this.fileChannel_ = this.file_.getChannel();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                object = new Integer(100 * i).toString();
                String string = CWRGSMessageHelper.getMessage("WARNING_STORAGE_FS_JVM_FILE_LOCKED", new Object[]{file, object});
                logger_.warning("open", "Error locking " + this.pathName_ + " : " + string);
                serializable = fileNotFoundException;
                if (logger_.isDebugLevel()) {
                    fileNotFoundException.printStackTrace();
                }
                try {
                    Thread.sleep(100 * i);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.fileChannel_ != null) break;
        }
        if (this.fileChannel_ != null) {
            try {
                this.fileLock_ = this.fileChannel_.lock(0L, 1L, !bl);
                if (bl2) {
                    this.fileChannel_.truncate(0L);
                }
                this.setSize();
            }
            catch (IOException iOException) {
                String string = iOException.getLocalizedMessage();
                object = CWRGSMessageHelper.getMessage("ERROR_STORAGE_TABLE_TRANS_OPEN_TABLE_EXCEPTION", new Object[]{this.pathName_, string});
                logger_.error("open", (String)object, iOException);
                throw iOException;
            }
            catch (RuntimeException runtimeException) {
                String string = runtimeException.getLocalizedMessage();
                object = CWRGSMessageHelper.getMessage("ERROR_STORAGE_TABLE_TRANS_OPEN_TABLE_EXCEPTION", new Object[]{this.pathName_, string});
                logger_.error("open", (String)object, runtimeException);
                throw runtimeException;
            }
        } else {
            String string = "Timed out waiting to open policy table.";
            String string2 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_FS_JVM_FILE_LOCK_TIMEOUT", new Object[]{this.pathName_});
            logger_.error("open", string2);
            this.close();
            string = "";
            if (serializable != null) {
                string = ((Throwable)serializable).getLocalizedMessage();
            }
            string2 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_TABLE_TRANS_OPEN_TABLE_EXCEPTION", new Object[]{this.pathName_, string});
            logger_.error("open", string2);
            object = new IOException(string2);
            throw object;
        }
        logger_.exit("open");
    }

    private void setSize() throws IOException {
        this.size_ = this.getFileChannel().size();
    }

    public void close() {
        String string;
        logger_.entry("close");
        if (this.fileLock_ != null) {
            try {
                this.fileLock_.release();
                this.fileLock_ = null;
            }
            catch (IOException iOException) {
                logger_.error("close", iOException.getLocalizedMessage());
                string = CWRGSMessageHelper.getMessage("ERROR_STORAGE_TABLE_TRANS_CLOSE_TABLE_EXCEPTION", new Object[]{this.pathName_, iOException.getMessage()});
                logger_.error("close", string, iOException);
            }
        }
        if (this.fileChannel_ != null) {
            try {
                this.fileChannel_.close();
                this.fileChannel_ = null;
            }
            catch (IOException iOException) {
                logger_.error("close", iOException.getLocalizedMessage());
                string = CWRGSMessageHelper.getMessage("ERROR_STORAGE_TABLE_TRANS_CLOSE_TABLE_EXCEPTION", new Object[]{this.pathName_, iOException.getMessage()});
                logger_.error("close", string, iOException);
            }
        }
        if (this.file_ != null) {
            try {
                this.file_.close();
            }
            catch (IOException iOException) {
                logger_.error("close", iOException.getLocalizedMessage());
                string = CWRGSMessageHelper.getMessage("ERROR_STORAGE_TABLE_TRANS_CLOSE_TABLE_EXCEPTION", new Object[]{this.pathName_, iOException.getMessage()});
                logger_.error("close", string, iOException);
            }
            this.file_ = null;
        }
        logger_.exit("close");
    }

    public void copyFrom(FSFile fSFile) throws IOException {
        long l = 0L;
        try {
            l = fSFile.getSize();
            this.byteCopy(fSFile, 0L, l);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            throw runtimeException;
        }
    }

    private void byteCopy(FSFile fSFile, long l, long l2) throws IOException {
        logger_.entry("byteCopy");
        long l3 = Math.min(4096L, l2);
        byte[] byArray = new byte[(int)l3];
        try {
            this.seek(l);
            int n = 0;
            while (l2 > 0L) {
                n = fSFile.file_.read(byArray);
                l2 -= (long)n;
                int n2 = n;
                for (int i = 0; i < n2; i += n2) {
                    this.file_.write(byArray, 0, n2);
                }
            }
        }
        catch (IOException iOException) {
            logger_.error("byteCopy", iOException.getLocalizedMessage());
            iOException.printStackTrace();
            throw iOException;
        }
        logger_.exit("byteCopy");
    }

    public long getSize() {
        return this.size_;
    }

    public void seek(long l) throws IOException {
        this.file_.seek(l);
    }

    public long getFilePointer() throws IOException {
        return this.file_.getFilePointer();
    }

    public void writeInt(int n) throws IOException {
        this.file_.writeInt(n);
    }

    public int readInt() throws IOException {
        return this.file_.readInt();
    }

    public void write(int n) throws IOException {
        this.file_.write(n);
    }

    public int read() throws IOException {
        return this.file_.read();
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.file_.writeBoolean(bl);
    }

    public boolean readBoolean() throws IOException {
        return this.file_.readBoolean();
    }

    public void writeLong(long l) throws IOException {
        this.file_.writeLong(l);
    }

    public long readLong() throws IOException {
        return this.file_.readLong();
    }

    public void writeShort(short s) throws IOException {
        this.file_.writeShort(s);
    }

    public short readShort() throws IOException {
        return this.file_.readShort();
    }

    public void writeUTF(String string) throws IOException {
        this.file_.writeUTF(string);
    }

    public String readUTF() throws IOException {
        return this.file_.readUTF();
    }

    public void truncate(long l) throws IOException {
        this.fileChannel_.truncate(l);
    }

    public void bottom() throws IOException {
        long l = this.file_.length();
        this.file_.seek(l);
    }

    public String toString() {
        return this.pathName_ + ":" + (this.fileLock_ == null ? "(unlocked)" : (this.fileLock_.isShared() ? "(read)" : "write"));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

