/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.iauthz.storage.adapter.impl.fs;

import com.ibm.sec.iauthz.log.SecLogger;
import com.ibm.sec.iauthz.storage.adapter.TableRow;
import com.ibm.sec.iauthz.storage.adapter.impl.SchemaColumn;
import com.ibm.sec.iauthz.storage.adapter.impl.SearchAction;
import com.ibm.sec.iauthz.storage.adapter.impl.SearchOptions;
import com.ibm.sec.iauthz.storage.adapter.impl.SearchResults;
import com.ibm.sec.iauthz.storage.adapter.impl.fs.FSException;
import com.ibm.sec.iauthz.storage.adapter.impl.fs.FSFile;
import com.ibm.sec.iauthz.storage.adapter.impl.fs.FSSchemaColumn;
import com.ibm.sec.iauthz.storage.adapter.impl.fs.FSTableSchema;
import com.ibm.sec.iauthz.storage.adapter.impl.fs.FSTableTransaction;
import com.ibm.sec.iauthz.util.CWRGSMessageHelper;
import java.io.EOFException;
import java.io.IOException;
import java.sql.Date;
import java.util.Collection;
import java.util.Iterator;

public class FSFlatTableHelper {
    private static final String FSFlatTableHelper_java_sourceCodeID = "$Id: @(#)72  1.12 src/ws/code/argus/src/com/ibm/sec/iauthz/storage/adapter/impl/fs/FSFlatTableHelper.java, argus.store, argus600, 060223a 06/02/23 13:11:54 @(#) $";
    private static SecLogger logger = SecLogger.getLogger(class$com$ibm$sec$iauthz$storage$adapter$impl$fs$FSFlatTableHelper == null ? (class$com$ibm$sec$iauthz$storage$adapter$impl$fs$FSFlatTableHelper = FSFlatTableHelper.class$("com.ibm.sec.iauthz.storage.adapter.impl.fs.FSFlatTableHelper")) : class$com$ibm$sec$iauthz$storage$adapter$impl$fs$FSFlatTableHelper);
    protected FSFile table_ = null;
    protected FSTableSchema schema_ = null;
    protected FSTableTransaction txn_ = null;
    private static final int ROW_MARKER = 1897;
    protected long start_ = 0L;
    static /* synthetic */ Class class$com$ibm$sec$iauthz$storage$adapter$impl$fs$FSFlatTableHelper;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Long;

    public FSFlatTableHelper(FSTableTransaction fSTableTransaction) {
        String string = "FSFlatTableHelper( FSTableTransaction )";
        logger.entry(string, fSTableTransaction);
        this.txn_ = fSTableTransaction;
        this.table_ = this.txn_.getTable();
        this.schema_ = this.txn_.getSchema();
        this.start_ = this.txn_.getStart();
        logger.exit(string);
    }

    private void top() throws IOException {
        if (this.table_ != null) {
            this.table_.seek(0L);
        }
    }

    private void bottom() throws IOException {
        if (this.table_ != null) {
            this.table_.bottom();
        }
    }

    private void reset() throws IOException {
        if (this.table_ != null) {
            this.table_.seek(this.start_);
        }
    }

    private void search_record(TableRow tableRow, SearchOptions searchOptions, SearchAction searchAction) throws FSException {
        String string = "search_record( TableRow, SearchOptions, SearchAction )";
        logger.entry(string, new Object[]{tableRow, searchOptions, searchAction});
        try {
            this.reset();
            long l = 0L;
            if (tableRow != null) {
                l = tableRow.getLocation();
            }
            TableRow tableRow2 = null;
            while ((tableRow2 = this.nextRow(l, searchOptions, searchAction)) != null) {
                boolean bl;
                l = this.table_.getFilePointer();
                if (searchOptions.SKIP_DELETED && tableRow2.isDeleted() || !(bl = searchOptions.WHERE != null ? searchOptions.WHERE.match(tableRow, tableRow2) : tableRow.match(tableRow2))) continue;
                if (logger.isDebugLevel()) {
                    logger.debug(string, "match = " + tableRow2);
                }
                if (searchAction != null) {
                    searchAction.doAction(tableRow2);
                    if (searchAction.doDelete()) {
                        this.markRowDeleted(tableRow2.getLocation(), true);
                        this.table_.seek(tableRow2.getLocation());
                    }
                    this.table_.seek(l);
                }
                if (!searchOptions.FIRSTONLY) continue;
                break;
            }
        }
        catch (IOException iOException) {
            String string2 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_TABLE_HELPER_SEARCH_EXCEPTION", new Object[]{iOException.getMessage()});
            logger.error(string, string2, iOException);
            throw new FSException(string2, iOException);
        }
        logger.exit(string);
    }

    private void search_record(TableRow tableRow, Collection collection, SearchOptions searchOptions, SearchAction searchAction) throws FSException {
        String string = "search_record( TableRow, Collection, SearchOptions, SearchAction )";
        logger.entry(string, new Object[]{tableRow, collection, searchOptions, searchAction});
        try {
            this.reset();
            long l = 0L;
            if (tableRow != null) {
                l = tableRow.getLocation();
            }
            TableRow tableRow2 = null;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                boolean bl;
                tableRow2 = (TableRow)iterator.next();
                l = this.table_.getFilePointer();
                if (searchOptions.SKIP_DELETED && tableRow2.isDeleted() || !(bl = searchOptions.WHERE != null ? searchOptions.WHERE.match(tableRow, tableRow2) : tableRow.match(tableRow2))) continue;
                if (logger.isDebugLevel()) {
                    logger.debug(string, "match = " + tableRow2);
                }
                if (searchAction != null) {
                    try {
                        searchAction.doAction(tableRow2);
                        if (searchAction.doDelete()) {
                            this.markRowDeleted(tableRow2.getLocation(), true);
                            this.table_.seek(tableRow2.getLocation());
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    this.table_.seek(l);
                }
                if (!searchOptions.FIRSTONLY) continue;
                break;
            }
        }
        catch (IOException iOException) {
            String string2 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_TABLE_HELPER_SEARCH_EXCEPTION", new Object[]{iOException.getMessage()});
            logger.error(string, string2, iOException);
            throw new FSException(string2, iOException);
        }
        logger.exit(string);
    }

    public SearchResults search(TableRow tableRow, SearchOptions searchOptions, SearchAction searchAction) throws FSException {
        String string = "search( TableRow, SearchOptions, SearchAction )";
        logger.entry(string, new Object[]{tableRow, searchOptions, searchAction});
        if (logger.isDebugLevel()) {
            logger.debug(string, "query = " + tableRow);
            logger.debug(string, "options = " + searchOptions);
            logger.debug(string, "action = " + searchAction);
        }
        SearchResults searchResults = null;
        if (searchAction != null) {
            searchAction.preAction();
        }
        this.search_record(tableRow, searchOptions, searchAction);
        if (searchAction != null) {
            searchAction.postAction();
        }
        if (searchAction != null) {
            searchResults = searchAction.getResults();
        }
        logger.exit(string, searchResults);
        return searchResults;
    }

    public SearchResults search(TableRow tableRow, Collection collection, SearchOptions searchOptions, SearchAction searchAction) throws FSException {
        String string = "search( TableRow, Collection, SearchOptions, SearchAction )";
        logger.entry(string, new Object[]{tableRow, collection, searchOptions, searchAction});
        if (logger.isDebugLevel()) {
            logger.debug(string, "query = " + tableRow);
            logger.debug(string, "options = " + searchOptions);
            logger.debug(string, "action = " + searchAction);
        }
        SearchResults searchResults = null;
        if (searchAction != null) {
            searchAction.preAction();
        }
        this.search_record(tableRow, collection, searchOptions, searchAction);
        if (searchAction != null) {
            searchAction.postAction();
        }
        if (searchAction != null) {
            searchResults = searchAction.getResults();
        }
        logger.exit(string, searchResults);
        return searchResults;
    }

    public SearchResults search(Collection collection, SearchOptions searchOptions, SearchAction searchAction) throws FSException {
        String string = "search( Collection, SearchOptions, SearchAction )";
        logger.entry(string, new Object[]{collection, searchOptions, searchAction});
        SearchResults searchResults = null;
        if (logger.isDebugLevel()) {
            logger.debug(string, "query = " + collection.toArray());
            logger.debug(string, "options = " + searchOptions.toString());
            logger.debug(string, "action = " + searchAction.toString());
        }
        if (searchAction != null) {
            searchAction.preAction();
        }
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                if (!(e2 instanceof TableRow)) {
                    String string2 = CWRGSMessageHelper.getMessage("WARNING_STORAGE_FS_TABLE_HELPER_INVALID_TARGET", new Object[]{e2.getClass().getName()});
                    logger.warning(string, string2);
                    continue;
                }
                this.search_record((TableRow)e2, searchOptions, searchAction);
            }
        }
        if (searchAction != null) {
            searchAction.postAction();
        }
        if (searchAction != null) {
            searchResults = searchAction.getResults();
        }
        logger.exit(string);
        return searchResults;
    }

    private void markRowDeleted(long l, boolean bl) throws IOException {
        String string = "markRowDeleted( long, boolean )";
        logger.entry(string, new Object[]{new Long(l), bl});
        this.table_.seek(l);
        int n = this.table_.readInt();
        if (n != 1897) {
            logger.error(string, "Expecting column");
            return;
        }
        long l2 = this.table_.readLong();
        this.table_.writeBoolean(bl);
        logger.exit(string);
    }

    protected TableRow nextRow(long l, SearchOptions searchOptions, SearchAction searchAction) throws IOException {
        String string = "nextRow( long, SearchOptions, SearchAction )";
        int n = this.schema_.getColumnCount();
        TableRow tableRow = null;
        try {
            if (l != 0L) {
                this.table_.seek(l);
            }
            long l2 = this.table_.getFilePointer();
            int n2 = this.table_.readInt();
            if (n2 != 1897) {
                String string2 = CWRGSMessageHelper.getMessage("WARNING_STORAGE_FS_TABLE_HELPER_EXPECTED_COLUMN");
                logger.warning(string, string2);
                return null;
            }
            long l3 = this.table_.readLong();
            boolean bl = this.table_.readBoolean();
            tableRow = new TableRow(n);
            tableRow.setByteCount(l3);
            tableRow.setDeleted(bl);
            if (searchOptions.CACHE_LOCATION) {
                tableRow.setLocation(l2);
            }
            for (int i = 0; i < n; ++i) {
                int n3 = this.table_.read();
                if (n3 == 0) continue;
                SchemaColumn schemaColumn = (FSSchemaColumn)this.schema_.getColumn(i);
                schemaColumn = this.schema_.getColumn(i);
                int n4 = schemaColumn.getType().getOrdinal();
                if (n4 == FSSchemaColumn.TYPE_INTEGER) {
                    long l4 = this.table_.readLong();
                    tableRow.setColumn(i, new Long(l4));
                    continue;
                }
                if (n4 == FSSchemaColumn.TYPE_CHAR || n4 == FSSchemaColumn.TYPE_VARCHAR) {
                    String string3 = this.table_.readUTF();
                    tableRow.setColumn(i, string3);
                    continue;
                }
                if (n4 == FSSchemaColumn.TYPE_DATE) {
                    long l5 = this.table_.readLong();
                    tableRow.setColumn(i, new Date(l5));
                    continue;
                }
                String string4 = CWRGSMessageHelper.getMessage("WARNING_STORAGE_FS_TABLE_HELPER_SCHEMA_VIOLATION", new Object[]{(class$java$lang$String == null ? FSFlatTableHelper.class$("java.lang.String") : class$java$lang$String).getName(), schemaColumn.getClass().getName()});
                logger.warning(string, string4);
                string4 = CWRGSMessageHelper.getMessage("WARNING_STORAGE_FS_TABLE_HELPER_SKIP_COLUMN", new Object[]{schemaColumn.getName()});
                logger.warning(string, string4);
            }
        }
        catch (EOFException eOFException) {
            if (tableRow != null) {
                String string5 = CWRGSMessageHelper.getMessage("WARNING_STORAGE_FS_TABLE_HELPER_PARTIAL_READ", new Object[]{tableRow == null ? "(null)" : tableRow.toString()});
                logger.warning(string, string5);
            }
            tableRow = null;
        }
        return tableRow;
    }

    protected void addRow(TableRow tableRow) throws IOException {
        String string = "addRow( TableRow )";
        logger.entry(string, tableRow);
        boolean bl = false;
        long l = 0L;
        this.bottom();
        if (logger.isDebugLevel()) {
            logger.debug(string, "row = " + tableRow);
        }
        l = this.table_.getFilePointer();
        this.table_.writeInt(1897);
        this.table_.writeLong(0L);
        this.table_.writeBoolean(false);
        int n = this.schema_.getColumnCount();
        boolean bl2 = false;
        for (int i = 0; i < n; ++i) {
            Object object;
            SchemaColumn schemaColumn = (FSSchemaColumn)this.schema_.getColumn(i);
            bl2 = schemaColumn.isRequired();
            schemaColumn = this.schema_.getColumn(i);
            int n2 = schemaColumn.getType().getOrdinal();
            Object object2 = tableRow.getColumn(i);
            if (object2 == null) {
                this.table_.write(0);
                continue;
            }
            if (n2 == FSSchemaColumn.TYPE_INTEGER) {
                if (object2 instanceof Long) {
                    object = (Long)object2;
                    this.table_.write(1);
                    this.table_.writeLong((Long)object);
                    continue;
                }
                object = CWRGSMessageHelper.getMessage("WARNING_STORAGE_FS_TABLE_HELPER_SCHEMA_VIOLATION", new Object[]{(class$java$lang$Long == null ? FSFlatTableHelper.class$("java.lang.Long") : class$java$lang$Long).getName(), object2.getClass().getName()});
                logger.warning(string, (String)object);
                object = CWRGSMessageHelper.getMessage("WARNING_STORAGE_FS_TABLE_HELPER_SKIP_COLUMN", new Object[]{schemaColumn.getName()});
                logger.warning(string, (String)object);
                this.table_.write(0);
                continue;
            }
            if (n2 == FSSchemaColumn.TYPE_CHAR || n2 == FSSchemaColumn.TYPE_VARCHAR) {
                if (object2 instanceof String) {
                    object = (String)tableRow.getColumn(i);
                    this.table_.write(1);
                    this.table_.writeUTF((String)object);
                    continue;
                }
                object = CWRGSMessageHelper.getMessage("WARNING_STORAGE_FS_TABLE_HELPER_SCHEMA_VIOLATION", new Object[]{(class$java$lang$String == null ? FSFlatTableHelper.class$("java.lang.String") : class$java$lang$String).getName(), object2.getClass().getName()});
                logger.warning(string, (String)object);
                object = CWRGSMessageHelper.getMessage("WARNING_STORAGE_FS_TABLE_HELPER_SKIP_COLUMN", new Object[]{schemaColumn.getName()});
                logger.warning(string, (String)object);
                this.table_.write(0);
                continue;
            }
            if (n2 == FSSchemaColumn.TYPE_DATE) {
                if (object2 instanceof Date) {
                    object = (Date)object2;
                    this.table_.write(1);
                    this.table_.writeLong(((java.util.Date)object).getTime());
                    continue;
                }
                object = CWRGSMessageHelper.getMessage("WARNING_STORAGE_FS_TABLE_HELPER_SCHEMA_VIOLATION", new Object[]{(class$java$lang$String == null ? FSFlatTableHelper.class$("java.lang.String") : class$java$lang$String).getName(), object2.getClass().getName()});
                logger.warning(string, (String)object);
                object = CWRGSMessageHelper.getMessage("WARNING_STORAGE_FS_TABLE_HELPER_SKIP_COLUMN", new Object[]{schemaColumn.getName()});
                logger.warning(string, (String)object);
                this.table_.write(0);
                continue;
            }
            this.table_.write(0);
            object = CWRGSMessageHelper.getMessage("WARNING_STORAGE_FS_TABLE_HELPER_UNKNOWN_TYPE");
            logger.warning(string, (String)object);
            object = CWRGSMessageHelper.getMessage("WARNING_STORAGE_FS_TABLE_HELPER_SKIP_COLUMN", new Object[]{schemaColumn.getName()});
            logger.warning(string, (String)object);
            break;
        }
        long l2 = this.table_.getFilePointer();
        this.table_.seek(l);
        this.table_.writeInt(1897);
        this.table_.writeLong(l2 - l);
        this.table_.seek(l2);
        logger.exit(string);
    }

    protected void delRow(TableRow tableRow) throws FSException {
        String string = "delRow( TableRow )";
        logger.entry(string, tableRow);
        long l = tableRow.getLocation();
        SearchOptions searchOptions = new SearchOptions();
        SearchAction searchAction = new SearchAction();
        searchAction.setDelete(true);
        this.search(tableRow, searchOptions, searchAction);
        logger.exit(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

