/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.iauthz.storage.adapter.impl.fs;

import com.ibm.sec.iauthz.log.SecLogger;
import com.ibm.sec.iauthz.storage.StoreRecordQuery;
import com.ibm.sec.iauthz.storage.adapter.TableRow;
import com.ibm.sec.iauthz.storage.adapter.impl.SearchAction;
import com.ibm.sec.iauthz.storage.adapter.impl.SearchOptions;
import com.ibm.sec.iauthz.storage.adapter.impl.SearchResults;
import com.ibm.sec.iauthz.storage.adapter.impl.SearchWhere;
import com.ibm.sec.iauthz.storage.adapter.impl.fs.FSAdapterImpl;
import com.ibm.sec.iauthz.storage.adapter.impl.fs.FSDBTable;
import com.ibm.sec.iauthz.storage.adapter.impl.fs.FSException;
import com.ibm.sec.iauthz.storage.adapter.impl.fs.FSQueryIterator;
import com.ibm.sec.iauthz.storage.adapter.impl.fs.FSTableRowXMTRef;
import com.ibm.sec.iauthz.storage.adapter.impl.fs.FSTableSchema;
import com.ibm.sec.iauthz.storage.adapter.impl.fs.FSTableTransaction;
import com.ibm.sec.iauthz.storage.adapter.impl.fs.SearchWhereExpr;
import com.ibm.sec.iauthz.util.CollectionFactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FSQuery {
    private static final String FSQuery_java_sourceCodeID = "$Id: @(#)74  1.11 src/ws/code/argus/src/com/ibm/sec/iauthz/storage/adapter/impl/fs/FSQuery.java, argus.store, argus600, 060223a 06/02/23 13:11:54 @(#) $";
    private static SecLogger logger = SecLogger.getLogger(class$com$ibm$sec$iauthz$storage$adapter$impl$fs$FSQuery == null ? (class$com$ibm$sec$iauthz$storage$adapter$impl$fs$FSQuery = FSQuery.class$("com.ibm.sec.iauthz.storage.adapter.impl.fs.FSQuery")) : class$com$ibm$sec$iauthz$storage$adapter$impl$fs$FSQuery);
    public static final int COLUMN_XMTREF_XMTID = 0;
    public static final int COLUMN_XMTREF_XREFID = 1;
    private SearchAction xmtCollectAction_ = null;
    private SearchOptions options_ = new SearchOptions();
    private SearchOptions xmtidoptions_ = new SearchOptions();
    private StoreRecordQuery query_;
    private List dbList_;
    private FSAdapterImpl adapter_;
    private FSTableSchema schema_;
    private String tableName_;
    private Map dbxmtMap_;
    private int maxReturn_;
    private boolean lockFile_;
    private static Map dbTableMap_ = CollectionFactory.newMap();
    private boolean atFirst_;
    private FSQueryIterator dbMapIterator_;
    private boolean stub_;
    static /* synthetic */ Class class$com$ibm$sec$iauthz$storage$adapter$impl$fs$FSQuery;

    public FSQuery() {
        this.xmtidoptions_.SKIP_DELETED = true;
        this.xmtidoptions_.FIRSTONLY = false;
        this.xmtidoptions_.WHERE = new SearchWhere(new int[]{0});
        this.query_ = null;
        this.dbList_ = null;
        this.adapter_ = null;
        this.tableName_ = null;
        this.dbxmtMap_ = null;
        this.maxReturn_ = 0;
        this.lockFile_ = false;
        this.stub_ = false;
    }

    public FSQuery(FSAdapterImpl fSAdapterImpl, String string, List list, StoreRecordQuery storeRecordQuery, int[] nArray, boolean bl) throws FSException {
        this.xmtidoptions_.SKIP_DELETED = true;
        this.xmtidoptions_.FIRSTONLY = false;
        this.xmtidoptions_.WHERE = new SearchWhere(new int[]{0});
        this.query_ = null;
        this.dbList_ = null;
        this.adapter_ = null;
        this.tableName_ = null;
        this.dbxmtMap_ = null;
        this.maxReturn_ = 0;
        this.lockFile_ = false;
        this.stub_ = false;
        this.lockFile_ = bl;
        this.tableName_ = string;
        this.adapter_ = fSAdapterImpl;
        this.dbList_ = list;
        this.query_ = storeRecordQuery;
        this.setMaxReturn(this.query_.getMaxReturn());
        if (!this.lockFile_) {
            this.addOpenCount(this.tableName_, list);
        }
        this.xmtCollectAction_ = new XMTCollectAction();
        this.initialize();
        this.primeList();
    }

    private void initialize() {
        String string = "initialize()";
        logger.entry(string);
        this.options_.FIRSTONLY = false;
        this.options_.SKIP_DELETED = true;
        this.options_.WHERE = this.query_.getQueryExpr() != null ? new SearchWhereExpr(this.query_.getQueryExpr()) : new SearchWhere(this.query_);
        if (this.lockFile_) {
            this.lock();
        }
        logger.exit(string);
    }

    private void lock() {
        String string = "lock()";
        logger.entry(string);
        if (!this.stub_) {
            Iterator iterator = this.dbList_.iterator();
            while (iterator.hasNext()) {
                FSDBTable fSDBTable = (FSDBTable)iterator.next();
                fSDBTable.readLock();
            }
        }
        logger.exit(string);
    }

    private void unlock() {
        String string = "unlock()";
        logger.entry(string);
        if (!this.stub_) {
            Iterator iterator = this.dbList_.iterator();
            while (iterator.hasNext()) {
                FSDBTable fSDBTable = (FSDBTable)iterator.next();
                fSDBTable.unlock();
            }
        }
        logger.exit(string);
    }

    public FSAdapterImpl getAdapter() {
        return this.adapter_;
    }

    public List getDbList() {
        return this.dbList_;
    }

    public FSTableSchema getSchema() {
        return this.schema_;
    }

    public String getTableName() {
        return this.tableName_;
    }

    public void setAdapter(FSAdapterImpl fSAdapterImpl) {
        this.adapter_ = fSAdapterImpl;
    }

    public void setDbList(List list) {
        this.dbList_ = list;
    }

    public void setSchema(FSTableSchema fSTableSchema) {
        this.schema_ = fSTableSchema;
    }

    public void setTableName(String string) {
        this.tableName_ = string;
    }

    public int getMaxReturn() {
        return this.maxReturn_;
    }

    public void setMaxReturn(int n) {
        this.maxReturn_ = n;
    }

    public StoreRecordQuery getQuery() {
        return this.query_;
    }

    private void primeList() throws FSException {
        String string = "primeList()";
        logger.entry(string);
        Iterator iterator = this.dbList_.iterator();
        this.dbxmtMap_ = CollectionFactory.newMap(this.dbList_.size());
        while (iterator.hasNext()) {
            FSDBTable fSDBTable = (FSDBTable)iterator.next();
            Object object = this.primeDBList(fSDBTable);
            this.dbxmtMap_.put(fSDBTable, object);
        }
        logger.exit(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object primeDBList(FSDBTable fSDBTable) throws FSException {
        Object object;
        String string = "primeDBList( FSDBTable )";
        logger.entry(string);
        FSTableTransaction fSTableTransaction = new FSTableTransaction(this.adapter_.getConfiguration());
        fSTableTransaction.openTable(fSDBTable.getPathName(), null, "r", false);
        this.schema_ = fSTableTransaction.getSchema();
        List list = null;
        Set set = null;
        try {
            object = fSTableTransaction.searchTable(this.query_, this.options_, this.xmtCollectAction_);
            list = (List)((SearchResults)object).getValue();
            set = this.resolveXMTIDs(fSTableTransaction, list);
        }
        finally {
            fSTableTransaction.closeTable();
        }
        if (set == null || set.isEmpty()) {
            return null;
        }
        if (this.query_.getSearchDepth() == 2) {
            logger.exit(string, "Shallow set");
            return set;
        }
        object = CollectionFactory.newMap(set.size());
        TableRow tableRow = null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object object2;
            Set set2 = null;
            tableRow = (TableRow)iterator.next();
            if (logger.isDebugLevel()) {
                logger.debug(string, " Hit XMTID id = " + tableRow.getColumn(0));
            }
            Object object3 = tableRow.getColumn(1);
            if (logger.isDebugLevel()) {
                logger.debug(string, " Hit XMTID Xref id = " + object3);
            }
            if (object3 != null) {
                object2 = null;
                try {
                    object2 = new FSTableTransaction(this.adapter_.getConfiguration());
                    ((FSTableTransaction)object2).openTable(fSDBTable.getPathName(), this.schema_, "r", false);
                    set2 = this.xmtDepthSearch((FSTableTransaction)object2, object3, null);
                }
                finally {
                    if (object2 != null) {
                        ((FSTableTransaction)object2).closeTable();
                    }
                }
            }
            if ((object2 = (List)object.get(tableRow.getColumn(0))) == null) {
                object2 = CollectionFactory.newList(list.size() * 2);
                object.put(tableRow.getColumn(0), object2);
            }
            if (set2 == null) {
                object2.add(tableRow);
                continue;
            }
            object2.add(tableRow);
            object2.addAll(set2);
        }
        logger.exit(string, object);
        return object;
    }

    private Set resolveXMTIDs(FSTableTransaction fSTableTransaction, Collection collection) throws FSException {
        String string = "resolveXMITIDs( FSTableTransaction, Collection )";
        logger.entry(string);
        Set set = null;
        if (collection != null) {
            TableRow tableRow = new TableRow();
            SearchAction searchAction = new SearchAction(){

                public TableRow doAction(TableRow tableRow) {
                    FSTableRowXMTRef fSTableRowXMTRef = new FSTableRowXMTRef(tableRow);
                    return super.doAction(fSTableRowXMTRef);
                }
            };
            searchAction.setCollect(true);
            ResolveXMTWhere resolveXMTWhere = new ResolveXMTWhere(collection);
            resolveXMTWhere.setMatchAll(true);
            SearchOptions searchOptions = new SearchOptions();
            searchOptions.FIRSTONLY = false;
            searchOptions.WHERE = resolveXMTWhere;
            SearchResults searchResults = fSTableTransaction.searchTable(tableRow, searchOptions, searchAction);
            set = (Set)searchResults.getValue();
        }
        logger.exit(string);
        return set;
    }

    private Set xmtDepthSearch(FSTableTransaction fSTableTransaction, Object object, Set set) throws FSException {
        String string = "xmtDepthSearch( FSDBTable, Object, Set )";
        logger.entry(string, object);
        if (object != null) {
            TableRow tableRow = new TableRow(1);
            tableRow.setColumn(0, object);
            SearchResults searchResults = fSTableTransaction.searchTable(tableRow, this.xmtidoptions_, this.xmtCollectAction_);
            List list = (List)searchResults.getValue();
            if (list != null && !list.isEmpty()) {
                if (set == null) {
                    set = CollectionFactory.newSet(list.size() * 2);
                }
                FSTableRowXMTRef fSTableRowXMTRef = null;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Object object2;
                    fSTableRowXMTRef = (FSTableRowXMTRef)iterator.next();
                    if (logger.isDebugLevel()) {
                        object2 = "[" + fSTableRowXMTRef.getColumn(1) + "] ";
                        logger.debug(string, (String)object2);
                    }
                    set.add(fSTableRowXMTRef);
                    object2 = fSTableRowXMTRef.getColumn(1);
                    if (object2 == null) continue;
                    set = this.xmtDepthSearch(fSTableTransaction, object2, set);
                }
            }
        }
        logger.exit(string, set);
        return set;
    }

    public boolean atFirst() {
        return this.atFirst_;
    }

    public void close() {
        String string = "close()";
        logger.entry(string);
        if (this.dbMapIterator_ != null) {
            this.dbMapIterator_ = null;
        }
        if (this.lockFile_) {
            this.unlock();
        } else {
            DBTableEntry dBTableEntry = (DBTableEntry)dbTableMap_.get(this.tableName_);
            if (dBTableEntry != null) {
                dBTableEntry.decrementCount();
                if (dBTableEntry.getCount() <= 0 && dBTableEntry.getCommitted()) {
                    this.unlock();
                    FSQuery.deleteResources(this.dbList_);
                    dbTableMap_.remove(this.tableName_);
                }
            }
        }
        logger.exit(string);
    }

    public Set query() throws FSException {
        String string = "query()";
        logger.entry(string);
        this.dbMapIterator_ = new FSQueryIterator(this, this.dbxmtMap_);
        Set set = this.nextPage();
        this.atFirst_ = true;
        logger.exit(string);
        return set;
    }

    public Set nextPage() throws FSException {
        String string = "nextPage()";
        logger.entry(string);
        if (this.dbMapIterator_ == null) {
            return null;
        }
        Set set = this.dbMapIterator_.nextPage();
        this.atFirst_ = false;
        logger.exit(string);
        return set;
    }

    public boolean hasNext() {
        String string = "hasNext()";
        logger.entry(string);
        boolean bl = false;
        if (this.dbMapIterator_ != null) {
            bl = this.dbMapIterator_.hasNext();
        }
        logger.exit(string, bl);
        return bl;
    }

    private static void deleteResources(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            FSDBTable fSDBTable = (FSDBTable)iterator.next();
            fSDBTable.unlock();
            fSDBTable.deleteFile(false);
        }
    }

    public static void commitDBTable(String string) {
        String string2 = "commitDBTable( String )";
        logger.entry(string2, string);
        DBTableEntry dBTableEntry = (DBTableEntry)dbTableMap_.get(string);
        if (dBTableEntry != null) {
            dBTableEntry.setCommitted(true);
            if (dBTableEntry.getCount() <= 0) {
                FSQuery.deleteResources(dBTableEntry.getDBList());
                dbTableMap_.remove(string);
            }
        }
        logger.exit(string2);
    }

    public void addOpenCount(String string, List list) {
        String string2 = "addOpenCount( String, List )";
        logger.entry(string2, new Object[]{string, list});
        DBTableEntry dBTableEntry = (DBTableEntry)dbTableMap_.get(string);
        if (dBTableEntry == null) {
            dBTableEntry = new DBTableEntry(list);
        }
        dBTableEntry.incrementCount();
        dbTableMap_.put(string, dBTableEntry);
        logger.exit(string2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class DBTableEntry {
        private int count_ = 0;
        private boolean committed_ = false;
        private List dbList_ = null;

        DBTableEntry(List list) {
            this.dbList_ = list;
        }

        List getDBList() {
            return this.dbList_;
        }

        int getCount() {
            return this.count_;
        }

        boolean getCommitted() {
            return this.committed_;
        }

        void incrementCount() {
            ++this.count_;
        }

        void decrementCount() {
            --this.count_;
        }

        void setCommitted(boolean bl) {
            this.committed_ = bl;
        }
    }

    class ResolveXMTWhere
    extends SearchWhere {
        private Collection xmtIDCollection_;

        public ResolveXMTWhere(Collection collection) {
            String string = "ResolveXMTWhere( Collection )";
            logger.entry(string);
            this.xmtIDCollection_ = collection;
            logger.exit(string);
        }

        public boolean match(TableRow tableRow, TableRow tableRow2) {
            return this.xmtIDCollection_.contains(new FSTableRowXMTRef(tableRow2));
        }
    }

    class XMTCollectAction
    extends SearchAction {
        public XMTCollectAction() {
            this.setCollect(true);
        }

        public void preAction() {
            this.clear();
        }

        public TableRow doAction(TableRow tableRow) {
            FSTableRowXMTRef fSTableRowXMTRef = new FSTableRowXMTRef(tableRow);
            List list = (List)this.getResults().getValue();
            if (list == null) {
                list = CollectionFactory.newList();
            }
            list.add(fSTableRowXMTRef);
            this.getResults().setValue(list);
            return tableRow;
        }
    }
}

