/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.iauthz.storage.adapter.impl.fs;

import com.ibm.sec.iauthz.log.SecLogger;
import com.ibm.sec.iauthz.storage.QueryOperand;
import com.ibm.sec.iauthz.storage.SimpleQueryExpr;
import com.ibm.sec.iauthz.storage.StoreRecord;
import com.ibm.sec.iauthz.storage.StoreRecordQuery;
import com.ibm.sec.iauthz.storage.StoreRecordQueryExpr;
import com.ibm.sec.iauthz.storage.adapter.TableRow;
import com.ibm.sec.iauthz.storage.adapter.impl.SearchAction;
import com.ibm.sec.iauthz.storage.adapter.impl.SearchOptions;
import com.ibm.sec.iauthz.storage.adapter.impl.SearchResults;
import com.ibm.sec.iauthz.storage.adapter.impl.SearchWhere;
import com.ibm.sec.iauthz.storage.adapter.impl.fs.FSAdapterImpl;
import com.ibm.sec.iauthz.storage.adapter.impl.fs.FSDBTable;
import com.ibm.sec.iauthz.storage.adapter.impl.fs.FSException;
import com.ibm.sec.iauthz.storage.adapter.impl.fs.FSQuery;
import com.ibm.sec.iauthz.storage.adapter.impl.fs.FSTableTransaction;
import com.ibm.sec.iauthz.util.CollectionFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FSQueryIterator {
    private static final String FSQueryIterator_java_sourceCodeID = "$Id: @(#)75  1.3 src/ws/code/argus/src/com/ibm/sec/iauthz/storage/adapter/impl/fs/FSQueryIterator.java, argus.store, argus600, 051020a 05/09/27 18:41:17 @(#) $";
    private static SecLogger logger = SecLogger.getLogger(class$com$ibm$sec$iauthz$storage$adapter$impl$fs$FSQueryIterator == null ? (class$com$ibm$sec$iauthz$storage$adapter$impl$fs$FSQueryIterator = FSQueryIterator.class$("com.ibm.sec.iauthz.storage.adapter.impl.fs.FSQueryIterator")) : class$com$ibm$sec$iauthz$storage$adapter$impl$fs$FSQueryIterator);
    private FSQuery fsQ_ = null;
    private Map dbxmtMap_ = null;
    private Iterator dbListIterator_ = null;
    private FSDBTable xmtDBBucket_ = null;
    private Iterator xmtBucketIterator_ = null;
    private Object xmtCollection_ = null;
    private static SearchWhere xmtSearchWhere_ = new SearchWhere(new int[]{FSAdapterImpl.COLUMN_POLICY_XMTID});
    private static SearchOptions xmtDeepSearchOptions_ = new SearchOptions();
    private static SearchOptions xmtShallowSearchOptions_ = new SearchOptions();
    private SearchAction xmtSearchAction_ = new StoreRecordAction();
    static /* synthetic */ Class class$com$ibm$sec$iauthz$storage$adapter$impl$fs$FSQueryIterator;

    public FSQueryIterator() {
    }

    public FSQueryIterator(FSQuery fSQuery, Map map) {
        this.fsQ_ = fSQuery;
        this.dbxmtMap_ = map;
        this.initialize();
    }

    public void initialize() {
        List list = CollectionFactory.newList(this.dbxmtMap_.keySet().size());
        list.addAll(this.dbxmtMap_.keySet());
        Collections.sort(list);
        this.dbListIterator_ = list.iterator();
    }

    private Set getRecord(FSDBTable fSDBTable, TableRow tableRow) throws FSException {
        String string = "getRecord( FSDBTable, TableRow )";
        logger.entry(string, new Object[]{fSDBTable, tableRow});
        Set set = null;
        if (tableRow != null) {
            FSTableTransaction fSTableTransaction = new FSTableTransaction(this.fsQ_.getAdapter().getConfiguration());
            fSTableTransaction.openPath(fSDBTable.getPathName(), null, "r", false);
            SearchResults searchResults = fSTableTransaction.searchTable(tableRow, xmtShallowSearchOptions_, this.xmtSearchAction_);
            fSTableTransaction.closeTable();
            set = (Set)searchResults.getValue();
        }
        logger.exit(string, set);
        return set;
    }

    private Set getRecords(FSDBTable fSDBTable, Collection collection, SearchOptions searchOptions) throws FSException {
        String string = "getRecords( FSDBTable, Collection, SearchOptions )";
        logger.entry(string, new Object[]{fSDBTable, collection, searchOptions});
        Set set = null;
        if (collection != null) {
            if (searchOptions == null) {
                searchOptions = xmtDeepSearchOptions_;
            }
            FSTableTransaction fSTableTransaction = new FSTableTransaction(this.fsQ_.getAdapter().getConfiguration());
            fSTableTransaction.openPath(fSDBTable.getPathName(), null, "r", false);
            SearchResults searchResults = fSTableTransaction.searchTable(collection, searchOptions, this.xmtSearchAction_);
            fSTableTransaction.closeTable();
            set = (Set)searchResults.getValue();
        }
        logger.exit(string, set);
        return set;
    }

    public boolean hasNext() {
        String string = "hasNext()";
        logger.entry(string);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = bl2 = this.xmtBucketIterator_ != null && this.xmtBucketIterator_.hasNext();
        bl = bl2 ? true : this.dbListIterator_ != null && this.dbListIterator_.hasNext();
        logger.exit(string, bl);
        return bl;
    }

    private void clear() {
        this.dbListIterator_ = null;
        this.xmtDBBucket_ = null;
        this.xmtCollection_ = null;
        this.xmtBucketIterator_ = null;
    }

    public Set nextPage() throws FSException {
        String string = "nextPage()";
        logger.entry(string);
        if (this.dbListIterator_ == null || !this.dbListIterator_.hasNext()) {
            return null;
        }
        boolean bl = false;
        FSDBTable fSDBTable = null;
        while (!bl) {
            Object object;
            Object object2;
            if (this.xmtBucketIterator_ == null) {
                object2 = null;
                while (this.xmtCollection_ == null && this.dbListIterator_.hasNext()) {
                    object2 = (FSDBTable)this.dbListIterator_.next();
                    this.xmtDBBucket_ = object2;
                    this.xmtCollection_ = this.dbxmtMap_.get(this.xmtDBBucket_);
                    if (this.xmtCollection_ != null) continue;
                    this.clear();
                    return null;
                }
            }
            object2 = null;
            if (this.xmtCollection_ instanceof Map) {
                object = (Map)this.xmtCollection_;
                if (this.xmtBucketIterator_ == null) {
                    this.xmtBucketIterator_ = object.keySet().iterator();
                }
                object2 = this.iterateMap(this.xmtDBBucket_, (Map)object, this.xmtBucketIterator_);
                if (!this.xmtBucketIterator_.hasNext()) {
                    this.xmtBucketIterator_ = null;
                    this.xmtCollection_ = null;
                }
            } else if (this.xmtCollection_ instanceof Set) {
                object = (Set)this.xmtCollection_;
                if (this.xmtBucketIterator_ == null) {
                    this.xmtBucketIterator_ = object.iterator();
                }
                object2 = this.iterateSet(this.xmtDBBucket_, (Set)object, this.xmtBucketIterator_);
                this.xmtBucketIterator_ = null;
                this.xmtCollection_ = null;
            }
            if (object2 == null) break;
            if (fSDBTable == null) {
                fSDBTable = object2;
            } else {
                fSDBTable.addAll(object2);
            }
            bl = this.bucketFull((Set)((Object)fSDBTable));
        }
        logger.exit(string);
        return fSDBTable;
    }

    private boolean bucketFull(Set set) {
        int n = this.fsQ_.getMaxReturn();
        return n != 0 && set.size() >= n;
    }

    private Set iterateMap(FSDBTable fSDBTable, Map map, Iterator iterator) throws FSException {
        String string = "iterateMap()";
        logger.entry(string);
        Set set = null;
        Object var6_6 = null;
        boolean bl = false;
        while (!bl) {
            Object object;
            while (iterator.hasNext() && var6_6 == null) {
                var6_6 = iterator.next();
            }
            if (var6_6 == null) break;
            Set set2 = null;
            Object v = map.get(var6_6);
            if (v instanceof List) {
                object = (List)map.get(var6_6);
                set2 = this.getRecords(fSDBTable, (Collection)object, xmtDeepSearchOptions_);
                StoreRecordQuery storeRecordQuery = this.fsQ_.getQuery();
                StoreRecordQueryExpr storeRecordQueryExpr = storeRecordQuery.getQueryExpr();
                if (storeRecordQueryExpr != null && storeRecordQueryExpr.getOperator() == 1) {
                    logger.debug(string, "Matching query for AND condition");
                    boolean bl2 = this.matchQuery(set2, this.fsQ_.getQuery());
                    if (!bl2) {
                        set2 = null;
                    }
                }
            } else if (v instanceof TableRow) {
                object = (TableRow)v;
                set2 = this.getRecord(fSDBTable, (TableRow)object);
            }
            var6_6 = null;
            if (set2 == null) continue;
            if (set == null) {
                set = set2;
            } else {
                set.addAll(set2);
            }
            bl = this.bucketFull(set);
        }
        logger.exit(string);
        return set;
    }

    private Set iterateSet(FSDBTable fSDBTable, Set set, Iterator iterator) throws FSException {
        String string = "iterateSet()";
        logger.entry(string);
        SearchOptions searchOptions = new SearchOptions();
        searchOptions.FIRSTONLY = true;
        searchOptions.SKIP_DELETED = true;
        searchOptions.WHERE = xmtSearchWhere_;
        Set set2 = this.getRecords(fSDBTable, set, searchOptions);
        logger.exit(string);
        return set2;
    }

    private boolean matchQuery(Collection collection, StoreRecordQuery storeRecordQuery) {
        String string = "matchQuery()";
        logger.entry(string);
        if (collection == null || collection.isEmpty()) {
            return false;
        }
        SimpleQueryExpr simpleQueryExpr = (SimpleQueryExpr)storeRecordQuery.getQueryExpr();
        if (simpleQueryExpr == null || simpleQueryExpr.getOperands() == null) {
            return true;
        }
        Iterator iterator = simpleQueryExpr.getOperands().iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            QueryOperand queryOperand = (QueryOperand)iterator.next();
            int[] nArray = queryOperand.getIndexes();
            StoreRecordQuery storeRecordQuery2 = queryOperand.getQuery();
            logger.debug(string, "StoreRecordQuery [" + storeRecordQuery2 + "]");
            boolean bl2 = false;
            Iterator iterator2 = collection.iterator();
            while (iterator2.hasNext()) {
                TableRow tableRow = (TableRow)iterator2.next();
                logger.debug(string, "candidate = ", tableRow);
                if (!storeRecordQuery2.match(tableRow, nArray)) continue;
                bl2 = true;
                logger.debug(string, "found match = " + bl2);
                break;
            }
            if (bl2) {
                logger.debug(string, "Found [" + storeRecordQuery2 + "]");
                if (!iterator.hasNext()) continue;
                continue;
            }
            bl = false;
        }
        logger.exit(string, Boolean.toString(bl));
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        FSQueryIterator.xmtDeepSearchOptions_.FIRSTONLY = true;
        FSQueryIterator.xmtDeepSearchOptions_.SKIP_DELETED = true;
        FSQueryIterator.xmtDeepSearchOptions_.WHERE = xmtSearchWhere_;
        FSQueryIterator.xmtShallowSearchOptions_.FIRSTONLY = true;
        FSQueryIterator.xmtShallowSearchOptions_.SKIP_DELETED = true;
        FSQueryIterator.xmtShallowSearchOptions_.WHERE = xmtSearchWhere_;
    }

    class StoreRecordAction
    extends SearchAction {
        public StoreRecordAction() {
            this.setCollect(true);
        }

        public void preAction() {
            super.clear();
        }

        public TableRow doAction(TableRow tableRow) {
            StoreRecord storeRecord = new StoreRecord(tableRow);
            if (this.doCollect()) {
                Set set = (Set)this.getResults().getValue();
                if (set == null) {
                    set = CollectionFactory.newOrderedSet();
                }
                set.add(storeRecord);
                this.getResults().setValue(set);
            }
            return storeRecord;
        }
    }
}

