/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.iauthz.storage.adapter.impl.fs;

import com.ibm.sec.iauthz.log.SecLogger;
import com.ibm.sec.iauthz.storage.adapter.TableRow;
import com.ibm.sec.iauthz.storage.adapter.TableVersion;
import com.ibm.sec.iauthz.storage.adapter.impl.BasicSchema;
import com.ibm.sec.iauthz.storage.adapter.impl.SearchAction;
import com.ibm.sec.iauthz.storage.adapter.impl.SearchOptions;
import com.ibm.sec.iauthz.storage.adapter.impl.SearchResults;
import com.ibm.sec.iauthz.storage.adapter.impl.SearchWhere;
import com.ibm.sec.iauthz.storage.adapter.impl.TableTransaction;
import com.ibm.sec.iauthz.storage.adapter.impl.fs.FSException;
import com.ibm.sec.iauthz.storage.adapter.impl.fs.FSFile;
import com.ibm.sec.iauthz.storage.adapter.impl.fs.FSFlatTableHelper;
import com.ibm.sec.iauthz.storage.adapter.impl.fs.FSTableSchema;
import com.ibm.sec.iauthz.storage.adapter.impl.fs.MoveToDeltaAction;
import com.ibm.sec.iauthz.storage.adapter.impl.fs.RebuildAction;
import com.ibm.sec.iauthz.storage.adapter.impl.fs.SMFileUtils;
import com.ibm.sec.iauthz.storage.adapter.impl.fs.TableAddAction;
import com.ibm.sec.iauthz.storage.adapter.impl.fs.TableApplyAction;
import com.ibm.sec.iauthz.storage.adapter.impl.fs.TableDelAction;
import com.ibm.sec.iauthz.util.CWRGSMessageHelper;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class FSTableTransaction
extends TableTransaction {
    private static final String FSTableTransaction_java_sourceCodeID = "$Id: @(#)24  1.16 src/ws/code/argus/src/com/ibm/sec/iauthz/storage/adapter/impl/fs/FSTableTransaction.java, argus.store, argus600, 051025a 05/10/21 16:57:22 @(#) $";
    private static SecLogger _logger = SecLogger.getLogger(class$com$ibm$sec$iauthz$storage$adapter$impl$fs$FSTableTransaction == null ? (class$com$ibm$sec$iauthz$storage$adapter$impl$fs$FSTableTransaction = FSTableTransaction.class$("com.ibm.sec.iauthz.storage.adapter.impl.fs.FSTableTransaction")) : class$com$ibm$sec$iauthz$storage$adapter$impl$fs$FSTableTransaction);
    public static final int MAGIC = 51904;
    public static final String DBEXT = ".tbl";
    public static final String DEFAULT_DELTA_EXT = "delta";
    protected FSFile table_ = null;
    protected FSTableSchema schema_ = null;
    protected FSFlatTableHelper helper_ = null;
    protected String tableName_ = null;
    protected String dir_;
    protected String path_;
    protected String clonedPath_;
    protected int tableType_ = 0;
    protected long nextPage_ = 0L;
    protected long start_ = 0L;
    private Thread lockHolder_ = null;
    static /* synthetic */ Class class$com$ibm$sec$iauthz$storage$adapter$impl$fs$FSTableTransaction;

    public FSTableTransaction(Properties properties) {
        super(properties);
        String string = "FSTableTransaction( Properties )";
        _logger.entry(string, properties);
        _logger.exit(string);
    }

    public FSFile getTable() {
        return this.table_;
    }

    public long getStart() {
        return this.start_;
    }

    public FSTableSchema getSchema() {
        return this.schema_;
    }

    protected FSFlatTableHelper getHelper() {
        if (this.helper_ == null) {
            this.helper_ = new FSFlatTableHelper(this);
        }
        return this.helper_;
    }

    public String getBaseDir(String string) {
        String string2 = "getBaseDir( String )";
        _logger.entry(string2, string);
        StringBuffer stringBuffer = new StringBuffer(this.getConfiguration().getProperty("ROOTDIR", "."));
        stringBuffer.append(File.separator);
        stringBuffer.append(string);
        _logger.exit(string2, stringBuffer.toString());
        return stringBuffer.toString();
    }

    public String getClientDir(String string, String string2) {
        String string3 = "getClientDir( String, String )";
        _logger.entry(string3, new Object[]{string, string2});
        StringBuffer stringBuffer = new StringBuffer(this.getConfiguration().getProperty("SESSIONSDIR", "."));
        stringBuffer.append(File.separator);
        stringBuffer.append(string);
        stringBuffer.append(File.separator);
        stringBuffer.append(string2);
        _logger.exit(string3, stringBuffer.toString());
        return stringBuffer.toString();
    }

    public void createTable(String string, BasicSchema basicSchema) throws FSException {
        String string2 = "createTable( String, BasicSchema )";
        _logger.entry(string2, new Object[]{string, basicSchema});
        StringBuffer stringBuffer = new StringBuffer(this.getBaseDir(string));
        stringBuffer.append(File.separator);
        stringBuffer.append(string);
        stringBuffer.append(DBEXT);
        this.createPath(stringBuffer.toString(), string, basicSchema);
        this.close();
        _logger.exit(string2);
    }

    public void createClientTable(String string, String string2, BasicSchema basicSchema) throws FSException {
        String string3 = "createTable( String, String, BasicSchema )";
        _logger.entry(string3, new Object[]{string, string2, basicSchema});
        StringBuffer stringBuffer = new StringBuffer(this.getClientDir(string, string2));
        stringBuffer.append(File.separator);
        stringBuffer.append(string2);
        stringBuffer.append(DBEXT);
        this.createPath(stringBuffer.toString(), string2, basicSchema);
        this.close();
        _logger.exit(string3);
    }

    public void createClientDeltaTable(String string, String string2, String string3, BasicSchema basicSchema) throws FSException {
        String string4 = "createClientDeltaTable( String, String, String, BasicSchema )";
        _logger.entry(string4, new Object[]{string, string2, string3, basicSchema});
        if (string3 == null) {
            string3 = DEFAULT_DELTA_EXT;
        }
        StringBuffer stringBuffer = new StringBuffer(string2);
        stringBuffer.append(".");
        stringBuffer.append(string3);
        StringBuffer stringBuffer2 = new StringBuffer(this.getClientDir(string, string2));
        stringBuffer2.append(File.separator);
        stringBuffer2.append(stringBuffer);
        stringBuffer2.append(DBEXT);
        this.createPath(stringBuffer2.toString(), stringBuffer.toString(), basicSchema);
        this.close();
        _logger.exit(string4);
    }

    protected void createPath(String string, String string2, BasicSchema basicSchema) throws FSException {
        String string3 = "createPath( String, String, BasicSchema )";
        _logger.entry(string3, new Object[]{string, string2, basicSchema});
        this.createPath(string, basicSchema);
        _logger.exit(string3);
    }

    protected void createPath(String string, BasicSchema basicSchema) throws FSException {
        String string2 = "createPath( String, BasicSchema )";
        _logger.entry(string2, new Object[]{string, basicSchema});
        FSTableSchema fSTableSchema = (FSTableSchema)basicSchema;
        File file = new File(string);
        File file2 = file.getParentFile();
        if (file2 != null) {
            file2.mkdirs();
        }
        this.open(string, "rw", true, true);
        this.writeHeader(fSTableSchema);
        _logger.exit(string2);
    }

    private void truncate() throws IOException {
        String string = "truncate()";
        _logger.entry(string);
        if (this.table_ != null) {
            long l = this.table_.getFilePointer();
            this.table_.truncate(l);
        }
        _logger.exit(string);
    }

    public void createReplica(String string, String string2) throws FSException {
        String string3 = "createReplica( String, String )";
        _logger.entry(string3, new Object[]{string, string2});
        String string4 = this.getBaseDir(string2);
        String string5 = this.getClientDir(string, string2);
        File file = new File(string5);
        file.mkdirs();
        String string6 = this.makeDBName(string4, string2);
        String string7 = this.makeDBName(string5, string2);
        try {
            SMFileUtils.copyFile(string6, string7);
        }
        catch (IOException iOException) {
            String string8 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_TABLE_TRANS_COPY_FILE", new Object[]{string6, string7, iOException.getMessage()});
            _logger.error(string3, string8, iOException);
            throw new FSException(string8, iOException);
        }
        _logger.exit(string3);
    }

    public void copyTable(String string, String string2, String string3) throws FSException {
        String string4 = "copyTable( String, String, String )";
        _logger.entry(string4, new Object[]{string, string2, string3});
        String string5 = this.getBaseDir(string2);
        String string6 = this.getClientDir(string, string2);
        File file = new File(string6);
        file.mkdirs();
        String string7 = this.makeDBName(string5, string2);
        String string8 = this.makeDBName(string6, string3);
        try {
            SMFileUtils.copyFile(string7, string8);
        }
        catch (IOException iOException) {
            String string9 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_TABLE_TRANS_COPY_FILE", new Object[]{string7, string8, iOException.getMessage()});
            _logger.error(string4, string9, iOException);
            throw new FSException(string9, iOException);
        }
        _logger.exit(string4);
    }

    public void openBaseTable(String string, BasicSchema basicSchema) throws FSException {
        String string2 = "openBaseTable( String, BasicSchema )";
        _logger.entry(string2, new Object[]{string, basicSchema});
        this.tableName_ = string;
        StringBuffer stringBuffer = new StringBuffer(this.getBaseDir(string));
        stringBuffer.append(File.separator);
        stringBuffer.append(string);
        stringBuffer.append(DBEXT);
        this.openPath(stringBuffer.toString(), basicSchema, null, true);
        _logger.exit(string2);
    }

    public void openClientTable(String string, String string2, BasicSchema basicSchema) throws FSException {
        String string3 = "openClientTable( String, String, BasicSchema )";
        _logger.entry(string3, new Object[]{string, string2, basicSchema});
        this.tableName_ = string2;
        StringBuffer stringBuffer = new StringBuffer(this.getClientDir(string, string2));
        stringBuffer.append(File.separator);
        stringBuffer.append(string2);
        stringBuffer.append(DBEXT);
        this.openPath(stringBuffer.toString(), basicSchema, null, true);
        _logger.exit(string3);
    }

    public void openClientDeltaTable(String string, String string2, String string3, BasicSchema basicSchema) throws FSException {
        String string4 = "openClientDeltaTable( String, String, String, BasicSchema )";
        _logger.entry(string4, new Object[]{string, string2, string3, basicSchema});
        this.tableName_ = string2;
        if (string3 == null) {
            string3 = DEFAULT_DELTA_EXT;
        }
        StringBuffer stringBuffer = new StringBuffer(this.getClientDir(string, string2));
        stringBuffer.append(File.separator);
        stringBuffer.append(string2);
        stringBuffer.append(".");
        stringBuffer.append(string3);
        stringBuffer.append(DBEXT);
        this.openPath(stringBuffer.toString(), basicSchema, null, true);
        _logger.exit(string4);
    }

    public void openDeltaTable(String string, String string2, BasicSchema basicSchema) throws FSException {
        String string3 = "openDeltaTable( String, String, BasicSchema )";
        _logger.entry(string3, new Object[]{string, string2, basicSchema});
        StringBuffer stringBuffer = new StringBuffer(this.getBaseDir(string));
        stringBuffer.append(File.separator);
        stringBuffer.append(string2);
        this.openPath(stringBuffer.toString(), basicSchema, null, false);
        _logger.exit(string3);
    }

    public void openTable(String string, BasicSchema basicSchema, String string2, boolean bl) throws FSException {
        String string3 = "openTable( String, BasicSchema, String, boolean )";
        _logger.entry(string3, new Object[]{string, basicSchema, string2, bl});
        this.openPath(string, basicSchema, string2, bl);
        _logger.exit(string3);
    }

    protected void openPath(String string, BasicSchema basicSchema, String string2, boolean bl) throws FSException {
        String string3 = "openPath( String, BasicSchema, String, boolean )";
        _logger.entry(string3, new Object[]{string, basicSchema, string2, bl});
        this.openPath(string, basicSchema, string2, bl, false);
        _logger.exit(string3);
    }

    protected void openPath(String string, BasicSchema basicSchema, String string2, boolean bl, boolean bl2) throws FSException {
        String string3 = "openPath( String, BasicSchema, String, boolean, boolean )";
        _logger.entry(string3, new Object[]{string, basicSchema, string2, bl, bl2});
        FSTableSchema fSTableSchema = (FSTableSchema)basicSchema;
        if (string2 == null) {
            string2 = "rw";
        }
        this.open(string, string2, bl, bl2);
        if (this.table_ != null) {
            this.readHeader(fSTableSchema);
        }
        _logger.exit(string3);
    }

    public boolean existsTable(String string) {
        String string2 = "existsTable( String )";
        _logger.entry(string2, string);
        this.tableName_ = string;
        StringBuffer stringBuffer = new StringBuffer(this.getBaseDir(string));
        stringBuffer.append(File.separator);
        stringBuffer.append(string);
        stringBuffer.append(DBEXT);
        boolean bl = this.existsPath(stringBuffer.toString());
        _logger.exit(string2, bl);
        return bl;
    }

    public boolean existsTable(String string, String string2, String string3) {
        _logger.entry("existsTable(clientID, tableName)", string2);
        String string4 = this.getClientDir(string, string2);
        String string5 = this.makeDBName(string4, string3);
        Boolean bl = SMFileUtils.fileExists(string5.toString());
        _logger.exit("existsTable(clientID, tableName)", bl);
        return bl;
    }

    protected boolean existsPath(String string) {
        String string2 = "existsPath( String )";
        _logger.entry(string2, string);
        Boolean bl = SMFileUtils.fileExists(string);
        _logger.exit(string2, bl);
        return bl;
    }

    public FSTableTransaction clonePath(String string) throws FSException {
        String string2 = "clonePath( String )";
        _logger.entry(string2, string);
        FSTableTransaction fSTableTransaction = null;
        String string3 = string;
        String string4 = ".save";
        String string5 = string + string4;
        try {
            SMFileUtils.copyFile(string3, string5);
            fSTableTransaction = new FSTableTransaction(this.getConfiguration());
            fSTableTransaction.openPath(string5, null, null, true);
        }
        catch (IOException iOException) {
            String string6 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_TABLE_TRANS_COPY_FILE", new Object[]{string3, string5, iOException.getMessage()});
            _logger.error(string2, string6, iOException);
            throw new FSException(string6, iOException);
        }
        _logger.exit(string2, fSTableTransaction);
        return fSTableTransaction;
    }

    public static String archive(String string, String string2) throws FSException {
        String string3 = "archive( String, String )";
        _logger.entry(string3, new Object[]{string, string2});
        String string4 = string + "." + string2;
        Boolean bl = SMFileUtils.renameFile(string, string4);
        if (!bl.booleanValue()) {
            try {
                SMFileUtils.copyFile(string, string4);
                SMFileUtils.deleteFile(string, false);
            }
            catch (IOException iOException) {
                String string5 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_TABLE_TRANS_COPY_FILE", new Object[]{string, string4, iOException.getMessage()});
                _logger.error(string3, string5, iOException);
                throw new FSException(string5, iOException);
            }
        }
        _logger.exit(string3, string4);
        return string4;
    }

    public SearchResults searchTable(TableRow tableRow, SearchOptions searchOptions, SearchAction searchAction) throws FSException {
        String string = "searchTable( TableRow, SearchOptions, SearchAction )";
        _logger.entry(string, new Object[]{tableRow, searchOptions, searchAction});
        SearchResults searchResults = this.search(tableRow, searchOptions, searchAction);
        _logger.exit(string, searchResults);
        return searchResults;
    }

    public SearchResults searchTable(TableRow tableRow, SearchOptions searchOptions) throws FSException {
        String string = "searchTable9 TableRow, SearchOptions )";
        _logger.entry(string, new Object[]{tableRow, searchOptions});
        SearchAction searchAction = new SearchAction();
        searchAction.setCollect(true);
        searchAction.setDelete(false);
        SearchResults searchResults = this.search(tableRow, searchOptions, searchAction);
        _logger.exit(string, searchResults);
        return searchResults;
    }

    public SearchResults searchTable(Collection collection, SearchOptions searchOptions, SearchAction searchAction) throws FSException {
        String string = "searchTable( Collection, SearchOptions, SearchAction )";
        _logger.entry(string, new Object[]{collection, searchOptions, searchAction});
        SearchResults searchResults = this.search(collection, searchOptions, searchAction);
        _logger.exit(string, searchResults);
        return searchResults;
    }

    public void clearAll() throws FSException {
        _logger.entry("clearAll");
        try {
            this.reset();
            this.truncate();
        }
        catch (IOException iOException) {
            _logger.error("clearAll", iOException.getLocalizedMessage());
            throw new FSException(iOException);
        }
        _logger.exit("clearAll");
    }

    public void closeTable() throws FSException {
        String string = "closeTable()";
        _logger.entry(string);
        this.tableName_ = null;
        this.close();
        _logger.exit(string);
    }

    public void closeTable(boolean bl) throws FSException {
        String string = "closeTable( boolean )";
        _logger.entry(string, bl);
        this.tableName_ = null;
        String string2 = this.getPath();
        this.close();
        if (bl) {
            SMFileUtils.deleteFile(string2, false);
        }
        _logger.exit(string);
    }

    public void commit() throws FSException {
        String string = "commit()";
        _logger.entry(string);
        this.close();
        _logger.exit(string);
    }

    public void rollback() throws FSException {
        String string = "rollback()";
        _logger.entry(string);
        String string2 = this.getPath();
        this.close();
        SMFileUtils.deleteFile(string2, false);
        _logger.exit(string);
    }

    public void insert(TableRow tableRow, SearchOptions searchOptions, SearchAction searchAction) throws FSException {
        String string = "insert( TableRow, SearchOptions, SearchAction )";
        _logger.entry(string, new Object[]{tableRow, searchOptions, searchAction});
        this.update(tableRow, searchOptions, searchAction);
        _logger.exit(string);
    }

    public void insert(List list, SearchOptions searchOptions, SearchAction searchAction) throws FSException {
        String string = "insert( List, SearchOptions, SearchAction )";
        _logger.entry(string, new Object[]{list, searchOptions, searchAction});
        this.update(list, searchOptions, searchAction);
        _logger.exit(string);
    }

    public void add(TableRow tableRow) throws FSException {
        String string = "add( TableRow )";
        _logger.entry(string, tableRow);
        this.addRow(tableRow);
        _logger.exit(string);
    }

    public void add(Collection collection) throws FSException {
        String string = "add( Collection )";
        _logger.entry(string, collection);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            TableRow tableRow = (TableRow)iterator.next();
            this.addRow(tableRow);
        }
        _logger.exit(string);
    }

    public void remove(TableRow tableRow) throws FSException {
        String string = "remove( TableRow )";
        _logger.entry(string, tableRow);
        SearchOptions searchOptions = new SearchOptions();
        searchOptions.WHERE = new SearchWhere(tableRow);
        this.deleteRow(tableRow, searchOptions);
        _logger.exit(string);
    }

    public void addTable(FSTableTransaction fSTableTransaction, String string, int n) throws FSException {
        String string2 = "addTable( FSTableTransaction, String, int )";
        _logger.entry(string2, new Object[]{fSTableTransaction, string, new Integer(n)});
        TableRow tableRow = new TableRow();
        SearchOptions searchOptions = new SearchOptions();
        searchOptions.FIRSTONLY = false;
        searchOptions.SKIP_DELETED = true;
        searchOptions.WHERE = new SearchAll();
        TableAddAction tableAddAction = new TableAddAction(this, string, n);
        fSTableTransaction.search(tableRow, searchOptions, (SearchAction)tableAddAction);
        _logger.exit(string2);
    }

    public void delTable(FSTableTransaction fSTableTransaction, int[] nArray) throws FSException {
        String string = "delTable( FSTableTransaction, int[] )";
        _logger.entry(string, new Object[]{fSTableTransaction, nArray});
        TableRow tableRow = new TableRow();
        SearchOptions searchOptions = new SearchOptions();
        searchOptions.FIRSTONLY = false;
        searchOptions.SKIP_DELETED = true;
        searchOptions.WHERE = new SearchAll();
        TableDelAction tableDelAction = new TableDelAction(this, nArray);
        fSTableTransaction.search(tableRow, searchOptions, (SearchAction)tableDelAction);
        _logger.exit(string);
    }

    public void applyTable(FSTableTransaction fSTableTransaction, int[] nArray, TableVersion tableVersion, int n) throws FSException {
        String string = "applyTable( FSTableTransaction, int[], String, int )";
        _logger.entry(string, new Object[]{fSTableTransaction, nArray, tableVersion, new Integer(n)});
        TableRow tableRow = new TableRow();
        SearchOptions searchOptions = new SearchOptions();
        searchOptions.FIRSTONLY = false;
        searchOptions.SKIP_DELETED = true;
        searchOptions.WHERE = new SearchAll();
        TableApplyAction tableApplyAction = new TableApplyAction(this, nArray, tableVersion);
        fSTableTransaction.search(tableRow, searchOptions, (SearchAction)tableApplyAction);
        _logger.exit(string);
    }

    public SearchResults searchPath(String string, SearchOptions searchOptions, SearchAction searchAction) throws FSException {
        String string2 = "searchPath( String, SearchOptions, SearchAction )";
        _logger.entry(string2, new Object[]{string, searchOptions, searchAction});
        TableRow tableRow = new TableRow();
        if (searchOptions == null) {
            searchOptions = new SearchOptions();
            searchOptions.FIRSTONLY = false;
            searchOptions.SKIP_DELETED = false;
            searchOptions.WHERE = new SearchAll();
        }
        if (searchAction == null) {
            searchAction = new SearchAction();
            searchAction.setCollect(true);
        }
        this.openPath(string, this.getSchema(), null, true);
        SearchResults searchResults = this.search(tableRow, searchOptions, searchAction);
        _logger.exit(string2, searchResults);
        return searchResults;
    }

    public void rebuild(String string) throws FSException {
        String string2 = "rebuild( String )";
        _logger.entry(string2, string);
        FSTableTransaction fSTableTransaction = new FSTableTransaction(this.getConfiguration());
        fSTableTransaction.createPath(string, this.getTableName(), this.schema_);
        fSTableTransaction.closeTable();
        fSTableTransaction.openPath(string, this.schema_, null, true);
        TableRow tableRow = new TableRow();
        SearchOptions searchOptions = new SearchOptions();
        searchOptions.FIRSTONLY = false;
        searchOptions.SKIP_DELETED = true;
        searchOptions.WHERE = new SearchAll();
        RebuildAction rebuildAction = new RebuildAction(fSTableTransaction);
        this.search(tableRow, searchOptions, (SearchAction)rebuildAction);
        fSTableTransaction.close();
        _logger.exit(string2);
    }

    public void moveToDelta(String string, int n) throws FSException {
        String string2 = "moveToDelta(String, int)";
        _logger.entry(string2, new Object[]{string, new Integer(n)});
        FSTableTransaction fSTableTransaction = new FSTableTransaction(this.getConfiguration());
        fSTableTransaction.createPath(string, this.getTableName(), this.schema_);
        fSTableTransaction.closeTable();
        fSTableTransaction.openPath(string, this.schema_, null, true);
        TableRow tableRow = new TableRow();
        SearchOptions searchOptions = new SearchOptions();
        searchOptions.FIRSTONLY = false;
        searchOptions.SKIP_DELETED = true;
        searchOptions.WHERE = new SearchAll();
        MoveToDeltaAction moveToDeltaAction = new MoveToDeltaAction(fSTableTransaction, n);
        this.search(tableRow, searchOptions, (SearchAction)moveToDeltaAction);
        fSTableTransaction.close();
        _logger.exit(string2);
    }

    protected String getVersion() throws FSException {
        TableRow tableRow;
        Iterator iterator;
        String string = "getVersion()";
        _logger.entry(string);
        if (!this.isOpen()) {
            String string2 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_TABLE_TRANS_CLOSE_TABLE", new Object[]{this.tableName_});
            _logger.error(string, string2);
            throw new FSException(string2);
        }
        TableRow tableRow2 = new TableRow();
        tableRow2.addColumn(new String("0"));
        SearchOptions searchOptions = new SearchOptions();
        searchOptions.FIRSTONLY = true;
        searchOptions.SKIP_DELETED = true;
        searchOptions.WHERE = new SearchWhere(new int[]{0});
        SearchAction searchAction = new SearchAction();
        searchAction.setCollect(true);
        SearchResults searchResults = this.search(tableRow2, searchOptions, searchAction);
        String string3 = "0";
        Set set = (Set)searchResults.getValue();
        if (set != null && (iterator = set.iterator()).hasNext() && (tableRow = (TableRow)iterator.next()) != null) {
            string3 = (String)tableRow.getColumn(0);
        }
        _logger.exit(string);
        return string3;
    }

    private String makeDBName(String string, String string2) {
        String string3 = "makeDBName( String, String )";
        _logger.entry(string3, new Object[]{string, string2});
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(File.separator);
        stringBuffer.append(string2);
        stringBuffer.append(DBEXT);
        _logger.exit(string3, stringBuffer.toString());
        return stringBuffer.toString();
    }

    protected void update(List list, SearchOptions searchOptions, SearchAction searchAction) throws FSException {
        String string = "update( List, SearchOptions, SearchAction )";
        _logger.entry(string, new Object[]{list, searchOptions, searchAction});
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TableRow tableRow = (TableRow)iterator.next();
            this.update(tableRow, searchOptions, searchAction);
        }
        _logger.exit(string);
    }

    protected void update(TableRow tableRow, SearchOptions searchOptions, SearchAction searchAction) throws FSException {
        Iterator iterator;
        String string = "update( TableRow, SearchOptions, SearchAction )";
        _logger.entry(string, new Object[]{tableRow, searchOptions, searchAction});
        if (searchOptions == null) {
            searchOptions = new SearchOptions();
            searchOptions.FIRSTONLY = true;
            searchOptions.SKIP_DELETED = true;
        }
        if (searchAction == null) {
            searchAction = new SearchAction();
            searchAction.setCollect(true);
        }
        TableRow tableRow2 = null;
        SearchResults searchResults = this.search(tableRow, searchOptions, searchAction);
        Set set = (Set)searchResults.getValue();
        if (set != null && (iterator = set.iterator()).hasNext()) {
            tableRow2 = (TableRow)iterator.next();
        }
        if (tableRow2 != null) {
            if (tableRow.match(tableRow2)) {
                return;
            }
            this.deleteRow(tableRow2);
        }
        if (!searchAction.doDelete()) {
            this.addRow(tableRow);
        }
        _logger.exit(string);
    }

    protected synchronized SearchResults search(TableRow tableRow, SearchOptions searchOptions, SearchAction searchAction) throws FSException {
        String string = "search( TableRow, SearchOptions, SearchAction )";
        _logger.entry(string, new Object[]{tableRow, searchOptions, searchAction});
        if (!this.isOpen()) {
            String string2 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_TABLE_TRANS_CLOSE_TABLE", new Object[]{this.tableName_});
            _logger.error(string, string2);
            throw new FSException(string2);
        }
        SearchResults searchResults = this.getHelper().search(tableRow, searchOptions, searchAction);
        _logger.exit(string, searchResults);
        return searchResults;
    }

    private SearchResults search(Collection collection, SearchOptions searchOptions, SearchAction searchAction) throws FSException {
        String string = "search( Collection, SearchOptions, SearchAction )";
        _logger.entry(string, new Object[]{collection, searchOptions, searchAction});
        if (!this.isOpen()) {
            String string2 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_TABLE_TRANS_CLOSE_TABLE", new Object[]{this.tableName_});
            _logger.error(string, string2);
            throw new FSException(string2);
        }
        SearchResults searchResults = this.getHelper().search(collection, searchOptions, searchAction);
        _logger.exit(string, searchResults);
        return searchResults;
    }

    protected synchronized void addRow(TableRow tableRow) throws FSException {
        String string = "addRow( TableRow )";
        _logger.entry(string, tableRow);
        if (!this.isOpen()) {
            String string2 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_TABLE_TRANS_CLOSE_TABLE", new Object[]{this.tableName_});
            _logger.error(string, string2);
            throw new FSException(string2);
        }
        try {
            this.getHelper().addRow(tableRow);
        }
        catch (IOException iOException) {
            String string3 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_TABLE_TRANS_ADD_ROW", new Object[]{this.tableName_, iOException.getMessage()});
            _logger.error(string, string3, iOException);
            throw new FSException(string3, iOException);
        }
        _logger.exit(string);
    }

    protected synchronized boolean isOpen() {
        if (this.table_ != null) {
            return this.table_.isOpen();
        }
        return false;
    }

    protected synchronized void deleteRow(TableRow tableRow, SearchOptions searchOptions) throws FSException {
        String string = "deleteRow( TableRow, SearchOptions )";
        _logger.entry(string, new Object[]{tableRow, searchOptions});
        if (!this.isOpen()) {
            String string2 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_TABLE_TRANS_CLOSE_TABLE", new Object[]{this.tableName_});
            _logger.error(string, string2);
            throw new FSException(string2);
        }
        if (searchOptions == null) {
            searchOptions = new SearchOptions();
        }
        SearchAction searchAction = new SearchAction();
        searchAction.setDelete(true);
        this.getHelper().search(tableRow, searchOptions, searchAction);
        _logger.exit(string);
    }

    protected synchronized void deleteRow(TableRow tableRow) throws FSException {
        String string = "deleteRow( TableRow )";
        _logger.entry(string, tableRow);
        this.deleteRow(tableRow, null);
        _logger.exit(string);
    }

    protected synchronized void open(String string, String string2, boolean bl, boolean bl2) throws FSException {
        String string3 = "open( String, String, boolean, boolean )";
        _logger.entry(string3, new Object[]{string, string2, bl, bl2});
        try {
            File file = new File(string);
            boolean bl3 = file.exists();
            if (!bl2 && !bl3) {
                String string4 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_TABLE_TRANS_OPEN_TABLE_NOT_FOUND", new Object[]{string});
                _logger.error(string3, string4);
                throw new FSException(string4);
            }
            if (string2 == null) {
                string2 = "rw";
            }
            this.table_ = new FSFile(string, string2);
            this.table_.open(bl);
            this.path_ = string;
            this.dir_ = file.getParent();
            if (bl2 && file.exists()) {
                this.truncate();
            }
        }
        catch (IOException iOException) {
            String string5 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_TABLE_TRANS_OPEN_TABLE_EXCEPTION", new Object[]{string, iOException.getMessage()});
            _logger.error(string3, string5, iOException);
            throw new FSException(string5, iOException);
        }
        _logger.exit(string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void close() throws FSException {
        String string = "close()";
        _logger.entry(string);
        if (this.table_ != null) {
            try {
                this.table_.close();
                this.table_ = null;
                this.path_ = null;
                this.dir_ = null;
            }
            finally {
                this.path_ = null;
                this.dir_ = null;
            }
        }
        _logger.exit(string);
    }

    private void setNextPage(long l) {
        this.nextPage_ = l;
    }

    private void top() throws IOException {
        if (this.table_ != null) {
            this.table_.seek(0L);
        }
    }

    private void bottom() throws IOException {
        if (this.table_ != null) {
            this.table_.bottom();
        }
    }

    private void reset() throws IOException {
        if (this.table_ != null) {
            this.table_.seek(this.start_);
        }
    }

    protected void writeHeader(FSTableSchema fSTableSchema) throws FSException {
        String string = "writeHeader( FSTableSchema )";
        _logger.entry(string, fSTableSchema);
        if (!this.isOpen()) {
            String string2 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_TABLE_TRANS_CLOSE_TABLE", new Object[]{this.tableName_});
            _logger.error(string, string2);
            throw new FSException(string2);
        }
        try {
            this.top();
            int n = 51904 + fSTableSchema.getMagic();
            this.table_.writeInt(n);
            this.table_.writeInt(0);
            this.table_.writeLong(0L);
            fSTableSchema.write(this.table_);
            this.schema_ = fSTableSchema;
        }
        catch (IOException iOException) {
            String string3 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_TABLE_TRANS_WRITE_HEADER", new Object[]{this.tableName_, iOException.getMessage()});
            _logger.error(string, string3, iOException);
            throw new FSException(string3, iOException);
        }
    }

    protected void readHeader(FSTableSchema fSTableSchema) throws FSException {
        String string = "readHeader( FSTableSchema )";
        _logger.entry(string, fSTableSchema);
        try {
            this.top();
            int n = this.table_.readInt();
            this.tableType_ = this.table_.readInt();
            this.nextPage_ = this.table_.readLong();
            this.setNextPage(this.nextPage_);
            if (fSTableSchema == null) {
                fSTableSchema = new FSTableSchema();
                fSTableSchema.read(this.table_);
                this.start_ = this.table_.getFilePointer();
            } else {
                this.start_ = this.table_.getFilePointer();
                int n2 = this.table_.readInt();
                this.start_ += (long)n2;
            }
            this.schema_ = fSTableSchema;
            this.reset();
        }
        catch (IOException iOException) {
            String string2 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_TABLE_TRANS_READ_HEADER", new Object[]{this.tableName_, iOException.getMessage()});
            _logger.error(string, string2, iOException);
            throw new FSException(string2, iOException);
        }
    }

    public String getTableName() {
        return this.tableName_;
    }

    public void setTableName(String string) {
        this.tableName_ = string;
    }

    protected String getPrimaryPath() {
        return this.clonedPath_;
    }

    protected void setPrimaryPath(String string) {
        this.clonedPath_ = string;
    }

    public String getPath() {
        return this.path_;
    }

    public void setPath(String string) {
        this.path_ = string;
    }

    public String getDir() {
        return this.dir_;
    }

    public void setDir(String string) {
        this.dir_ = string;
    }

    public static void moveDB(String string, String string2, String string3) {
        String string4 = "moveDB( String, String, String )";
        _logger.entry(string4, new Object[]{string, string2, string3});
        StringBuffer stringBuffer = new StringBuffer(string2);
        stringBuffer.append(File.separator);
        stringBuffer.append(string3);
        SMFileUtils.renameFile(string, stringBuffer.toString());
        _logger.exit(string4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        String string = "finalize";
        if (this.isOpen()) {
            try {
                _logger.debug(string, "Finalize cleaning up table.");
                this.closeTable(false);
            }
            catch (Exception exception) {
                _logger.error(string, exception.getLocalizedMessage());
            }
            finally {
                super.finalize();
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class SearchAll
    extends SearchWhere {
        public boolean match(TableRow tableRow, TableRow tableRow2) {
            return true;
        }
    }
}

