/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.iauthz.storage.adapter.impl.mem;

import com.ibm.sec.iauthz.log.SecLogger;
import com.ibm.sec.iauthz.mcc.DataProcessingConstants;
import com.ibm.sec.iauthz.storage.ConfigTableEntry;
import com.ibm.sec.iauthz.storage.PolicyStoreException;
import com.ibm.sec.iauthz.storage.QueryOperand;
import com.ibm.sec.iauthz.storage.SessionTableEntry;
import com.ibm.sec.iauthz.storage.SimpleQueryExpr;
import com.ibm.sec.iauthz.storage.StoreRecord;
import com.ibm.sec.iauthz.storage.StoreRecordQuery;
import com.ibm.sec.iauthz.storage.adapter.AdapterException;
import com.ibm.sec.iauthz.storage.adapter.AdapterResultSet;
import com.ibm.sec.iauthz.storage.adapter.IAdapterSession;
import com.ibm.sec.iauthz.storage.adapter.StorageAdapter;
import com.ibm.sec.iauthz.storage.adapter.TableRow;
import com.ibm.sec.iauthz.storage.adapter.impl.mem.MemoryBackedAdapterResultSet;
import com.ibm.sec.iauthz.storage.adapter.impl.mem.MemorySession;
import com.ibm.sec.iauthz.util.CWRGSMessageHelper;
import com.ibm.sec.iauthz.util.CollectionFactory;
import com.ibm.sec.iauthz.util.RWLock;
import com.ibm.sec.iauthz.util.RWLockException;
import com.ibm.sec.iauthz.util.StoreRecordUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class MemoryBackedAdapterImpl
extends StorageAdapter {
    private static Map _contextToMasterRepository = CollectionFactory.newMap();
    static Map _instanceSandboxMap = CollectionFactory.newMap();
    static Map _instanceReplicaMasterMap = null;
    static Map _instanceReplicaDeltaMap = null;
    static Map _contextToDeltaRepository = CollectionFactory.newMap();
    static Map _sessionTable = CollectionFactory.newMap();
    static Map _policyContextIDTable = CollectionFactory.newMap();
    static Map _roleMappingContextIDTable = CollectionFactory.newMap();
    static Map _uniqueIDs = CollectionFactory.newMap();
    private static SecLogger _logger = SecLogger.getLogger(class$com$ibm$sec$iauthz$storage$adapter$impl$mem$MemoryBackedAdapterImpl == null ? (class$com$ibm$sec$iauthz$storage$adapter$impl$mem$MemoryBackedAdapterImpl = MemoryBackedAdapterImpl.class$("com.ibm.sec.iauthz.storage.adapter.impl.mem.MemoryBackedAdapterImpl")) : class$com$ibm$sec$iauthz$storage$adapter$impl$mem$MemoryBackedAdapterImpl);
    private Map _policyTableSandbox = null;
    private boolean _policyConfig;
    private boolean _config;
    private static RWLock _rwLockContextM = new RWLock();
    private static RWLock _rwLockContextD = new RWLock();
    private static RWLock _rwLockInstanceM = new RWLock();
    private static RWLock _rwLockInstanceD = new RWLock();
    private RWLock _rwLockInstanceS = new RWLock();
    private static RWLock _rwLockUniqueID = new RWLock();
    private static RWLock _rwLockSessionT = new RWLock();
    private static RWLock _rwLockCtxTableM = new RWLock();
    private RWLock _rwLockCtxTableS = new RWLock();
    public static int POLICY_CONTEXT_ID = 0;
    public static int POLICY_CONTEXT_TABLE = 1;
    public static int ROLE_CONTEXT_ID = 2;
    public static int ROLE_CONTEXT_TABLE = 3;
    public static int ROLE_CONTEXT_INSERVICE = 4;
    public static String FALSE = "false";
    public static String TRUE = "true";
    static /* synthetic */ Class class$com$ibm$sec$iauthz$storage$adapter$impl$mem$MemoryBackedAdapterImpl;

    public static StorageAdapter getAdapter(Properties properties) {
        return new MemoryBackedAdapterImpl(properties);
    }

    public MemoryBackedAdapterImpl(Properties properties) {
        super(properties);
        String string = "MemoryBackedAdapterImpl( Properties )";
        _logger.entry(string, properties);
        String string2 = (String)properties.get("CONFIG_OR_RUNTIME");
        this._config = string2 != null && string2.equalsIgnoreCase("config");
        String string3 = (String)properties.get("POLICY_OR_RM");
        if (string3 != null && string3.equalsIgnoreCase("policy")) {
            this._policyConfig = true;
        }
        _logger.exit(string);
    }

    public void policyUpdate(IAdapterSession iAdapterSession, Set set) throws PolicyStoreException {
        String string = "policyUpdate( IAdapterSession, Set )";
        _logger.entry(string, new Object[]{iAdapterSession, set});
        MemorySession memorySession = (MemorySession)iAdapterSession;
        if (set != null) {
            Set set2 = StoreRecordUtil.groupStoreRecords(set, _logger);
            if (set2 != null) {
                Iterator iterator = set2.iterator();
                while (iterator.hasNext()) {
                    Map map = (Map)iterator.next();
                    Set set3 = (Set)map.get("RECORDS");
                    if (set3 != null) {
                        this.updatePolicy(memorySession, set3);
                        continue;
                    }
                    _logger.debug(string, "No records found in Set. Nothing to add.");
                }
            } else {
                _logger.debug(string, "The grouped StoreRecords Set is null. Nothing to add.");
            }
        } else {
            _logger.debug(string, "The update Set is null. Nothing to add.");
        }
        _logger.exit(string);
    }

    public AdapterResultSet policyGetFull(IAdapterSession iAdapterSession, StoreRecordQuery storeRecordQuery, boolean bl) throws PolicyStoreException {
        return this.retrievePolicy(iAdapterSession, storeRecordQuery, bl);
    }

    public AdapterResultSet policyGetDelta(IAdapterSession iAdapterSession, String string, StoreRecordQuery storeRecordQuery) throws PolicyStoreException {
        return this.retrieveDeltaPolicy(iAdapterSession, storeRecordQuery);
    }

    public void policyDestroy(IAdapterSession iAdapterSession) throws PolicyStoreException {
        String string = "policyDestroy( IAdapterSession )";
        _logger.entry(string, iAdapterSession);
        MemorySession memorySession = (MemorySession)iAdapterSession;
        try {
            Object object;
            Set set;
            boolean bl = _rwLockInstanceM.getWriterLock();
            boolean bl2 = _rwLockInstanceD.getWriterLock();
            boolean bl3 = this._rwLockInstanceS.getWriterLock();
            if (bl && bl2 && bl3) {
                if (this._policyTableSandbox == null) {
                    this._policyTableSandbox = CollectionFactory.newMap(_policyContextIDTable);
                }
                if (memorySession.getInstanceDeltaRepository() != null) {
                    memorySession.getInstanceDeltaRepository().clear();
                }
                this.moveMasterDBToDelta(memorySession);
                if (memorySession.getInstanceContextSandbox() != null) {
                    memorySession.getInstanceContextSandbox().clear();
                }
            } else {
                String string2;
                if (!bl) {
                    string2 = CWRGSMessageHelper.getMessage("WARNING_STORAGE_MEM_MASTER_WRITE_LOCK");
                    _logger.warning(string, string2);
                }
                if (!bl2) {
                    string2 = CWRGSMessageHelper.getMessage("WARNING_STORAGE_MEM_DELTA_WRITE_LOCK");
                    _logger.warning(string, string2);
                }
                if (!bl3) {
                    string2 = CWRGSMessageHelper.getMessage("WARNING_STORAGE_MEM_CONTEXT_WRITE_LOCK");
                    _logger.warning(string, string2);
                }
                string2 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_DESTROY_LOCK", new Object[]{memorySession.getContextID()});
                _logger.error(string, string2);
                throw new PolicyStoreException(string2);
            }
            _rwLockInstanceM.releaseLock();
            _rwLockInstanceD.releaseLock();
            this._rwLockInstanceS.releaseLock();
            if (memorySession.isPolicyConfig() && (set = this.configGetLinkedContexts(memorySession.getContextID())).size() == 1 && set.contains(memorySession.getContextID())) {
                _logger.debug(string, "Removing last of the linked policy [" + memorySession.getContextID() + "] - cleaning role config");
                try {
                    String string3 = this.configGetRoleContext(memorySession.getContextID());
                    object = new MemorySession(memorySession.getClientID(), string3);
                    ((MemorySession)object).setPolicyConfig(false);
                    _logger.debug(string, "Calling policyDestroy with roleContext ID '" + string3 + "'");
                    this.policyDestroy((IAdapterSession)object);
                }
                catch (PolicyStoreException policyStoreException) {
                    String string4 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_REMOVE_ROLE_FOR_POLICY", new Object[]{policyStoreException.getMessage()});
                    _logger.error(string, string4, policyStoreException);
                    throw new PolicyStoreException(string4, policyStoreException);
                }
            }
            boolean bl4 = this._rwLockCtxTableS.getWriterLock();
            boolean bl5 = _rwLockCtxTableM.getWriterLock();
            if (bl4 && bl5) {
                if (this._policyTableSandbox != null) {
                    this._policyTableSandbox.clear();
                }
                if (memorySession.isPolicyConfig()) {
                    _logger.debug(string, "Removing policy contextID [" + memorySession.getContextID() + "] from contextTable");
                    _policyContextIDTable.remove(memorySession.getContextID());
                } else {
                    _logger.debug(string, "Removing role contextID [" + memorySession.getContextID() + "] from contextTable");
                    object = _policyContextIDTable.values();
                    if (object != null) {
                        Iterator iterator = object.iterator();
                        while (iterator.hasNext()) {
                            TableRow tableRow = (TableRow)iterator.next();
                            String string5 = (String)tableRow.getColumn(ROLE_CONTEXT_ID);
                            if (memorySession.getContextID() == null || string5 == null || !memorySession.getContextID().equals(string5)) continue;
                            tableRow.setColumn(ROLE_CONTEXT_INSERVICE, FALSE);
                            _policyContextIDTable.put(tableRow.getColumn(POLICY_CONTEXT_ID), tableRow);
                            _logger.debug(string, "Setting role contextID " + memorySession.getContextID() + " out of service on policy contextID " + tableRow.getColumn(POLICY_CONTEXT_ID));
                        }
                    }
                }
            } else {
                if (!bl4) {
                    _logger.debug(string, "Could not get writer lock for sandbox context table.");
                }
                if (!bl5) {
                    _logger.debug(string, "Could not get writer lock for master context table.");
                }
                object = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_DESTROY_LOCK", new Object[]{memorySession.getContextID()});
                _logger.error(string, (String)object);
                throw new PolicyStoreException((String)object);
            }
            this._policyTableSandbox = null;
            this._rwLockCtxTableS.releaseLock();
            bl4 = false;
            _rwLockCtxTableM.releaseLock();
            bl5 = false;
        }
        catch (RWLockException rWLockException) {
            String string6 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_DESTROY_LOCK", new Object[]{memorySession.getContextID()});
            _logger.error(string, string6, rWLockException);
            throw new PolicyStoreException(string6, rWLockException);
        }
        _logger.exit(string);
    }

    public void policyCommit(IAdapterSession iAdapterSession, boolean bl) throws PolicyStoreException {
        String string = "policyCommit( IAdapterSession, boolean )";
        _logger.entry(string, new Object[]{iAdapterSession, bl});
        MemorySession memorySession = (MemorySession)iAdapterSession;
        try {
            Object object;
            Object object2;
            Object object3;
            Collection collection;
            boolean bl2 = this._rwLockInstanceS.getWriterLock();
            boolean bl3 = _rwLockInstanceM.getWriterLock();
            if (bl2 && bl3) {
                if (this._policyTableSandbox == null) {
                    this._policyTableSandbox = CollectionFactory.newMap(_policyContextIDTable);
                }
                if (bl) {
                    boolean bl4 = _rwLockInstanceD.getWriterLock();
                    if (bl4) {
                        this.moveMasterDBToDelta(memorySession);
                        _rwLockInstanceD.releaseLock();
                        bl4 = false;
                    } else {
                        String string2 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_COMMIT_LOCK", new Object[]{memorySession.getContextID()});
                        _logger.error(string, string2);
                        throw new PolicyStoreException(string2);
                    }
                }
                if (memorySession.getInstanceContextSandbox() != null && !memorySession.getInstanceContextSandbox().isEmpty()) {
                    String string3 = StoreRecordUtil.getIncrementedVersion(memorySession.getInstanceMasterRepository(), _logger);
                    _logger.debug(string, "New version is " + string3);
                    memorySession.getInstanceMasterRepository().put("_MASTER_CURRENT_VERSION_", string3);
                    Map map = CollectionFactory.newMap();
                    collection = memorySession.getInstanceContextSandbox().iterator();
                    while (collection.hasNext()) {
                        Map map2 = (Map)collection.next();
                        object3 = map2.keySet();
                        if (object3 != null) {
                            object2 = object3.iterator();
                            while (object2.hasNext()) {
                                object = (String)object2.next();
                                Set set = (Set)map2.get(object);
                                if (set != null) {
                                    Object object4;
                                    String string4 = StoreRecordUtil.getMasterDBKey(set, _logger);
                                    if (string4 != null) {
                                        _logger.debug(string, "About to " + (String)object + " policy for " + string4);
                                        object4 = (Set)memorySession.getInstanceMasterRepository().get(string4);
                                        if (object4 == null) {
                                            _logger.debug(string, "No current entry in master repository for " + string4);
                                            object4 = CollectionFactory.newSet();
                                        }
                                        StoreRecord storeRecord = StoreRecordUtil.getFirstStoreRecord(set, _logger);
                                        String string5 = storeRecord.getXMTID();
                                        _logger.debug(string, "Base XMTID for the current Set of StoreRecords is " + string5);
                                        this.updateMasterDB(iAdapterSession, (Set)object4, set, (String)object, string4, storeRecord);
                                        Set set2 = StoreRecordUtil.setActions(set, (String)object, _logger);
                                        Set set3 = (Set)map.get(string4);
                                        if (set3 == null) {
                                            set3 = CollectionFactory.newOrderedSet();
                                        }
                                        set3.addAll(set2);
                                        map.put(string4, set3);
                                        continue;
                                    }
                                    object4 = CWRGSMessageHelper.getMessage("WARNING_STORAGE_MEM_COMMIT_DB_NAME");
                                    _logger.warning(string, (String)object4);
                                    continue;
                                }
                                _logger.debug(string, "No entries in current Map for type " + (String)object);
                            }
                            continue;
                        }
                        _logger.debug(string, "No entries for current Map.");
                    }
                    if (map != null) {
                        boolean bl5 = _rwLockInstanceD.getWriterLock();
                        if (bl5) {
                            if (memorySession.getInstanceDeltaRepository() != null) {
                                memorySession.getInstanceDeltaRepository().put(string3, map);
                            }
                            _rwLockInstanceD.releaseLock();
                        } else {
                            object3 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_COMMIT_LOCK", new Object[]{memorySession.getContextID()});
                            _logger.error(string, (String)object3);
                            throw new PolicyStoreException((String)object3);
                        }
                    }
                    memorySession.getInstanceContextSandbox().clear();
                } else {
                    _logger.debug(string, "Memory Session context null or empty.");
                }
            } else {
                if (!bl2) {
                    _logger.debug(string, "Could not get a writer lock for the instance master repository.");
                }
                if (!bl3) {
                    _logger.debug(string, "Could not get a writer lock for the context master repository.");
                }
                String string6 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_COMMIT_LOCK", new Object[]{memorySession.getContextID()});
                _logger.error(string, string6);
                throw new PolicyStoreException(string6);
            }
            this._rwLockInstanceS.releaseLock();
            _rwLockInstanceM.releaseLock();
            boolean bl6 = this._rwLockCtxTableS.getWriterLock();
            boolean bl7 = _rwLockCtxTableM.getWriterLock();
            if (bl6 && bl7) {
                if (this._policyTableSandbox != null) {
                    if (memorySession.isPolicyConfig()) {
                        if (!this._policyTableSandbox.containsKey(memorySession.getContextID())) {
                            collection = new TableRow();
                            ((TableRow)((Object)collection)).addColumn(memorySession.getContextID());
                            ((TableRow)((Object)collection)).addColumn(memorySession.getContextID());
                            ((TableRow)((Object)collection)).addColumn(null);
                            ((TableRow)((Object)collection)).addColumn(null);
                            ((TableRow)((Object)collection)).addColumn(FALSE);
                            this._policyTableSandbox.put(memorySession.getContextID(), collection);
                            _logger.debug(string, "Adding policy context to table " + memorySession.getContextID());
                        }
                    } else {
                        collection = this._policyTableSandbox.values();
                        if (collection != null) {
                            Iterator iterator = collection.iterator();
                            while (iterator.hasNext()) {
                                object3 = (TableRow)iterator.next();
                                object2 = (String)((TableRow)object3).getColumn(ROLE_CONTEXT_ID);
                                if (memorySession.getContextID() == null || object2 == null || !memorySession.getContextID().equals(object2)) continue;
                                ((TableRow)object3).setColumn(ROLE_CONTEXT_INSERVICE, TRUE);
                                this._policyTableSandbox.put((String)((TableRow)object3).getColumn(POLICY_CONTEXT_ID), object3);
                                _logger.debug(string, "Adding role context to table " + memorySession.getContextID());
                            }
                        }
                    }
                    if (_policyContextIDTable != null && (collection = this._policyTableSandbox.values()) != null) {
                        Iterator iterator = collection.iterator();
                        while (iterator.hasNext()) {
                            object3 = (TableRow)iterator.next();
                            if (((TableRow)object3).isDeleted()) {
                                object2 = (String)((TableRow)object3).getColumn(POLICY_CONTEXT_ID);
                                if (!_policyContextIDTable.containsKey(object2)) continue;
                                _policyContextIDTable.remove(object2);
                                continue;
                            }
                            if (_policyContextIDTable.containsValue(object3)) continue;
                            object2 = (String)((TableRow)object3).getColumn(POLICY_CONTEXT_ID);
                            if (_policyContextIDTable.containsKey(object2)) {
                                object = (TableRow)_policyContextIDTable.get(object2);
                                if (((TableRow)object).equals(object3)) continue;
                                _policyContextIDTable.put(object2, object3);
                                continue;
                            }
                            _policyContextIDTable.put(object2, object3);
                        }
                    }
                    this._policyTableSandbox = null;
                }
            } else {
                if (!bl6) {
                    _logger.debug(string, "Unable to obtain a lock for Context Table Sandbox.");
                }
                if (!bl7) {
                    _logger.debug(string, "Unable to obtain a lock for Context Table Master");
                }
                collection = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_COMMIT_LOCK", new Object[]{memorySession.getContextID()});
                _logger.error(string, (String)((Object)collection));
                throw new PolicyStoreException((String)((Object)collection));
            }
            this._rwLockCtxTableS.releaseLock();
            _rwLockCtxTableM.releaseLock();
        }
        catch (RWLockException rWLockException) {
            String string7 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_COMMIT_LOCK", new Object[]{memorySession.getContextID()});
            _logger.error(string, string7, rWLockException);
            throw new PolicyStoreException(string7, rWLockException);
        }
        this.cleanupDeltaDB(iAdapterSession);
        _logger.exit(string);
    }

    private void cleanupDeltaDB(IAdapterSession iAdapterSession) throws PolicyStoreException {
        String string;
        block11: {
            string = "cleanupDeltaDB( IAdapterSession )";
            _logger.entry(string, iAdapterSession);
            MemorySession memorySession = (MemorySession)iAdapterSession;
            try {
                Set set = CollectionFactory.newSet();
                boolean bl = _rwLockSessionT.getReaderLock();
                if (bl) {
                    Object object;
                    Object object2;
                    Collection collection = _sessionTable.values();
                    if (collection != null) {
                        set.addAll(collection);
                    } else {
                        _logger.debug(string, "No entries in the session table.");
                    }
                    _rwLockSessionT.releaseLock();
                    bl = false;
                    Set set2 = CollectionFactory.newSet();
                    boolean bl2 = _rwLockInstanceD.getReaderLock();
                    if (bl2 && memorySession.getInstanceDeltaRepository() != null) {
                        object2 = memorySession.getInstanceDeltaRepository().keySet();
                        object = object2.iterator();
                        while (object.hasNext()) {
                            boolean bl3 = false;
                            String string2 = (String)object.next();
                            Iterator iterator = set.iterator();
                            while (iterator.hasNext()) {
                                String string3 = (String)iterator.next();
                                if (StoreRecordUtil.compareVersions(string3, string2, _logger) != 2) continue;
                                bl3 = true;
                                break;
                            }
                            if (bl3) continue;
                            set2.add(string2);
                        }
                        _rwLockInstanceD.releaseLock();
                        bl2 = false;
                    }
                    object2 = set2.iterator();
                    bl2 = _rwLockInstanceD.getWriterLock();
                    if (bl2) {
                        if (memorySession.getInstanceDeltaRepository() != null) {
                            while (object2.hasNext()) {
                                object = (String)object2.next();
                                _logger.debug(string, "Removing old delta version '" + (String)object + "' from session delta repository");
                                memorySession.getInstanceDeltaRepository().remove(object);
                            }
                        }
                        _rwLockInstanceD.releaseLock();
                        bl2 = false;
                    }
                    break block11;
                }
                String string4 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_CLEANUP_DELTA_LOCK", new Object[]{memorySession.getContextID()});
                _logger.error(string, string4);
                throw new PolicyStoreException(string4);
            }
            catch (RWLockException rWLockException) {
                String string5 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_CLEANUP_DELTA_LOCK", new Object[]{memorySession.getContextID()});
                _logger.error(string, string5, rWLockException);
                throw new PolicyStoreException(string5, rWLockException);
            }
        }
        _logger.exit(string);
    }

    public boolean sessionIsClientUnique(String string) throws PolicyStoreException {
        String string2 = "isUniqueClientID( String )";
        _logger.entry(string2, string);
        boolean bl = true;
        if (string == null || string.length() == 0) {
            _logger.debug(string2, "ClientID, " + string + ", is invalid. Returning false.");
            bl = false;
        } else {
            try {
                boolean bl2 = _rwLockUniqueID.getReaderLock();
                if (bl2) {
                    if (_uniqueIDs.containsKey(string)) {
                        bl = false;
                    }
                } else {
                    String string3 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_CHECK_CLIENT_UNIQUE_LOCK", new Object[]{string});
                    _logger.error(string2, string3);
                    throw new PolicyStoreException(string3);
                }
                _rwLockUniqueID.releaseLock();
            }
            catch (RWLockException rWLockException) {
                String string4 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_CHECK_CLIENT_UNIQUE_LOCK", new Object[]{string});
                _logger.error(string2, string4, rWLockException);
                throw new PolicyStoreException(string4, rWLockException);
            }
        }
        _logger.exit(string2, new Boolean(bl));
        return bl;
    }

    public boolean sessionIsContextUnique(String string) throws PolicyStoreException {
        return true;
    }

    public boolean sessionAddClient(String string, String string2) throws PolicyStoreException {
        return this.sessionIsClientUnique(string);
    }

    private void updatePolicy(IAdapterSession iAdapterSession, Set set) throws PolicyStoreException {
        String string = "updatePolicy( IAdapterSession, Set )";
        _logger.entry(string, new Object[]{iAdapterSession, set});
        if (set == null || set.isEmpty()) {
            _logger.debug(string, "Set is null or empty. Nothing to update.");
        } else {
            Iterator iterator = set.iterator();
            if (iterator.hasNext()) {
                StoreRecord storeRecord = (StoreRecord)iterator.next();
                int n = storeRecord.getAction();
                if (n == 1) {
                    this.updateSandbox(iAdapterSession, "ADD", set);
                } else {
                    this.updateSandbox(iAdapterSession, "DELETE", set);
                }
            }
        }
        _logger.exit(string);
    }

    private void updateSandbox(IAdapterSession iAdapterSession, String string, Set set) throws PolicyStoreException {
        String string2 = "updateSandbox( IAdapterSession, String, Set)";
        _logger.entry(string2, string);
        MemorySession memorySession = (MemorySession)iAdapterSession;
        if (string == null || set == null) {
            _logger.debug(string2, "The type or Set of objects is null. Type is " + string);
        } else {
            try {
                Object object;
                boolean bl = this._rwLockInstanceS.getWriterLock();
                if (bl) {
                    if (memorySession.getInstanceContextSandbox() == null) {
                        memorySession.setInstanceContextSandbox((Set)_instanceSandboxMap.get(memorySession.getContextID()));
                        if (memorySession.getInstanceContextSandbox() == null) {
                            memorySession.setInstanceContextSandbox(CollectionFactory.newSet());
                            _instanceSandboxMap.put(memorySession.getContextID(), memorySession.getInstanceContextSandbox());
                        }
                    }
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        Set set2;
                        object = (StoreRecord)iterator.next();
                        if (!((StoreRecord)object).getClassname().equalsIgnoreCase(DataProcessingConstants.CACN) || (set2 = memorySession.getInstanceContextSandbox()) == null) continue;
                        Iterator iterator2 = set2.iterator();
                        while (iterator2.hasNext()) {
                            Map map = (Map)iterator2.next();
                            Set set3 = (Set)map.get("ADD");
                            if (set3 == null) continue;
                            Set set4 = CollectionFactory.newSet();
                            Iterator iterator3 = set3.iterator();
                            while (iterator3.hasNext()) {
                                StoreRecord storeRecord = (StoreRecord)iterator3.next();
                                if (storeRecord.getClassname().equalsIgnoreCase(DataProcessingConstants.CACN)) continue;
                                set4.add(storeRecord);
                            }
                            map.put("ADD", set4);
                        }
                    }
                } else {
                    String string3 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_UPDATE_SANDBOX_LOCK", new Object[]{memorySession.getContextID(), memorySession.getClientID()});
                    _logger.error(string2, string3);
                    throw new PolicyStoreException(string3);
                }
                object = CollectionFactory.newMap();
                object.put(string, set);
                memorySession.getInstanceContextSandbox().add(object);
                this._rwLockInstanceS.releaseLock();
                bl = false;
            }
            catch (RWLockException rWLockException) {
                String string4 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_UPDATE_SANDBOX_LOCK", new Object[]{memorySession.getContextID(), memorySession.getClientID()});
                _logger.error(string2, string4, rWLockException);
                throw new PolicyStoreException(string4, rWLockException);
            }
        }
        _logger.exit(string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AdapterResultSet retrievePolicy(IAdapterSession iAdapterSession, StoreRecordQuery storeRecordQuery, boolean bl) throws PolicyStoreException {
        Set set;
        String string;
        block56: {
            block53: {
                MemorySession memorySession;
                block54: {
                    SimpleQueryExpr simpleQueryExpr;
                    Object object;
                    String string2;
                    String string3;
                    Object object2;
                    block55: {
                        string = "retrievePolicy( IAdapterSession, StoreRecordQuery, boolean )";
                        _logger.entry(string, new Object[]{iAdapterSession, storeRecordQuery, bl});
                        memorySession = (MemorySession)iAdapterSession;
                        set = CollectionFactory.newSet();
                        if (storeRecordQuery == null) break block53;
                        if (!this._config) {
                            boolean bl2;
                            block51: {
                                bl2 = false;
                                boolean bl3 = false;
                                try {
                                    try {
                                        if (memorySession.getInstanceMasterRepository() == null) {
                                            this.setInstanceMasterRuntime(memorySession);
                                        }
                                        if (memorySession.getInstanceDeltaRepository() == null) {
                                            bl2 = _rwLockInstanceD.getWriterLock();
                                            bl3 = _rwLockContextD.getReaderLock();
                                            if (bl2 && bl3) {
                                                object2 = (Map)_contextToDeltaRepository.get(memorySession.getContextID());
                                                if (object2 != null) {
                                                    memorySession.setInstanceDeltaRepository(CollectionFactory.newMap((Map)object2));
                                                }
                                            } else {
                                                String string4 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_RETRIEVE_POLICY_LOCK", new Object[]{memorySession.getContextID(), memorySession.getClientID()});
                                                _logger.error(string, string4);
                                                throw new PolicyStoreException(string4);
                                            }
                                        }
                                        string3 = null;
                                        if (!bl3) break block51;
                                    }
                                    catch (RWLockException rWLockException) {
                                        String string5 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_RETRIEVE_POLICY_LOCK", new Object[]{memorySession.getContextID(), memorySession.getClientID()});
                                        _logger.error(string, string5, rWLockException);
                                        throw new PolicyStoreException(string5, rWLockException);
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var12_16 = null;
                                    if (bl3) {
                                        _rwLockContextD.releaseLock();
                                        bl3 = false;
                                    }
                                    if (bl2) {
                                        _rwLockInstanceD.releaseLock();
                                        bl2 = false;
                                    }
                                    throw throwable;
                                }
                                _rwLockContextD.releaseLock();
                                bl3 = false;
                            }
                            if (bl2) {
                                _rwLockInstanceD.releaseLock();
                                bl2 = false;
                            }
                        }
                        if (memorySession.getInstanceMasterRepository() == null || bl) break block54;
                        string2 = storeRecordQuery.getAttrName();
                        object = storeRecordQuery.getAttrValue();
                        object2 = storeRecordQuery.getClassname();
                        simpleQueryExpr = (SimpleQueryExpr)storeRecordQuery.getQueryExpr();
                        if (string2 == null || object != null || simpleQueryExpr != null) break block55;
                        Set set2 = null;
                        boolean bl4 = false;
                        try {
                            bl4 = _rwLockInstanceM.getReaderLock();
                            if (!bl4) {
                                String string6 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_RETRIEVE_POLICY_LOCK", new Object[]{memorySession.getContextID(), memorySession.getClientID()});
                                _logger.error(string, string6);
                                throw new PolicyStoreException(string6);
                            }
                            if (object2 != null && ((String)object2).equalsIgnoreCase(DataProcessingConstants.CACN)) {
                                set = (Set)memorySession.getInstanceMasterRepository().get("CA_KEY:");
                            }
                            set2 = memorySession.getInstanceMasterRepository().keySet();
                            if (set2 != null) {
                                Iterator iterator = set2.iterator();
                                block19: while (iterator.hasNext()) {
                                    String string7 = (String)iterator.next();
                                    if (string7 == null || string7.equalsIgnoreCase("_MASTER_CURRENT_VERSION_")) continue;
                                    Set set3 = (Set)memorySession.getInstanceMasterRepository().get(string7);
                                    if (set3 != null) {
                                        Iterator iterator2 = set3.iterator();
                                        while (iterator2.hasNext()) {
                                            StoreRecord storeRecord = (StoreRecord)iterator2.next();
                                            String string8 = storeRecord.getAttrName();
                                            String string9 = storeRecord.getClassname();
                                            if (string8 == null || string9 == null || !string8.equalsIgnoreCase("Key") || !string9.equalsIgnoreCase((String)object2)) continue;
                                            Set set4 = StoreRecordUtil.getRelatedRecords(set3, storeRecord, _logger);
                                            set.add(storeRecord);
                                            if (set4 == null) continue block19;
                                            set.addAll(set4);
                                            continue block19;
                                        }
                                        continue;
                                    }
                                    _logger.debug(string, "No policy for : " + string7);
                                }
                            }
                            _logger.debug(string, "No attrName policy to return.");
                        }
                        catch (RWLockException rWLockException) {
                            String string10 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_RETRIEVE_POLICY_LOCK", new Object[]{memorySession.getContextID(), memorySession.getClientID()});
                            _logger.error(string, string10, rWLockException);
                            throw new PolicyStoreException(string10, rWLockException);
                        }
                        finally {
                            if (bl4) {
                                _rwLockInstanceM.releaseLock();
                                bl4 = false;
                            }
                        }
                    }
                    if (string2 != null && object != null && simpleQueryExpr == null) {
                        String string11 = null;
                        if (object2 != null) {
                            if (((String)object2).equalsIgnoreCase(DataProcessingConstants.PCOCN)) {
                                string11 = "ROLE_KEY:" + (String)object;
                            } else if (((String)object2).equalsIgnoreCase(DataProcessingConstants.RCOCN)) {
                                string11 = (String)object;
                            } else if (((String)object2).equalsIgnoreCase(DataProcessingConstants.IRCN)) {
                                string11 = "IR_KEY:" + object;
                            }
                        }
                        boolean bl5 = false;
                        try {
                            bl5 = _rwLockInstanceM.getReaderLock();
                            if (!bl5) {
                                String string12 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_RETRIEVE_POLICY_LOCK", new Object[]{memorySession.getContextID(), memorySession.getClientID()});
                                _logger.error(string, string12);
                                throw new PolicyStoreException(string12);
                            }
                            set = (Set)memorySession.getInstanceMasterRepository().get(string11);
                        }
                        catch (RWLockException rWLockException) {
                            String string13 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_RETRIEVE_POLICY_LOCK", new Object[]{memorySession.getContextID(), memorySession.getClientID()});
                            _logger.error(string, string13, rWLockException);
                            throw new PolicyStoreException(string13, rWLockException);
                        }
                        finally {
                            if (bl5) {
                                _rwLockInstanceM.releaseLock();
                                bl5 = false;
                            }
                        }
                    }
                    if (string2 != null && object == null && simpleQueryExpr != null) {
                        String string14 = null;
                        if (object2 != null || ((String)object2).equalsIgnoreCase(DataProcessingConstants.RCOCN)) {
                            string14 = this.getRMKeyFromSimpleQueryExpr(simpleQueryExpr);
                        }
                        if (string14 == null) {
                            string3 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_RETRIEVE_POLICY_1", new Object[]{string2, object, simpleQueryExpr});
                            _logger.error(string, string3);
                            throw new PolicyStoreException(string3);
                        }
                        boolean bl6 = false;
                        try {
                            bl6 = _rwLockInstanceM.getReaderLock();
                            if (!bl6) {
                                String string15 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_RETRIEVE_POLICY_LOCK", new Object[]{memorySession.getContextID(), memorySession.getClientID()});
                                _logger.error(string, string15);
                                throw new PolicyStoreException(string15);
                            }
                            set = (Set)memorySession.getInstanceMasterRepository().get(string14);
                        }
                        catch (RWLockException rWLockException) {
                            String string16 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_RETRIEVE_POLICY_LOCK", new Object[]{memorySession.getContextID(), memorySession.getClientID()});
                            _logger.error(string, string16, rWLockException);
                            throw new PolicyStoreException(string16, rWLockException);
                        }
                        finally {
                            if (bl6) {
                                _rwLockInstanceM.releaseLock();
                                bl6 = false;
                            }
                        }
                    } else {
                        String string17 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_RETRIEVE_POLICY_2", new Object[]{string2, object});
                        _logger.error(string, string17);
                        throw new PolicyStoreException(string17);
                    }
                }
                _logger.debug(string, "No policy for this contextID : " + memorySession.getContextID());
                break block56;
            }
            _logger.debug(string, "The query was null. Returning an empty Set.");
        }
        if (set == null) {
            set = CollectionFactory.newSet();
            _logger.debug(string, "The return Set is null. Changing to an empty Set.");
        }
        MemoryBackedAdapterResultSet memoryBackedAdapterResultSet = new MemoryBackedAdapterResultSet(set);
        _logger.exit(string, memoryBackedAdapterResultSet);
        return memoryBackedAdapterResultSet;
    }

    private AdapterResultSet retrieveDeltaPolicy(IAdapterSession iAdapterSession, StoreRecordQuery storeRecordQuery) throws PolicyStoreException {
        String string = "retrieveDeltaPolicy( IAdapterSession, StoreRecordQuery )";
        _logger.entry(string, storeRecordQuery);
        MemorySession memorySession = (MemorySession)iAdapterSession;
        Object object = CollectionFactory.newOrderedSet();
        if (storeRecordQuery != null) {
            Object object2;
            boolean bl;
            block43: {
                if (!this._config) {
                    try {
                        boolean bl2;
                        if (memorySession.getInstanceMasterRepository() == null) {
                            bl2 = _rwLockInstanceM.getWriterLock();
                            if (bl2) {
                                bl = _rwLockContextM.getReaderLock();
                                if (bl) {
                                    object2 = (Map)_contextToMasterRepository.get(memorySession.getContextID());
                                    if (object2 != null) {
                                        memorySession.setInstanceMasterRepository(CollectionFactory.newMap((Map)object2));
                                    }
                                } else {
                                    String string2 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_RETRIEVE_DELTA_LOCK", new Object[]{memorySession.getContextID(), memorySession.getClientID()});
                                    _logger.error(string, string2);
                                    throw new PolicyStoreException(string2);
                                }
                                _rwLockContextM.releaseLock();
                                bl = false;
                                _rwLockInstanceM.releaseLock();
                                bl2 = false;
                            } else {
                                String string3 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_RETRIEVE_DELTA_LOCK", new Object[]{memorySession.getContextID(), memorySession.getClientID()});
                                _logger.error(string, string3);
                                throw new PolicyStoreException(string3);
                            }
                        }
                        if (memorySession.getInstanceDeltaRepository() != null) break block43;
                        bl2 = _rwLockInstanceD.getWriterLock();
                        if (bl2) {
                            bl = _rwLockContextD.getReaderLock();
                            if (bl) {
                                object2 = (Map)_contextToDeltaRepository.get(memorySession.getContextID());
                                if (object2 != null) {
                                    memorySession.setInstanceDeltaRepository(CollectionFactory.newMap((Map)object2));
                                }
                            } else {
                                object2 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_RETRIEVE_DELTA_LOCK", new Object[]{memorySession.getContextID(), memorySession.getClientID()});
                                _logger.error(string, (String)object2);
                                throw new PolicyStoreException((String)object2);
                            }
                            _rwLockContextD.releaseLock();
                            bl = false;
                            _rwLockInstanceD.releaseLock();
                            bl2 = false;
                            break block43;
                        }
                        String string4 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_RETRIEVE_DELTA_LOCK", new Object[]{memorySession.getContextID(), memorySession.getClientID()});
                        _logger.error(string, string4);
                        throw new PolicyStoreException(string4);
                    }
                    catch (RWLockException rWLockException) {
                        String string5 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_RETRIEVE_DELTA_LOCK", new Object[]{memorySession.getContextID(), memorySession.getClientID()});
                        _logger.error(string, string5, rWLockException);
                        throw new PolicyStoreException(string5, rWLockException);
                    }
                }
            }
            if (memorySession.getInstanceDeltaRepository() != null) {
                try {
                    Object object3;
                    String string6 = null;
                    bl = _rwLockSessionT.getReaderLock();
                    if (!bl) {
                        object2 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_RETRIEVE_DELTA_LOCK", new Object[]{memorySession.getContextID(), memorySession.getClientID()});
                        _logger.error(string, (String)object2);
                        throw new PolicyStoreException((String)object2);
                    }
                    string6 = (String)_sessionTable.get(memorySession.getClientID());
                    _rwLockSessionT.releaseLock();
                    bl = false;
                    object2 = null;
                    if (string6 != null) {
                        object2 = StoreRecordUtil.getTimestampFromVersion(string6, _logger);
                    }
                    if (object2 == null) {
                        _logger.debug(string, "Client has no current session. Retrieving full policy.");
                        AdapterResultSet adapterResultSet = this.retrievePolicy(iAdapterSession, storeRecordQuery, false);
                        Set set = null;
                        if (adapterResultSet != null) {
                            set = adapterResultSet.first();
                            object = set;
                        }
                        object = CollectionFactory.newSet();
                        _logger.debug(string, "A null AdapterResultSet was returned from getFullPolicy. Returning a new Set.");
                    }
                    boolean bl3 = false;
                    boolean bl4 = false;
                    String string7 = storeRecordQuery.getAttrName();
                    String string8 = (String)storeRecordQuery.getAttrValue();
                    String string9 = storeRecordQuery.getClassname();
                    SimpleQueryExpr simpleQueryExpr = (SimpleQueryExpr)storeRecordQuery.getQueryExpr();
                    if (string7 != null && string8 == null && simpleQueryExpr == null) {
                        bl3 = true;
                    } else if (string7 != null && (string8 != null || simpleQueryExpr != null)) {
                        bl3 = false;
                    } else {
                        bl4 = true;
                        object3 = CWRGSMessageHelper.getMessage("WARNING_STORAGE_MEM_RETRIEVE_DELTA_INVALID_QUERY", new Object[]{memorySession.getContextID(), memorySession.getClientID()});
                        _logger.warning(string, (String)object3);
                    }
                    if (string9 != null && string9.equalsIgnoreCase(DataProcessingConstants.CACN)) {
                        _logger.debug(string, "Retrieving the Combining Algorithm.");
                        bl = _rwLockInstanceM.getReaderLock();
                        if (bl) {
                            object = (Set)memorySession.getInstanceMasterRepository().get("CA_KEY:");
                            _rwLockInstanceM.releaseLock();
                            bl = false;
                        }
                        object3 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_RETRIEVE_DELTA_LOCK", new Object[]{memorySession.getContextID(), memorySession.getClientID()});
                        _logger.error(string, (String)object3);
                        throw new PolicyStoreException((String)object3);
                    }
                    object3 = CollectionFactory.newOrderedSet();
                    List list = null;
                    bl = _rwLockInstanceD.getReaderLock();
                    if (bl) {
                        Object object4;
                        object = CollectionFactory.newOrderedSet();
                        list = CollectionFactory.newList();
                        list.addAll(memorySession.getInstanceDeltaRepository().keySet());
                        Collections.sort(list);
                        String string10 = null;
                        if (!bl3 && !bl4) {
                            if (string9 != null) {
                                if (string9.equalsIgnoreCase(DataProcessingConstants.PCOCN)) {
                                    string10 = "ROLE_KEY:" + string8;
                                } else if (string9.equalsIgnoreCase(DataProcessingConstants.RCOCN)) {
                                    string10 = this.getRMKeyFromSimpleQueryExpr(simpleQueryExpr);
                                } else if (string9.equalsIgnoreCase(DataProcessingConstants.IRCN)) {
                                    string10 = "IR_KEY:" + string8;
                                }
                            }
                            if (string10 == null) {
                                object4 = CWRGSMessageHelper.getMessage("WARNING_STORAGE_MEM_RETRIEVE_DELTA_POLICY_NULL_KEY", new Object[]{string9, string8, simpleQueryExpr});
                                _logger.warning(string, (String)object4);
                            }
                        }
                        object4 = list.iterator();
                        while (object4.hasNext()) {
                            Set set;
                            Map map;
                            String string11 = (String)object4.next();
                            if (StoreRecordUtil.compareVersions(string6, string11, _logger) != 2 || (map = (Map)memorySession.getInstanceDeltaRepository().get(string11)) == null) continue;
                            if (bl3 && !bl4) {
                                object3.addAll(this.getDeltaNames(map, (Set)object3, string9));
                                continue;
                            }
                            if (bl4 || string10 == null || (set = (Set)map.get(string10)) == null) continue;
                            object.addAll(set);
                        }
                        if (bl3 && !bl4) {
                            object = object3;
                        }
                        _rwLockInstanceD.releaseLock();
                        bl = false;
                    }
                    String string12 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_RETRIEVE_DELTA_LOCK", new Object[]{memorySession.getContextID(), memorySession.getClientID()});
                    _logger.error(string, string12);
                    throw new PolicyStoreException(string12);
                }
                catch (RWLockException rWLockException) {
                    String string13 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_RETRIEVE_DELTA_LOCK", new Object[]{memorySession.getContextID(), memorySession.getClientID()});
                    _logger.error(string, string13, rWLockException);
                    throw new PolicyStoreException(string13, rWLockException);
                }
                catch (AdapterException adapterException) {
                    String string14 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_RETRIEVE_DELTA_EXCEPTION", new Object[]{memorySession.getContextID(), memorySession.getClientID(), adapterException.getMessage()});
                    _logger.error(string, string14, adapterException);
                    throw new PolicyStoreException(string14, adapterException);
                }
            } else {
                _logger.debug(string, "No delta policy for this contextID : " + memorySession.getContextID());
            }
        } else {
            _logger.debug(string, "The query was null. Returning an empty Set.");
        }
        if (object == null) {
            object = CollectionFactory.newSet();
            _logger.debug(string, "The return Set is null. Changing to an empty Set.");
        }
        MemoryBackedAdapterResultSet memoryBackedAdapterResultSet = new MemoryBackedAdapterResultSet((Set)object);
        _logger.exit(string, memoryBackedAdapterResultSet);
        return memoryBackedAdapterResultSet;
    }

    public void configLinkContexts(String string, String string2) throws PolicyStoreException {
        String string3;
        block21: {
            string3 = "configLinkContexts(String, String)";
            _logger.entry(string3, new Object[]{string, string2});
            if (string == null || string2 == null || "".equals(string) || "".equals(string2)) {
                String string4 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_LINK_CONTEXT_INVALID");
                _logger.error(string3, string4);
                throw new PolicyStoreException(string4);
            }
            TableRow tableRow = null;
            TableRow tableRow2 = null;
            try {
                String string5;
                boolean bl = this._rwLockCtxTableS.getReaderLock();
                if (bl) {
                    if (this._policyTableSandbox == null) {
                        this._policyTableSandbox = CollectionFactory.newMap(_policyContextIDTable);
                    }
                    if (this._policyTableSandbox.containsKey(string)) {
                        tableRow = (TableRow)this._policyTableSandbox.get(string);
                    }
                    if (this._policyTableSandbox.containsKey(string2)) {
                        tableRow2 = (TableRow)this._policyTableSandbox.get(string2);
                    }
                    this._rwLockCtxTableS.releaseLock();
                    bl = false;
                    if (tableRow == null) {
                        String string6 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_LINK_CONTEXT_NO_CONTEXT", new Object[]{string});
                        _logger.error(string3, string6);
                        throw new PolicyStoreException(string6);
                    }
                    if (tableRow2 == null) {
                        String string7 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_LINK_CONTEXT_NO_CONTEXT", new Object[]{string2});
                        _logger.error(string3, string7);
                        throw new PolicyStoreException(string7);
                    }
                } else {
                    String string8 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_LINK_CONTEXT_LOCK");
                    _logger.error(string3, string8);
                    throw new PolicyStoreException(string8);
                }
                if (tableRow != null && tableRow2 != null && !tableRow.isDeleted() && !tableRow2.isDeleted()) {
                    String string9 = (String)tableRow.getColumn(ROLE_CONTEXT_ID);
                    String string10 = (String)tableRow2.getColumn(ROLE_CONTEXT_ID);
                    if (string9 == null && string10 == null) {
                        string9 = this.configGetRoleContext(string);
                        bl = this._rwLockCtxTableS.getWriterLock();
                        if (bl) {
                            TableRow tableRow3 = (TableRow)this._policyTableSandbox.get(string);
                            String string11 = (String)tableRow3.getColumn(ROLE_CONTEXT_TABLE);
                            String string12 = (String)tableRow3.getColumn(ROLE_CONTEXT_INSERVICE);
                            tableRow2.setColumn(ROLE_CONTEXT_ID, string9);
                            tableRow2.setColumn(ROLE_CONTEXT_TABLE, string11);
                            tableRow2.setColumn(ROLE_CONTEXT_INSERVICE, string12);
                            this._policyTableSandbox.put(string2, tableRow2);
                            this._rwLockCtxTableS.releaseLock();
                            bl = false;
                            break block21;
                        }
                        String string13 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_LINK_CONTEXT_LOCK");
                        _logger.error(string3, string13);
                        throw new PolicyStoreException(string13);
                    }
                    if (string9 != null) {
                        bl = this._rwLockCtxTableS.getWriterLock();
                        if (bl) {
                            TableRow tableRow4 = (TableRow)this._policyTableSandbox.get(string);
                            String string14 = (String)tableRow4.getColumn(ROLE_CONTEXT_TABLE);
                            String string15 = (String)tableRow4.getColumn(ROLE_CONTEXT_INSERVICE);
                            tableRow2.setColumn(ROLE_CONTEXT_ID, string9);
                            tableRow2.setColumn(ROLE_CONTEXT_TABLE, string14);
                            tableRow2.setColumn(ROLE_CONTEXT_INSERVICE, string15);
                            this._policyTableSandbox.put(string2, tableRow2);
                            if (string10 != null) {
                                Collection collection = this._policyTableSandbox.values();
                                Iterator iterator = collection.iterator();
                                while (iterator.hasNext()) {
                                    TableRow tableRow5 = (TableRow)iterator.next();
                                    if (!string10.equals((String)tableRow5.getColumn(ROLE_CONTEXT_ID)) || tableRow5.isDeleted()) continue;
                                    String string16 = (String)tableRow5.getColumn(POLICY_CONTEXT_ID);
                                    tableRow5.setColumn(ROLE_CONTEXT_ID, string9);
                                    tableRow5.setColumn(ROLE_CONTEXT_TABLE, string14);
                                    tableRow5.setColumn(ROLE_CONTEXT_INSERVICE, string15);
                                    this._policyTableSandbox.put(string16, tableRow5);
                                }
                            }
                            this._rwLockCtxTableS.releaseLock();
                            bl = false;
                            break block21;
                        }
                        String string17 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_LINK_CONTEXT_LOCK");
                        _logger.error(string3, string17);
                        throw new PolicyStoreException(string17);
                    }
                    if (string10 != null) {
                        bl = this._rwLockCtxTableS.getWriterLock();
                        if (bl) {
                            String string18 = (String)tableRow2.getColumn(ROLE_CONTEXT_TABLE);
                            String string19 = (String)tableRow2.getColumn(ROLE_CONTEXT_INSERVICE);
                            tableRow.setColumn(ROLE_CONTEXT_ID, string10);
                            tableRow.setColumn(ROLE_CONTEXT_TABLE, string18);
                            tableRow.setColumn(ROLE_CONTEXT_INSERVICE, string19);
                            this._policyTableSandbox.put(string, tableRow);
                            this._rwLockCtxTableS.releaseLock();
                            bl = false;
                            break block21;
                        }
                        String string20 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_LINK_CONTEXT_LOCK");
                        _logger.error(string3, string20);
                        throw new PolicyStoreException(string20);
                    }
                    _logger.error(string3, "We have got into a state that should not happen. JAVA is broken");
                    throw new PolicyStoreException();
                }
                String string21 = "";
                if (tableRow.isDeleted()) {
                    string5 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_LINK_CONTEXT_DELETED", new Object[]{string});
                    string21 = string21 + string5;
                    _logger.error(string3, string5);
                }
                if (tableRow2.isDeleted()) {
                    string5 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_LINK_CONTEXT_DELETED", new Object[]{string2});
                    string21 = string21 + "\n" + string5;
                    _logger.error(string3, string5);
                }
                throw new PolicyStoreException(string21);
            }
            catch (RWLockException rWLockException) {
                String string22 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_LINK_CONTEXT_LOCK");
                _logger.error(string3, string22, rWLockException);
                throw new PolicyStoreException(string22, rWLockException);
            }
        }
        _logger.exit(string3);
    }

    public void configRemoveContext(String string) throws PolicyStoreException {
        String string2 = "configRemoveContext(String)";
        _logger.entry(string2, string);
        if (string != null) {
            try {
                boolean bl = this._rwLockCtxTableS.getWriterLock();
                if (bl) {
                    if (this._policyTableSandbox == null) {
                        this._policyTableSandbox = CollectionFactory.newMap(_policyContextIDTable);
                    }
                } else {
                    String string3 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_REMOVE_CONTEXT_LOCK", new Object[]{string});
                    _logger.error(string2, string3);
                    throw new PolicyStoreException(string3);
                }
                TableRow tableRow = (TableRow)this._policyTableSandbox.get(string);
                tableRow.setDeleted(true);
                this._policyTableSandbox.put(string, tableRow);
                this._rwLockCtxTableS.releaseLock();
                bl = false;
            }
            catch (RWLockException rWLockException) {
                String string4 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_REMOVE_CONTEXT_LOCK", new Object[]{string});
                _logger.error(string2, string4, rWLockException);
                throw new PolicyStoreException(string4, rWLockException);
            }
        } else {
            String string5 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_REMOVE_CONTEXT_NULL");
            _logger.error(string2, string5);
            throw new PolicyStoreException(string5);
        }
        _logger.exit(string2);
    }

    public Set configGetRoleContexts() throws PolicyStoreException {
        String string = "configGetRoleContexts()";
        _logger.entry(string);
        Set set = CollectionFactory.newSet();
        try {
            boolean bl = this._rwLockCtxTableS.getReaderLock();
            if (bl) {
                if (this._policyTableSandbox == null) {
                    this._policyTableSandbox = CollectionFactory.newMap(_policyContextIDTable);
                }
                Collection collection = this._policyTableSandbox.values();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    TableRow tableRow = (TableRow)iterator.next();
                    String string2 = (String)tableRow.getColumn(ROLE_CONTEXT_ID);
                    if (string2 == null) continue;
                    if (!tableRow.isDeleted()) {
                        if (TRUE.equals(tableRow.getColumn(ROLE_CONTEXT_INSERVICE))) {
                            if (set.contains(string2)) continue;
                            _logger.debug(string, "Adding role context '" + string2 + "' to return set.");
                            set.add(string2);
                            continue;
                        }
                        _logger.debug(string, "roleCtx '" + string2 + "' is not in service, not returning this value");
                        continue;
                    }
                    _logger.debug(string, "roleCtx '" + string2 + "' is deleted, not returning this value.");
                }
            } else {
                String string3 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_GET_CONTEXTS_LOCK");
                _logger.error(string, string3);
                throw new PolicyStoreException(string3);
            }
            this._rwLockCtxTableS.releaseLock();
            bl = false;
        }
        catch (RWLockException rWLockException) {
            String string4 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_GET_CONTEXTS_LOCK");
            _logger.error(string, string4, rWLockException);
            throw new PolicyStoreException(string4, rWLockException);
        }
        _logger.exit(string);
        return set;
    }

    public Set configGetLinkedContexts(String string) throws PolicyStoreException {
        String string2 = "configGetLinkedContexts(String)";
        _logger.entry(string2, string);
        Set set = CollectionFactory.newSet();
        if (string != null) {
            try {
                boolean bl = this._rwLockCtxTableS.getReaderLock();
                if (bl) {
                    String string3;
                    TableRow tableRow;
                    if (this._policyTableSandbox == null) {
                        this._policyTableSandbox = CollectionFactory.newMap(_policyContextIDTable);
                    }
                    if ((tableRow = (TableRow)this._policyTableSandbox.get(string)) != null && !tableRow.isDeleted() && (string3 = (String)tableRow.getColumn(ROLE_CONTEXT_ID)) != null) {
                        Collection collection = this._policyTableSandbox.values();
                        Iterator iterator = collection.iterator();
                        while (iterator.hasNext()) {
                            String string4;
                            TableRow tableRow2 = (TableRow)iterator.next();
                            String string5 = (String)tableRow2.getColumn(ROLE_CONTEXT_ID);
                            if (string5 == null || !string5.equals(string3) || (string4 = (String)tableRow2.getColumn(POLICY_CONTEXT_ID)) == null || set.contains(string4)) continue;
                            set.add(string4);
                        }
                    }
                } else {
                    String string6 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_GET_LINKED_CONTEXTS_LOCK", new Object[]{string});
                    _logger.error(string2, string6);
                    throw new PolicyStoreException(string6);
                }
                this._rwLockCtxTableS.releaseLock();
                bl = false;
            }
            catch (RWLockException rWLockException) {
                String string7 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_GET_LINKED_CONTEXTS_LOCK", new Object[]{string});
                _logger.error(string2, string7, rWLockException);
                throw new PolicyStoreException(string7, rWLockException);
            }
        } else {
            String string8 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_GET_LINKED_CONTEXTS_NULL");
            _logger.error(string2, string8);
            throw new PolicyStoreException(string8);
        }
        _logger.exit(string2, set);
        return set;
    }

    public Set configGetPolicyContexts() throws PolicyStoreException {
        String string = "configGetPolicyContexts()";
        _logger.entry(string);
        Set set = CollectionFactory.newSet();
        try {
            boolean bl = this._rwLockCtxTableS.getReaderLock();
            if (bl) {
                if (this._policyTableSandbox == null) {
                    this._policyTableSandbox = CollectionFactory.newMap(_policyContextIDTable);
                }
                Collection collection = this._policyTableSandbox.values();
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    TableRow tableRow = (TableRow)iterator.next();
                    String string2 = (String)tableRow.getColumn(POLICY_CONTEXT_ID);
                    if (string2 == null || tableRow.isDeleted() || set.contains(string2)) continue;
                    set.add(string2);
                }
            } else {
                String string3 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_GET_CONTEXTS_LOCK");
                _logger.error(string, string3);
                throw new PolicyStoreException(string3);
            }
            this._rwLockCtxTableS.releaseLock();
            bl = false;
        }
        catch (RWLockException rWLockException) {
            String string4 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_GET_CONTEXTS_LOCK");
            _logger.error(string, string4, rWLockException);
            throw new PolicyStoreException(string4, rWLockException);
        }
        _logger.exit(string, set);
        return set;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String configGetRoleContext(String string) throws PolicyStoreException {
        String string2 = "configGetRoleContext( String )";
        _logger.entry(string2, string);
        String string3 = null;
        if (string == null) {
            String string4 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_GET_ROLE_CONTEXT_NULL");
            _logger.error(string2, string4);
            throw new PolicyStoreException(string4);
        }
        try {
            TableRow tableRow;
            boolean bl = this._rwLockCtxTableS.getWriterLock();
            if (!bl) {
                String string5 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_GET_CONTEXTS_LOCK");
                _logger.error(string2, string5);
                throw new PolicyStoreException(string5);
            }
            if (this._policyTableSandbox == null) {
                this._policyTableSandbox = CollectionFactory.newMap(_policyContextIDTable);
            }
            if ((tableRow = (TableRow)this._policyTableSandbox.get(string)) != null && !tableRow.isDeleted()) {
                string3 = (String)tableRow.getColumn(ROLE_CONTEXT_ID);
                if (string3 == null) {
                    string3 = string + "_role";
                    tableRow.setColumn(ROLE_CONTEXT_ID, string3);
                    tableRow.setColumn(ROLE_CONTEXT_TABLE, string3);
                    this._policyTableSandbox.put(string, tableRow);
                }
            } else {
                this._rwLockCtxTableS.releaseLock();
                String string6 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_POLICY_CONTEXT_NOT_FOUND", new Object[]{string});
                _logger.error(string2, string6);
                throw new PolicyStoreException(string6);
            }
            this._rwLockCtxTableS.releaseLock();
        }
        catch (RWLockException rWLockException) {
            String string7 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_GET_CONTEXTS_LOCK");
            _logger.error(string2, string7, rWLockException);
            throw new PolicyStoreException(string7, rWLockException);
        }
        _logger.exit(string2, string3);
        return string3;
    }

    public void configDeleteAll() {
    }

    public void configCreate() {
    }

    public void configDestroy() {
    }

    public void policyLock() {
    }

    public void sessionCreate() {
    }

    public void sessionDestroy() {
    }

    private void updateMasterDB(IAdapterSession iAdapterSession, Set set, Set set2, String string, String string2, StoreRecord storeRecord) throws PolicyStoreException {
        String string3 = "updateMasterDB( IAdapterSession, Set, Set, String, String, StoreRecord )";
        _logger.entry(string3, new Object[]{string, string2, storeRecord});
        if (string == "ADD") {
            this.addToMasterDB(iAdapterSession, set, set2, string2, storeRecord);
        } else {
            this.delFromMasterDB(iAdapterSession, set, set2, string2, storeRecord);
        }
        _logger.exit(string3);
    }

    private void addToMasterDB(IAdapterSession iAdapterSession, Set set, Set set2, String string, StoreRecord storeRecord) throws PolicyStoreException {
        String string2 = "addToMasterDB( IAdapterSession, Set, Set, String, StoreRecord )";
        _logger.entry(string2, new Object[]{string, storeRecord});
        MemorySession memorySession = (MemorySession)iAdapterSession;
        if (set2 != null && storeRecord != null && string != null) {
            if (set == null) {
                set = CollectionFactory.newSet();
            }
            if (string.equalsIgnoreCase("CA_KEY:")) {
                set.clear();
            }
            if (!StoreRecordUtil.doRecordsExist(set, set2, storeRecord, false, _logger).isEmpty()) {
                _logger.debug(string2, "Attempting to add policy that already exists. No action performed.");
            } else {
                set.addAll(set2);
                memorySession.getInstanceMasterRepository().put(string, set);
            }
        } else {
            String string3 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_ADD_TO_MASTER_NULL");
            _logger.error(string2, string3);
            throw new PolicyStoreException(string3);
        }
        _logger.exit(string2);
    }

    private void delFromMasterDB(IAdapterSession iAdapterSession, Set set, Set set2, String string, StoreRecord storeRecord) throws PolicyStoreException {
        String string2 = "delFromMasterDB( IAdapterSession, Set, Set, String, StoreRecord)";
        _logger.entry(string2, new Object[]{iAdapterSession, set, set2, string, storeRecord});
        MemorySession memorySession = (MemorySession)iAdapterSession;
        if (set2 != null && storeRecord != null && string != null) {
            if (set != null) {
                if (set2.size() == 1) {
                    _logger.debug(string2, "Removing all policy for " + string);
                    memorySession.getInstanceMasterRepository().remove(string);
                } else if (set2.size() == 2 && (storeRecord.getType().equalsIgnoreCase(DataProcessingConstants.PRIN_XMT_TYPE) || storeRecord.getClassname().equalsIgnoreCase(DataProcessingConstants.RCOCN))) {
                    _logger.debug(string2, "Removing all policy for principal " + string);
                    memorySession.getInstanceMasterRepository().remove(string);
                } else {
                    Set set3 = StoreRecordUtil.doRecordsExist(set, set2, storeRecord, false, _logger);
                    if (set3 != null && !set3.isEmpty()) {
                        Iterator iterator = set3.iterator();
                        while (iterator.hasNext()) {
                            Object object;
                            Object object2;
                            StoreRecord storeRecord2 = (StoreRecord)iterator.next();
                            if (storeRecord2 == null) continue;
                            Set set4 = CollectionFactory.newSet();
                            Set set5 = StoreRecordUtil.getLevelRecords(set, storeRecord2, _logger);
                            Iterator iterator2 = set5.iterator();
                            while (iterator2.hasNext()) {
                                object2 = (StoreRecord)iterator2.next();
                                set4.add(object2);
                                object = StoreRecordUtil.getRelatedRecords(set, (StoreRecord)object2, _logger);
                                set4.addAll(object);
                            }
                            object2 = set4.iterator();
                            while (object2.hasNext()) {
                                object = (StoreRecord)object2.next();
                                set.remove(object);
                            }
                        }
                    } else {
                        _logger.debug(string2, "No records to delete.");
                    }
                    if (set != null && set.isEmpty()) {
                        memorySession.getInstanceMasterRepository().remove(string);
                    }
                }
            }
        } else {
            String string3 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_DELETE_FROM_MASTER_NULL");
            _logger.error(string2, string3);
            throw new PolicyStoreException(string3);
        }
        _logger.exit(string2);
    }

    public void policyRefresh(IAdapterSession iAdapterSession) throws PolicyStoreException {
        String string = "policyRefresh( IAdapterSession )";
        _logger.entry(string, iAdapterSession);
        MemorySession memorySession = (MemorySession)iAdapterSession;
        if (!this._config) {
            try {
                if (memorySession.getInstanceMasterRepository() == null) {
                    this.setInstanceMasterRuntime(memorySession);
                }
                boolean bl = _rwLockSessionT.getWriterLock();
                boolean bl2 = _rwLockInstanceM.getWriterLock();
                if (bl && bl2) {
                    if (memorySession.getInstanceMasterRepository() != null) {
                        String string2 = (String)memorySession.getInstanceMasterRepository().get("_MASTER_CURRENT_VERSION_");
                        if (string2 != null) {
                            _sessionTable.put(memorySession.getClientID(), string2);
                        } else {
                            _logger.debug(string, "Master version is null.");
                            string2 = StoreRecordUtil.getIncrementedVersion(memorySession.getInstanceMasterRepository(), _logger);
                            if (string2 == null) {
                                _logger.debug(string, "Could not retrieve a new version.");
                            } else {
                                _sessionTable.put(memorySession.getClientID(), string2);
                            }
                        }
                        memorySession.setEffectiveVersion(string2);
                    } else {
                        _logger.debug(string, "InstanceMasterRepository is null.");
                    }
                } else {
                    String string3 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_REFRESH_POLICY_LOCK", new Object[]{memorySession.getClientID(), memorySession.getContextID()});
                    _logger.error(string, string3);
                    throw new PolicyStoreException(string3);
                }
                _rwLockSessionT.releaseLock();
                bl = false;
                _rwLockInstanceM.releaseLock();
                bl2 = false;
                boolean bl3 = _rwLockInstanceM.getWriterLock();
                if (!bl3) {
                    String string4 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_REFRESH_POLICY_LOCK", new Object[]{memorySession.getClientID(), memorySession.getContextID()});
                    _logger.error(string, string4);
                    throw new PolicyStoreException(string4);
                }
                memorySession.setInstanceMasterRepository(null);
                _rwLockInstanceM.releaseLock();
                bl3 = false;
                bl3 = _rwLockInstanceD.getWriterLock();
                if (!bl3) {
                    String string5 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_REFRESH_POLICY_LOCK", new Object[]{memorySession.getClientID(), memorySession.getContextID()});
                    _logger.error(string, string5);
                    throw new PolicyStoreException(string5);
                }
                memorySession.setInstanceDeltaRepository(null);
                _rwLockInstanceD.releaseLock();
                bl3 = false;
            }
            catch (RWLockException rWLockException) {
                String string6 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_REFRESH_POLICY_LOCK", new Object[]{memorySession.getClientID(), memorySession.getContextID()});
                _logger.error(string, string6, rWLockException);
                throw new PolicyStoreException(string6, rWLockException);
            }
        }
        _logger.exit(string);
    }

    private Set getDeltaNames(Map map, Set set, String string) {
        String string2 = "getDeltaNames(Map)";
        _logger.entry(string2);
        Set set2 = CollectionFactory.newSet();
        if (set != null) {
            set2.addAll(set);
        }
        if (map != null && string != null) {
            Set set3 = map.keySet();
            if (set3 != null) {
                Iterator iterator = set3.iterator();
                block0: while (iterator.hasNext()) {
                    Set set4;
                    String string3 = (String)iterator.next();
                    if (string3 == null || (set4 = (Set)map.get(string3)) == null) continue;
                    Iterator iterator2 = set4.iterator();
                    while (iterator2.hasNext()) {
                        StoreRecord storeRecord = (StoreRecord)iterator2.next();
                        String string4 = storeRecord.getAttrName();
                        String string5 = storeRecord.getClassname();
                        if (string4 == null || string5 == null || !string4.equalsIgnoreCase("Key") || !string5.equalsIgnoreCase(string)) continue;
                        Set set5 = StoreRecordUtil.getRelatedRecords(set4, storeRecord, _logger);
                        if (!StoreRecordUtil.doRecordsExist(set2, set5, storeRecord, false, _logger).isEmpty()) continue block0;
                        set2.add(storeRecord);
                        if (set5 == null) continue block0;
                        set2.addAll(set5);
                        continue block0;
                    }
                }
            }
        } else if (map == null) {
            _logger.debug(string2, "The Set of delta records was null. Nothing to add,");
        } else {
            String string6 = CWRGSMessageHelper.getMessage("WARNING_STORAGE_GET_DELTA_NAMES");
            _logger.warning(string2, string6);
        }
        _logger.exit(string2, set2);
        return set2;
    }

    public AdapterResultSet dumpTable(String string) {
        return null;
    }

    public void configUpdate(ConfigTableEntry configTableEntry) {
    }

    public Set configGetContexts() {
        return null;
    }

    public ConfigTableEntry configGetEntry(String string) {
        return null;
    }

    public void policyCreate(String string) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IAdapterSession newSession(SessionTableEntry sessionTableEntry) throws PolicyStoreException {
        String string = "newSession( SessionTableEntry )";
        _logger.entry(string, sessionTableEntry);
        String string2 = sessionTableEntry.getContextID();
        String string3 = sessionTableEntry.getClientID();
        MemorySession memorySession = new MemorySession(string3, string2);
        memorySession.setPolicyConfig(this._policyConfig);
        memorySession.setSessionTableEntry(sessionTableEntry);
        boolean bl = false;
        boolean bl2 = false;
        try {
            boolean bl3;
            boolean bl4 = _rwLockSessionT.getWriterLock();
            boolean bl5 = _rwLockInstanceM.getWriterLock();
            String string4 = null;
            if (bl4 && bl5) {
                string4 = (String)_sessionTable.get(memorySession.getClientID());
                memorySession.setEffectiveVersion(string4);
                _rwLockSessionT.releaseLock();
                _rwLockInstanceM.releaseLock();
                bl4 = false;
                bl5 = false;
                bl3 = _rwLockUniqueID.getWriterLock();
                if (!bl3) {
                    String string5 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_NEW_SESSION_LOCK");
                    _logger.error(string, string5);
                    throw new PolicyStoreException(string5);
                }
            } else {
                String string6 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_NEW_SESSION_LOCK");
                _logger.error(string, string6);
                throw new PolicyStoreException(string6);
            }
            _uniqueIDs.put(string3, memorySession);
            _rwLockUniqueID.releaseLock();
            bl3 = false;
            if (!this._config) return memorySession;
            bl2 = _rwLockInstanceM.getWriterLock();
            if (!bl2) {
                String string7 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_NEW_SESSION_LOCK");
                _logger.error(string, string7);
                throw new PolicyStoreException(string7);
            }
            bl = _rwLockContextM.getReaderLock();
            if (!bl) {
                String string8 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_NEW_SESSION_LOCK");
                _logger.error(string, string8);
                throw new PolicyStoreException(string8);
            }
            memorySession.setInstanceMasterRepository((Map)_contextToMasterRepository.get(memorySession.getContextID()));
            _rwLockContextM.releaseLock();
            bl = false;
            if (memorySession.getInstanceMasterRepository() == null) {
                bl = _rwLockContextM.getWriterLock();
                if (!bl) {
                    String string9 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_NEW_SESSION_LOCK");
                    _logger.error(string, string9);
                    throw new PolicyStoreException(string9);
                }
                memorySession.setInstanceMasterRepository(CollectionFactory.newMap());
                _contextToMasterRepository.put(memorySession.getContextID(), memorySession.getInstanceMasterRepository());
                memorySession.setInstanceMasterRepository((Map)_contextToMasterRepository.get(memorySession.getContextID()));
                _rwLockContextM.releaseLock();
                bl = false;
            }
            _rwLockInstanceM.releaseLock();
            bl2 = false;
            bl2 = _rwLockInstanceD.getWriterLock();
            if (!bl2) {
                String string10 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_NEW_SESSION_LOCK");
                _logger.error(string, string10);
                throw new PolicyStoreException(string10);
            }
            bl = _rwLockContextD.getReaderLock();
            if (!bl) {
                String string11 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_NEW_SESSION_LOCK");
                _logger.error(string, string11);
                throw new PolicyStoreException(string11);
            }
            memorySession.setInstanceDeltaRepository((Map)_contextToDeltaRepository.get(memorySession.getContextID()));
            _rwLockContextD.releaseLock();
            bl = false;
            if (memorySession.getInstanceDeltaRepository() == null) {
                bl = _rwLockContextD.getWriterLock();
                if (!bl) {
                    String string12 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_NEW_SESSION_LOCK");
                    _logger.error(string, string12);
                    throw new PolicyStoreException(string12);
                }
                memorySession.setInstanceDeltaRepository(CollectionFactory.newMap());
                _contextToDeltaRepository.put(memorySession.getContextID(), memorySession.getInstanceDeltaRepository());
                memorySession.setInstanceDeltaRepository((Map)_contextToDeltaRepository.get(memorySession.getContextID()));
                _rwLockContextD.releaseLock();
                bl = false;
            }
            _rwLockInstanceD.releaseLock();
            bl2 = false;
            return memorySession;
        }
        catch (RWLockException rWLockException) {
            String string13 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_NEW_SESSION_LOCK");
            _logger.error(string, string13, rWLockException);
            throw new PolicyStoreException(string13, rWLockException);
        }
    }

    public void sessionUpdate(SessionTableEntry sessionTableEntry) {
    }

    public SessionTableEntry sessionGetEntry(String string, String string2) {
        String string3 = "sessionGetEntry( String, String )";
        _logger.entry(string3, new Object[]{string, string2});
        SessionTableEntry sessionTableEntry = null;
        sessionTableEntry = ((MemorySession)_uniqueIDs.get(string)).getSessionTableEntry();
        _logger.exit(string3, sessionTableEntry);
        return sessionTableEntry;
    }

    public void policyUpdate(IAdapterSession iAdapterSession, List list) throws PolicyStoreException {
    }

    public void sessionRemove(String string) throws PolicyStoreException {
    }

    public ConfigTableEntry configGetEntry(ConfigTableEntry configTableEntry) throws PolicyStoreException {
        return null;
    }

    public void rebuildTable(String string, boolean bl) {
        String string2 = "rebuildTable( String, boolean )";
        _logger.entry(string2);
        _logger.exit(string2);
    }

    private String getRMKeyFromSimpleQueryExpr(SimpleQueryExpr simpleQueryExpr) {
        String string = "getRMKeyFromSimpleQueryExpr( SimplyQueryExpr )";
        _logger.entry(string, simpleQueryExpr);
        String string2 = null;
        List list = simpleQueryExpr.getOperands();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string3;
                String string4;
                QueryOperand queryOperand = (QueryOperand)iterator.next();
                StoreRecordQuery storeRecordQuery = queryOperand.getQuery();
                if (storeRecordQuery == null || (string4 = storeRecordQuery.getType()) == null || !string4.equalsIgnoreCase(DataProcessingConstants.PRIN_XMT_TYPE) || (string3 = storeRecordQuery.getAttrName()) == null || !string3.equalsIgnoreCase("Name")) continue;
                string2 = (String)storeRecordQuery.getAttrValue();
                break;
            }
        }
        _logger.exit(string, string2);
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String policyGetMasterVersion(IAdapterSession iAdapterSession) throws PolicyStoreException {
        boolean bl;
        String string;
        String string2;
        block12: {
            string2 = "policyGetMasterVersion(IAdapterSession)";
            _logger.entry(string2);
            MemorySession memorySession = (MemorySession)iAdapterSession;
            string = null;
            boolean bl2 = false;
            bl = false;
            try {
                try {
                    bl2 = _rwLockInstanceM.getReaderLock();
                    if (!bl2) {
                        String string3 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_GET_MASTER_VERSION_LOCK", new Object[]{memorySession.getContextID()});
                        _logger.error(string2, string3);
                        throw new PolicyStoreException(string3);
                    }
                    if (memorySession.getInstanceMasterRepository() != null) {
                        string = (String)memorySession.getInstanceMasterRepository().get("_MASTER_CURRENT_VERSION_");
                    } else {
                        bl = _rwLockContextM.getWriterLock();
                        if (!bl) {
                            String string4 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_GET_MASTER_VERSION_LOCK", new Object[]{memorySession.getContextID()});
                            _logger.error(string2, string4);
                            throw new PolicyStoreException(string4);
                        }
                        Map map = (Map)_contextToMasterRepository.get(memorySession.getContextID());
                        if (map != null) {
                            string = (String)map.get("_MASTER_CURRENT_VERSION_");
                        }
                        _rwLockContextM.releaseLock();
                        bl = false;
                    }
                    Object var10_11 = null;
                    if (!bl2) break block12;
                }
                catch (RWLockException rWLockException) {
                    String string5 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_GET_MASTER_VERSION_LOCK", new Object[]{memorySession.getContextID()});
                    _logger.error(string2, string5, rWLockException);
                    throw new PolicyStoreException(string5, rWLockException);
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                if (bl2) {
                    _rwLockInstanceM.releaseLock();
                    bl2 = false;
                }
                if (bl) {
                    _rwLockContextM.releaseLock();
                    bl = false;
                }
                throw throwable;
            }
            _rwLockInstanceM.releaseLock();
            bl2 = false;
        }
        if (bl) {
            _rwLockContextM.releaseLock();
            bl = false;
        }
        _logger.exit(string2, string);
        return string;
    }

    private void moveMasterDBToDelta(MemorySession memorySession) {
        String string = "moveMasterDBToDelta( MemorySession )";
        _logger.entry(string, memorySession);
        if (memorySession.getInstanceMasterRepository() != null) {
            Map map = CollectionFactory.newMap();
            String string2 = StoreRecordUtil.getIncrementedVersion(memorySession.getInstanceMasterRepository(), _logger);
            _logger.debug(string, "New delta version is " + string2);
            Set set = memorySession.getInstanceMasterRepository().keySet();
            if (set != null) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    if (string3 == null || string3.equalsIgnoreCase("_MASTER_CURRENT_VERSION_")) continue;
                    _logger.debug(string, "Moving information from master repository for '" + string3 + "'");
                    Set set2 = (Set)memorySession.getInstanceMasterRepository().get(string3);
                    if (set2 != null) {
                        Set set3 = StoreRecordUtil.groupStoreRecords(set2, _logger);
                        if (set3 != null) {
                            Iterator iterator2 = set3.iterator();
                            while (iterator2.hasNext()) {
                                Map map2 = (Map)iterator2.next();
                                Set set4 = (Set)map2.get("RECORDS");
                                if (set4 != null) {
                                    Object object;
                                    Set set5 = CollectionFactory.newSet();
                                    Iterator iterator3 = set4.iterator();
                                    while (iterator3.hasNext()) {
                                        object = (StoreRecord)iterator3.next();
                                        ((StoreRecord)object).setAction(2);
                                        set5.add(object);
                                    }
                                    object = StoreRecordUtil.setActions(set5, "DELETE", _logger);
                                    Set set6 = (Set)map.get(string3);
                                    if (set6 == null) {
                                        set6 = CollectionFactory.newOrderedSet();
                                    }
                                    set6.addAll(object);
                                    map.put(string3, set6);
                                    continue;
                                }
                                _logger.debug(string, "No records found in the Set");
                            }
                            continue;
                        }
                        _logger.debug(string, "Grouped records Set is null.");
                        continue;
                    }
                    _logger.debug(string, "No policy found for " + string3);
                }
                if (memorySession.getInstanceDeltaRepository() != null && !map.isEmpty()) {
                    memorySession.getInstanceDeltaRepository().put(string2, map);
                }
            } else {
                _logger.debug(string, "No names found in instance master repository. Nothing to do.");
            }
            memorySession.getInstanceMasterRepository().clear();
            memorySession.getInstanceMasterRepository().put("_MASTER_CURRENT_VERSION_", string2);
        }
        _logger.exit(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setInstanceMasterRuntime(MemorySession memorySession) throws PolicyStoreException {
        boolean bl;
        String string;
        block10: {
            string = "setInstanceMasterRuntime( MemorySession )";
            _logger.entry(string, memorySession);
            boolean bl2 = false;
            bl = false;
            try {
                try {
                    bl2 = _rwLockInstanceM.getWriterLock();
                    if (!bl2) {
                        String string3 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_SET_INST_MASTER_LOCK");
                        _logger.error(string, string3);
                        throw new PolicyStoreException(string3);
                    }
                    bl = _rwLockContextM.getReaderLock();
                    if (!bl) {
                        String string2 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_SET_INST_MASTER_LOCK");
                        _logger.error(string, string2);
                        throw new PolicyStoreException(string2);
                    }
                    Map map = (Map)_contextToMasterRepository.get(memorySession.getContextID());
                    if (map != null) {
                        memorySession.setInstanceMasterRepository(CollectionFactory.newMap(map));
                    }
                    _rwLockContextM.releaseLock();
                    bl = false;
                    _rwLockInstanceM.releaseLock();
                    bl2 = false;
                    Object var8_9 = null;
                    if (!bl2) break block10;
                }
                catch (RWLockException rWLockException) {
                    String string4 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_MEM_SET_INST_MASTER_LOCK");
                    _logger.error(string, string4, rWLockException);
                    throw new PolicyStoreException(string4, rWLockException);
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (bl2) {
                    _rwLockInstanceM.releaseLock();
                    bl2 = false;
                }
                if (bl) {
                    _rwLockContextM.releaseLock();
                    bl = false;
                }
                throw throwable;
            }
            _rwLockInstanceM.releaseLock();
            bl2 = false;
        }
        if (bl) {
            _rwLockContextM.releaseLock();
            bl = false;
        }
        _logger.exit(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

