/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.iauthz.storage.adapter.impl.rdbm;

import com.ibm.sec.iauthz.log.SecLogger;
import com.ibm.sec.iauthz.storage.ConfigTableEntry;
import com.ibm.sec.iauthz.storage.PolicyStoreException;
import com.ibm.sec.iauthz.storage.SessionTableEntry;
import com.ibm.sec.iauthz.storage.StoreRecord;
import com.ibm.sec.iauthz.storage.StoreRecordQuery;
import com.ibm.sec.iauthz.storage.adapter.AdapterResultSet;
import com.ibm.sec.iauthz.storage.adapter.IAdapterSession;
import com.ibm.sec.iauthz.storage.adapter.StorageAdapter;
import com.ibm.sec.iauthz.storage.adapter.TableRow;
import com.ibm.sec.iauthz.storage.adapter.TableVersion;
import com.ibm.sec.iauthz.storage.adapter.impl.ConfigTableSearchAction;
import com.ibm.sec.iauthz.storage.adapter.impl.SchemaDataType;
import com.ibm.sec.iauthz.storage.adapter.impl.SearchOptions;
import com.ibm.sec.iauthz.storage.adapter.impl.SearchResults;
import com.ibm.sec.iauthz.storage.adapter.impl.SearchWhere;
import com.ibm.sec.iauthz.storage.adapter.impl.SessionTableSearchAction;
import com.ibm.sec.iauthz.storage.adapter.impl.rdbm.RDBMException;
import com.ibm.sec.iauthz.storage.adapter.impl.rdbm.RDBMSchemaColumn;
import com.ibm.sec.iauthz.storage.adapter.impl.rdbm.RDBMSession;
import com.ibm.sec.iauthz.storage.adapter.impl.rdbm.RDBMTableSchema;
import com.ibm.sec.iauthz.storage.adapter.impl.rdbm.RDBMTableTransaction;
import com.ibm.sec.iauthz.util.CWRGSMessageHelper;
import com.ibm.sec.iauthz.util.RWLock;
import com.ibm.sec.iauthz.util.RWLockException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public abstract class RDBMAbstractAdapter
extends StorageAdapter {
    private static final String RDBMAbstractAdapter_java_sourceCodeID = "$Id: @(#)64  1.10 src/ws/code/argus/src/com/ibm/sec/iauthz/storage/adapter/impl/rdbm/RDBMAbstractAdapter.java, argus.store, argus600, 060223a 06/02/23 13:11:50 @(#) $";
    private static SecLogger logger = SecLogger.getLogger(class$com$ibm$sec$iauthz$storage$adapter$impl$rdbm$RDBMAbstractAdapter == null ? (class$com$ibm$sec$iauthz$storage$adapter$impl$rdbm$RDBMAbstractAdapter = RDBMAbstractAdapter.class$("com.ibm.sec.iauthz.storage.adapter.impl.rdbm.RDBMAbstractAdapter")) : class$com$ibm$sec$iauthz$storage$adapter$impl$rdbm$RDBMAbstractAdapter);
    public static final String RDBM_USER = "USER";
    public static final String RDBM_USERPW = "USERPW";
    public static final String RDBM_URL = "URL";
    public static final String RDBM_DRIVER = "DRIVER";
    public static final String RDBM_TIMEOUT = "TIMEOUT";
    protected static final String CONFIG_TABLENAME = "CONFIGURATION";
    protected static RDBMTableSchema configSchema_ = new RDBMTableSchema();
    public static final int COLUMN_CONFIG_POLICYCTXID = 0;
    public static final int COLUMN_CONFIG_ROLEMAPCTXID = 1;
    public static final int COLUMN_CONFIG_PERMTABLEID = 2;
    public static final int COLUMN_CONFIG_ROLETABLEID = 3;
    public static final int COLUMN_CONFIG_PERMCTXSVC = 4;
    public static final int COLUMN_CONFIG_ROLECTXSVC = 5;
    public static final int COLUMN_CONFIG_LINKPERMID = 6;
    protected static final String SESSION_TABLENAME = "SESSION_TABLE";
    protected static RDBMTableSchema sessionSchema_ = new RDBMTableSchema();
    public static final int COLUMN_SESSION_POLICYCTXID = 0;
    public static final int COLUMN_SESSION_CLIENTID = 1;
    public static final int COLUMN_SESSION_DBVERSION = 2;
    public static final int COLUMN_SESSION_MODTIME = 3;
    protected static final String PERMISSION_DATA_TABLENAME = "PERMISSIONS";
    protected static final String ROLE_MAPPING_DATA_TABLENAME = "ROLEMAPPING";
    protected static RDBMTableSchema permPolicySchema_ = new RDBMTableSchema();
    public static final int COLUMN_POLICY_XMTID = 0;
    public static final int COLUMN_POLICY_CONTEXT_ID = 1;
    public static final int COLUMN_POLICY_UPDATEVERSION = 2;
    public static final int COLUMN_POLICY_DELETEDVERSION = 3;
    public static final int COLUMN_POLICY_ACTION = 4;
    public static final int COLUMN_POLICY_PERMTYPE = 5;
    public static final int COLUMN_POLICY_CLASSNAME = 6;
    public static final int COLUMN_POLICY_ATTR_NAME = 7;
    public static final int COLUMN_POLICY_ATTR_VALUE_XMTID = 8;
    public static final int COLUMN_POLICY_ATTR_VALUE_STRING = 9;
    public static final int COLUMN_POLICY_ORDER = 10;
    public static final boolean TABLE_IS_KEY = true;
    public static final boolean TABLE_NOT_KEY = false;
    public static final boolean TABLE_NOT_NULL = true;
    public static final boolean TABLE_CAN_BE_NULL = false;
    private static final String XMTID = "XMTID";
    private static final String DELETEDVERSION = "DELETEDVERSION";
    private static final String UPDATEVERSION = "UPDATEVERSION";
    private static final String ACTION = "ACTION";
    private boolean policyInitialized_ = false;
    private RWLock masterLock_ = new RWLock();
    private static boolean isConfigured_;
    static /* synthetic */ Class class$com$ibm$sec$iauthz$storage$adapter$impl$rdbm$RDBMAbstractAdapter;

    public RDBMAbstractAdapter(Properties properties) {
        super(properties);
    }

    public static boolean isConfigured() {
        return isConfigured_;
    }

    public static void setConfigured(boolean bl) {
        isConfigured_ = bl;
    }

    public synchronized void configureRDBM() {
        String string = "configureRDBM";
        if (!RDBMAbstractAdapter.isConfigured()) {
            try {
                RDBMTableTransaction rDBMTableTransaction = new RDBMTableTransaction(this.getConfiguration());
                rDBMTableTransaction.startTransaction();
                boolean bl = this.configureDB(rDBMTableTransaction);
                RDBMAbstractAdapter.setConfigured(bl);
                rDBMTableTransaction.endTransaction();
            }
            catch (RDBMException rDBMException) {
                logger.error(string, rDBMException.getLocalizedMessage());
                rDBMException.printStackTrace();
            }
        }
    }

    public boolean configureDB(RDBMTableTransaction rDBMTableTransaction) {
        return true;
    }

    public String getConfigTableName() {
        return CONFIG_TABLENAME;
    }

    public String getSessionTableName() {
        return SESSION_TABLENAME;
    }

    public void configLinkContexts(String string, String string2) throws PolicyStoreException {
        logger.entry("configLinkContexts");
        RDBMTableTransaction rDBMTableTransaction = new RDBMTableTransaction(this.getConfiguration());
        try {
            SearchOptions searchOptions;
            ConfigTableEntry configTableEntry;
            String string3 = null;
            String string4 = null;
            rDBMTableTransaction.startTransaction();
            SearchOptions searchOptions2 = new SearchOptions();
            searchOptions2.WHERE = new SearchWhere(new ConfigTableEntry(string));
            SearchResults searchResults = rDBMTableTransaction.searchTable(CONFIG_TABLENAME, configSchema_, searchOptions2, new ConfigTableSearchAction(true));
            Set set = (Set)searchResults.getValue();
            if (set != null && set.iterator().hasNext()) {
                string3 = ((ConfigTableEntry)set.iterator().next()).getRoleContextID();
            }
            searchOptions2.WHERE = new SearchWhere(new ConfigTableEntry(string2));
            searchResults = rDBMTableTransaction.searchTable(CONFIG_TABLENAME, configSchema_, searchOptions2, new ConfigTableSearchAction(true));
            set = (Set)searchResults.getValue();
            if (set != null && set.iterator().hasNext()) {
                string4 = ((ConfigTableEntry)set.iterator().next()).getRoleContextID();
            }
            if (string4 == null) {
                string4 = string2 + "_ROLE";
                configTableEntry = new ConfigTableEntry();
                configTableEntry.setRoleContextID(string4);
                searchOptions = new SearchOptions();
                searchOptions.WHERE = new SearchWhere(new ConfigTableEntry(string2));
                rDBMTableTransaction.updateTable(CONFIG_TABLENAME, configSchema_, configTableEntry, searchOptions);
            }
            System.out.println("Source role context ID: " + string3 + "; Target role context ID: " + string4);
            configTableEntry = new ConfigTableEntry();
            configTableEntry.setRoleContextID(string4);
            searchOptions = new SearchOptions();
            if (string3 == null) {
                searchOptions.WHERE = new SearchWhere(new ConfigTableEntry(string));
            } else {
                ConfigTableEntry configTableEntry2 = new ConfigTableEntry();
                configTableEntry2.setRoleContextID(string3);
                searchOptions.WHERE = new SearchWhere(configTableEntry2);
            }
            int n = rDBMTableTransaction.updateTable(CONFIG_TABLENAME, configSchema_, configTableEntry, searchOptions);
            logger.debug("configLinkContexts", n + " policy context IDs updated.");
            rDBMTableTransaction.endTransaction();
        }
        catch (RDBMException rDBMException) {
            try {
                rDBMTableTransaction.rollbackTransaction();
            }
            catch (RDBMException rDBMException2) {
                String string5 = "Error rolling back failed transaction.";
                logger.debug("configLinkContexts", string5);
            }
            String string6 = "Exception caught when linking contexts.";
            logger.error("configLinkContexts", string6, rDBMException);
            throw new PolicyStoreException(string6, rDBMException);
        }
        logger.exit("configLinkContexts");
    }

    public void configRemoveContext(String string) throws PolicyStoreException {
        logger.entry("configRemoveContext", string);
        RDBMTableTransaction rDBMTableTransaction = new RDBMTableTransaction(this.getConfiguration());
        try {
            boolean bl = false;
            String string2 = null;
            rDBMTableTransaction.startTransaction();
            SearchOptions searchOptions = new SearchOptions();
            searchOptions.WHERE = new SearchWhere(new ConfigTableEntry(string));
            SearchResults searchResults = rDBMTableTransaction.searchTable(CONFIG_TABLENAME, configSchema_, searchOptions, new ConfigTableSearchAction(true));
            Set set = (Set)searchResults.getValue();
            if (set != null && set.iterator().hasNext()) {
                logger.debug("configRemoveContext", "Found information matching the context ID '" + string + "' as policy.");
                string2 = ((ConfigTableEntry)set.iterator().next()).getRoleContextID();
                bl = true;
            }
            if (!bl) {
                string2 = string;
            }
            if (bl) {
                Object object;
                logger.debug("configRemoveContext", "Removing policy context '" + string + "' from configuration table.");
                searchOptions = new SearchOptions();
                searchOptions.WHERE = new SearchWhere(new ConfigTableEntry(string));
                int n = rDBMTableTransaction.deleteFromTable(CONFIG_TABLENAME, configSchema_, searchOptions);
                logger.debug("configRemoveContext", "Delete command affected " + n + " rows in the configuration table.");
                if (string2 != null) {
                    searchOptions = new SearchOptions();
                    object = new ConfigTableEntry();
                    ((ConfigTableEntry)object).setRoleContextID(string2);
                    searchOptions.WHERE = new SearchWhere((TableRow)object);
                    searchResults = rDBMTableTransaction.searchTable(CONFIG_TABLENAME, configSchema_, searchOptions, new ConfigTableSearchAction(true));
                    set = (Set)searchResults.getValue();
                    boolean bl2 = false;
                    if (set.size() > 0) {
                        bl2 = true;
                    }
                    if (!bl2) {
                        logger.debug("configRemoveContext", "No other policy context is linked to the role-mapping context '" + string2 + "', removing from configuration.");
                        this.configRemoveContext(string2);
                    }
                }
                object = "DELETE FROM PERMISSIONS WHERE CONTEXTID='" + string + "'";
                n = rDBMTableTransaction.executeSQLUpdate((String)object);
                logger.debug("configRemoveContext", "Removed " + n + " rows of policy information from the master table for context '" + string + "'");
            }
            rDBMTableTransaction.endTransaction();
        }
        catch (RDBMException rDBMException) {
            try {
                rDBMTableTransaction.rollbackTransaction();
            }
            catch (RDBMException rDBMException2) {
                String string3 = "Error rolling back failed transaction.";
                logger.debug("configRemoveContext", string3);
            }
            String string4 = "Error when removing context '" + string + "'";
            logger.error("configRemoveContext", string4, rDBMException);
            throw new PolicyStoreException(string4, rDBMException);
        }
        logger.exit("configRemoveContext");
    }

    public void configUpdate(ConfigTableEntry configTableEntry) throws PolicyStoreException {
        logger.entry("configUpdate");
        RDBMTableTransaction rDBMTableTransaction = new RDBMTableTransaction(this.getConfiguration());
        try {
            rDBMTableTransaction.startTransaction();
            SearchOptions searchOptions = new SearchOptions();
            searchOptions.WHERE = new SearchWhere(new ConfigTableEntry(configTableEntry.getPermContextID()));
            rDBMTableTransaction.deleteFromTable(CONFIG_TABLENAME, configSchema_, searchOptions);
            rDBMTableTransaction.insertRow(CONFIG_TABLENAME, configTableEntry);
            rDBMTableTransaction.endTransaction();
        }
        catch (RDBMException rDBMException) {
            try {
                rDBMTableTransaction.rollbackTransaction();
            }
            catch (RDBMException rDBMException2) {
                String string = "Error rolling back failed transaction.";
                logger.debug("configUpdate", string);
            }
            String string = "Error updating configuration table.";
            logger.error("configUpdate", string, rDBMException);
            throw new PolicyStoreException(string, rDBMException);
        }
        logger.exit("configUpdate");
    }

    public Set configGetContexts() throws PolicyStoreException {
        Object object;
        logger.entry("configGetContexts");
        SearchResults searchResults = null;
        RDBMTableTransaction rDBMTableTransaction = new RDBMTableTransaction(this.getConfiguration());
        try {
            rDBMTableTransaction.startTransaction();
            object = new SearchOptions();
            ((SearchOptions)object).WHERE = new SearchWhere();
            ((SearchOptions)object).WHERE.setMatchAll(true);
            searchResults = rDBMTableTransaction.searchTable(CONFIG_TABLENAME, configSchema_, (SearchOptions)object, new ConfigTableSearchAction(true));
            rDBMTableTransaction.endTransaction();
        }
        catch (RDBMException rDBMException) {
            try {
                rDBMTableTransaction.rollbackTransaction();
            }
            catch (RDBMException rDBMException2) {
                String string = "Error rolling back failed transaction.";
                logger.debug("configGetContexts", string);
            }
            String string = "Error when retrieving data from configuration table.";
            logger.error("configGetContexts", string, rDBMException);
            throw new PolicyStoreException(string, rDBMException);
        }
        object = null;
        if (searchResults != null) {
            object = (Set)searchResults.getValue();
        }
        logger.exit("configGetContexts", object);
        return object;
    }

    protected String configGetTableID(String string) throws PolicyStoreException {
        ConfigTableEntry configTableEntry = this.configGetEntry(string);
        if (configTableEntry != null) {
            return configTableEntry.getPermTableID();
        }
        return null;
    }

    public ConfigTableEntry configGetEntry(String string) throws PolicyStoreException {
        logger.entry("configGetEntry");
        ConfigTableEntry configTableEntry = new ConfigTableEntry(string);
        ConfigTableEntry configTableEntry2 = this.configGetEntry(configTableEntry);
        logger.exit("configGetEntry", configTableEntry2);
        return configTableEntry2;
    }

    public ConfigTableEntry configGetEntry(ConfigTableEntry configTableEntry) throws PolicyStoreException {
        logger.entry("configGetEntry");
        ConfigTableEntry configTableEntry2 = new ConfigTableEntry();
        String string = configTableEntry.getPermContextID();
        String string2 = configTableEntry.getRoleContextID();
        String string3 = configTableEntry.getPermTableID();
        String string4 = configTableEntry.getRoleTableID();
        if (string != null || string2 != null || string3 != null || string4 != null) {
            Object object;
            SearchResults searchResults = null;
            RDBMTableTransaction rDBMTableTransaction = new RDBMTableTransaction(this.getConfiguration());
            try {
                rDBMTableTransaction.startTransaction();
                object = new SearchOptions();
                ((SearchOptions)object).WHERE = new SearchWhere(configTableEntry);
                searchResults = rDBMTableTransaction.searchTable(CONFIG_TABLENAME, configSchema_, (SearchOptions)object, new ConfigTableSearchAction(true));
                rDBMTableTransaction.endTransaction();
            }
            catch (RDBMException rDBMException) {
                try {
                    rDBMTableTransaction.rollbackTransaction();
                }
                catch (RDBMException rDBMException2) {
                    String string5 = "Error rolling back failed transaction.";
                    logger.debug("configGetEntry", string5);
                }
                String string6 = "Error searching configuration table based on ConfigTableEntry: " + configTableEntry;
                logger.error("configGetEntry", string6, rDBMException);
                throw new PolicyStoreException(string6, rDBMException);
            }
            if (searchResults != null && (object = (Set)searchResults.getValue()).size() > 0) {
                configTableEntry2 = (ConfigTableEntry)((Set)searchResults.getValue()).iterator().next();
            }
        } else {
            String string7 = "Invalid input to function, must have at least one non-null member.";
            logger.error("configGetEntry", string7);
            throw new PolicyStoreException(string7);
        }
        logger.exit("configGetEntry", configTableEntry2);
        return configTableEntry2;
    }

    public void configDeleteAll() throws PolicyStoreException {
        logger.entry("configDeleteAll");
        RDBMTableTransaction rDBMTableTransaction = new RDBMTableTransaction(this.getConfiguration());
        try {
            rDBMTableTransaction.startTransaction();
            rDBMTableTransaction.deleteFromTable(CONFIG_TABLENAME, configSchema_, null);
            rDBMTableTransaction.endTransaction();
        }
        catch (RDBMException rDBMException) {
            try {
                rDBMTableTransaction.rollbackTransaction();
            }
            catch (RDBMException rDBMException2) {
                String string = "Error rolling back failed transaction.";
                logger.debug("configDeleteAll", string);
            }
            String string = "Error clearing data from configuration table.";
            logger.error("configDeleteAll", string, rDBMException);
            throw new PolicyStoreException(string, rDBMException);
        }
        logger.exit("configDeleteAll");
    }

    public void configCreate() throws PolicyStoreException {
        logger.entry("configCreate");
        RDBMTableTransaction rDBMTableTransaction = new RDBMTableTransaction(this.getConfiguration());
        try {
            rDBMTableTransaction.startTransaction();
            rDBMTableTransaction.createTable(CONFIG_TABLENAME, configSchema_);
            rDBMTableTransaction.endTransaction();
        }
        catch (RDBMException rDBMException) {
            try {
                rDBMTableTransaction.rollbackTransaction();
            }
            catch (RDBMException rDBMException2) {
                String string = "Error rolling back failed transaction.";
                logger.debug("configCreate", string);
            }
            String string = "Error creating configuration table.";
            logger.error("configCreate", string, rDBMException);
            throw new PolicyStoreException(string, rDBMException);
        }
        logger.exit("configCreate");
    }

    public void configDestroy() throws PolicyStoreException {
        logger.entry("configDestroy");
        RDBMTableTransaction rDBMTableTransaction = new RDBMTableTransaction(this.getConfiguration());
        try {
            rDBMTableTransaction.startTransaction();
            rDBMTableTransaction.deleteTable(CONFIG_TABLENAME);
            rDBMTableTransaction.endTransaction();
        }
        catch (RDBMException rDBMException) {
            try {
                rDBMTableTransaction.rollbackTransaction();
            }
            catch (RDBMException rDBMException2) {
                String string = "Error rolling back failed transaction.";
                logger.debug("configDestroy", string);
            }
            String string = "Error when destroying configuration table.";
            logger.error("configDestroy", string, rDBMException);
            throw new PolicyStoreException(string, rDBMException);
        }
        logger.exit("configDestroy");
    }

    public String configGetRoleContext(String string) throws PolicyStoreException {
        logger.entry("configGetRoleContext");
        String string2 = null;
        try {
            ConfigTableEntry configTableEntry = new ConfigTableEntry(string);
            ConfigTableEntry configTableEntry2 = this.configGetEntry(configTableEntry);
            if (configTableEntry2 != null) {
                string2 = configTableEntry2.getRoleContextID();
            }
        }
        catch (PolicyStoreException policyStoreException) {
            String string3 = "Error when retrieving role-mapping context for policy context '" + string + "'";
            logger.error("configGetRoleContext", string3, policyStoreException);
            throw new PolicyStoreException(string3, policyStoreException);
        }
        logger.exit("configGetRoleContext", string2);
        return string2;
    }

    public Set configGetPolicyContexts() throws PolicyStoreException {
        logger.entry("configGetPolicyContexts");
        HashSet<String> hashSet = new HashSet<String>();
        try {
            Set set = this.configGetContexts();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                ConfigTableEntry configTableEntry = (ConfigTableEntry)iterator.next();
                String string = configTableEntry.getPermContextID();
                if (string == null) continue;
                hashSet.add(string);
            }
        }
        catch (PolicyStoreException policyStoreException) {
            String string = "Error retrieving known policy contexts.";
            throw new PolicyStoreException(string, policyStoreException);
        }
        logger.exit("configGetPolicyContexts", hashSet);
        return hashSet;
    }

    public Set configGetRoleContexts() throws PolicyStoreException {
        logger.entry("configGetRoleContexts");
        HashSet<String> hashSet = new HashSet<String>();
        try {
            Set set = this.configGetContexts();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                ConfigTableEntry configTableEntry = (ConfigTableEntry)iterator.next();
                String string = configTableEntry.getRoleContextID();
                if (string == null) continue;
                hashSet.add(string);
            }
        }
        catch (PolicyStoreException policyStoreException) {
            String string = "Error retrieving known policy contexts.";
            throw new PolicyStoreException(string, policyStoreException);
        }
        logger.exit("configGetRoleContexts", hashSet);
        return hashSet;
    }

    public Set configGetLinkedContexts(String string) throws PolicyStoreException {
        logger.entry("configGetLinkedContexts");
        HashSet<String> hashSet = new HashSet<String>();
        RDBMTableTransaction rDBMTableTransaction = new RDBMTableTransaction(this.getConfiguration());
        try {
            rDBMTableTransaction.startTransaction();
            SearchOptions searchOptions = new SearchOptions();
            searchOptions.WHERE = new SearchWhere(new ConfigTableEntry(string));
            SearchResults searchResults = rDBMTableTransaction.searchTable(CONFIG_TABLENAME, configSchema_, searchOptions, new ConfigTableSearchAction(true));
            String string2 = null;
            if (searchResults != null && ((Set)searchResults.getValue()).size() > 0) {
                string2 = ((ConfigTableEntry)((Set)searchResults.getValue()).iterator().next()).getRoleContextID();
            }
            if (string2 != null) {
                ConfigTableEntry configTableEntry = new ConfigTableEntry();
                configTableEntry.setRoleContextID(string2);
                searchOptions.WHERE = new SearchWhere(configTableEntry);
                searchResults = rDBMTableTransaction.searchTable(CONFIG_TABLENAME, configSchema_, searchOptions, new ConfigTableSearchAction(true));
                if (searchResults != null) {
                    Iterator iterator = ((Set)searchResults.getValue()).iterator();
                    while (iterator.hasNext()) {
                        hashSet.add(((ConfigTableEntry)iterator.next()).getPermContextID());
                    }
                }
            } else {
                logger.debug("configGetLinkedContexts", "The policy context '" + string + "' has no linked policy.");
            }
            rDBMTableTransaction.endTransaction();
        }
        catch (RDBMException rDBMException) {
            try {
                rDBMTableTransaction.rollbackTransaction();
            }
            catch (RDBMException rDBMException2) {
                String string3 = "Error rolling back failed transaction.";
                logger.debug("configGetLinkedContexts", string3);
            }
            String string4 = "Error retrieving policy contexts linked to context '" + string + "'";
            logger.error("configGetLinkedContexts", string4, rDBMException);
            throw new PolicyStoreException(string4, rDBMException);
        }
        logger.exit("configGetLinkedContexts", hashSet);
        return hashSet;
    }

    public void policyUpdate(IAdapterSession iAdapterSession, Set set) throws PolicyStoreException {
        logger.entry("policyUpdate");
        RDBMSession rDBMSession = (RDBMSession)iAdapterSession;
        this.initializeSession(rDBMSession);
        String string = rDBMSession.getSandboxTableName();
        if (string == null) {
            string = this.policyGetTableID(rDBMSession);
            rDBMSession.setSandboxTableName(string);
        }
        if (string == null) {
            return;
        }
        RDBMTableTransaction rDBMTableTransaction = null;
        try {
            rDBMTableTransaction = (RDBMTableTransaction)rDBMSession.getPolicyTxn();
            if (rDBMTableTransaction == null) {
                rDBMTableTransaction = new RDBMTableTransaction(this.getConfiguration());
                rDBMTableTransaction.startTransaction();
                rDBMTableTransaction.setUseTemporaryTable(true);
                rDBMSession.setPolicyTxn(rDBMTableTransaction);
            }
        }
        catch (Exception exception) {
            PolicyStoreException policyStoreException = new PolicyStoreException(exception);
            throw policyStoreException;
        }
        try {
            rDBMTableTransaction.insertPolicyRows(string, set, rDBMSession.getContextID());
        }
        catch (RDBMException rDBMException) {
            PolicyStoreException policyStoreException = new PolicyStoreException(rDBMException);
            throw policyStoreException;
        }
        logger.exit("policyUpdate");
    }

    private String policyGetTableID(RDBMSession rDBMSession) throws PolicyStoreException {
        String string = "policyGetTableID";
        logger.entry(string);
        String string2 = null;
        ConfigTableEntry configTableEntry = rDBMSession.getConfigEntry();
        String string3 = rDBMSession.getContextID();
        string2 = configTableEntry != null && configTableEntry.getPermContextID() != null && configTableEntry.getPermContextID().equals(string3) ? configTableEntry.getPermTableID() : (configTableEntry != null && configTableEntry.getRoleContextID() != null && configTableEntry.getRoleContextID().equals(string3) ? configTableEntry.getRoleTableID() : this.configGetTableID(string3));
        logger.exit(string);
        return null;
    }

    public AdapterResultSet policyGetFull(IAdapterSession iAdapterSession, StoreRecordQuery storeRecordQuery, boolean bl) throws PolicyStoreException {
        logger.entry("policyGetFull");
        RDBMSession rDBMSession = (RDBMSession)iAdapterSession;
        this.initializeSession(rDBMSession);
        TableVersion tableVersion = this.policyGetMasterTableVersion(iAdapterSession);
        if (tableVersion != null && rDBMSession.getVersion() == null) {
            rDBMSession.setVersion(tableVersion);
        }
        AdapterResultSet adapterResultSet = null;
        logger.exit("policyGetFull", adapterResultSet);
        return adapterResultSet;
    }

    public AdapterResultSet policyGetReplica(IAdapterSession iAdapterSession, StoreRecordQuery storeRecordQuery) throws PolicyStoreException {
        logger.entry("policyGetReplica");
        RDBMSession rDBMSession = (RDBMSession)iAdapterSession;
        this.initializeSession(rDBMSession);
        AdapterResultSet adapterResultSet = null;
        logger.exit("policyGetReplica", adapterResultSet);
        return adapterResultSet;
    }

    public AdapterResultSet policyGetDelta(IAdapterSession iAdapterSession, String string, StoreRecordQuery storeRecordQuery) throws PolicyStoreException {
        logger.entry("policyGetDelta");
        RDBMSession rDBMSession = (RDBMSession)iAdapterSession;
        this.initializeSession(rDBMSession);
        AdapterResultSet adapterResultSet = null;
        logger.exit("policyGetDelta", adapterResultSet);
        return adapterResultSet;
    }

    protected TableVersion getMasterVersion(IAdapterSession iAdapterSession) throws PolicyStoreException {
        String string = "getMasterVersion(IAdapterSession)";
        logger.entry(string, iAdapterSession);
        RDBMSession rDBMSession = (RDBMSession)iAdapterSession;
        SessionTableEntry sessionTableEntry = this.sessionGetEntry("0", rDBMSession.getContextID());
        TableVersion tableVersion = null;
        if (sessionTableEntry != null) {
            tableVersion = new TableVersion(sessionTableEntry);
        }
        if (tableVersion == null) {
            logger.debug(string, "Creating initial master DB version.");
            tableVersion = new TableVersion(1L);
        }
        logger.exit(string, tableVersion);
        return tableVersion;
    }

    protected void setMasterVersion(IAdapterSession iAdapterSession, TableVersion tableVersion) throws PolicyStoreException {
        RDBMSession rDBMSession = (RDBMSession)iAdapterSession;
        SessionTableEntry sessionTableEntry = new SessionTableEntry("0", rDBMSession.getContextID());
        TableVersion.setSessionEntry(tableVersion, sessionTableEntry);
        this.sessionUpdate(sessionTableEntry);
    }

    public void policyCommit(IAdapterSession iAdapterSession, boolean bl) throws PolicyStoreException {
        block13: {
            logger.entry("policyCommit");
            RDBMSession rDBMSession = (RDBMSession)iAdapterSession;
            this.initializeSession(rDBMSession);
            RDBMTableTransaction rDBMTableTransaction = (RDBMTableTransaction)rDBMSession.getPolicyTxn();
            if (rDBMTableTransaction == null) {
                rDBMSession.setPolicyTxn(null);
                if (rDBMSession.getConfigEntry() != null) {
                    this.configUpdate(rDBMSession.getConfigEntry());
                    rDBMSession.setConfigEntry(null);
                } else {
                    logger.debug("policyCommit", "There is no config entry.");
                }
                logger.debug("policyCommit", "No policy to commit.");
                return;
            }
            boolean bl2 = false;
            try {
                bl2 = this.masterLock_.getWriterLock();
                if (bl2) {
                    Object object = this.getMasterVersion(iAdapterSession);
                    TableVersion tableVersion = new TableVersion((TableVersion)object);
                    tableVersion.increment();
                    object = rDBMSession.getSandboxTableName();
                    Object object2 = new StoreRecord();
                    ((StoreRecord)object2).setUpdateVersion(tableVersion.getVersionNumber());
                    ((StoreRecord)object2).setUpdateTime(tableVersion.getModTime());
                    Object object3 = new SearchOptions();
                    ((SearchOptions)object3).WHERE = new SearchWhere((TableRow)object2);
                    rDBMTableTransaction.updateTable((String)object, permPolicySchema_, (TableRow)object2, (SearchOptions)object3);
                    object2 = new RDBMTableTransaction(this.getConfiguration());
                    ((RDBMTableTransaction)object2).startTransaction();
                    object3 = "UPDATE " + (String)object + "  SET  " + DELETEDVERSION + "= ? WHERE " + XMTID + " IN (SELECT " + XMTID + " FROM " + rDBMTableTransaction.getTemporaryTableName() + " )";
                    Object[] objectArray = new Object[]{"'" + tableVersion + "'"};
                    rDBMTableTransaction.executeSQLStatement((String)object3, objectArray);
                    object3 = "UPDATE " + (String)object + "  SET  " + UPDATEVERSION + "= ? ";
                    objectArray = new Object[]{"'" + tableVersion + "'"};
                    rDBMTableTransaction.executeSQLStatement((String)object3, objectArray);
                    object3 = "INSERT INTO " + (String)object + " (SELECT * FROM " + rDBMTableTransaction.getTemporaryTableName() + " WHERE " + ACTION + " = " + 1 + ")";
                    rDBMTableTransaction.executeSQLStatement((String)object3, null);
                    rDBMTableTransaction.endTransaction();
                    this.setMasterVersion(iAdapterSession, tableVersion);
                    rDBMSession.setPolicyTxn(null);
                    break block13;
                }
                String string = "Unable to obtain lock for context id " + rDBMSession.getContextID();
                rDBMTableTransaction.rollbackTransaction();
                logger.error("policyCommit", string);
                throw new PolicyStoreException(string);
            }
            catch (RWLockException rWLockException) {
                String string = "An error was encountered while attempting to commit policy. The details are : " + rWLockException.toString();
                logger.error("policyCommit", string);
                throw new PolicyStoreException(string, rWLockException);
            }
            catch (RDBMException rDBMException) {
                String string = "An error was encountered while attempting to commit policy. The details are : " + rDBMException.toString();
                logger.error("policyCommit", string);
                try {
                    rDBMTableTransaction.rollbackTransaction();
                }
                catch (RDBMException rDBMException2) {
                    logger.error("policyCommit", rDBMException2.getLocalizedMessage());
                }
                throw new PolicyStoreException(string, rDBMException);
            }
            finally {
                if (bl2) {
                    this.masterLock_.releaseLock();
                }
            }
        }
        logger.exit("policyCommit");
    }

    private synchronized void policyInitialize() throws PolicyStoreException {
        logger.entry("policyCreate");
        if (!this.policyInitialized_) {
            RDBMTableTransaction rDBMTableTransaction = new RDBMTableTransaction(this.getConfiguration());
            try {
                rDBMTableTransaction.startTransaction();
                rDBMTableTransaction.createTable(PERMISSION_DATA_TABLENAME, permPolicySchema_);
                rDBMTableTransaction.createTable(ROLE_MAPPING_DATA_TABLENAME, permPolicySchema_);
                rDBMTableTransaction.endTransaction();
                this.policyInitialized_ = true;
            }
            catch (RDBMException rDBMException) {
                try {
                    rDBMTableTransaction.rollbackTransaction();
                }
                catch (RDBMException rDBMException2) {
                    String string = "Rolling back failure creating policy tables.";
                    logger.debug("policyCreate", string);
                }
                String string = "Error when creating policy tables.";
                logger.error("policyCreate", string, rDBMException);
                throw new PolicyStoreException(string, rDBMException);
            }
        }
        logger.exit("policyCreate");
    }

    public void policyCreate(String string, String string2) throws PolicyStoreException {
        logger.entry("policyCreate");
        this.policyInitialize();
        RDBMTableTransaction rDBMTableTransaction = new RDBMTableTransaction(this.getConfiguration());
        try {
            String string3 = this.isPermAdapter() ? PERMISSION_DATA_TABLENAME : ROLE_MAPPING_DATA_TABLENAME;
            rDBMTableTransaction.startTransaction();
            rDBMTableTransaction.createPolicyView(string, string3, string2, permPolicySchema_);
            rDBMTableTransaction.endTransaction();
        }
        catch (RDBMException rDBMException) {
            try {
                rDBMTableTransaction.rollbackTransaction();
            }
            catch (RDBMException rDBMException2) {
                String string4 = "Rolling back failure creating policy view.";
                logger.debug("policyCreate", string4);
            }
            String string5 = "Failure creating policy view.";
            logger.error("policyCreate", string5, rDBMException);
            throw new PolicyStoreException(string5, rDBMException);
        }
        logger.exit("policyCreate");
    }

    public void policyDestroy(IAdapterSession iAdapterSession) throws PolicyStoreException {
        logger.entry("policyDestroy");
        logger.exit("policyDestroy");
    }

    public void policyRefresh(IAdapterSession iAdapterSession) throws PolicyStoreException {
    }

    public String policyGetMasterVersion(IAdapterSession iAdapterSession) throws PolicyStoreException {
        String string = "policyGetMasterVersion(IAdapterSession)";
        logger.entry(string, iAdapterSession);
        TableVersion tableVersion = this.policyGetMasterTableVersion(iAdapterSession);
        String string2 = tableVersion.getVersion();
        logger.exit(string, string2);
        return string2;
    }

    private TableVersion policyGetMasterTableVersion(IAdapterSession iAdapterSession) throws PolicyStoreException {
        return new TableVersion(0L);
    }

    public boolean sessionIsClientUnique(String string) throws PolicyStoreException {
        logger.entry("sessionIsClientUnique");
        boolean bl = true;
        try {
            SessionTableEntry sessionTableEntry = this.sessionGetEntry(string, null);
            if (sessionTableEntry != null) {
                bl = false;
            }
        }
        catch (PolicyStoreException policyStoreException) {
            String string2 = "Error when checking for uniqueness of client ID '" + string + "'";
            logger.error("sessionIsClientUnique", string2, policyStoreException);
            throw new PolicyStoreException(string2, policyStoreException);
        }
        logger.exit("sessionIsClientUnique", bl);
        return bl;
    }

    public boolean sessionIsContextUnique(String string) throws PolicyStoreException {
        logger.entry("sessionIsClientUnique");
        boolean bl = true;
        try {
            SessionTableEntry sessionTableEntry = this.sessionGetEntry(null, string);
            if (sessionTableEntry != null) {
                bl = false;
            }
        }
        catch (PolicyStoreException policyStoreException) {
            String string2 = "Error when checking for uniqueness of context ID '" + string + "'";
            logger.error("sessionIsClientUnique", string2, policyStoreException);
            throw new PolicyStoreException(string2, policyStoreException);
        }
        logger.exit("sessionIsClientUnique", bl);
        return bl;
    }

    public boolean sessionAddClient(String string, String string2) throws PolicyStoreException {
        String string3 = "sessionAddClient( String, String )";
        logger.entry(string3, new Object[]{string, string2});
        String string4 = null;
        if (string == null) {
            string4 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_NO_CLIENT_ID");
        }
        if (string2 == null) {
            string4 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_NO_CONTEXT_ID");
        }
        if (string4 != null) {
            throw new PolicyStoreException(string4);
        }
        SessionTableEntry sessionTableEntry = this.sessionGetEntry(string, string2, true);
        logger.exit(string3);
        return sessionTableEntry == null;
    }

    public void sessionCreate() throws PolicyStoreException {
        logger.entry("sessionCreate");
        RDBMTableTransaction rDBMTableTransaction = new RDBMTableTransaction(this.getConfiguration());
        try {
            rDBMTableTransaction.startTransaction();
            rDBMTableTransaction.createTable(SESSION_TABLENAME, sessionSchema_);
            rDBMTableTransaction.endTransaction();
        }
        catch (Exception exception) {
            try {
                rDBMTableTransaction.rollbackTransaction();
            }
            catch (RDBMException rDBMException) {
                String string = "Error rolling back failed transaction.";
                logger.debug("sessionCreate", string);
            }
            String string = "Error creating session table.";
            logger.error("sessionCreate", string, exception);
            throw new PolicyStoreException(string, exception);
        }
        logger.exit("sessionCreate");
    }

    public void sessionDestroy() throws PolicyStoreException {
        logger.entry("sessionDestroy");
        RDBMTableTransaction rDBMTableTransaction = new RDBMTableTransaction(this.getConfiguration());
        try {
            rDBMTableTransaction.startTransaction();
            rDBMTableTransaction.deleteTable(SESSION_TABLENAME);
            rDBMTableTransaction.endTransaction();
        }
        catch (Exception exception) {
            try {
                rDBMTableTransaction.rollbackTransaction();
            }
            catch (RDBMException rDBMException) {
                String string = "Error rolling back failed transaction.";
                logger.debug("sessionDestroy", string);
            }
            String string = "Error destroying session table.";
            logger.error("sessionDestroy", string, exception);
            throw new PolicyStoreException(string, exception);
        }
        logger.exit("sessionDestroy");
    }

    public IAdapterSession newSession(SessionTableEntry sessionTableEntry) throws PolicyStoreException {
        logger.entry("newSession");
        String string = sessionTableEntry.getContextID();
        String string2 = sessionTableEntry.getClientID();
        RDBMSession rDBMSession = new RDBMSession(string2, string);
        if (this.isRuntime()) {
            SessionTableEntry sessionTableEntry2 = this.sessionGetEntry(string2, string);
            if (sessionTableEntry2 == null) {
                sessionTableEntry2 = sessionTableEntry;
                this.sessionUpdate(sessionTableEntry2);
            }
            TableVersion tableVersion = new TableVersion(sessionTableEntry2);
            if (sessionTableEntry2.getDBVersion() != 0L && sessionTableEntry2.getModTime() != null) {
                rDBMSession.setEffectiveVersion(tableVersion);
            }
        }
        logger.exit("newSession", rDBMSession);
        return rDBMSession;
    }

    public void sessionUpdate(SessionTableEntry sessionTableEntry) throws PolicyStoreException {
        logger.entry("sessionUpdate");
        String string = sessionTableEntry.getContextID();
        String string2 = sessionTableEntry.getClientID();
        if (string != null && string2 != null) {
            RDBMTableTransaction rDBMTableTransaction = new RDBMTableTransaction(this.getConfiguration());
            try {
                rDBMTableTransaction.startTransaction();
                SearchOptions searchOptions = new SearchOptions();
                searchOptions.WHERE = new SearchWhere(new SessionTableEntry(string2, string));
                rDBMTableTransaction.deleteFromTable(SESSION_TABLENAME, sessionSchema_, searchOptions);
                rDBMTableTransaction.insertRow(SESSION_TABLENAME, sessionTableEntry);
                rDBMTableTransaction.endTransaction();
            }
            catch (RDBMException rDBMException) {
                try {
                    rDBMTableTransaction.rollbackTransaction();
                }
                catch (RDBMException rDBMException2) {
                    String string3 = "Error rolling back failed transaction.";
                    logger.debug("sessionUpdate", string3);
                }
                String string4 = "Error when updating session table for [context, client] pair: [" + string + ", " + string2 + "]";
                logger.error("sessionUpdate", string4, rDBMException);
                throw new PolicyStoreException(string4, rDBMException);
            }
        }
        String string5 = "Invalid SessionTableEntry, must have values for both context ID and client ID";
        logger.error("sessionUpdate", string5);
        throw new PolicyStoreException(string5);
        logger.exit("sessionUpdate");
    }

    public SessionTableEntry sessionGetEntry(String string, String string2) throws PolicyStoreException {
        logger.entry("sessionGetEntry (clientid, contextid)", new Object[]{string, string2});
        SessionTableEntry sessionTableEntry = this.sessionGetEntry(string, string2, false);
        logger.exit("sessionGetEntry (clientid, contextid)");
        return sessionTableEntry;
    }

    public SessionTableEntry sessionGetEntry(String string, String string2, boolean bl) throws PolicyStoreException {
        logger.entry("sessionGetEntry (clientid, contextid, update)", new Object[]{string, string2, bl});
        SessionTableEntry sessionTableEntry = null;
        RDBMTableTransaction rDBMTableTransaction = new RDBMTableTransaction(this.getConfiguration());
        try {
            rDBMTableTransaction.startTransaction();
            SearchOptions searchOptions = new SearchOptions();
            SessionTableEntry sessionTableEntry2 = new SessionTableEntry(string, string2);
            searchOptions.WHERE = new SearchWhere(sessionTableEntry2);
            SearchResults searchResults = rDBMTableTransaction.searchTable(SESSION_TABLENAME, sessionSchema_, searchOptions, new SessionTableSearchAction(true));
            if (searchResults != null && ((Set)searchResults.getValue()).iterator().hasNext()) {
                sessionTableEntry = (SessionTableEntry)((Set)searchResults.getValue()).iterator().next();
            } else if (bl) {
                rDBMTableTransaction.insertRow(SESSION_TABLENAME, sessionTableEntry2);
            }
            rDBMTableTransaction.endTransaction();
        }
        catch (RDBMException rDBMException) {
            try {
                rDBMTableTransaction.rollbackTransaction();
            }
            catch (RDBMException rDBMException2) {
                String string3 = "Error rolling back failed transaction.";
                logger.debug("sessionGetEntry (clientid, contextid, update)", string3);
            }
            String string4 = "Error when retrieving session table entry for context '" + string2 + "' and client '" + string + "'";
            logger.error("sessionGetEntry (clientid, contextid, update)", string4, rDBMException);
            throw new PolicyStoreException(string4, rDBMException);
        }
        logger.exit("sessionGetEntry (clientid, contextid, update)", sessionTableEntry);
        return sessionTableEntry;
    }

    public void sessionRemove(String string) throws PolicyStoreException {
        logger.entry("removeSession");
        RDBMTableTransaction rDBMTableTransaction = new RDBMTableTransaction(this.getConfiguration());
        try {
            rDBMTableTransaction.startTransaction();
            SearchOptions searchOptions = new SearchOptions();
            searchOptions.WHERE = new SearchWhere(new SessionTableEntry(string, null));
            rDBMTableTransaction.deleteFromTable(SESSION_TABLENAME, sessionSchema_, searchOptions);
            rDBMTableTransaction.endTransaction();
        }
        catch (RDBMException rDBMException) {
            try {
                rDBMTableTransaction.rollbackTransaction();
            }
            catch (RDBMException rDBMException2) {
                String string2 = "Error rolling back failed transaction.";
                logger.debug("removeSession", string2);
            }
            String string3 = "Error when removing session for client ID '" + string + "'";
            logger.error("removeSession", string3, rDBMException);
            throw new PolicyStoreException(string3, rDBMException);
        }
        logger.exit("removeSession");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void initializeSession(RDBMSession rDBMSession) throws PolicyStoreException {
        Object object;
        Object object2;
        String string;
        String string2;
        block22: {
            String string3;
            Object var11_8;
            boolean bl;
            RDBMTableTransaction rDBMTableTransaction;
            block21: {
                block20: {
                    string2 = "initializeSession( RDBMSession )";
                    logger.entry(string2, rDBMSession);
                    if (rDBMSession.isInitialized()) {
                        logger.debug(string2, "Session already initialized.");
                        logger.exit(string2);
                        return;
                    }
                    String string4 = rDBMSession.getContextID();
                    String string5 = rDBMSession.getClientID();
                    string = null;
                    string = this.isPermAdapter() ? RDBMTableSchema.generatePermTableID(string4) : RDBMTableSchema.generateRoleTableID(string4);
                    rDBMTableTransaction = new RDBMTableTransaction(this.getConfiguration());
                    bl = false;
                    rDBMTableTransaction.startTransaction();
                    bl = this.masterLock_.getWriterLock();
                    if (!bl) break block20;
                    if (!rDBMTableTransaction.existsTable(string)) {
                        logger.debug(string2, "Master DB does not exist for contextID " + rDBMSession.getContextID() + ". Creating empty DB.");
                        this.policyCreate(string, string4);
                    }
                    this.masterLock_.releaseLock();
                    bl = false;
                }
                var11_8 = null;
                if (!bl) break block21;
                this.masterLock_.releaseLock();
                bl = false;
            }
            try {
                rDBMTableTransaction.endTransaction();
            }
            catch (RDBMException rDBMException2) {
                string3 = "An error was encountered while attempting to terminate the session. The details are : " + rDBMException2.toString();
                logger.error(string2, string3);
                rDBMException2.printStackTrace();
            }
            break block22;
            {
                catch (PolicyStoreException policyStoreException) {
                    String string6 = "An error was encountered while attempting to initialize the session. The details are : " + policyStoreException.toString();
                    logger.error(string2, string6);
                    throw new PolicyStoreException(string6, policyStoreException);
                }
                catch (RWLockException rWLockException) {
                    String string7 = "An error was encountered while attempting to initialize the session. The details are : " + rWLockException.toString();
                    logger.error(string2, string7);
                    throw new PolicyStoreException(string7, rWLockException);
                }
                catch (RDBMException rDBMException) {
                    object2 = "An error was encountered while attempting to start the session. The details are : " + rDBMException.toString();
                    logger.error(string2, (String)object2);
                    var11_8 = null;
                    if (bl) {
                        this.masterLock_.releaseLock();
                        bl = false;
                    }
                    try {
                        rDBMTableTransaction.endTransaction();
                    }
                    catch (RDBMException rDBMException2) {
                        string3 = "An error was encountered while attempting to terminate the session. The details are : " + rDBMException2.toString();
                        logger.error(string2, string3);
                        rDBMException2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_9 = null;
                if (bl) {
                    this.masterLock_.releaseLock();
                    bl = false;
                }
                try {
                    rDBMTableTransaction.endTransaction();
                }
                catch (RDBMException rDBMException) {
                    String string8 = "An error was encountered while attempting to terminate the session. The details are : " + rDBMException.toString();
                    logger.error(string2, string8);
                    rDBMException.printStackTrace();
                }
                throw throwable;
            }
        }
        rDBMSession.setSandboxTableName(string);
        if (rDBMSession.getConfigEntry() == null && (object = this.configGetContexts()) != null) {
            object2 = object.iterator();
            while (object2.hasNext()) {
                ConfigTableEntry configTableEntry = (ConfigTableEntry)object2.next();
                if (this.isPermAdapter()) {
                    if (configTableEntry.getPermContextID() == null || !configTableEntry.getPermContextID().equals(rDBMSession.getContextID())) continue;
                    if (configTableEntry.getPermTableID() == null) {
                        configTableEntry.setPermTableID(rDBMSession.getSandboxTableName());
                    }
                    rDBMSession.setConfigEntry(configTableEntry);
                    break;
                }
                if (!this.isRoleMapAdapter() || configTableEntry.getRoleContextID() == null || !configTableEntry.getRoleContextID().equals(rDBMSession.getContextID())) continue;
                if (configTableEntry.getRoleTableID() == null) {
                    configTableEntry.setRoleTableID(rDBMSession.getSandboxTableName());
                }
                rDBMSession.setConfigEntry(configTableEntry);
                break;
            }
        }
        if (rDBMSession.getConfigEntry() == null) {
            object = new ConfigTableEntry(rDBMSession.getContextID());
            ((ConfigTableEntry)object).setPermTableID(rDBMSession.getSandboxTableName());
            rDBMSession.setConfigEntry((ConfigTableEntry)object);
            logger.debug(string2, "An error was encountered. The details are : unknown CTX ID");
        }
        rDBMSession.setInitialized(true);
        logger.exit(string2);
    }

    private String getInitialVersion(String string) {
        String string2 = "getInitialVersion(String)";
        logger.entry(string2, string);
        String string3 = null;
        Date date = new Date();
        long l = date.getTime();
        Timestamp timestamp = new Timestamp(l);
        string3 = string + timestamp.toString();
        logger.exit(string2, string3);
        return string3;
    }

    protected RDBMTableSchema getSchema(String string) {
        if (string.equalsIgnoreCase(CONFIG_TABLENAME)) {
            return configSchema_;
        }
        if (string.equalsIgnoreCase(SESSION_TABLENAME)) {
            return sessionSchema_;
        }
        return permPolicySchema_;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        sessionSchema_.addColumn(new RDBMSchemaColumn("POLICYCTXID", SchemaDataType.VARCHAR, 255, true, true));
        sessionSchema_.addColumn(new RDBMSchemaColumn("CLIENTID", SchemaDataType.VARCHAR, 255, true, true));
        sessionSchema_.addColumn(new RDBMSchemaColumn("DBVERSION", SchemaDataType.INT, false, false));
        sessionSchema_.addColumn(new RDBMSchemaColumn("MODTIME", SchemaDataType.DATE, false, false));
        configSchema_.addColumn(new RDBMSchemaColumn("POLICYCTXID", SchemaDataType.VARCHAR, 255, true, true));
        configSchema_.addColumn(new RDBMSchemaColumn("ROLEMAPCTXID", SchemaDataType.VARCHAR, 255, false, false));
        configSchema_.addColumn(new RDBMSchemaColumn("PERMTABLEID", SchemaDataType.CHAR, 64, false, false));
        configSchema_.addColumn(new RDBMSchemaColumn("ROLETABLEID", SchemaDataType.CHAR, 64, false, false));
        configSchema_.addColumn(new RDBMSchemaColumn("PERMCTXSVC", SchemaDataType.VARCHAR, 10, false, false));
        configSchema_.addColumn(new RDBMSchemaColumn("ROLECTXSVC", SchemaDataType.VARCHAR, 10, false, false));
        configSchema_.addColumn(new RDBMSchemaColumn("LINKPERMID", SchemaDataType.VARCHAR, 255, false, false));
        permPolicySchema_.addColumn(new RDBMSchemaColumn(XMTID, SchemaDataType.VARCHAR, 255, true, true));
        permPolicySchema_.addColumn(new RDBMSchemaColumn("CONTEXTID", SchemaDataType.VARCHAR, 255, true, true));
        permPolicySchema_.addColumn(new RDBMSchemaColumn(UPDATEVERSION, SchemaDataType.VARCHAR, 255, false, false));
        permPolicySchema_.addColumn(new RDBMSchemaColumn(DELETEDVERSION, SchemaDataType.VARCHAR, 255, false, false));
        permPolicySchema_.addColumn(new RDBMSchemaColumn(ACTION, SchemaDataType.INT, false, true));
        permPolicySchema_.addColumn(new RDBMSchemaColumn("PERMTYPE", SchemaDataType.CHAR, 64, false, true));
        permPolicySchema_.addColumn(new RDBMSchemaColumn("CLASSNAME", SchemaDataType.VARCHAR, 255, false, true));
        permPolicySchema_.addColumn(new RDBMSchemaColumn("ATTR_NAME", SchemaDataType.VARCHAR, 64, true, true));
        permPolicySchema_.addColumn(new RDBMSchemaColumn("ATTR_VALUE_XMTID", SchemaDataType.VARCHAR, 255, false, false));
        permPolicySchema_.addColumn(new RDBMSchemaColumn("ATTR_VALUE_STRING", SchemaDataType.VARCHAR, 1000, false, false));
        permPolicySchema_.addColumn(new RDBMSchemaColumn("ORDER", SchemaDataType.INT, false, false));
        isConfigured_ = false;
    }
}

