/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.iauthz.storage.adapter.impl.rdbm;

import com.ibm.sec.iauthz.log.SecLogger;
import com.ibm.sec.iauthz.storage.adapter.impl.rdbm.RDBMConnection;
import com.ibm.sec.iauthz.storage.adapter.impl.rdbm.RDBMException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class RDBMConnectionPool {
    private static final String RDBMConnectionPoolDB2AdapterImpl_java_sourceCodeID = "$Id: @(#)45  1.1 src/ws/code/argus/src/com/ibm/sec/iauthz/storage/adapter/impl/rdbm/RDBMConnectionPool.java, argus.store, argus600, 051020a 05/07/29 13:05:52 @(#) $";
    private static SecLogger logger = SecLogger.getLogger(class$com$ibm$sec$iauthz$storage$adapter$impl$rdbm$RDBMConnectionPool == null ? (class$com$ibm$sec$iauthz$storage$adapter$impl$rdbm$RDBMConnectionPool = RDBMConnectionPool.class$("com.ibm.sec.iauthz.storage.adapter.impl.rdbm.RDBMConnectionPool")) : class$com$ibm$sec$iauthz$storage$adapter$impl$rdbm$RDBMConnectionPool);
    static RDBMConnectionPool thePool_ = new RDBMConnectionPool();
    private int connLimit_ = 10;
    private List connections_ = new ArrayList();
    private int overLimit_ = 5;
    private int overFlow_ = 0;
    private Properties props_;
    static /* synthetic */ Class class$com$ibm$sec$iauthz$storage$adapter$impl$rdbm$RDBMConnectionPool;

    protected RDBMConnectionPool() {
        logger.entry("RDBMConnectionPool");
        logger.exit("RDBMConnectionPool");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RDBMConnectionPool getConnectionPool(Properties properties) {
        RDBMConnectionPool rDBMConnectionPool = thePool_;
        synchronized (rDBMConnectionPool) {
            RDBMConnectionPool rDBMConnectionPool2 = thePool_;
            if (rDBMConnectionPool2.props_ == null) {
                rDBMConnectionPool2.props_ = properties;
            }
        }
        return thePool_;
    }

    public synchronized RDBMConnection getConnection() throws RDBMException {
        RDBMConnection rDBMConnection;
        logger.entry("getConnection");
        for (int i = 0; i < this.connections_.size(); ++i) {
            rDBMConnection = (RDBMConnection)this.connections_.get(i);
            if (!rDBMConnection.isAvailable()) continue;
            rDBMConnection.setAvailable(false);
            logger.exit("getConnection", rDBMConnection);
            return rDBMConnection;
        }
        if (this.overFlow_ > this.overLimit_) {
            logger.error("getConnection", "Too many connections.");
            return null;
        }
        rDBMConnection = null;
        try {
            rDBMConnection = this.newConnection(this.props_);
        }
        catch (RDBMException rDBMException) {
            String string = "Error creating new connection to database.";
            logger.error("getConnection", string, rDBMException);
            throw rDBMException;
        }
        if (this.connections_.size() > this.connLimit_) {
            rDBMConnection.setTransient(true);
        } else {
            this.connections_.add(rDBMConnection);
        }
        logger.exit("getConnection", rDBMConnection);
        return rDBMConnection;
    }

    private RDBMConnection newConnection(Properties properties) throws RDBMException {
        Connection connection;
        logger.entry("newConnection", properties);
        String string = properties.getProperty("URL");
        String string2 = properties.getProperty("USER");
        String string3 = properties.getProperty("USERPW");
        try {
            connection = DriverManager.getConnection(string, string2, string3);
        }
        catch (SQLException sQLException) {
            String string4 = "Unable to get JDBC connection to database.";
            logger.error("newConnection", string4, sQLException);
            throw new RDBMException(string4, sQLException);
        }
        RDBMConnection rDBMConnection = new RDBMConnection(connection);
        rDBMConnection.setAvailable(false);
        logger.exit("newConnection", rDBMConnection);
        return rDBMConnection;
    }

    public synchronized void returnConnection(RDBMConnection rDBMConnection) throws RDBMException {
        logger.entry("returnConnection", rDBMConnection);
        if (rDBMConnection != null) {
            if (rDBMConnection.isTransient()) {
                try {
                    rDBMConnection.close();
                }
                catch (SQLException sQLException) {
                    String string = "SQLException when returning connection to pool.";
                    logger.error("returnConnection", string, sQLException);
                    throw new RDBMException(string, sQLException);
                }
            }
            rDBMConnection.setAvailable(true);
        }
        logger.exit("returnConnection");
    }

    private void closeAll() throws RDBMException {
        logger.entry("closeAll");
        for (int i = 0; i < this.connections_.size(); ++i) {
            RDBMConnection rDBMConnection = (RDBMConnection)this.connections_.get(i);
            if (!rDBMConnection.isAvailable()) continue;
            try {
                rDBMConnection.close();
                continue;
            }
            catch (SQLException sQLException) {
                String string = "SQLException when returning connection to pool.";
                logger.error("closeAll", string, sQLException);
                throw new RDBMException(string, sQLException);
            }
        }
        logger.exit("closeAll");
    }

    public void close() {
        String string = "close()";
        logger.entry(string);
        try {
            this.closeAll();
        }
        catch (RDBMException rDBMException) {
            String string2 = "Error when closing connection pool.";
            logger.error(string, string2);
        }
        logger.exit(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

