/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.iauthz.storage.adapter.impl.rdbm;

import com.ibm.sec.iauthz.log.SecLogger;
import com.ibm.sec.iauthz.storage.adapter.TableRow;
import com.ibm.sec.iauthz.storage.adapter.impl.BasicSchema;
import com.ibm.sec.iauthz.storage.adapter.impl.SchemaDataType;
import com.ibm.sec.iauthz.storage.adapter.impl.SearchAction;
import com.ibm.sec.iauthz.storage.adapter.impl.SearchOptions;
import com.ibm.sec.iauthz.storage.adapter.impl.SearchResults;
import com.ibm.sec.iauthz.storage.adapter.impl.SearchWhere;
import com.ibm.sec.iauthz.storage.adapter.impl.TableTransaction;
import com.ibm.sec.iauthz.storage.adapter.impl.rdbm.RDBMConnection;
import com.ibm.sec.iauthz.storage.adapter.impl.rdbm.RDBMConnectionPool;
import com.ibm.sec.iauthz.storage.adapter.impl.rdbm.RDBMException;
import com.ibm.sec.iauthz.storage.adapter.impl.rdbm.RDBMTableSchema;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class RDBMTableTransaction
extends TableTransaction {
    private static final String RDBMTableTransaction_java_sourceCodeID = "$Id: @(#)50  1.2 src/ws/code/argus/src/com/ibm/sec/iauthz/storage/adapter/impl/rdbm/RDBMTableTransaction.java, argus.store, argus600, 051020a 05/08/17 15:30:00 @(#) $";
    private static SecLogger logger_ = SecLogger.getLogger(class$com$ibm$sec$iauthz$storage$adapter$impl$rdbm$RDBMTableTransaction == null ? (class$com$ibm$sec$iauthz$storage$adapter$impl$rdbm$RDBMTableTransaction = RDBMTableTransaction.class$("com.ibm.sec.iauthz.storage.adapter.impl.rdbm.RDBMTableTransaction")) : class$com$ibm$sec$iauthz$storage$adapter$impl$rdbm$RDBMTableTransaction);
    private static SecLogger sqllogger_ = SecLogger.getLogger(class$com$ibm$sec$iauthz$storage$adapter$impl$rdbm$RDBMTableTransaction == null ? (class$com$ibm$sec$iauthz$storage$adapter$impl$rdbm$RDBMTableTransaction = RDBMTableTransaction.class$("com.ibm.sec.iauthz.storage.adapter.impl.rdbm.RDBMTableTransaction")) : class$com$ibm$sec$iauthz$storage$adapter$impl$rdbm$RDBMTableTransaction, (class$com$ibm$sec$iauthz$storage$adapter$impl$rdbm$RDBMTableTransaction == null ? (class$com$ibm$sec$iauthz$storage$adapter$impl$rdbm$RDBMTableTransaction = RDBMTableTransaction.class$("com.ibm.sec.iauthz.storage.adapter.impl.rdbm.RDBMTableTransaction")) : class$com$ibm$sec$iauthz$storage$adapter$impl$rdbm$RDBMTableTransaction).getName() + ".sql");
    private static final String SQL_SELECT_ALL = "SELECT * FROM ";
    private static final String SQL_DELETE_FROM = "DELETE FROM ";
    private RDBMConnection _conn = null;
    private RDBMConnectionPool _connectionPool = null;
    private boolean useTemporaryTable_ = false;
    private String temporaryTableName_ = null;
    private Set _openStatements = new HashSet();
    private boolean doStub_ = false;
    static /* synthetic */ Class class$com$ibm$sec$iauthz$storage$adapter$impl$rdbm$RDBMTableTransaction;

    public RDBMTableTransaction(Properties properties) {
        super(properties);
        String string = "RDBMTableTransaction( Properties )";
        logger_.entry(string, properties);
        this._connectionPool = RDBMConnectionPool.getConnectionPool(properties);
        logger_.exit(string);
    }

    public RDBMConnection getConnection() {
        return this._conn;
    }

    public String getTemporaryTableName() {
        return this.temporaryTableName_;
    }

    private void setTemporaryTableName(String string) {
        this.temporaryTableName_ = string;
    }

    private boolean getUseTemporaryTable() {
        return this.useTemporaryTable_;
    }

    public void setUseTemporaryTable(boolean bl) {
        this.useTemporaryTable_ = bl;
    }

    public void createTable(String string, BasicSchema basicSchema) throws RDBMException {
        String string2 = "createTable( String, BasicSchema )";
        logger_.entry(string2, new Object[]{string, basicSchema});
        if (!this.existsTable(string)) {
            String string3 = RDBMTableSchema.generateSQLCreateTableCommand(string, basicSchema);
            logger_.debug(string2, "Creating table '" + string + "' using SQL command: " + string3);
            this.executeSQLUpdate(string3);
        } else {
            logger_.debug(string2, "Table '" + string + "' already exists in database.");
        }
        logger_.exit(string2);
    }

    private String createTemporaryTable(String string) throws RDBMException {
        String string2 = "createTemporaryTable";
        logger_.entry(string2);
        String string3 = "SESSION.TMP" + string;
        StringBuffer stringBuffer = new StringBuffer("DECLARE GLOBAL TEMPORARY TABLE ");
        stringBuffer.append(string3);
        stringBuffer.append(" LIKE ");
        stringBuffer.append(string);
        stringBuffer.append(" ON COMMIT PRESERVE ROWS ");
        this.executeSQLUpdate(stringBuffer.toString());
        logger_.exit(string2);
        return string3;
    }

    public void deleteTable(String string) throws RDBMException {
        String string2 = "deleteTable( String )";
        logger_.entry(string2, string);
        String string3 = "DROP TABLE " + string;
        this.executeSQLUpdate(string3);
        logger_.exit(string2);
    }

    public void endTransaction() throws RDBMException {
        String string = "endTransaction()";
        logger_.entry(string);
        try {
            this._conn.commit();
            this._conn.setAutoCommit(true);
        }
        catch (SQLException sQLException) {
            String string2 = "Error when committing transactions.";
            logger_.error(string, string2, sQLException);
            throw new RDBMException(string2, sQLException);
        }
        this.closeOpenStatements();
        this._connectionPool.returnConnection(this._conn);
        this._conn = null;
        this.setTemporaryTableName(null);
        this.setUseTemporaryTable(false);
        logger_.exit(string);
    }

    private void closeOpenStatements() throws RDBMException {
        try {
            Iterator iterator = this._openStatements.iterator();
            while (iterator.hasNext()) {
                Statement statement = (Statement)iterator.next();
                statement.close();
            }
            this._openStatements.clear();
        }
        catch (SQLException sQLException) {
            String string = "Error when closing all opened statements.";
            throw new RDBMException(string, sQLException);
        }
    }

    public ResultSet executeSQLQuery(String string) throws RDBMException {
        String string2 = "executeSQL( String )";
        logger_.entry(string2, string);
        ResultSet resultSet = null;
        if (this._conn != null) {
            try {
                Statement statement = this._conn.createStatement();
                sqllogger_.debug(string2, string);
                resultSet = statement.executeQuery(string);
                this._openStatements.add(statement);
            }
            catch (SQLException sQLException) {
                String string3 = "Exception when attempting to execute SQL.";
                logger_.error(string2, string3, sQLException);
                throw new RDBMException(string3, sQLException);
            }
        } else {
            String string4 = "Couldn't execute statement. Make sure startTransaction() has been called.";
            logger_.error(string2, string4);
            throw new RDBMException(string4);
        }
        logger_.exit(string2, resultSet);
        return resultSet;
    }

    public int executeSQLUpdate(String string) throws RDBMException {
        String string2 = "executeSQL( String )";
        logger_.entry(string2, string);
        int n = 0;
        if (this._conn != null) {
            try {
                Statement statement = this._conn.createStatement();
                logger_.debug(string2, "Executing SQL ");
                logger_.debug(string2, string);
                if (this.doStub_) {
                    System.out.println("Executing [" + string + "]");
                } else {
                    sqllogger_.debug(string2, string);
                    n = statement.executeUpdate(string);
                }
                statement.close();
            }
            catch (SQLException sQLException) {
                String string3 = "Exception when attempting to execute SQL. [" + string + "]";
                logger_.error(string2, string3, sQLException);
                throw new RDBMException(string3, sQLException);
            }
        } else {
            String string4 = "Couldn't execute statement. Make sure startTransaction() has been called.";
            logger_.error(string2, string4);
            throw new RDBMException(string4);
        }
        logger_.exit(string2, new Integer(n));
        return n;
    }

    public boolean existsTable(String string) {
        String string2 = "existsTable( String )";
        logger_.entry(string2, string);
        boolean bl = false;
        if (this._conn != null) {
            try {
                ResultSet resultSet = this._conn.getMetaData().getTables(null, null, string, null);
                if (resultSet.next()) {
                    bl = true;
                }
                resultSet.close();
            }
            catch (SQLException sQLException) {
                String string3 = "Exception when checking table existence.";
                logger_.error(string2, string3, sQLException);
                bl = false;
            }
        } else {
            String string4 = "Couldn't check for table existence. Make sure startTransaction() has been called.";
            logger_.error(string2, string4);
        }
        logger_.exit(string2, bl);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void dumpRS(ResultSet resultSet) {
        block13: {
            logger_.entry("dumpRS");
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            int n2 = 0;
            while (resultSet.next()) {
                System.out.print("Row: " + ++n2 + ": ");
                for (int i = 1; i <= n; ++i) {
                    System.out.print(resultSet.getString(i));
                    if (i == n) continue;
                    System.out.print(" , ");
                }
                System.out.println("");
            }
            Object var8_7 = null;
            try {
                if (resultSet.getType() != 1003) {
                    resultSet.first();
                }
                break block13;
            }
            catch (SQLException sQLException) {
                logger_.error("dumpRS", sQLException.getLocalizedMessage());
            }
            break block13;
            {
                catch (SQLException sQLException) {
                    logger_.error("dumpRS", sQLException.getLocalizedMessage());
                    sQLException.printStackTrace();
                    Object var8_8 = null;
                    try {
                        if (resultSet.getType() != 1003) {
                            resultSet.first();
                        }
                        break block13;
                    }
                    catch (SQLException sQLException2) {
                        logger_.error("dumpRS", sQLException2.getLocalizedMessage());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                try {
                    if (resultSet.getType() != 1003) {
                        resultSet.first();
                    }
                }
                catch (SQLException sQLException) {
                    logger_.error("dumpRS", sQLException.getLocalizedMessage());
                }
                throw throwable;
            }
        }
        logger_.exit("dumpRS");
    }

    public void insertRow(String string, TableRow tableRow) throws RDBMException {
        String string2 = "insertData( String, TableRow )";
        logger_.entry(string2, new Object[]{string, tableRow});
        StringBuffer stringBuffer = new StringBuffer("INSERT INTO ");
        stringBuffer.append(string);
        stringBuffer.append(" VALUES (");
        int n = tableRow.getColumnCount();
        for (int i = 0; i < n; ++i) {
            Object object = tableRow.getColumn(i);
            if (object != null) {
                if (object instanceof String || object instanceof Timestamp) {
                    stringBuffer.append(" '");
                    stringBuffer.append(object.toString());
                    stringBuffer.append("'");
                } else {
                    stringBuffer.append(object.toString());
                }
            } else {
                stringBuffer.append(" NULL");
            }
            if (i >= n - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(")");
        this.executeSQLUpdate(stringBuffer.toString());
        logger_.exit(string2);
    }

    public void insertPolicyRows(String object, Collection collection, String string) throws RDBMException {
        Object object2;
        String string2 = "insertPolicyRows( String, collection )";
        logger_.entry(string2);
        if (this.getUseTemporaryTable()) {
            object2 = this.getTemporaryTableName();
            if (object2 == null) {
                object2 = this.createTemporaryTable((String)object);
                this.setTemporaryTableName((String)object2);
            }
            object = object2;
        }
        object2 = collection.iterator();
        boolean bl = false;
        while (!bl) {
            int n = 0;
            StringBuffer stringBuffer = new StringBuffer("INSERT INTO ");
            stringBuffer.append((String)object);
            stringBuffer.append(" VALUES ");
            while (object2.hasNext()) {
                TableRow tableRow = (TableRow)object2.next();
                tableRow.setColumn(1, string);
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append("( ");
                StringBuffer stringBuffer3 = tableRow.getValues(",");
                stringBuffer2.append(stringBuffer3);
                stringBuffer2.append(")");
                if (n != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(stringBuffer2);
                if (++n <= 2) continue;
            }
            if (n > 0) {
                this.executeSQLUpdate(stringBuffer.toString());
                stringBuffer = null;
            }
            if (object2.hasNext()) continue;
            bl = true;
        }
        logger_.exit(string2);
    }

    public void rollbackTransaction() throws RDBMException {
        String string = "rollbackTransaction()";
        logger_.entry(string);
        try {
            this._conn.rollback();
        }
        catch (SQLException sQLException) {
            String string2 = "Error rolling back uncommitted updates.";
            logger_.error(string, string2, sQLException);
            throw new RDBMException(string2, sQLException);
        }
        this.closeOpenStatements();
        this._connectionPool.returnConnection(this._conn);
        this._conn = null;
        logger_.exit(string);
    }

    public void startTransaction() throws RDBMException {
        String string = "startTransaction()";
        logger_.entry(string);
        if (this._conn == null) {
            this._conn = this._connectionPool.getConnection();
        }
        try {
            this._conn.setAutoCommit(false);
        }
        catch (SQLException sQLException) {
            String string2 = "Error initialising transaction.";
            logger_.error(string, string2, sQLException);
            throw new RDBMException(string2, sQLException);
        }
        logger_.exit(string);
    }

    public SearchResults searchTable(String string, RDBMTableSchema rDBMTableSchema, SearchOptions searchOptions, SearchAction searchAction) throws RDBMException {
        int n;
        logger_.entry("searchTable");
        SearchResults searchResults = null;
        String string2 = SQL_SELECT_ALL + string;
        String string3 = "";
        if (searchOptions != null && searchOptions.WHERE != null) {
            string3 = searchOptions.WHERE.generateSQLWhere(rDBMTableSchema, null, null);
            string2 = string2 + " ";
            string2 = string2 + string3;
        }
        if (searchAction == null) {
            searchAction = new SearchAction();
            searchAction.setCollect(true);
        }
        if (searchAction != null) {
            searchAction.preAction();
        }
        ResultSet resultSet = null;
        try {
            resultSet = this.executeSQLQuery(string2);
            n = resultSet.getMetaData().getColumnCount();
        }
        catch (RDBMException rDBMException) {
            String string4 = "Error executing table search query.";
            logger_.error("searchTable", string4, rDBMException);
            throw new RDBMException(string4, rDBMException);
        }
        catch (SQLException sQLException) {
            String string5 = "Error retrieving number of columns in query result.";
            logger_.error("searchTable", string5, sQLException);
            throw new RDBMException(string5, sQLException);
        }
        if (resultSet != null) {
            try {
                while (resultSet.next()) {
                    TableRow tableRow = new TableRow();
                    for (int i = 0; i < n; ++i) {
                        SchemaDataType schemaDataType = rDBMTableSchema.getColumn(i).getType();
                        Object object = null;
                        if (schemaDataType == SchemaDataType.VARCHAR || schemaDataType == SchemaDataType.CHAR) {
                            object = resultSet.getString(i + 1);
                        } else if (schemaDataType == SchemaDataType.INT) {
                            object = new Long(resultSet.getInt(i + 1));
                        } else {
                            logger_.error("searchTable", "Don't know what to do with this col type " + rDBMTableSchema.getColumn(i));
                            object = null;
                        }
                        tableRow.setColumn(i, object);
                    }
                    if (searchAction == null) continue;
                    searchAction.doAction(tableRow);
                }
                if (searchAction != null) {
                    searchAction.postAction();
                    searchResults = searchAction.getResults();
                }
            }
            catch (SQLException sQLException) {
                String string6 = "Error parsing query results into TableRow objects.";
                logger_.error("searchTable", string6, sQLException);
                throw new RDBMException(string6, sQLException);
            }
        }
        logger_.exit("searchTable");
        return searchResults;
    }

    public int deleteFromTable(String string, RDBMTableSchema rDBMTableSchema, SearchOptions searchOptions) throws RDBMException {
        String string2 = "deleteFromTable( String, RDBMTableSchema, SearchOptions )";
        logger_.entry(string2, new Object[]{string, rDBMTableSchema, searchOptions});
        int n = 0;
        String string3 = SQL_DELETE_FROM + string;
        if (searchOptions != null && searchOptions.WHERE != null) {
            String string4 = searchOptions.WHERE.generateSQLWhere(rDBMTableSchema, null, null);
            string3 = string3 + " ";
            string3 = string3 + string4;
        }
        try {
            n = this.executeSQLUpdate(string3);
        }
        catch (RDBMException rDBMException) {
            String string5 = "Error executing delete command on database.";
            logger_.error(string2, string5, rDBMException);
            throw new RDBMException(string5, rDBMException);
        }
        logger_.exit(string2, new Integer(n));
        return n;
    }

    public int updateTable(String string, RDBMTableSchema rDBMTableSchema, TableRow tableRow, SearchOptions searchOptions) throws RDBMException {
        String string2 = "updateTable( String, RDBMTableSchema, SearchOptions, SearchOptions )";
        logger_.entry(string2);
        int n = 0;
        String string3 = "UPDATE " + string;
        if (tableRow == null) {
            String string4 = "Must specify values to add to table.";
            logger_.error(string2, string4);
            throw new RDBMException(string4);
        }
        String string5 = SearchWhere.doGenerateSQLSet(rDBMTableSchema, tableRow, tableRow.getIndexes());
        string3 = string3 + " ";
        string3 = string3 + string5;
        if (searchOptions == null || searchOptions.WHERE == null) {
            string5 = "Must specify values to specify which rows to replace.";
            logger_.error(string2, string5);
            throw new RDBMException(string5);
        }
        string5 = searchOptions.WHERE.generateSQLWhere(rDBMTableSchema, null, null);
        string3 = string3 + " ";
        string3 = string3 + string5;
        try {
            n = this.executeSQLUpdate(string3);
        }
        catch (RDBMException rDBMException) {
            String string6 = "Error executing update statement on database.";
            logger_.error(string2, string6, rDBMException);
            throw new RDBMException(string6, rDBMException);
        }
        logger_.exit(string2, new Integer(n));
        return n;
    }

    public void createPolicyView(String string, String string2, String string3, RDBMTableSchema rDBMTableSchema) throws RDBMException {
        String string4 = "createPolicyView";
        logger_.entry(string4);
        logger_.entry(string4, new Object[]{string, string2, string3, rDBMTableSchema});
        if (!this.existsTable(string)) {
            String string5 = RDBMTableSchema.generateSQLCreateViewCommand(string, string2, string3, rDBMTableSchema);
            logger_.debug(string4, "Creating view '" + string + "' using SQL command: " + string5);
            this.executeSQLUpdate(string5);
        } else {
            logger_.debug(string4, "View '" + string + "' already exists in database.");
        }
        logger_.exit(string4);
    }

    /*
     * Unable to fully structure code
     */
    public void executeSQLStatement(String var1_1, Object[] var2_2) throws RDBMException {
        block15: {
            RDBMTableTransaction.logger_.entry("executeSQLStatement");
            if (this._conn != null) {
                var4_3 = var1_1;
                var5_5 = null;
                try {
                    block14: {
                        var5_5 = this._conn.prepareStatement(var1_1);
                        if (var2_2 != null) {
                            for (var6_6 = 0; var6_6 < var2_2.length; ++var6_6) {
                                var5_5.setObject(var6_6 + 1, var2_2[var6_6]);
                            }
                        }
                        var4_3 = var5_5.toString();
                        RDBMTableTransaction.logger_.debug("executeSQLStatement", "Executing SQL ");
                        RDBMTableTransaction.logger_.debug("executeSQLStatement", var4_3);
                        if (this.doStub_) {
                            System.out.println("Executing [" + var4_3 + "]");
                            break block14;
                        }
                        RDBMTableTransaction.sqllogger_.debug("executeSQLStatement", var4_3);
                        var6_6 = (int)var5_5.execute();
                        RDBMTableTransaction.logger_.debug("executeSQLStatement", "Execute rc=" + (boolean)var6_6);
                    }
                    var9_9 = null;
                    ** if (var5_5 == null) goto lbl-1000
                }
                catch (Throwable var8_15) {
                    var9_10 = null;
                    if (var5_5 != null) {
                        try {
                            var5_5.close();
                        }
                        catch (SQLException var10_12) {
                            RDBMTableTransaction.logger_.error("executeSQLStatement", var10_12.getLocalizedMessage());
                        }
                    }
                    throw var8_15;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        var5_5.close();
                    }
                    catch (SQLException var10_11) {
                        RDBMTableTransaction.logger_.error("executeSQLStatement", var10_11.getLocalizedMessage());
                    }
                }
lbl-1000:
                // 2 sources

                {
                    break block15;
                    catch (SQLException var6_7) {
                        var7_13 = "Exception when attempting to execute SQL. [" + var4_3 + "]";
                        RDBMTableTransaction.logger_.error("executeSQLStatement", var7_13, var6_7);
                        throw new RDBMException(var7_13, var6_7);
                    }
                    catch (Exception var6_8) {
                        var7_14 = "Exception when attempting to execute SQL. [" + var4_3 + "]";
                        RDBMTableTransaction.logger_.error("executeSQLStatement", var7_14, var6_8);
                        throw new RDBMException(var7_14, var6_8);
                    }
                }
            }
            var4_4 = "Couldn't execute statement. Make sure startTransaction() has been called.";
            RDBMTableTransaction.logger_.error("executeSQLStatement", var4_4);
            throw new RDBMException(var4_4);
        }
        RDBMTableTransaction.logger_.exit("executeSQLStatement");
    }

    /*
     * Unable to fully structure code
     */
    public ResultSet executeSQLQuery(String var1_1, String[] var2_2) throws RDBMException {
        block13: {
            RDBMTableTransaction.logger_.entry("executeSQLQuery");
            var4_3 = null;
            if (this._conn != null) {
                var5_4 = var1_1;
                var6_6 = null;
                try {
                    block12: {
                        var6_6 = this._conn.prepareStatement(var1_1);
                        for (var7_7 = 0; var7_7 < var2_2.length; ++var7_7) {
                            var6_6.setString(var7_7 + 1, var2_2[var7_7]);
                        }
                        var5_4 = var1_1;
                        RDBMTableTransaction.logger_.debug("executeSQLQuery", "Executing SQL ");
                        RDBMTableTransaction.logger_.debug("executeSQLQuery", var5_4);
                        if (this.doStub_) {
                            System.out.println("Executing [" + var5_4 + "]");
                            break block12;
                        }
                        RDBMTableTransaction.sqllogger_.debug("executeSQLQuery", var5_4);
                        var4_3 = var6_6.executeQuery();
                        RDBMTableTransaction.logger_.debug("executeSQLQuery", "Execute rc=" + var4_3.getWarnings());
                    }
                    var10_9 = null;
                    ** if (var6_6 == null) goto lbl-1000
                }
                catch (Throwable var9_14) {
                    var10_10 = null;
                    if (var6_6 != null) {
                        try {
                            var6_6.close();
                        }
                        catch (SQLException var11_12) {
                            RDBMTableTransaction.logger_.error("executeSQLQuery", var11_12.getLocalizedMessage());
                        }
                    }
                    throw var9_14;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        var6_6.close();
                    }
                    catch (SQLException var11_11) {
                        RDBMTableTransaction.logger_.error("executeSQLQuery", var11_11.getLocalizedMessage());
                    }
                }
lbl-1000:
                // 2 sources

                {
                    break block13;
                    catch (SQLException var7_8) {
                        var8_13 = "Exception when attempting to execute SQL. [" + var5_4 + "]";
                        RDBMTableTransaction.logger_.error("executeSQLQuery", var8_13, var7_8);
                        throw new RDBMException(var8_13, var7_8);
                    }
                }
            }
            var5_5 = "Couldn't execute statement. Make sure startTransaction() has been called.";
            RDBMTableTransaction.logger_.error("executeSQLQuery", var5_5);
            throw new RDBMException(var5_5);
        }
        RDBMTableTransaction.logger_.exit("executeSQLQuery");
        return var4_3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

