/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.iauthz.util;

import com.ibm.sec.iauthz.log.SecLogger;
import com.ibm.sec.iauthz.util.CWRGSMessageHelper;
import java.security.SecurityPermission;

public class CommonAuthzUtilities {
    public static void checkSecurityPermission(String string, SecLogger secLogger, SecurityManager securityManager) throws SecurityException {
        try {
            if (securityManager != null) {
                securityManager.checkPermission(new SecurityPermission("setPolicy"));
            }
        }
        catch (SecurityException securityException) {
            String string2 = CWRGSMessageHelper.getMessage("ERROR_DURING_SECURITY_CHECK", new Object[]{securityException.toString()});
            secLogger.warning(string, string2);
            throw securityException;
        }
    }

    public static void checkForInvalidState(String string, SecLogger secLogger, short s, short s2) throws RuntimeException {
        if (s == s2) {
            String string2 = CWRGSMessageHelper.getMessage("INFO_INVALID_STATE", new Object[]{string});
            secLogger.error(string, string2);
            throw new UnsupportedOperationException(string2);
        }
    }

    public static void checkForValidState(String string, SecLogger secLogger, short s, short s2) throws RuntimeException {
        if (s != s2) {
            String string2 = CWRGSMessageHelper.getMessage("INFO_INVALID_STATE", new Object[]{string});
            secLogger.error(string, string2);
            throw new UnsupportedOperationException(string2);
        }
    }
}

