/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.iauthz.util;

import com.ibm.sec.iauthz.util.RWLockException;
import java.util.ArrayList;

public class RWLock {
    private static final String RWLock_java_sourceCodeID = "$Id: @(#)39  1.3 src/ws/code/argus/src/com/ibm/sec/iauthz/util/RWLock.java, argus.oracle, argus600, 051020a 05/08/31 19:21:01 @(#) $";
    static final int READER_LOCK = 1;
    static final int WRITER_LOCK = 2;
    private ParticipantList _list = new ParticipantList();
    private Participant _writer;

    public synchronized boolean getReaderLock() throws RWLockException {
        boolean bl = false;
        Thread thread = Thread.currentThread();
        int n = this._list.getCurrentThreadIndex(thread);
        Participant participant = null;
        if (n == -1) {
            participant = new Participant(1, thread);
            this._list.add(participant);
            n = this._list.size() - 1;
            if (participant != null && n != -1) {
                boolean bl2 = true;
                while (bl2) {
                    int n2 = this._list.getWriterIndex();
                    if (n2 == -1 || n2 > n) {
                        ++participant.numLocks;
                        bl2 = false;
                        bl = true;
                        continue;
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        this._list.remove(n);
                        bl2 = false;
                    }
                    if (!bl2) continue;
                    n = this._list.getCurrentThreadIndex(thread);
                }
            }
        } else {
            participant = (Participant)this._list.get(n);
            ++participant.numLocks;
        }
        return bl;
    }

    public synchronized boolean getWriterLock() throws RWLockException {
        boolean bl = false;
        Thread thread = Thread.currentThread();
        int n = this._list.getCurrentThreadIndex(thread);
        Participant participant = null;
        if (n == -1) {
            participant = new Participant(2, thread);
            this._list.add(participant);
            n = this._list.size() - 1;
            if (participant != null && n != -1) {
                boolean bl2 = true;
                while (bl2) {
                    if (n != 0) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            this._list.remove(n);
                            bl2 = false;
                        }
                        if (!bl2) continue;
                        n = this._list.getCurrentThreadIndex(thread);
                        continue;
                    }
                    bl2 = false;
                    bl = true;
                    this._writer = participant;
                    ++participant.numLocks;
                }
            }
        } else {
            participant = (Participant)this._list.get(n);
            if (participant.lockType == 1) {
                throw new RWLockException("RWLock::getWriterLock -- Lock upgrades are not supported");
            }
            ++participant.numLocks;
        }
        return bl;
    }

    public synchronized boolean lock(boolean bl) {
        boolean bl2 = false;
        bl2 = bl ? this.getWriterLock() : this.getReaderLock();
        return bl2;
    }

    public synchronized boolean releaseLock() throws RWLockException {
        boolean bl = false;
        Thread thread = Thread.currentThread();
        int n = this._list.getCurrentThreadIndex(thread);
        Participant participant = null;
        if (n > -1) {
            participant = (Participant)this._list.get(n);
        }
        if (participant != null) {
            bl = true;
            this._writer = null;
            --participant.numLocks;
            if (participant.numLocks == 0) {
                this._list.remove(n);
                this.notifyAll();
            }
        } else {
            throw new RWLockException("RWLock::releaseLock -- Lock not held");
        }
        return bl;
    }

    public synchronized boolean isWriter() {
        if (this._writer == null) {
            return false;
        }
        return this._writer.threadID.equals(Thread.currentThread());
    }

    private class ParticipantList
    extends ArrayList {
        public int getCurrentThreadIndex(Thread thread) {
            int n = -1;
            for (int i = 0; i < this.size(); ++i) {
                Participant participant = (Participant)this.get(i);
                if (participant.threadID != thread) continue;
                n = i;
                break;
            }
            return n;
        }

        public int getWriterIndex() {
            int n = -1;
            for (int i = 0; i < this.size(); ++i) {
                Participant participant = (Participant)this.get(i);
                if (participant.lockType != 2) continue;
                n = i;
                break;
            }
            return n;
        }
    }

    private class Participant {
        int numLocks;
        int lockType;
        Thread threadID;

        public boolean equals(Object object) {
            boolean bl = false;
            Participant participant = (Participant)object;
            if (participant.threadID == this.threadID) {
                bl = true;
            }
            return bl;
        }

        public Participant(int n, Thread thread) {
            this.lockType = n;
            this.numLocks = 0;
            this.threadID = thread;
        }
    }
}

