/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.iauthz.util;

import com.ibm.sec.iauthz.log.SecLogger;
import com.ibm.sec.iauthz.mcc.dna.XMTObject;
import com.ibm.sec.iauthz.storage.PagedResultSet;
import com.ibm.sec.iauthz.storage.PolicySet;
import com.ibm.sec.iauthz.storage.PolicyStoreException;
import com.ibm.sec.iauthz.storage.StoreRecordQuery;
import com.ibm.sec.iauthz.util.CWRGSMessageHelper;
import com.ibm.sec.iauthz.util.CollectionFactory;
import com.ibm.sec.iauthz.util.CommonAuthProperties;
import com.ibm.sec.iauthz.util.RWLock;
import com.ibm.sec.iauthz.util.RWLockException;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

public class StorageBuffer {
    public static final String PROPERTY_BUFFER_ENABLED = "com.ibm.sec.iauthz.util.StorageBuffer.bufferEnabled";
    public static final String PROPERTY_MAX_BUFFER_SIZE = "com.ibm.sec.iauthz.util.StorageBuffer.maxBufferSize";
    public static final String PROPERTY_MAX_BUFFER_PERIOD = "com.ibm.sec.iauthz.util.StorageBuffer.maxBufferPeriod";
    private static SecLogger _logger = SecLogger.getLogger(class$com$ibm$sec$iauthz$util$StorageBuffer == null ? (class$com$ibm$sec$iauthz$util$StorageBuffer = StorageBuffer.class$("com.ibm.sec.iauthz.util.StorageBuffer")) : class$com$ibm$sec$iauthz$util$StorageBuffer);
    boolean _bufferEnabled = false;
    int _maxBufferSize = 0;
    List _buffer = null;
    PolicySet _storage = null;
    RWLock _lock = null;
    StorageBufferCleanupTask _cleanTask = null;
    Timer _cleanupScheduler = null;
    float _bufferPeriod = 0.0f;
    private long _lastModified = 0L;
    private boolean _hasModifications = false;
    private boolean _remove = false;
    static /* synthetic */ Class class$com$ibm$sec$iauthz$util$StorageBuffer;

    public StorageBuffer(PolicySet policySet) throws PolicyStoreException {
        String string;
        String string2 = "StorageBuffer( PolicySet )";
        _logger.entry(string2, policySet);
        Properties properties = CommonAuthProperties.getProps();
        if (properties != null) {
            String string3;
            this._bufferEnabled = Boolean.valueOf(properties.getProperty(PROPERTY_BUFFER_ENABLED, "false"));
            try {
                this._maxBufferSize = Integer.parseInt(properties.getProperty(PROPERTY_MAX_BUFFER_SIZE, "10"));
                if (this._maxBufferSize < 0) {
                    string = CWRGSMessageHelper.getMessage("ERROR_INVALID_STORAGE_BUFFER_SIZE", new Object[]{new Integer(this._maxBufferSize)});
                    _logger.error(string2, string);
                    this._maxBufferSize = 10;
                }
            }
            catch (NumberFormatException numberFormatException) {
                string3 = CWRGSMessageHelper.getMessage("ERROR_INVALID_STORAGE_BUFFER_SIZE", new Object[]{properties.getProperty(PROPERTY_MAX_BUFFER_SIZE)});
                _logger.error(string2, string3);
                this._maxBufferSize = 10;
            }
            try {
                this._bufferPeriod = Float.parseFloat(properties.getProperty(PROPERTY_MAX_BUFFER_PERIOD, "1"));
                if (this._bufferPeriod < 0.001f) {
                    string = CWRGSMessageHelper.getMessage("ERROR_INVALID_STORAGE_BUFFER_PERIOD", new Object[]{new Float(this._bufferPeriod)});
                    _logger.error(string2, string);
                    this._bufferPeriod = 1.0f;
                }
            }
            catch (NumberFormatException numberFormatException) {
                string3 = CWRGSMessageHelper.getMessage("ERROR_INVALID_STORAGE_BUFFER_PERIOD", new Object[]{properties.getProperty(PROPERTY_MAX_BUFFER_PERIOD)});
                _logger.error(string2, string3);
                this._bufferPeriod = 1.0f;
            }
        } else {
            _logger.debug(string2, "Couldn't load properties file, using default values.");
            this._bufferEnabled = false;
            this._maxBufferSize = 0;
            this._bufferPeriod = 1.0f;
        }
        if (policySet == null) {
            string = "";
            _logger.error(string2, string);
            throw new PolicyStoreException(string);
        }
        this._storage = policySet;
        if (this._bufferEnabled) {
            _logger.debug(string2, "Buffering is enabled; Max size is " + this._maxBufferSize + " and max period is " + this._bufferPeriod + " seconds.");
            this._buffer = CollectionFactory.newList(this._maxBufferSize);
            this._cleanupScheduler = new Timer(true);
            this._cleanTask = new StorageBufferCleanupTask(this);
            this._cleanupScheduler.schedule((TimerTask)this._cleanTask, (long)(this._bufferPeriod * 1000.0f), (long)(this._bufferPeriod * 1000.0f));
            this._lock = new RWLock();
        } else {
            _logger.debug(string2, "Buffering is disabled.");
        }
        _logger.exit(string2);
    }

    public void updatePolicy(XMTObject xMTObject) {
        String string = "updatePolicy( XMTObject )";
        _logger.entry(string, xMTObject);
        this.updatePolicy(xMTObject, true);
        _logger.exit(string);
    }

    public void setRemove(boolean bl) {
        this._remove = bl;
    }

    public void removePolicy(XMTObject xMTObject) {
        String string = "removePolicy( XMTObject )";
        _logger.exit(string, xMTObject);
        this.updatePolicy(xMTObject, false);
        _logger.exit(string);
    }

    public PagedResultSet getPolicy(StoreRecordQuery storeRecordQuery) {
        String string = "getPolicy( StoreRecordQuery )";
        _logger.entry(string, storeRecordQuery);
        PagedResultSet pagedResultSet = null;
        try {
            pagedResultSet = this._storage.getFullPolicy(storeRecordQuery, this._remove);
        }
        catch (PolicyStoreException policyStoreException) {
            String string2 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_BUFFER_EXCEPTION", new Object[]{policyStoreException.getMessage()});
            _logger.error(string, string2, policyStoreException);
        }
        _logger.exit(string, pagedResultSet);
        return pagedResultSet;
    }

    public void removeAllPolicy() {
        String string = "removeAllPolicy()";
        _logger.entry(string);
        try {
            this._storage.destroyPolicy();
        }
        catch (PolicyStoreException policyStoreException) {
            String string2 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_BUFFER_EXCEPTION", new Object[]{policyStoreException.getMessage()});
            _logger.error(string, string2, policyStoreException);
        }
        _logger.exit(string);
    }

    public void commit() {
        Object object;
        String string = "commit()";
        _logger.entry(string);
        if (this._bufferEnabled) {
            _logger.debug(string, "Writing all buffered policy to storage.");
            try {
                boolean bl = this._lock.getWriterLock();
                if (bl) {
                    if (this._buffer.size() > 0) {
                        object = this._buffer.iterator();
                        while (object.hasNext()) {
                            BufferedObject bufferedObject = (BufferedObject)object.next();
                            this.writePolicy(bufferedObject.getObject(), bufferedObject.getAdd());
                        }
                        this._buffer.clear();
                        this._hasModifications = false;
                    }
                } else {
                    object = CWRGSMessageHelper.getMessage("ERROR_STORAGE_BUFFER_LOCK_PROBLEM");
                    _logger.error(string, (String)object);
                }
                this._lock.releaseLock();
            }
            catch (RWLockException rWLockException) {
                object = CWRGSMessageHelper.getMessage("ERROR_STORAGE_BUFFER_LOCK_PROBLEM");
                _logger.error(string, (String)object);
            }
        } else {
            _logger.debug(string, "Buffering is disabled, no policy to write to storage.");
        }
        _logger.debug(string, "Committing policy.");
        try {
            this._storage.save(this._remove);
            this.setRemove(false);
        }
        catch (PolicyStoreException policyStoreException) {
            object = CWRGSMessageHelper.getMessage("ERROR_STORAGE_BUFFER_EXCEPTION", new Object[]{policyStoreException.getMessage()});
            _logger.error(string, (String)object, policyStoreException);
        }
        _logger.exit(string);
    }

    private void updatePolicy(XMTObject xMTObject, boolean bl) {
        String string = "updatePolicy( XMTObject, boolean )";
        _logger.entry(string, new Object[]{xMTObject, bl});
        if (this._bufferEnabled) {
            this.bufferPolicy(xMTObject, bl);
        } else {
            this.writePolicy(xMTObject, bl);
        }
        _logger.exit(string);
    }

    private void bufferPolicy(XMTObject xMTObject, boolean bl) {
        String string = "bufferPolicy(XMTObject, boolean)";
        _logger.entry(string, new Object[]{xMTObject, bl});
        int n = 0;
        try {
            boolean bl2 = this._lock.getWriterLock();
            if (bl2) {
                this._buffer.add(new BufferedObject(xMTObject, bl));
                this._hasModifications = true;
                Date date = new Date();
                this._lastModified = date.getTime();
                n = this._buffer.size();
            } else {
                String string2 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_BUFFER_LOCK_PROBLEM");
                _logger.error(string, string2);
            }
            this._lock.releaseLock();
        }
        catch (RWLockException rWLockException) {
            String string3 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_BUFFER_LOCK_PROBLEM");
            _logger.error(string, string3, rWLockException);
        }
        if (n == this._maxBufferSize) {
            _logger.debug(string, "Buffer has reached maximum size.");
            this.commit();
        }
        _logger.exit(string);
    }

    private void writePolicy(XMTObject xMTObject, boolean bl) {
        String string = "writePolicy( XMTObject )";
        _logger.entry(string, xMTObject);
        Set set = CollectionFactory.newSet();
        set.add(xMTObject);
        try {
            this._storage.updatePolicy(set, bl);
        }
        catch (PolicyStoreException policyStoreException) {
            String string2 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_BUFFER_EXCEPTION", new Object[]{policyStoreException.getMessage()});
            _logger.error(string, string2, policyStoreException);
        }
        _logger.exit(string);
    }

    private void checkForTimedCommit() {
        String string = "checkForTimedCommit()";
        _logger.entry(string);
        boolean bl = false;
        try {
            boolean bl2 = this._lock.getReaderLock();
            if (bl2) {
                Date date;
                long l;
                if (this._hasModifications && (float)(l = (date = new Date()).getTime() - this._lastModified) >= this._bufferPeriod * 1000.0f) {
                    bl = true;
                }
            } else {
                String string2 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_BUFFER_LOCK_PROBLEM");
                _logger.error(string, string2);
            }
            this._lock.releaseLock();
        }
        catch (RWLockException rWLockException) {
            String string3 = CWRGSMessageHelper.getMessage("ERROR_STORAGE_BUFFER_LOCK_PROBLEM");
            _logger.error(string, string3, rWLockException);
        }
        if (bl) {
            _logger.debug(string, "Maximum buffering period has elapsed.");
            this.commit();
        }
        _logger.exit(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class BufferedObject {
        private XMTObject _object;
        private boolean _add;

        public BufferedObject(XMTObject xMTObject, boolean bl) {
            this._object = xMTObject;
            this._add = bl;
        }

        public XMTObject getObject() {
            return this._object;
        }

        public boolean getAdd() {
            return this._add;
        }
    }

    private static class StorageBufferCleanupTask
    extends TimerTask {
        StorageBuffer _buffer = null;

        public StorageBufferCleanupTask(StorageBuffer storageBuffer) {
            String string = "StorageBufferCleanupTask( StorageBuffer )";
            _logger.entry(string, storageBuffer);
            this._buffer = storageBuffer;
            _logger.exit(string);
        }

        public void run() {
            String string = "run()";
            _logger.entry(string);
            this._buffer.checkForTimedCommit();
            _logger.exit(string);
        }
    }
}

