/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.sec.iauthz.util;

import com.ibm.sec.iauthz.log.SecLogger;
import com.ibm.sec.iauthz.mcc.DataProcessingConstants;
import com.ibm.sec.iauthz.storage.StoreRecord;
import com.ibm.sec.iauthz.util.CollectionFactory;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StoreRecordUtil {
    public static Timestamp getTimestampFromVersion(String string, SecLogger secLogger) {
        int n;
        String string2 = "getTimestampFromVersion(String, SecLogger)";
        secLogger.entry(string2, string);
        Timestamp timestamp = null;
        if (string != null && (n = string.indexOf(58)) >= 0) {
            String string3 = string.substring(n + 1);
            try {
                timestamp = Timestamp.valueOf(string3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                secLogger.debug(string2, "Invalid timestamp portion in version. Version is " + string + ", and Timestamp portion is " + string3);
                timestamp = null;
            }
        }
        secLogger.exit(string2, timestamp);
        return timestamp;
    }

    public static long getNumberFromVersion(String string, SecLogger secLogger) {
        int n;
        String string2 = "getNumberFromVersion(String, SecLogger)";
        secLogger.entry(string2, string);
        long l = -1L;
        if (string != null && (n = string.indexOf(58)) >= 0) {
            String string3 = string.substring(0, n);
            try {
                l = Long.parseLong(string3);
            }
            catch (NumberFormatException numberFormatException) {
                secLogger.debug(string2, "Invalid number portion of version. Version is " + string + ", number portion is " + string3);
                l = -1L;
            }
        }
        secLogger.exit(string2, new Long(l));
        return l;
    }

    public static Set groupStoreRecords(Collection collection, SecLogger secLogger) {
        String string = "groupStoreRecords(Set, SecLogger)";
        secLogger.entry(string);
        Set set = CollectionFactory.newOrderedSet();
        if (collection == null) {
            secLogger.debug(string, "No records in Set.");
        } else {
            StoreRecord storeRecord;
            Set set2 = CollectionFactory.newOrderedSet();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                storeRecord = (StoreRecord)iterator.next();
                String string2 = storeRecord.getAttrXmtID();
                if (string2 == null) {
                    set2.add(storeRecord);
                    continue;
                }
                set = StoreRecordUtil.addRecordToCorrectPlace(set, storeRecord, secLogger);
            }
            iterator = set2.iterator();
            while (iterator.hasNext()) {
                storeRecord = (StoreRecord)iterator.next();
                set = StoreRecordUtil.addRecordToCorrectPlace(set, storeRecord, secLogger);
            }
        }
        secLogger.exit(string);
        return set;
    }

    public static Set addRecordToCorrectPlace(Set set, StoreRecord storeRecord, SecLogger secLogger) {
        Object object;
        Object object2;
        Set set2;
        String string = "addRecordToCorrectPlace(Set, StoreRecord, SecLogger)";
        secLogger.entry(string, storeRecord);
        if (set == null) {
            set = CollectionFactory.newSet();
            secLogger.debug(string, "Input Set was null. Created new set.");
        }
        List list = CollectionFactory.newList();
        Map map = null;
        String string2 = storeRecord.getXMTID();
        String string3 = storeRecord.getAttrXmtID();
        Iterator iterator = set.iterator();
        block0: while (iterator.hasNext()) {
            map = (Map)iterator.next();
            set2 = (Set)map.get("XMTIDS");
            object2 = set2.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                if (!((String)object).equalsIgnoreCase(string2) && !((String)object).equalsIgnoreCase(string3)) continue;
                list.add(map);
                continue block0;
            }
        }
        set2 = CollectionFactory.newOrderedSet();
        object2 = CollectionFactory.newSet();
        map = CollectionFactory.newMap();
        if (!list.isEmpty()) {
            iterator = list.iterator();
            while (iterator.hasNext()) {
                object = (Map)iterator.next();
                Set set3 = (Set)object.get("XMTIDS");
                Set set4 = (Set)object.get("RECORDS");
                set2.addAll(set3);
                object2.addAll(set4);
                set.remove(object);
            }
            secLogger.debug(string, "Adding record to current map. Matched list size is " + list.size());
        } else {
            secLogger.debug(string, "Creating new map for record.");
        }
        object2.add(storeRecord);
        if (string3 != null) {
            set2.add(string3);
        }
        set2.add(string2);
        map.put("XMTIDS", set2);
        map.put("RECORDS", object2);
        set.add(map);
        secLogger.exit(string);
        return set;
    }

    public static boolean compareRecords(StoreRecord storeRecord, StoreRecord storeRecord2, SecLogger secLogger) {
        String string = "compareRecords(StoreRecord, StoreRecord, SecLogger)";
        secLogger.entry(string, new Object[]{storeRecord, storeRecord2});
        boolean bl = false;
        if (storeRecord == null || storeRecord2 == null) {
            if (storeRecord == null && storeRecord2 == null) {
                bl = true;
            }
        } else {
            String string2 = storeRecord.getType();
            String string3 = storeRecord2.getType();
            if (string2 != null && string2.equalsIgnoreCase(string3) || string2 == null && string3 == null) {
                String string4 = storeRecord.getAttrName();
                String string5 = storeRecord2.getAttrName();
                if (string4 != null && string4.equalsIgnoreCase(string5) || string4 == null && string5 == null) {
                    Object object = storeRecord.getAttrValue();
                    Object object2 = storeRecord2.getAttrValue();
                    if (object != null && object.equals(object2) || object == null && object2 == null) {
                        String string6 = storeRecord.getClassname();
                        String string7 = storeRecord2.getClassname();
                        if (string6 != null && string6.equalsIgnoreCase(string7) || string6 == null && string7 == null) {
                            String string8 = storeRecord.getAttrXmtID();
                            String string9 = storeRecord2.getAttrXmtID();
                            if (string8 == null && string9 == null || string8 != null && string9 != null) {
                                bl = true;
                            }
                        }
                    }
                }
            }
        }
        secLogger.exit(string, new Boolean(bl));
        return bl;
    }

    public static boolean compareLinks(Set set, Set set2, Set set3, Set set4, boolean bl, SecLogger secLogger) {
        String string = "compareLinks(Set, Set, Set, Set, SecLogger)";
        secLogger.entry(string, bl);
        boolean bl2 = true;
        Set set5 = CollectionFactory.newSet();
        if (set3 != null) {
            set5.addAll(set3);
        }
        Set set6 = CollectionFactory.newSet();
        if (set4 != null) {
            set6.addAll(set4);
        }
        if (set5.size() != set6.size()) {
            if (!bl) {
                secLogger.debug(string, "Different sized Sets. Can't be the same entries.");
                bl2 = false;
            } else {
                secLogger.debug(string, "Sets are different sizes but ignoreSize is true.");
            }
        }
        if (bl2) {
            Iterator iterator = set6.iterator();
            while (iterator.hasNext()) {
                boolean bl3 = false;
                StoreRecord storeRecord = (StoreRecord)iterator.next();
                Iterator iterator2 = set5.iterator();
                while (iterator2.hasNext()) {
                    StoreRecord storeRecord2 = (StoreRecord)iterator2.next();
                    if (!StoreRecordUtil.compareRecords(storeRecord, storeRecord2, secLogger)) continue;
                    Set set7 = StoreRecordUtil.getLinkedRecords(set, storeRecord2, secLogger);
                    Set set8 = StoreRecordUtil.getLinkedRecords(set2, storeRecord, secLogger);
                    if (!StoreRecordUtil.compareLevelRecords(set, set2, storeRecord, storeRecord2, bl, secLogger) || !StoreRecordUtil.compareLinks(set, set2, set7, set8, bl, secLogger)) continue;
                    bl3 = true;
                    set5.remove(storeRecord);
                    break;
                }
                if (bl3) continue;
                bl2 = false;
                break;
            }
        }
        secLogger.exit(string, new Boolean(bl2));
        return bl2;
    }

    public static boolean compareLevelRecords(Set set, Set set2, StoreRecord storeRecord, StoreRecord storeRecord2, boolean bl, SecLogger secLogger) {
        Set set3;
        String string = "compareLevelRecords(Set, Set, StoreRecord, StoreRecord, boolean, SecLogger)";
        secLogger.entry(string, new Object[]{storeRecord, storeRecord2, bl});
        boolean bl2 = true;
        Set set4 = StoreRecordUtil.getLevelRecords(set, storeRecord2, secLogger);
        if (set4.isEmpty()) {
            set4.add(storeRecord2);
        }
        if ((set3 = StoreRecordUtil.getLevelRecords(set2, storeRecord, secLogger)).isEmpty()) {
            set3.add(storeRecord);
        }
        if (set4.size() != set3.size()) {
            if (!bl) {
                secLogger.debug(string, "Sets are different sizes. Can't be the same records.");
                bl2 = false;
            } else {
                secLogger.debug(string, "Sets are different sizes but ignoreSize is true.");
            }
        }
        if (bl2) {
            Iterator iterator = set3.iterator();
            while (iterator.hasNext()) {
                boolean bl3 = false;
                StoreRecord storeRecord3 = (StoreRecord)iterator.next();
                Iterator iterator2 = set4.iterator();
                while (iterator2.hasNext()) {
                    StoreRecord storeRecord4 = (StoreRecord)iterator2.next();
                    if (!StoreRecordUtil.compareRecords(storeRecord4, storeRecord3, secLogger) || !StoreRecordUtil.compareLinks(set, set2, StoreRecordUtil.getLinkedRecords(set, storeRecord4, secLogger), StoreRecordUtil.getLinkedRecords(set2, storeRecord3, secLogger), bl, secLogger)) continue;
                    bl3 = true;
                    set4.remove(storeRecord4);
                    break;
                }
                if (bl3) continue;
                bl2 = false;
            }
        }
        secLogger.exit(string, new Boolean(bl2));
        return bl2;
    }

    public static Set getLevelRecords(Set set, StoreRecord storeRecord, SecLogger secLogger) {
        String string = "getLevelRecords(Set, StoreRecord, SecLogger)";
        secLogger.entry(string, storeRecord);
        Set set2 = CollectionFactory.newSet();
        if (set == null) {
            secLogger.debug(string, "Null Set thus there is no linked records.");
        } else if (storeRecord == null) {
            secLogger.debug(string, "Null StoreRecord thus there is no linked records.");
        } else {
            String string2 = storeRecord.getXMTID();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                StoreRecord storeRecord2 = (StoreRecord)iterator.next();
                String string3 = storeRecord2.getXMTID();
                if (string2 == null || !string2.equalsIgnoreCase(string3)) continue;
                set2.add(storeRecord2);
            }
        }
        secLogger.exit(string);
        return set2;
    }

    public static Set getLinkedRecords(Set set, StoreRecord storeRecord, SecLogger secLogger) {
        String string = "getLinkedRecords(Set, StoreRecord, SecLogger)";
        secLogger.entry(string, storeRecord);
        Set set2 = CollectionFactory.newSet();
        if (set == null) {
            secLogger.debug(string, "Null Set thus there is no linked records.");
        } else if (storeRecord == null) {
            secLogger.debug(string, "Null StoreRecord thus there is no linked records.");
        } else {
            String string2 = storeRecord.getAttrXmtID();
            if (string2 != null) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    StoreRecord storeRecord2 = (StoreRecord)iterator.next();
                    String string3 = storeRecord2.getXMTID();
                    if (!string3.equalsIgnoreCase(string2)) continue;
                    set2.add(storeRecord2);
                }
            }
        }
        secLogger.debug(string, "Found " + set2.size() + " linked records.");
        secLogger.exit(string);
        return set2;
    }

    public static Set getRelatedRecords(Set set, StoreRecord storeRecord, SecLogger secLogger) {
        String string = "getRelatedRecords(Set, StoreRecord, SecLogger)";
        secLogger.entry(string);
        Set set2 = CollectionFactory.newSet();
        Set set3 = StoreRecordUtil.getLinkedRecords(set, storeRecord, secLogger);
        set2.addAll(set3);
        Iterator iterator = set3.iterator();
        while (iterator.hasNext()) {
            StoreRecord storeRecord2 = (StoreRecord)iterator.next();
            Set set4 = StoreRecordUtil.getRelatedRecords(set, storeRecord2, secLogger);
            if (set4 == null) continue;
            set2.addAll(set4);
        }
        secLogger.exit(string);
        return set2;
    }

    public static String getIncrementedVersion(Map map, SecLogger secLogger) {
        String string = "getVersion(Map, SecLogger)";
        secLogger.entry(string);
        String string2 = null;
        if (map != null) {
            string2 = (String)map.get("_MASTER_CURRENT_VERSION_");
        }
        if (string2 == null) {
            Date date = new Date();
            long l = date.getTime();
            Timestamp timestamp = new Timestamp(l);
            string2 = "0:" + timestamp.toString();
        }
        int n = string2.indexOf(58);
        String string3 = string2.substring(0, n);
        String string4 = string2.substring(n + 1);
        int n2 = Integer.parseInt(string3);
        string3 = Integer.toString(++n2);
        string2 = string3 + ":" + string4;
        secLogger.exit(string, string2);
        return string2;
    }

    public static String getMasterDBKey(Set set, SecLogger secLogger) {
        String string = "getMasterDBKey(Set, SecLogger)";
        secLogger.entry(string);
        String string2 = null;
        if (set == null) {
            secLogger.debug(string, "Entry Set is null. Returning null.");
        } else {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                StoreRecord storeRecord = (StoreRecord)iterator.next();
                String string3 = storeRecord.getClassname();
                String string4 = storeRecord.getAttrName();
                String string5 = storeRecord.getType();
                secLogger.debug(string, "Current record : " + storeRecord);
                if (string3 != null && string3.equalsIgnoreCase(DataProcessingConstants.PCOCN)) {
                    if (string4 != null && string4.equalsIgnoreCase("Key")) {
                        string2 = "ROLE_KEY:" + (String)storeRecord.getAttrValue();
                    }
                } else if (string5 != null && string5.equalsIgnoreCase(DataProcessingConstants.PRIN_XMT_TYPE)) {
                    if (string4 != null && string4.equalsIgnoreCase("Name")) {
                        string2 = (String)storeRecord.getAttrValue();
                    }
                } else if (string3 != null && string3.equalsIgnoreCase(DataProcessingConstants.IRCN)) {
                    if (string4 != null && string4.equalsIgnoreCase("BaseRole")) {
                        string2 = "IR_KEY:" + (String)storeRecord.getAttrValue();
                    }
                } else if (string3 != null && string3.equalsIgnoreCase(DataProcessingConstants.CACN) && string4 != null && string4.equalsIgnoreCase("Algorithm")) {
                    string2 = "CA_KEY:";
                }
                if (string2 == null) continue;
            }
        }
        secLogger.exit(string, string2);
        return string2;
    }

    public static Set setActions(Set set, String string, SecLogger secLogger) {
        String string2 = "setActions(Set, String, Secogger)";
        secLogger.entry(string2, new Object[]{set, string});
        Set set2 = CollectionFactory.newSet();
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                StoreRecord storeRecord = (StoreRecord)iterator.next();
                if (string == "ADD") {
                    storeRecord.setAction(1);
                } else {
                    storeRecord.setAction(2);
                }
                set2.add(storeRecord);
            }
        } else {
            secLogger.debug(string2, "The entry Set was null.");
        }
        secLogger.exit(string2, set2);
        return set2;
    }

    public static Set getDeltaObject(Set set, String string, String string2, SecLogger secLogger) {
        String string3 = "getDeltaObject(Set, String, String, SecLogger)";
        secLogger.entry(string3, new Object[]{string, string2});
        if (set == null) {
            secLogger.debug(string3, "Set of records is null. Doing nothing.");
        } else if (string == null) {
            secLogger.debug(string3, "Base XMTID is null. Returning null.");
        } else if (string2 == null) {
            secLogger.debug(string3, "Type is null. Returning null.");
        } else {
            StoreRecord storeRecord = new StoreRecord(DataProcessingConstants.DDO_XMT_TYPE);
            String string4 = string + "-d";
            storeRecord.setXMTID(string4);
            storeRecord.setClassname(DataProcessingConstants.DDOCN);
            storeRecord.setAttrName("Type");
            if (string2 != null && string2.equalsIgnoreCase("ADD")) {
                storeRecord.setAttrValue(Short.toString((short)0));
            } else {
                storeRecord.setAttrValue(Short.toString((short)1));
            }
            StoreRecord storeRecord2 = new StoreRecord(DataProcessingConstants.DDO_XMT_TYPE);
            storeRecord2.setXMTID(string4);
            storeRecord2.setClassname(DataProcessingConstants.DDOCN);
            storeRecord2.setAttrName("Data");
            storeRecord2.setAttrXmtID(string);
            set.add(storeRecord);
            set.add(storeRecord2);
        }
        secLogger.exit(string3);
        return set;
    }

    public static Set wrapInDelta(Set set, SecLogger secLogger) {
        String string = "wrapInDelta(Set, SecLogger)";
        secLogger.entry(string, set);
        Set set2 = CollectionFactory.newOrderedSet();
        if (set != null) {
            Set set3 = StoreRecordUtil.groupStoreRecords(set, secLogger);
            if (set3 != null) {
                Iterator iterator = set3.iterator();
                while (iterator.hasNext()) {
                    Map map = (Map)iterator.next();
                    Set set4 = (Set)map.get("RECORDS");
                    StoreRecord storeRecord = StoreRecordUtil.getFirstStoreRecord(set4, secLogger);
                    String string2 = storeRecord.getXMTID();
                    int n = storeRecord.getAction();
                    String string3 = null;
                    string3 = n == 1 ? "ADD" : "DELETE";
                    Set set5 = StoreRecordUtil.getDeltaObject(set4, string2, string3, secLogger);
                    set2.addAll(set5);
                }
            } else {
                secLogger.debug(string, "The grouped records Set is null.");
            }
        }
        secLogger.exit(string);
        return set2;
    }

    public static StoreRecord getFirstStoreRecord(Set set, SecLogger secLogger) {
        String string = "getFirstStoreRecord(Set, SecLogger)";
        secLogger.entry(string);
        StoreRecord storeRecord = null;
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                boolean bl = true;
                StoreRecord storeRecord2 = null;
                StoreRecord storeRecord3 = (StoreRecord)iterator.next();
                String string2 = storeRecord3.getXMTID();
                Iterator iterator2 = set.iterator();
                while (iterator2.hasNext()) {
                    storeRecord2 = (StoreRecord)iterator2.next();
                    String string3 = storeRecord2.getAttrXmtID();
                    if (string3 == null || !string3.equalsIgnoreCase(string2)) continue;
                    bl = false;
                }
                if (!bl) continue;
                storeRecord = storeRecord3;
                break;
            }
        }
        secLogger.exit(string, storeRecord);
        return storeRecord;
    }

    public static Set doRecordsExist(Set set, Set set2, StoreRecord storeRecord, boolean bl, SecLogger secLogger) {
        String string = "doRecordExist(Set, Set, StoreRecord, boolean, SecLogger";
        secLogger.entry(string, new Object[]{storeRecord, bl});
        Set set3 = CollectionFactory.newSet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Set set4;
            Set set5;
            StoreRecord storeRecord2 = (StoreRecord)iterator.next();
            if (!StoreRecordUtil.compareRecords(storeRecord, storeRecord2, secLogger) || !StoreRecordUtil.compareLevelRecords(set, set2, storeRecord, storeRecord2, bl, secLogger) || !StoreRecordUtil.compareLinks(set, set2, set5 = StoreRecordUtil.getLinkedRecords(set, storeRecord2, secLogger), set4 = StoreRecordUtil.getLinkedRecords(set2, storeRecord, secLogger), bl, secLogger)) continue;
            set3.add(storeRecord2);
        }
        secLogger.exit(string, set3);
        return set3;
    }

    public static short compareVersions(String string, String string2, SecLogger secLogger) {
        String string3 = "compareVersions(String, String, SecLogger)";
        secLogger.entry(string3, new Object[]{string, string2});
        int n = 2;
        if (string == null && string2 == null) {
            n = 1;
        } else if (string == null && string2 != null) {
            n = 2;
        } else if (string != null && string2 == null) {
            n = 0;
        } else {
            long l = StoreRecordUtil.getNumberFromVersion(string, secLogger);
            long l2 = StoreRecordUtil.getNumberFromVersion(string2, secLogger);
            Timestamp timestamp = StoreRecordUtil.getTimestampFromVersion(string, secLogger);
            Timestamp timestamp2 = StoreRecordUtil.getTimestampFromVersion(string2, secLogger);
            if (l == -1L || timestamp == null) {
                secLogger.debug(string3, "Invalid versions. Returning 3.");
                n = 3;
            } else {
                n = l2 == -1L || timestamp2 == null ? 4 : (timestamp.after(timestamp2) ? 0 : (timestamp.before(timestamp2) ? 2 : (l < l2 ? 2 : (l > l2 ? 0 : 1))));
            }
        }
        secLogger.exit(string3, new Short((short)n));
        return (short)n;
    }
}

